/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activationgroupfordevice;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnActivationTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDCActGroupBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCBoardInfo4ActGrp;
import com.huawei.dc.common.asndatacenter.AsnDCBoardInfo4ActGrpList;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.components.dialog.CommonProgressDlg;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.devicemanagement.deviceoperation.activationgroupfordevice.RowData;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.tasktable.TaskTablePanel;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class GroupingBdActForSingleDevDlg
extends DCModalDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    private JButton removeEmptyButton;
    private JPanel boardTreePan;
    private static final Color PANEL_BORDER_COLOR = new Color(148, 145, 140);
    private transient JSortTreeTable m_oTreeTable;
    private transient DCTreeTableModel m_oTreeTableModel;
    private transient JScrollPane m_oTreeScrollPane;
    private Vector<TreeTableNode> groupListTmp;
    private transient TreeTableNode rootNode;
    protected JPopupMenu m_oPopupMenu = null;
    private int deviceId = -1;
    private static final long serialVersionUID = 1L;
    protected Vector<TreeTableNode> boardListStore = new Vector();
    protected Vector<TreeTableNode> boardListStoreBackup = new Vector();

    public GroupingBdActForSingleDevDlg(Vector<TreeTableNode> boardList, int devId) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        String title = ResourceManager.getInstance().getResString("MODIFY_ACTIVE_GROUP_FOR_SINGLE_DEV");
        this.deviceId = devId;
        Resource resource = DeviceInfoManagerImpl.getInstance().getResourceForID(this.deviceId);
        String deviceName = "";
        if (null != resource) {
            deviceName = DeviceInfoManagerImpl.getInstance().getResourceForID(devId).getDeviceName();
        } else {
            DCDebugTracer.trace("GroupingBoardActiveForSingleDevDialog:get devid=" + devId);
        }
        title = title + "-" + deviceName;
        this.getContentPane().setLayout(null);
        this.setSize(560, 515);
        this.jbInit();
        this.setGroupNodeByBoardListWhenInit(boardList);
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(title);
        this.populateDataInTable();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
        this.setVisible(true);
    }

    private void setGroupNodeByBoardListWhenInit(Vector<TreeTableNode> boardList) {
        int i;
        this.groupListTmp = new Vector();
        this.boardListStore = boardList;
        Vector<RowData> groupRowDataListTmp = new Vector<RowData>();
        for (i = 0; i < boardList.size(); ++i) {
            TreeTableNode broadNode = boardList.get(i);
            RowData rowdata = (RowData)broadNode.getUserObject();
            RowData groupNodeInfo = new RowData(rowdata.getGroupId(), null, 1, null);
            if (groupRowDataListTmp.contains(groupNodeInfo)) continue;
            groupRowDataListTmp.add(groupNodeInfo);
            TreeTableNode groupNode = new TreeTableNode(groupNodeInfo);
            this.groupListTmp.add(groupNode);
        }
        for (i = 0; i < this.groupListTmp.size(); ++i) {
            TreeTableNode groupNode = this.groupListTmp.get(i);
            RowData groupRow = (RowData)groupNode.getUserObject();
            for (TreeTableNode boardNode : boardList) {
                RowData devRow = (RowData)boardNode.getUserObject();
                if (devRow.getGroupId() != groupRow.getGroupId()) continue;
                groupNode.add(boardNode);
            }
        }
    }

    private void initializeButton() {
        this.removeEmptyButton = new JButton();
        this.removeEmptyButton.setName("TaskMgmt_NewGroupPanel_removeEmptyButton");
        this.removeEmptyButton.setBounds(15, 450, 160, 21);
        this.removeEmptyButton.setText(ResourceManager.getInstance().getResString("REMOVE_EMPTY_GROUP_BTN"));
        this.removeEmptyButton.setToolTipText(ResourceManager.getInstance().getResString("REMOVE_EMPTY_GROUP_BTN"));
        this.removeEmptyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupingBdActForSingleDevDlg.this.removeEmptyGroupButtonActionPerfromed();
            }
        });
        this.okButton = new JButton();
        this.okButton.setName("TaskMgmt_NewGroupPanel_okButton");
        this.okButton.setBounds(370, 450, 80, 21);
        this.okButton.setText(ResourceManager.getInstance().getResString("OK_BUTTON"));
        this.okButton.setToolTipText(ResourceManager.getInstance().getResString("OK_BUTTON"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupingBdActForSingleDevDlg.this.okButtonActionPerfromed();
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.setName("TaskMgmt_NewGroupPanel_cancelButton");
        this.cancelButton.setBounds(460, 450, 80, 21);
        this.cancelButton.setText(ResourceManager.getInstance().getResString("CANCEL_BUTTON"));
        this.cancelButton.setToolTipText(ResourceManager.getInstance().getResString("CANCEL_BUTTON"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupingBdActForSingleDevDlg.this.cancelButtonActionPerfromed();
            }
        });
    }

    private void jbInit() {
        this.boardTreePan = this.createTreePan();
        this.boardTreePan.setName("TaskMgmt_NewGroupPanel_boardTreePan");
        this.initializeButton();
        this.registerWindowCloseListeneres();
        this.getContentPane().add(this.boardTreePan);
        this.getContentPane().add(this.removeEmptyButton);
        this.getContentPane().add(this.okButton);
        this.getContentPane().add(this.cancelButton);
    }

    private void initPopupMenu() {
        int[] selectRows = this.m_oTreeTable.getSelectedRows();
        boolean isSelectGroup1Board = false;
        boolean isSelectBoardOnly = true;
        boolean isSelectGroupOnly = false;
        TreeTableNode oNode = null;
        RowData oRowData = null;
        for (int i = 0; i < selectRows.length; ++i) {
            TreePath oTreePath = this.m_oTreeTable.getTree().getPathForRow(selectRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            oRowData = (RowData)oNode.getUserObject();
            if (isSelectBoardOnly && 1 == oRowData.getNodeType()) {
                isSelectBoardOnly = false;
            }
            if (!isSelectGroup1Board && oRowData.getGroupId() == 1) {
                isSelectGroup1Board = true;
            }
            if (selectRows.length != 1 || 1 != oRowData.getNodeType()) continue;
            isSelectGroupOnly = true;
        }
        this.m_oPopupMenu = new JPopupMenu();
        if (isSelectGroupOnly) {
            JMenuItem insertGroup = new JMenuItem(ResourceManager.getInstance().getResString("INSERT_GROUP"));
            JMenuItem appendGroup = new JMenuItem(ResourceManager.getInstance().getResString("APPEND_GROUP"));
            if (null != oRowData) {
                int selectGroupID = oRowData.getGroupId();
                if (1 == selectGroupID) {
                    insertGroup.setEnabled(false);
                } else {
                    insertGroup.addActionListener(this);
                }
                appendGroup.addActionListener(this);
                this.m_oPopupMenu.add(insertGroup);
                this.m_oPopupMenu.add(appendGroup);
            }
        } else {
            for (int j = 1; j < this.groupListTmp.size(); ++j) {
                TreeTableNode group = this.groupListTmp.get(j);
                RowData groupData = (RowData)group.getUserObject();
                String menuStr = ResourceManager.getInstance().getResString("MOVE_TO_GROUP") + "-" + groupData.getGroupId();
                JMenuItem moveToGroup = new JMenuItem(menuStr);
                if (!isSelectBoardOnly || isSelectGroup1Board) {
                    moveToGroup.setEnabled(false);
                } else {
                    moveToGroup.addActionListener(this);
                }
                this.m_oPopupMenu.add(moveToGroup);
            }
        }
    }

    private void populateDataInTable() {
        TreeTableNode rootNode = this.getRootNode();
        rootNode.removeAllChildren();
        Vector<TreeTableNode> groupList = this.groupListTmp;
        for (int i = 0; i < groupList.size(); ++i) {
            TreeTableNode groupNode = groupList.get(i);
            rootNode.add(groupNode);
        }
        this.updateTableView();
    }

    public String[] getStrColumnNamesByTree() {
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("BOARD_NALE"), ResourceManager.getInstance().getResString("SLOTID_TABLE_COL"), ResourceManager.getInstance().getResString("BOARD_RESET_INFO_COL")};
        return strColumnNames;
    }

    public Class[] getArrColumnTypes() {
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class};
        return arrColumnTypes;
    }

    public String[] getMethodBoardTreeNames() {
        return RowData.getMethodBoardTreeName();
    }

    public boolean[] getArrSortableColumns() {
        boolean[] arrSortableColumns = new boolean[]{false, false, false};
        return arrSortableColumns;
    }

    public boolean[] getArrEditableColumns() {
        boolean[] arrEditableColumns = new boolean[]{true, false, false};
        return arrEditableColumns;
    }

    public String getBorderTitle() {
        return ResourceManager.getInstance().getResString("ACTIVATION_MODE_GROUP");
    }

    public void setCellRenderer(JLabel label, Object value) {
        label.setText(value.toString());
    }

    public void tree_MousePressed(MouseEvent oMouseEvent) {
        int arrSelectedRow = this.getTreeTable().getSelectedRow();
        if (arrSelectedRow < 0) {
            return;
        }
        int iClickedRow = this.m_oTreeTable.rowAtPoint(oMouseEvent.getPoint());
        boolean bIsClickedRowSelected = false;
        int[] nRows = this.m_oTreeTable.getSelectedRows();
        if (nRows.length > 0) {
            for (int i = 0; i < nRows.length; ++i) {
                if (nRows[i] != iClickedRow) continue;
                bIsClickedRowSelected = true;
                break;
            }
        }
        if (!bIsClickedRowSelected && 0 != (4 & oMouseEvent.getModifiers())) {
            ListSelectionModel oSelectionModel = this.m_oTreeTable.getSelectionModel();
            oSelectionModel.setSelectionInterval(iClickedRow, iClickedRow);
        }
        if (3 == oMouseEvent.getButton()) {
            this.initPopupMenu();
            this.m_oPopupMenu.show((Component)((Object)this.m_oTreeTable), oMouseEvent.getX(), oMouseEvent.getY());
        }
        this.getTreeTable().updateUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okButtonActionPerfromed() {
        if (this.checkIsIncludeEmptyGroup()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("EMPTY_GROUP_DOESNOT_DATA"), ResourceManager.getInstance().getResString("INFO"), 1);
            return;
        }
        this.getBoardResult();
        AsnDCActGroupBoardInfo oAsnDCActGroupBoardInfoResult = new AsnDCActGroupBoardInfo();
        AsnDCBoardInfo4ActGrpList oAsnDCBoardInfo4ActGrpList = new AsnDCBoardInfo4ActGrpList();
        AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
        ArrayList<Integer> devIdLst = new ArrayList<Integer>();
        for (int i = 0; i < this.boardListStore.size(); ++i) {
            TreeTableNode boardNode = this.boardListStore.get(i);
            RowData boardData = (RowData)boardNode.getUserObject();
            AsnDCBoardInfo4ActGrp oAsnDCBoardInfo4ActGrp = new AsnDCBoardInfo4ActGrp();
            oAsnDCBoardInfo4ActGrp.iGroupId = BigInteger.valueOf(boardData.getGroupId());
            oAsnDCBoardInfo4ActGrp.iSlotId = BigInteger.valueOf(boardData.getSlotId());
            oAsnDCBoardInfo4ActGrp.strBoardName = "".getBytes();
            oAsnDCBoardInfo4ActGrp.enActiveDeviceMode = new AsnActivationTypeEnum();
            oAsnDCBoardInfo4ActGrpList.add((Object)oAsnDCBoardInfo4ActGrp);
        }
        oAsnDCActGroupBoardInfoResult.oAsnDCBoardInfo4ActGrpLst = oAsnDCBoardInfo4ActGrpList;
        oAsnDCActGroupBoardInfoResult.iDeviceID = BigInteger.valueOf(this.deviceId);
        TaskTablePanel oTaskTablePan = DCFrameWorkUtil.getTaskTablePanel();
        devIdLst.add(this.deviceId);
        oAsnDCActGroupBoardInfoResult.iRequestID = DCTimeDateUtil.getRandomReqId();
        oAsnDCActGroupBoardInfoResult.oErrorInfo = new AsnDCErrorCodeInfo();
        oAsnDCActGroupBoardInfoResult.oErrorInfo.iErrorNo = BigInteger.valueOf(0L);
        Object object = oTaskTablePan.getSynObject();
        synchronized (object) {
            try {
                TaskAsynCommController.getInstance().setModifySingleNEActiveGroupOperation(oAsnDCActGroupBoardInfoResult, oAsnDCOpertionRsp);
                String[] columnNames = new String[]{ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("OPERATE_RESULT")};
                final CommonProgressDlg commonFileCheckResultDlg = new CommonProgressDlg(44090, devIdLst, columnNames);
                commonFileCheckResultDlg.setProgressDlgId(oAsnDCActGroupBoardInfoResult.iRequestID.intValue());
                commonFileCheckResultDlg.setTitle(ResourceManager.getInstance().getResString("ACTIVE_CONFIGURE_BORDER"));
                oTaskTablePan.setResultDlg(commonFileCheckResultDlg);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        commonFileCheckResultDlg.setVisible(true);
                    }
                });
            }
            catch (DCException e) {
                DCOptionPane.showMessageDialog(null, e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        }
        this.dispose();
    }

    private void cancelButtonActionPerfromed() {
        this.dispose();
    }

    private Vector<TreeTableNode> getBoardResult() {
        this.boardListStoreBackup = this.boardListStore;
        this.boardListStore.clear();
        for (int i = 0; i < this.groupListTmp.size(); ++i) {
            TreeTableNode groupNode = this.groupListTmp.get(i);
            RowData groupData = (RowData)groupNode.getUserObject();
            for (int j = 0; j < groupNode.getChildCount(); ++j) {
                TreeTableNode boardNode = (TreeTableNode)groupNode.getChildAt(j);
                RowData boardData = (RowData)boardNode.getUserObject();
                boardData.setGroupId(groupData.getGroupId());
                this.boardListStore.add(boardNode);
            }
        }
        return this.boardListStore;
    }

    private void removeEmptyGroupButtonActionPerfromed() {
        Iterator<TreeTableNode> i = this.groupListTmp.iterator();
        while (i.hasNext()) {
            TreeTableNode groupNode = i.next();
            if (0 != groupNode.getChildCount()) continue;
            i.remove();
        }
        this.sortGroup();
        this.populateDataInTable();
    }

    private void sortGroup() {
        for (int i = 0; i < this.groupListTmp.size(); ++i) {
            TreeTableNode groupNode = this.groupListTmp.get(i);
            RowData groupData = (RowData)groupNode.getUserObject();
            groupData.setGroupId(i + 1);
            groupData.setResourceName();
        }
    }

    private void registerWindowCloseListeneres() {
        ActionListener oESCKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupingBdActForSingleDevDlg.this.closeDialog();
            }
        };
        KeyStroke oKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.rootPane.registerKeyboardAction(oESCKeyHandler, oKeyStroke, 2);
    }

    @Override
    protected String getCurrentContext() {
        return "SINGLE_DEVICE_ACT_GROUP_MODIFY";
    }

    private JPanel createTreePan() {
        JPanel oLeftPanel = new JPanel();
        oLeftPanel.setName("TaskMgmt_NewGroupPanel_oLeftPanel");
        oLeftPanel.setLayout(null);
        oLeftPanel.setBounds(12, 6, 528, 417);
        String[] strColumnNames = this.getStrColumnNamesByTree();
        Class[] arrColumnTypes = this.getArrColumnTypes();
        boolean[] arrSortableColumns = this.getArrSortableColumns();
        boolean[] arrEditableColumns = this.getArrEditableColumns();
        this.m_oTreeTableModel = new DCTreeTableModel(strColumnNames, arrColumnTypes, arrSortableColumns, arrEditableColumns, this.getMethodBoardTreeNames());
        this.m_oTreeTable = new JSortTreeTable(this.m_oTreeTableModel);
        this.m_oTreeTable.setName("TaskMgmt_NewGroupPanel_m_oTreeTable");
        this.m_oTreeTable.getTree().setCellRenderer(new MyCellRenderer());
        this.m_oTreeTable.addMouseListener(this.generateMouseAdapterForTable());
        this.initializeSelectionModel((JTable)((Object)this.m_oTreeTable));
        this.initializeTreeTable((JTable)((Object)this.m_oTreeTable));
        this.initializeTreeLines(this.m_oTreeTable);
        this.m_oTreeTable.getColumnModel().getColumn(0).setMaxWidth(500);
        this.m_oTreeTable.getColumnModel().getColumn(0).setMinWidth(150);
        this.m_oTreeTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.m_oTreeScrollPane = new JScrollPane((Component)((Object)this.m_oTreeTable));
        this.m_oTreeScrollPane.setName("TaskMgmt_NewGroupPanel_m_oTreeScrollPane");
        this.m_oTreeScrollPane.setBounds(12, 5, 504, 410);
        oLeftPanel.add(this.m_oTreeScrollPane);
        this.rootNode = this.m_oTreeTableModel.getRoot();
        this.updateTableView();
        return oLeftPanel;
    }

    private void initializeSelectionModel(JTable jTable) {
        DefaultListSelectionModel oTaskSelection = new DefaultListSelectionModel();
        oTaskSelection.setSelectionMode(0);
        jTable.setSelectionModel(oTaskSelection);
    }

    public void updateTableView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GroupingBdActForSingleDevDlg.this.m_oTreeTable.getTableHeader().updateUI();
                GroupingBdActForSingleDevDlg.this.m_oTreeTable.expandAllNodes();
                GroupingBdActForSingleDevDlg.this.m_oTreeTable.updateUI();
            }
        });
    }

    private void initializeTreeTable(JTable jTable) {
        jTable.setRowHeight(21);
        JTableHeader oTableHeader = jTable.getTableHeader();
        oTableHeader.setReorderingAllowed(false);
        oTableHeader.setPreferredSize(new Dimension(jTable.getSize().width, 21));
    }

    private void initializeTreeLines(JSortTreeTable jTable) {
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(false);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(false);
    }

    public TreeTableNode getRootNode() {
        return this.rootNode;
    }

    public JSortTreeTable getTreeTable() {
        return this.m_oTreeTable;
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent oMouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                GroupingBdActForSingleDevDlg.this.tree_MousePressed(oMouseEvent);
            }
        };
    }

    @Override
    protected void closeDialog() {
        this.doCleanUp();
        if (null != this.m_oPopupMenu) {
            this.m_oPopupMenu.removeAll();
            this.m_oPopupMenu.setVisible(false);
            this.m_oPopupMenu = null;
        }
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String menuStr = e.getActionCommand();
        if (ResourceManager.getInstance().getResString("INSERT_GROUP").equals(menuStr)) {
            this.insertGroup();
        } else if (ResourceManager.getInstance().getResString("APPEND_GROUP").equals(menuStr)) {
            this.appendGroup();
        } else {
            String[] menuStrArr = menuStr.split("-");
            String index = menuStrArr[1];
            this.moveBoards(index);
        }
    }

    private void moveBoards(String groupId) {
        int[] selectRows = this.m_oTreeTable.getSelectedRows();
        TreeTableNode oNode = null;
        if (selectRows.length <= 0) {
            return;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            TreePath oTreePath = this.m_oTreeTable.getTree().getPathForRow(selectRows[i]);
            if (null == oTreePath) continue;
            oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            this.moveBoardToNewGroupBySelectRow(oNode, groupId);
        }
        this.populateDataInTable();
    }

    private void moveBoardToNewGroupBySelectRow(TreeTableNode modifyBoardNode, String groupId) {
        try {
            Integer targetGroupId = Integer.valueOf(groupId);
            TreeTableNode oldParent = (TreeTableNode)modifyBoardNode.getParent();
            for (int i = 0; i < this.groupListTmp.size(); ++i) {
                TreeTableNode groupNode = this.groupListTmp.get(i);
                RowData groupData = (RowData)groupNode.getUserObject();
                if (targetGroupId.intValue() != groupData.getGroupId()) continue;
                oldParent.remove(modifyBoardNode);
                groupNode.add(modifyBoardNode);
                break;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace("modifyBoardListBySelectRow got exception.");
            DCDebugTracer.trace(e);
        }
    }

    private void insertGroup() {
        int[] selectRows = this.m_oTreeTable.getSelectedRows();
        if (selectRows.length != 1) {
            DCDebugTracer.trace("insertGroup:select node is not single.");
            return;
        }
        TreePath oTreePath = this.m_oTreeTable.getTree().getPathForRow(selectRows[0]);
        if (null == oTreePath) {
            DCDebugTracer.trace("insertGroup:get tree path is null.");
            return;
        }
        TreeTableNode selectGroupNode = null;
        selectGroupNode = (TreeTableNode)oTreePath.getLastPathComponent();
        int selectGroupIndex = this.groupListTmp.indexOf(selectGroupNode);
        if (0 == selectGroupIndex) {
            DCDebugTracer.trace("insertGroup:select group1,can not insert");
            return;
        }
        RowData newGroupNodeData = new RowData(selectGroupIndex + 1, null, 1, null);
        TreeTableNode newGroupNode = new TreeTableNode(newGroupNodeData);
        this.groupListTmp.add(selectGroupIndex, newGroupNode);
        this.getRootNode().insert(newGroupNode, selectGroupIndex);
        this.sortGroup();
        this.populateDataInTable();
    }

    private void appendGroup() {
        TreeTableNode groupNode;
        int appendGroupId = 0;
        for (int i = 0; i < this.groupListTmp.size(); ++i) {
            groupNode = this.groupListTmp.get(i);
            RowData groupData = (RowData)groupNode.getUserObject();
            if (appendGroupId > groupData.getGroupId()) continue;
            appendGroupId = groupData.getGroupId();
        }
        RowData groupNodeInfo = new RowData(++appendGroupId, null, 1, null);
        groupNode = new TreeTableNode(groupNodeInfo);
        this.getRootNode().add(groupNode);
        this.groupListTmp.add(groupNode);
        this.populateDataInTable();
    }

    private boolean checkIsIncludeEmptyGroup() {
        for (int i = 0; i < this.groupListTmp.size(); ++i) {
            TreeTableNode groupNode = this.groupListTmp.get(i);
            if (groupNode.getChildCount() != 0) continue;
            return true;
        }
        return false;
    }

    class MyCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            GroupingBdActForSingleDevDlg.this.setCellRenderer(this, value);
            return this;
        }
    }
}

