/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CheckBoxHeader;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.ActivationDataBaseOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.ActivationDataBaseOperationData;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.ActivationDataBaseTableModel;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.controller.ActivationDataBaseOperationController;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.RecoverModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ActivationDataBaseDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private static final int ALL_SELECTED = 0;
    private static final int PART_SELECTED = 1;
    private static final int NONE_SELECTED = 2;
    private static final int IS_NOT_SELECT = 0;
    private static final int IS_SELECT = 1;
    private static final int IS_DISABLE = 2;
    private ActivationDataBaseTableModel m_oActivationDataBaseTableModel = null;
    private int REBOOTTYPE_COLUMN_INDEX = -1;
    private int DELIVER_TO_BOARD_REBOOT_FOR_TABLE_INDEX = -1;
    private int DELIVER_TO_BOARD_REBOOT_FOR_MODEL_INDEX = -1;
    private JTable m_oAcivationDataBaseTable = null;
    private DeviceInfo[] m_arrDevInfo = null;
    private JPanel m_oAcivationDataBasePanel;
    private JScrollPane m_oAcivationDataBaseScrollPane;
    private ActivationDataBaseOperation m_oActivationDataBaseOperation;
    private ResourceManager m_oResourceMgr = ResourceManager.getInstance();
    private RecoverModel[] m_oActivationDataBaseModel = null;
    private ArrayList m_oRebootTypeLst;
    private CheckBoxHeader m_oCheckBoxHeader = null;
    private Map m_oStoreLastState;
    private int m_iNoDeliverSelectedRows = 0;
    private int m_iRowsIsDisableCount = 0;
    private int m_iSelectionType = 2;
    private boolean m_bDeliverOption = false;
    private ActivationDataBaseOperationData m_oActivationDataBaseOparetionData;
    ParaValue[] m_arrRebootType;
    private transient TableCellRenderer tableCellRenderer = new TableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            if (isSelected) {
                oLabel.setBackground(table.getSelectionBackground());
                oLabel.setForeground(Color.white);
            } else {
                oLabel.setBackground(table.getBackground());
                oLabel.setForeground(table.getForeground());
            }
            if (null != value) {
                oLabel.setText(value.toString());
                oLabel.setToolTipText(value.toString());
            }
            return oLabel;
        }
    };

    public ActivationDataBaseDlg(ActivationDataBaseOperation oActivationDataBaseOperation) {
        this.m_oActivationDataBaseOperation = oActivationDataBaseOperation;
        this.m_oRebootTypeLst = (ArrayList)this.m_oActivationDataBaseOperation.getConfigParam().getActivationParaValueList();
        if (null != this.m_oRebootTypeLst) {
            this.m_arrRebootType = new ParaValue[this.m_oRebootTypeLst.size()];
            this.m_arrRebootType = this.m_oRebootTypeLst.toArray(new ParaValue[0]);
        }
        this.jbinit();
    }

    private void jbinit() {
        this.m_arrDevInfo = this.m_oActivationDataBaseOperation.getSelectedRowDevId();
        this.m_oAcivationDataBasePanel = new JPanel();
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        this.initDeviceInfoMgr();
        this.addTable();
        this.addButtons();
        this.addComponentsToPanel();
        if (this.m_oActivationDataBaseOperation.getConfigParam().isActivationRequired()) {
            this.setDisableRows();
        }
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
        this.setVisible(true);
    }

    private void setDisableRows() {
        if (this.m_oActivationDataBaseOperation.getConfigParam().isDeliverToBoardRebootReuqired()) {
            this.m_oStoreLastState = new HashMap();
            int iRowCount = this.m_oActivationDataBaseTableModel.getRowCount();
            for (int iRowIndex = 0; iRowIndex < iRowCount; ++iRowIndex) {
                String strRebootItem = this.m_oActivationDataBaseTableModel.getValueAt(iRowIndex, this.REBOOTTYPE_COLUMN_INDEX).toString();
                int iActivationId = this.getActivationId(strRebootItem);
                this.m_oStoreLastState.put(iRowIndex, iActivationId);
                if (0 != iActivationId) continue;
                ++this.m_iRowsIsDisableCount;
            }
            this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
        }
    }

    private void initDeviceInfoMgr() {
    }

    private void addComponentsToPanel() {
        this.m_oAcivationDataBasePanel.setLayout(null);
        this.m_oAcivationDataBasePanel.add(this.m_oAcivationDataBaseScrollPane);
        this.m_oAcivationDataBasePanel.add(this.m_oOKBtn);
        this.m_oAcivationDataBasePanel.add(this.m_oCancelBtn);
        this.aligncomponent();
        this.initializeActivationDataBaseOparetionData();
        this.getContentPane().add(this.m_oAcivationDataBasePanel);
        this.setTitle(ResourceManager.getInstance().getResString("ACTIVATE_DATABASE_TITLE"));
    }

    private void initializeActivationDataBaseOparetionData() {
        this.m_oActivationDataBaseOparetionData = new ActivationDataBaseOperationData();
        this.m_oActivationDataBaseOparetionData.setDeviceInfo(this.m_arrDevInfo);
        this.m_oActivationDataBaseOparetionData.setActivationDataBaseTableModel(this.m_oActivationDataBaseTableModel);
        this.m_oActivationDataBaseOparetionData.setActivationDataBaseDlg(this);
        this.m_oActivationDataBaseOparetionData.setDeviceTable(this.m_oActivationDataBaseOperation.getDeviceTable());
        this.m_oActivationDataBaseOparetionData.setDCTreeTableModel(this.m_oActivationDataBaseOperation.getDeviceTableModel());
    }

    private int getActivationId(String StrActivation) {
        ArrayList oRebootTypeLst = (ArrayList)this.m_oActivationDataBaseOperation.getConfigParam().getActivationParaValueList();
        int iActivationItemCount = oRebootTypeLst.size();
        String strActivationId = "";
        int iActivationValue = 0;
        ParaValue oParaValue = null;
        for (int index = 0; !(index >= iActivationItemCount || null != (oParaValue = (ParaValue)oRebootTypeLst.get(index)) && StrActivation.startsWith(oParaValue.getDisplayName())); ++index) {
        }
        if (null != oParaValue) {
            strActivationId = oParaValue.getId();
        }
        if (strActivationId.equals("NoReboot")) {
            iActivationValue = 0;
        }
        if (strActivationId.equals("OSSU")) {
            iActivationValue = 1;
        }
        if (strActivationId.equals("ISSU")) {
            iActivationValue = 2;
        }
        if (strActivationId.equals("ScheduledReboot")) {
            iActivationValue = 3;
        }
        if (strActivationId.equals("ActivationWithServiceBoards")) {
            iActivationValue = 6;
        }
        return iActivationValue;
    }

    private MouseMotionAdapter generateMouseMotionAdaper() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int colNum = ActivationDataBaseDlg.this.m_oAcivationDataBaseTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (colNum > -1) {
                    ActivationDataBaseDlg.this.m_oAcivationDataBaseTable.getTableHeader().setToolTipText(ActivationDataBaseDlg.this.m_oAcivationDataBaseTable.getColumnName(colNum));
                }
            }
        };
    }

    private void aligncomponent() {
        this.setSize(560, 360);
        this.m_oAcivationDataBaseScrollPane.setBounds(12, 12, 532, 270);
        this.m_oAcivationDataBasePanel.setBounds(0, 0, 550, 400);
        this.m_oOKBtn.setBounds(374, 294, 80, 21);
        this.m_oCancelBtn.setBounds(463, 294, 80, 21);
    }

    private void addButtons() {
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("START_BUTTON"));
        this.m_oOKBtn.setName("DeviceOperation_ActivationDataBaseDlg_m_oOKBtn");
        this.m_oOKBtn.setName("DeviceOperation_ActivationDataBaseDlg_m_oOKBtn");
        this.m_oOKBtn.setMnemonic('S');
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CLOSE_BUTTON"));
        this.m_oCancelBtn.setName("DeviceOperation_ActivationDataBaseDlg_m_oCancelBtn");
        this.m_oCancelBtn.setName("DeviceOperation_ActivationDataBaseDlg_m_oCancelBtn");
    }

    @Override
    protected void oKButton_ActionPerformed() {
        int iRowCount = this.m_oActivationDataBaseTableModel.getRowCount();
        this.m_oActivationDataBaseModel = new RecoverModel[iRowCount];
        this.fillRecoverModeldata();
        ActivationDataBaseOperationController oActivationDataBaseOperationController = new ActivationDataBaseOperationController(this.m_oActivationDataBaseModel, this.m_oActivationDataBaseOparetionData);
        oActivationDataBaseOperationController.sendActivationDataBaseRequest();
        this.dispose();
    }

    private void fillRecoverModeldata() {
        int iDevId = -1;
        int iRowCount = this.m_oActivationDataBaseTableModel.getRowCount();
        for (int iRowIndex = 0; iRowIndex < iRowCount; ++iRowIndex) {
            this.m_oActivationDataBaseModel[iRowIndex] = new RecoverModel();
            iDevId = Integer.parseInt(this.m_oActivationDataBaseTableModel.getValueAt(iRowIndex, 0).toString());
            this.m_oActivationDataBaseModel[iRowIndex].setDevId(iDevId);
            if (this.m_oActivationDataBaseOperation.getConfigParam().isActivationRequired()) {
                boolean bRebootSelected = false;
                String strRebootItem = this.m_oActivationDataBaseTableModel.getValueAt(iRowIndex, this.REBOOTTYPE_COLUMN_INDEX).toString();
                int iActivationId = this.getActivationId(strRebootItem);
                this.m_oActivationDataBaseModel[iRowIndex].setRebootType(iActivationId);
                this.m_oActivationDataBaseModel[iRowIndex].setReboot(bRebootSelected);
            }
            if (!this.m_oActivationDataBaseOperation.getConfigParam().isDeliverToBoardRebootReuqired()) continue;
            int isSelect = this.m_oActivationDataBaseTableModel.getValueAt(iRowIndex, this.DELIVER_TO_BOARD_REBOOT_FOR_MODEL_INDEX).hashCode();
            if (isSelect == 1) {
                this.m_oActivationDataBaseModel[iRowIndex].setDeliverToBoardReboot(true);
                continue;
            }
            this.m_oActivationDataBaseModel[iRowIndex].setDeliverToBoardReboot(false);
        }
    }

    private void addTable() {
        Vector<String> oColumnNameVector = new Vector<String>(5);
        oColumnNameVector.add(this.m_oResourceMgr.getResString("NE_ID"));
        oColumnNameVector.add(this.m_oResourceMgr.getResString("DEVICE_NAME"));
        oColumnNameVector.add(this.m_oResourceMgr.getResString("MULDEVICE_RECOVER_DLG_DEVICE_IP"));
        oColumnNameVector.add(this.m_oResourceMgr.getResString("MULDEVICE_RECOVER_DLG_REBOOT_DEVICE"));
        oColumnNameVector.add(this.m_oResourceMgr.getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT"));
        String[] arrColumnName = new String[oColumnNameVector.size()];
        for (int index = 0; index < arrColumnName.length; ++index) {
            arrColumnName[index] = oColumnNameVector.get(index).toString();
        }
        this.m_oActivationDataBaseTableModel = new ActivationDataBaseTableModel(this.m_arrDevInfo, arrColumnName, this.m_arrRebootType);
        this.m_oAcivationDataBaseTable = new JTable(this.m_oActivationDataBaseTableModel);
        this.m_oAcivationDataBaseTable.setName("DeviceOperation_ActivationDataBaseDlg_m_oAcivationDataBaseTable");
        this.m_oAcivationDataBaseTable.setName("DeviceOperation_ActivationDataBaseDlg_m_oAcivationDataBaseTable");
        this.addKeyListenerToComponent(this.m_oAcivationDataBaseTable);
        this.m_oAcivationDataBaseTable.addMouseListener(this.generateMouseAdapterForTable());
        this.m_oAcivationDataBaseTable.removeColumn(this.m_oAcivationDataBaseTable.getColumn(ResourceManager.getInstance().getResString("NE_ID")));
        if (!this.m_oActivationDataBaseOperation.getConfigParam().isActivationRequired()) {
            this.m_oAcivationDataBaseTable.removeColumn(this.m_oAcivationDataBaseTable.getColumn(this.m_oResourceMgr.getResString("MULDEVICE_RECOVER_DLG_REBOOT_DEVICE")));
        }
        if (!this.m_oActivationDataBaseOperation.getConfigParam().isDeliverToBoardRebootReuqired()) {
            this.m_oAcivationDataBaseTable.removeColumn(this.m_oAcivationDataBaseTable.getColumn(this.m_oResourceMgr.getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT")));
        }
        this.setColumnIndex();
        if (this.m_oActivationDataBaseOperation.getConfigParam().isDeliverToBoardRebootReuqired()) {
            TableColumn oSaveCoulmn = this.addCheckBoxToDeliverToBoardRebootHeader(true);
            oSaveCoulmn.setHeaderRenderer(this.m_oCheckBoxHeader);
            oSaveCoulmn.setMinWidth(120);
            oSaveCoulmn.setPreferredWidth(140);
            this.m_oAcivationDataBaseTable.getColumnModel().getColumn(this.DELIVER_TO_BOARD_REBOOT_FOR_TABLE_INDEX).setCellRenderer(this.getRenderer());
        }
        this.m_oAcivationDataBaseTable.getTableHeader().setReorderingAllowed(false);
        this.m_oAcivationDataBaseTable.getTableHeader().setPreferredSize(new Dimension(this.m_oAcivationDataBaseTable.getSize().width, 28));
        this.m_oAcivationDataBaseScrollPane = new JScrollPane();
        this.m_oAcivationDataBaseScrollPane.getViewport().add(this.m_oAcivationDataBaseTable);
        this.m_oAcivationDataBaseTable.setRowHeight(21);
        this.addTableListener();
        this.addCellRenderer();
        this.m_oAcivationDataBaseTable.updateUI();
    }

    private TableCellRenderer getRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
                return this.disableCheckBoxForsaveDevices(table, value, iRow);
            }

            private Component disableCheckBoxForsaveDevices(JTable table, Object value, int iRow) {
                JLabel jLabel = null;
                if (null == value) {
                    return null;
                }
                if (value.hashCode() == 2) {
                    jLabel = new JLabel(null, ResourceManager.getInstance().getImage("noneselect.gif"), 0);
                    jLabel.setEnabled(false);
                }
                if (value.hashCode() == 0) {
                    jLabel = new JLabel(null, ResourceManager.getInstance().getImage("noneselect.gif"), 0);
                }
                if (value.hashCode() == 1) {
                    jLabel = new JLabel(null, ResourceManager.getInstance().getImage("all.gif"), 0);
                }
                ActivationDataBaseDlg.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
                ActivationDataBaseDlg.this.m_oAcivationDataBaseTable.getTableHeader().updateUI();
                ActivationDataBaseDlg.this.m_oAcivationDataBaseTable.getTableHeader().repaint();
                return jLabel;
            }
        };
    }

    @Override
    public void doCleanUp() {
        this.setVisible(false);
        this.dispose();
    }

    private TableColumn addCheckBoxToDeliverToBoardRebootHeader(boolean bSetHeaderSave) {
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oSaveCoulmn = this.m_oAcivationDataBaseTable.getColumnModel().getColumn(this.DELIVER_TO_BOARD_REBOOT_FOR_TABLE_INDEX);
        this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, bSetHeaderSave, this, this.m_oAcivationDataBaseTable.getTableHeader().getBackground());
        return oSaveCoulmn;
    }

    public int rowsSelectedForDeliverToBoardReboot() {
        int count = this.m_iNoDeliverSelectedRows + this.m_iRowsIsDisableCount;
        int iRowCount = this.m_oActivationDataBaseTableModel.getRowCount();
        this.m_iSelectionType = count == iRowCount ? 0 : (count < iRowCount && this.m_iNoDeliverSelectedRows != 0 ? 1 : 2);
        return this.m_iSelectionType;
    }

    public boolean rowsDisableForDeliverToBoardReboot() {
        boolean isAllDisable = false;
        int iRowCount = this.m_oActivationDataBaseTableModel.getRowCount();
        if (this.m_iRowsIsDisableCount == iRowCount) {
            isAllDisable = true;
        }
        return isAllDisable;
    }

    private void setCheckBox() {
        int val = 2;
        int iRowCount = this.m_oActivationDataBaseTableModel.getRowCount();
        if (!this.m_bDeliverOption) {
            this.m_iNoDeliverSelectedRows = 0;
            val = 0;
        } else {
            this.m_iNoDeliverSelectedRows = iRowCount - this.m_iRowsIsDisableCount;
            val = 1;
        }
        for (int i = 0; i < iRowCount; ++i) {
            if (2 == (Integer)this.m_oActivationDataBaseTableModel.getValueAt(i, this.DELIVER_TO_BOARD_REBOOT_FOR_MODEL_INDEX)) continue;
            this.m_oActivationDataBaseTableModel.setValueAt(val, i, this.DELIVER_TO_BOARD_REBOOT_FOR_MODEL_INDEX);
        }
    }

    private void setColumnIndex() {
        if (this.m_oActivationDataBaseOperation.getConfigParam().isActivationRequired()) {
            this.REBOOTTYPE_COLUMN_INDEX = this.m_oAcivationDataBaseTable.getColumnModel().getColumnIndex(this.m_oResourceMgr.getResString("MULDEVICE_RECOVER_DLG_REBOOT_DEVICE"));
            ++this.REBOOTTYPE_COLUMN_INDEX;
        }
        if (this.m_oActivationDataBaseOperation.getConfigParam().isDeliverToBoardRebootReuqired()) {
            this.DELIVER_TO_BOARD_REBOOT_FOR_TABLE_INDEX = this.m_oAcivationDataBaseTable.getColumnModel().getColumnIndex(this.m_oResourceMgr.getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT"));
            this.DELIVER_TO_BOARD_REBOOT_FOR_MODEL_INDEX = this.m_oActivationDataBaseTableModel.findColumn(this.m_oResourceMgr.getResString("MULDEVICE_RECOVER_DLG_DELVER_TO_BOARD_REBOOT"));
        }
    }

    private void addTableListener() {
        this.m_oAcivationDataBaseTable.getTableHeader().addMouseMotionListener(this.generateMouseMotionAdaper());
    }

    private void addCellRenderer() {
        this.m_oAcivationDataBaseTable.getColumnModel().getColumn(0).setCellRenderer(this.tableCellRenderer);
        this.m_oAcivationDataBaseTable.getColumnModel().getColumn(1).setCellRenderer(this.tableCellRenderer);
        if (this.m_oActivationDataBaseOperation.getConfigParam().isActivationRequired()) {
            this.addRebootCellRenderer();
        }
    }

    private void addRebootCellRenderer() {
        RebootTypeCellRenderer oRebootCellRenderer = new RebootTypeCellRenderer(this.m_arrRebootType);
        this.m_oAcivationDataBaseTable.getColumnModel().getColumn(2).setCellRenderer(oRebootCellRenderer);
        this.m_oAcivationDataBaseTable.getColumnModel().getColumn(2).setCellEditor(new RebootTypeCellEditor(this.m_arrRebootType));
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_ACTIVATION_DATABASE";
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                ActivationDataBaseDlg.this.taskTable_MousePressed(oMouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent oMouseEvent) {
                ActivationDataBaseDlg.this.taskTable_MouseReleased(oMouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                ActivationDataBaseDlg.this.taskTable_MouseClicked(oMouseEvent);
            }
        };
    }

    private void taskTable_MousePressed(MouseEvent oMouseEvent) {
    }

    private void taskTable_MouseReleased(MouseEvent oMouseEvent) {
    }

    private void taskTable_MouseClicked(MouseEvent oMouseEvent) {
        int iClickedColumn = this.m_oAcivationDataBaseTable.columnAtPoint(oMouseEvent.getPoint());
        if (iClickedColumn == this.DELIVER_TO_BOARD_REBOOT_FOR_TABLE_INDEX) {
            int rowSelected = this.m_oAcivationDataBaseTable.getSelectedRow();
            int isSelect = this.m_oActivationDataBaseTableModel.getValueAt(rowSelected, this.DELIVER_TO_BOARD_REBOOT_FOR_MODEL_INDEX).hashCode();
            if (isSelect == 2) {
                return;
            }
            if (isSelect == 0) {
                ++this.m_iNoDeliverSelectedRows;
                this.m_oActivationDataBaseTableModel.setValueAt(1, rowSelected, this.DELIVER_TO_BOARD_REBOOT_FOR_MODEL_INDEX);
            } else if (isSelect == 1) {
                --this.m_iNoDeliverSelectedRows;
                this.m_oActivationDataBaseTableModel.setValueAt(0, rowSelected, this.DELIVER_TO_BOARD_REBOOT_FOR_MODEL_INDEX);
            }
            this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            this.m_oAcivationDataBaseTable.getTableHeader().repaint();
        }
    }

    private class RebootTypeCellEditor
    extends DefaultCellEditor {
        public RebootTypeCellEditor(Object[] items) {
            super(new ComboBoxWithToolTip(items));
        }
    }

    public class RebootTypeCellRenderer
    extends ComboBoxWithToolTip
    implements TableCellRenderer {
        public RebootTypeCellRenderer(Object[] oRebootType) {
            super(oRebootType);
            this.setSelectedItem(oRebootType[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!ActivationDataBaseDlg.this.m_oOKBtn.isEnabled()) {
                return;
            }
            if (source instanceof AbstractButton) {
                if (0 == ActivationDataBaseDlg.this.m_iSelectionType) {
                    ActivationDataBaseDlg.this.m_bDeliverOption = false;
                } else if (2 == ActivationDataBaseDlg.this.m_iSelectionType || 1 == ActivationDataBaseDlg.this.m_iSelectionType) {
                    ActivationDataBaseDlg.this.m_bDeliverOption = true;
                }
            } else {
                return;
            }
            ActivationDataBaseDlg.this.setCheckBox();
            ActivationDataBaseDlg.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
        }
    }
}

