/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.controller;

import com.huawei.dc.common.asndatacenter.AsnActivationTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDCManualRecoverInfo;
import com.huawei.dc.common.asndatacenter.AsnDCManualRecoverReqeust;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.ActivationDataBaseOperationData;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.ActivationDataBaseTableModel;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.view.ActivationDataBaseDlg;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.deviceoperation.recover.model.RecoverModel;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.SwingUtilities;

public class ActivationDataBaseOperationController {
    private ActivationDataBaseTableModel m_oActivationDataBaseTableModel;
    private RecoverModel[] m_oarrActivationDataBaseModel;
    private ActivationDataBaseDlg m_oActivationDataBaseDlg;
    private DeviceInfo[] m_arrDevInfo;
    private JSortTreeTable m_oDeviceTable;

    public ActivationDataBaseOperationController(RecoverModel[] m_oActivationDataBaseModel, ActivationDataBaseOperationData m_oActivationDataBaseOparetionData) {
        this.m_oActivationDataBaseDlg = m_oActivationDataBaseOparetionData.getActivationDataBaseDlg();
        this.m_oActivationDataBaseTableModel = m_oActivationDataBaseOparetionData.getActivationDataBaseTableModel();
        this.m_oarrActivationDataBaseModel = m_oActivationDataBaseModel;
        this.m_arrDevInfo = m_oActivationDataBaseOparetionData.getDeviceInfos();
        this.m_oDeviceTable = m_oActivationDataBaseOparetionData.getDeviceTabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendActivationDataBaseRequest() {
        AsnDCManualRecoverReqeust oActivationDataBaseRequest = this.fillAsnActivationDataBaseOperationRequest();
        IDeviceOperationManager deviceoperationMgr = DCFrameWorkUtil.getDeviceOperationManager();
        AsnDCOpertionRsp operationRsp = new AsnDCOpertionRsp();
        Object object = DCFrameWorkUtil.getSynchronizedObject();
        synchronized (object) {
            operationRsp = deviceoperationMgr.activationDataBase(oActivationDataBaseRequest);
            this.processActivationDataBaseResponse(operationRsp);
        }
    }

    private void processActivationDataBaseResponse(AsnDCOpertionRsp oActivationDataBaseResp) {
        int iErrorCode = -1;
        iErrorCode = oActivationDataBaseResp.oErrorInfo.iErrorNo.intValue();
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            this.doCleanup();
        } else {
            this.updateProgresssOnDeviceTable();
        }
    }

    private void doCleanup() {
        this.m_oActivationDataBaseDlg.dispose();
    }

    private void updateProgresssOnDeviceTable() {
        int iOperationType = 25;
        OperationStatus oOperationStatus = null;
        for (int iRowIndex = 0; iRowIndex < this.m_arrDevInfo.length; ++iRowIndex) {
            oOperationStatus = new OperationStatus();
            oOperationStatus.setOperationType(iOperationType);
            oOperationStatus.setIsProgress(true);
            oOperationStatus.setProgress(0);
            this.setOperationStatus(this.m_arrDevInfo[iRowIndex], oOperationStatus);
        }
    }

    private void setOperationStatus(DeviceInfo oDevInfo, OperationStatus oOpeartionStatus) {
        BusyDeviceObjectStore.getInstance().updateOperationStatusForDevice(oDevInfo, oOpeartionStatus);
        this.updateTable();
    }

    private void updateTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActivationDataBaseOperationController.this.m_oDeviceTable.updateUI();
            }
        });
    }

    private AsnDCManualRecoverReqeust fillAsnActivationDataBaseOperationRequest() {
        AsnDCManualRecoverReqeust oAsnDCManualActivationDataBaseReqeust = new AsnDCManualRecoverReqeust();
        oAsnDCManualActivationDataBaseReqeust.oReqID = BigInteger.valueOf(DCFrameWorkUtil.generateRequestId());
        AsnDCManualRecoverInfo oAsnDCManualActivationDataBaseInfo = null;
        int iRowCount = this.m_oActivationDataBaseTableModel.getRowCount();
        for (int iRowIndex = 0; iRowIndex < iRowCount; ++iRowIndex) {
            oAsnDCManualActivationDataBaseInfo = new AsnDCManualRecoverInfo();
            oAsnDCManualActivationDataBaseInfo.iDeviceId = BigInteger.valueOf(this.m_oarrActivationDataBaseModel[iRowIndex].getDevId());
            oAsnDCManualActivationDataBaseInfo.enReboot = new AsnActivationTypeEnum(this.m_oarrActivationDataBaseModel[iRowIndex].getRebootType());
            oAsnDCManualActivationDataBaseInfo.bDeliverToBoardReboot = this.m_oarrActivationDataBaseModel[iRowIndex].getDeliverToBoardReboot();
            oAsnDCManualActivationDataBaseInfo.strFileName = "".getBytes();
            oAsnDCManualActivationDataBaseInfo.strServerName = "".getBytes();
            oAsnDCManualActivationDataBaseReqeust.oAsnDCManualRecoverList.add((Object)oAsnDCManualActivationDataBaseInfo);
        }
        return oAsnDCManualActivationDataBaseReqeust;
    }
}

