/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation.view;

import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperationUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ViewActivationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField m_oActivationTypeTxtField;
    private JTextField m_oActivationModeTxtField;
    private JTextField m_oActivationTimeTxtField;
    private JTextField m_oDelayRebootTxtField;
    private JLabel m_oActivateTimeLabel;
    private JLabel m_oActivateTypeLabel;
    private JLabel m_oActivateModeLabel;
    private JLabel m_oDelayRebootLabel;
    private ActivationConfigPara m_oActivationConfigPara;
    private ResourceManager oResourceManager = ResourceManager.getInstance();
    private ResourceManager m_oResourceMgr;
    private JSortTreeTable m_oDeviceTreeTable;
    private DCTreeTableModel m_oDeviceTreeTableModel;
    private TreeTableNode m_oRootNode;
    private boolean m_bIsGroupLevelView;
    private JScrollPane m_oDeviceTableScrollPane;
    private static int COLUMN_SIZE = 5;

    public ViewActivationPanel(ActivationConfigPara oActivationConfigPara, ITask oTaskObj) {
        this.setSize(608, 400);
        this.setLayout(null);
        this.m_oActivationConfigPara = oActivationConfigPara;
        this.m_oResourceMgr = ResourceManager.getInstance();
        String strActivationMode = this.m_oActivationConfigPara.getSelectedActivationMode().getId();
        List oElementList = ActivationOperationUtil.getElementInfo(oActivationConfigPara, strActivationMode);
        this.m_oActivationConfigPara.setElementInfoLst(oElementList);
        if ("GroupActivation".equalsIgnoreCase(strActivationMode)) {
            this.m_bIsGroupLevelView = true;
        }
        this.createTableComponent();
        this.initializeLabelComponents();
        this.initializeTextFields();
        this.fillActivateConfigInfo();
        this.populateDeviceTable();
    }

    private void initializeTextFields() {
        this.m_oActivationTimeTxtField = new JTextField();
        this.m_oActivationTimeTxtField.setBounds(486, 12, 113, 20);
        this.m_oActivationTimeTxtField.setEditable(false);
        this.m_oDelayRebootTxtField = new JTextField();
        this.m_oDelayRebootTxtField.setBounds(486, 44, 113, 20);
        this.m_oDelayRebootTxtField.setEditable(false);
        this.m_oActivationTypeTxtField = new JTextField();
        this.m_oActivationTypeTxtField.setBounds(128, 12, 126, 20);
        this.m_oActivationTypeTxtField.setEditable(false);
        this.m_oActivationModeTxtField = new JTextField();
        this.m_oActivationModeTxtField.setBounds(128, 44, 126, 20);
        this.m_oActivationModeTxtField.setEditable(false);
    }

    private void initializeLabelComponents() {
        this.m_oActivateTimeLabel = new JLabel();
        this.m_oActivateTimeLabel.setText(this.oResourceManager.getResString("ACTIVATE_TIME") + ':');
        this.m_oActivateTimeLabel.setBounds(370, 14, 100, 16);
        this.m_oDelayRebootLabel = new JLabel();
        this.m_oDelayRebootLabel.setText(this.oResourceManager.getResString("Delay_Time_Label") + ':');
        this.m_oDelayRebootLabel.setBounds(370, 46, 130, 16);
        this.m_oActivateTypeLabel = new JLabel();
        this.m_oActivateTypeLabel.setText(this.oResourceManager.getResString("ACTIVATION_TYPE") + ':');
        this.m_oActivateTypeLabel.setBounds(22, 14, 100, 16);
        this.m_oActivateModeLabel = new JLabel();
        this.m_oActivateModeLabel.setText(this.oResourceManager.getResString("ACTIVATION_MODE") + ':');
        this.m_oActivateModeLabel.setBounds(22, 46, 100, 16);
    }

    private void createTableComponent() {
        this.createTreeTableModel();
        this.createTreeTable();
        this.m_oDeviceTableScrollPane = new JScrollPane((Component)((Object)this.m_oDeviceTreeTable));
        this.m_oDeviceTableScrollPane.setName("DeviceOperation_ViewActivationPanel_m_oDeviceTableScrollPane");
        this.m_oDeviceTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oDeviceTableScrollPane.setBounds(22, 76, 578, 298);
        this.add(this.m_oDeviceTableScrollPane);
    }

    private void fillActivateConfigInfo() {
        if (this.m_oActivationConfigPara.isActivationTimeRequired()) {
            this.fillActivateTimeInfo(this.m_oActivationConfigPara.getActivationUTCTime());
        }
        if (this.m_oActivationConfigPara.isActivationTypeRequired()) {
            this.fillActivateTypeSet();
        }
        if (this.m_oActivationConfigPara.isDelayRebootRequired()) {
            this.fillDelayRebootInfo();
        }
        this.fillActivateModeSet();
    }

    private void fillActivateModeSet() {
        this.m_oActivationModeTxtField.setText(this.m_oActivationConfigPara.getSelectedActivationMode().toString());
        this.m_oActivationModeTxtField.setToolTipText(this.m_oActivationConfigPara.getSelectedActivationMode().toString());
        this.m_oActivationModeTxtField.setCaretPosition(0);
        this.add(this.m_oActivationModeTxtField);
        this.add(this.m_oActivateModeLabel);
    }

    private void fillActivateTypeSet() {
        if (null != this.m_oActivationConfigPara.getSelectedActivateType()) {
            this.m_oActivationTypeTxtField.setText(this.m_oActivationConfigPara.getSelectedActivateType().toString());
            this.m_oActivationTypeTxtField.setToolTipText(this.m_oActivationConfigPara.getSelectedActivateType().toString());
            if ("ScheduledReboot".equals(this.m_oActivationConfigPara.getSelectedActivateType().getParaValue().getId())) {
                TimeDateFormatUtil.switchLocalCalendar((Calendar)this.m_oActivationConfigPara.getSelectedActivateType().getScheduledActivationTime());
                this.fillActivateTimeInfo(this.m_oActivationConfigPara.getSelectedActivateType().getScheduledActivationTime());
            }
        }
        this.m_oActivationTypeTxtField.setCaretPosition(0);
        this.add(this.m_oActivationTypeTxtField);
        this.add(this.m_oActivateTypeLabel);
    }

    private void fillDelayRebootInfo() {
        ITask taskRef;
        long lDelayTime = this.m_oActivationConfigPara.getM_oDelayTime();
        if (lDelayTime != -1L) {
            this.m_oDelayRebootTxtField.setText(String.valueOf(lDelayTime));
            this.m_oDelayRebootTxtField.setToolTipText(String.valueOf(lDelayTime));
            this.m_oDelayRebootTxtField.setCaretPosition(0);
        }
        if (!(taskRef = this.m_oActivationConfigPara.getTaskRef()).isStackDevicePresent(3)) {
            this.add(this.m_oDelayRebootLabel);
            this.add(this.m_oDelayRebootTxtField);
        }
    }

    private void fillActivateTimeInfo(Calendar oCalObj) {
        ITask taskRef;
        if (null != oCalObj) {
            String strTime = DCTimeDateUtil.getLocaleDisplayTime(oCalObj);
            this.m_oActivationTimeTxtField.setText(strTime);
            this.m_oActivationTimeTxtField.setToolTipText(strTime);
            this.m_oActivationTimeTxtField.setCaretPosition(0);
        }
        if (!(taskRef = this.m_oActivationConfigPara.getTaskRef()).isStackDevicePresent(3)) {
            this.add(this.m_oActivateTimeLabel);
            this.add(this.m_oActivationTimeTxtField);
        }
    }

    private void populateDeviceTable() {
        if (this.m_bIsGroupLevelView) {
            this.populateGroupsToTable(this.m_oActivationConfigPara.getActivateGroupInfoLst());
        } else {
            this.populateResourcesToTreeTable(this.m_oActivationConfigPara.getElementInfoLst());
        }
    }

    private void createTreeTableModel() {
        Vector<String> oTableHeader = new Vector<String>(4);
        if (this.m_bIsGroupLevelView) {
            oTableHeader.add(this.m_oResourceMgr.getResString("ACTIVATION_TABLE_GROUP_NAME_COLUMN"));
        }
        oTableHeader.add(this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_NAME"));
        oTableHeader.add(this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_IP"));
        oTableHeader.add(this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_VERSION"));
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class};
        boolean[] arrSortableColumns = new boolean[]{true, false, false, false};
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false};
        this.m_oDeviceTreeTableModel = new DCTreeTableModel(oTableHeader.toArray(new String[0]), arrColumnTypes, arrSortableColumns, arrEditableColumns);
        this.m_oRootNode = this.m_oDeviceTreeTableModel.getRoot();
    }

    private void createTreeTable() {
        this.m_oDeviceTreeTable = new JSortTreeTable(this.m_oDeviceTreeTableModel);
        this.m_oDeviceTreeTable.setName("DeviceOperation_ViewActivationPanel_m_oDeviceTreeTable");
        this.m_oDeviceTreeTable.setOpaque(false);
        this.m_oDeviceTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oDeviceTreeTable.getTableHeader().setPreferredSize(new Dimension(this.m_oDeviceTreeTable.getSize().width, 20));
        this.m_oDeviceTreeTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.m_oDeviceTreeTable.getColumnModel().getColumn(0).setMaxWidth(250);
        this.m_oDeviceTreeTable.setRowHeight(20);
        DefaultListSelectionModel devSelection = new DefaultListSelectionModel();
        devSelection.setSelectionMode(2);
        this.m_oDeviceTreeTable.setSelectionModel(devSelection);
        this.initializeTableCellRenderer();
    }

    private void initializeTableCellRenderer() {
        DCTreeTableCellRenderer oDefaultCellRenderer = new DCTreeTableCellRenderer(this.m_oDeviceTreeTable);
        int iColumnCount = this.m_oDeviceTreeTable.getColumnModel().getColumnCount();
        for (int i = 0; i < iColumnCount; ++i) {
            this.m_oDeviceTreeTable.getColumnModel().getColumn(i).setCellRenderer(oDefaultCellRenderer);
        }
    }

    public void populateResourcesToTreeTable(List oResourceList) {
        if (null == oResourceList || 0 == oResourceList.size()) {
            return;
        }
        this.m_oRootNode.removeAllChildren();
        int iResourceCount = oResourceList.size();
        for (int i = 0; i < iResourceCount; ++i) {
            ActivationElementInfo oElementInfo = (ActivationElementInfo)oResourceList.get(i);
            this.addResourceToTableModel(oElementInfo, this.m_oRootNode);
        }
        this.m_oDeviceTreeTable.getSelectionModel().setSelectionInterval(0, 0);
        this.refreshTable();
    }

    public void populateGroupsToTable(List oGroupList) {
        if (null == oGroupList || 0 == oGroupList.size()) {
            return;
        }
        this.m_oRootNode.removeAllChildren();
        int iGroupCount = oGroupList.size();
        for (int i = 0; i < iGroupCount; ++i) {
            ActivationGroupInfo oGroup = (ActivationGroupInfo)oGroupList.get(i);
            this.addGroupToTableModel(oGroup);
        }
        this.refreshTable();
    }

    private void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewActivationPanel.this.m_oDeviceTreeTable.getTableHeader().updateUI();
                ViewActivationPanel.this.m_oDeviceTreeTable.updateUI();
            }
        });
    }

    private void addResourceToTableModel(ActivationElementInfo oElementInfo, TreeTableNode oNode) {
        if (3 == oElementInfo.getResource().getRoleType() && -1 != oElementInfo.getResource().getStackId()) {
            return;
        }
        TreeTableCellData[] oTreeTableCellData = this.fillRowForElementInfo(oElementInfo);
        TreeTableRowData oRowData = new TreeTableRowData(oTreeTableCellData);
        TreeTableNode oElementNode = new TreeTableNode(oRowData);
        int iNodeIndex = 0;
        if (this.m_bIsGroupLevelView) {
            iNodeIndex = 1;
        }
        ((TreeTableNodeCellData)oTreeTableCellData[iNodeIndex]).setAttachedTreeNode(oNode);
        oNode.add(oElementNode);
    }

    private void addGroupToTableModel(ActivationGroupInfo oGroupInfo) {
        TreeTableCellData[] oTreeTableCellData = this.fillRowForGroupInfo(oGroupInfo);
        TreeTableRowData oRowData = new TreeTableRowData(oTreeTableCellData);
        TreeTableNode oNode = new TreeTableNode(oRowData);
        ((TreeTableNodeCellData)oTreeTableCellData[0]).setAttachedTreeNode(oNode);
        this.m_oRootNode.add(oNode);
        List<ActivationElementInfo> oElementList = this.m_oActivationConfigPara.getElementsFromGroup(oGroupInfo.getGroupId());
        int iElementCount = oElementList.size();
        for (int i = 0; i < iElementCount; ++i) {
            ActivationElementInfo oElement = oElementList.get(i);
            this.addResourceToTableModel(oElement, oNode);
        }
    }

    private TreeTableCellData[] fillRowForElementInfo(ActivationElementInfo oElementInfo) {
        TreeTableCellData[] oTreeTableCellData = null;
        if (this.m_bIsGroupLevelView) {
            oTreeTableCellData = new TreeTableCellData[COLUMN_SIZE];
            oTreeTableCellData[1] = this.getTableNodeData(oElementInfo);
            Resource oResource = oElementInfo.getResource();
            oTreeTableCellData[2] = this.getCellData(oResource.getDeviceIP());
            oTreeTableCellData[3] = this.getCellData(oResource.getDeviceVersion());
        } else {
            oTreeTableCellData = new TreeTableCellData[COLUMN_SIZE - 1];
            oTreeTableCellData[0] = this.getTableNodeData(oElementInfo);
            Resource oResource = oElementInfo.getResource();
            oTreeTableCellData[1] = this.getCellData(oResource.getDeviceIP());
            oTreeTableCellData[2] = this.getCellData(oResource.getDeviceVersion());
        }
        return oTreeTableCellData;
    }

    private TreeTableCellData[] fillRowForGroupInfo(ActivationGroupInfo oGroupInfo) {
        TreeTableCellData[] oTreeTableCellData = null;
        oTreeTableCellData = this.m_bIsGroupLevelView ? new TreeTableCellData[COLUMN_SIZE] : new TreeTableCellData[COLUMN_SIZE - 1];
        oTreeTableCellData[0] = this.getTableNodeData(oGroupInfo);
        return oTreeTableCellData;
    }

    private TreeTableCellData getCellData(Object colValue) {
        return new TreeTableCellData(colValue);
    }

    private TreeTableNodeCellData getTableNodeData(Object oNodeInfo) {
        TreeTableNodeCellData oDeviceNodeData = new TreeTableNodeCellData();
        if (oNodeInfo instanceof ActivationElementInfo) {
            oDeviceNodeData.setNodeClosedIcon("");
            oDeviceNodeData.setNodeOpenedIcon("");
            oDeviceNodeData.setNodeLeafIcon("");
        }
        oDeviceNodeData.setCellDataValue(oNodeInfo);
        return oDeviceNodeData;
    }
}

