/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation.view;

import com.huawei.dc.common.components.deviceselection.table.DCDefaultTableRenderer;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupManager;
import com.huawei.dc.taskmgmt.model.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class SelectedResourcesTablePanel
extends JPanel {
    private JTable m_oSelectedResourceTable;
    private DefaultTableModel m_oSelectedResourceTableModel;
    private JScrollPane m_oSelectedResourceTableScrollPane;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private static final int RESOURCE_NAME_COLUMN = 0;
    private static final int COLUMN_COUNT = 2;

    public SelectedResourcesTablePanel(ActivationGroupManager oManager) {
        this.initSelectedResourcePanel();
    }

    private void initSelectedResourcePanel() {
        this.setBorder(new TitledBorder(this.m_oResManager.getResString("SELECTED_RESOURCE_PANEL_TITLE")));
        this.setLayout(null);
        this.createTableModel();
        this.createTable();
        this.m_oSelectedResourceTableScrollPane = new JScrollPane(this.m_oSelectedResourceTable);
        this.m_oSelectedResourceTableScrollPane.setName("DeviceOperation_SelectedResourcesTablePanel_m_oSelectedResourceTableScrollPane");
        this.m_oSelectedResourceTableScrollPane.setVerticalScrollBarPolicy(22);
        this.m_oSelectedResourceTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oSelectedResourceTableScrollPane.setBounds(15, 25, 267, 230);
        this.add(this.m_oSelectedResourceTableScrollPane);
    }

    private void createTable() {
        this.m_oSelectedResourceTable = new JTable(this.m_oSelectedResourceTableModel);
        this.m_oSelectedResourceTable.setName("DeviceOperation_SelectedResourcesTablePanel_m_oSelectedResourceTable");
        this.initializeTableCellRenderer();
    }

    private void createTableModel() {
        this.m_oSelectedResourceTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_oSelectedResourceTableModel.addColumn(this.m_oResManager.getResString("DEVICE_TABLE_COLUMN_DEVICE_NAME"));
        this.m_oSelectedResourceTableModel.addColumn(this.m_oResManager.getResString("DEVICE_TABLE_COLUMN_DEVICE_IP"));
    }

    private void initializeTableCellRenderer() {
        DCDefaultTableRenderer oRenderer = new DCDefaultTableRenderer();
        for (int i = 0; i < 2; ++i) {
            this.m_oSelectedResourceTable.getColumnModel().getColumn(i).setCellRenderer(oRenderer);
        }
    }

    public void addResourcesToTable(List oElementList) {
        if (null == oElementList || 0 == oElementList.size()) {
            return;
        }
        int iElementCount = oElementList.size();
        for (int i = 0; i < iElementCount; ++i) {
            ActivationElementInfo oElement = (ActivationElementInfo)oElementList.get(i);
            this.addElementToTable(oElement);
        }
        this.refreshTable(iElementCount);
    }

    public void refreshTable(int iRowsToBeSelected) {
        int iRowCount = this.m_oSelectedResourceTable.getRowCount();
        if (iRowsToBeSelected <= iRowCount) {
            if (1 == iRowsToBeSelected) {
                this.setDefaultSelection(iRowCount - 1, iRowCount - 1);
            } else {
                int iMin = iRowCount - iRowsToBeSelected;
                int iMax = iRowCount - 1;
                if (0 > iMin) {
                    iMin = 0;
                }
                this.setDefaultSelection(iMin, iMax);
            }
        }
        this.updateTable();
    }

    private void setDefaultSelection(int iMinSel, int iMaxSel) {
        if (this.m_oSelectedResourceTable.getRowCount() > 0) {
            this.m_oSelectedResourceTable.getSelectionModel().setSelectionInterval(iMinSel, iMaxSel);
        }
    }

    private void updateTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectedResourcesTablePanel.this.m_oSelectedResourceTable.updateUI();
            }
        });
    }

    private void addElementToTable(ActivationElementInfo oElement) {
        Vector<Object> oVector = new Vector<Object>(2);
        Resource oRes = oElement.getResource();
        oVector.addElement(oElement);
        oVector.addElement(oRes.getDeviceIP());
        this.m_oSelectedResourceTableModel.addRow(oVector);
    }

    public List deleteSelectedResources() {
        int[] arrSelectedRows = this.m_oSelectedResourceTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return null;
        }
        Vector<Vector> oDataVector = this.m_oSelectedResourceTableModel.getDataVector();
        ArrayList<ActivationElementInfo> oSelectedElements = new ArrayList<ActivationElementInfo>(0);
        int iStartIndex = arrSelectedRows.length - 1;
        if (iStartIndex > oDataVector.size() - 1) {
            iStartIndex = oDataVector.size() - 1;
        }
        for (int i = iStartIndex; i >= 0 && iStartIndex >= 0; --i) {
            Vector oRowVector = oDataVector.get(arrSelectedRows[i]);
            ActivationElementInfo oElement = (ActivationElementInfo)oRowVector.get(0);
            if (null == oElement) continue;
            oSelectedElements.add(oElement);
            oDataVector.remove(oRowVector);
        }
        if (0 < oDataVector.size()) {
            this.setDefaultSelection(oDataVector.size() - 1, oDataVector.size() - 1);
        }
        this.updateTable();
        return oSelectedElements;
    }

    public List getCurrentElements() {
        Vector<Vector> oDataVector = this.m_oSelectedResourceTableModel.getDataVector();
        ArrayList<ActivationElementInfo> oCurrentElements = new ArrayList<ActivationElementInfo>(0);
        int iElementCount = oDataVector.size();
        for (int i = 0; i < iElementCount; ++i) {
            Vector oRowVector = oDataVector.get(i);
            ActivationElementInfo oElement = (ActivationElementInfo)oRowVector.get(0);
            if (null == oElement) continue;
            oCurrentElements.add(oElement);
        }
        return oCurrentElements;
    }
}

