/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation.view;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupManager;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.SelectedResourcesTablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CurrentGroupsTreePanel
extends JPanel {
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private JTree m_oResourceTree;
    private DefaultTreeModel m_oResourceTreeModel;
    private JScrollPane m_oResourceTreeTableScrollPane;
    private ActivationGroupManager m_oGroupManager;
    private DefaultMutableTreeNode m_oRootNode;

    public CurrentGroupsTreePanel(SelectedResourcesTablePanel oSelectedResourcePanel, ActivationGroupManager oGroupManager) {
        this.m_oGroupManager = oGroupManager;
        this.setBorder(new TitledBorder(this.m_oResManager.getResString("CURRENT_GROUPS_TREE_PANEL_TITLE")));
        this.setLayout(null);
        this.initResourceTree();
        this.add(this.m_oResourceTreeTableScrollPane);
    }

    private void initResourceTree() {
        this.m_oResourceTree = new JTree();
        this.m_oResourceTree.setName("DeviceOperation_CurrentGroupsTreePanel_m_oResourceTree");
        this.m_oResourceTree.setCellRenderer(this.generateRenderer());
        this.m_oResourceTreeModel = (DefaultTreeModel)this.m_oResourceTree.getModel();
        this.setRootNode();
        this.addGroupsToTree();
        this.expandTreeAtRoot();
        this.m_oResourceTreeTableScrollPane = new JScrollPane(this.m_oResourceTree);
        this.m_oResourceTreeTableScrollPane.setName("DeviceOperation_CurrentGroupsTreePanel_m_oResourceTreeTableScrollPane");
        this.m_oResourceTreeTableScrollPane.setVerticalScrollBarPolicy(22);
        this.m_oResourceTreeTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oResourceTreeTableScrollPane.setBounds(15, 25, 245, 230);
    }

    private TreeCellRenderer generateRenderer() {
        return new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object aValue, boolean anIsSelected, boolean anIsExpanded, boolean leaf, int row, boolean hasFocus) {
                if (!(aValue instanceof DefaultMutableTreeNode)) {
                    return null;
                }
                DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)aValue;
                Object oNodeUserObject = oNode.getUserObject();
                if (null == oNodeUserObject) {
                    oNodeUserObject = "";
                }
                JPanel oPanel = new JPanel();
                oPanel.setBackground(DCFrameWorkUtil.getBackgroundColor());
                JLabel oLabel = this.initializeLabelForNode(oNodeUserObject, anIsSelected, leaf, anIsExpanded);
                oLabel.setText(oNodeUserObject.toString());
                oPanel.setLayout(new BorderLayout());
                oPanel.add(oLabel);
                return oPanel;
            }

            protected JLabel initializeLabelForNode(Object oUserObject, boolean anIsSelected, boolean bIsLeaf, boolean anIsExpanded) {
                JLabel oLabel = this.createLabelWithIcon(oUserObject, bIsLeaf, anIsExpanded);
                if (anIsSelected) {
                    oLabel.setForeground(Color.BLUE);
                } else {
                    oLabel.setForeground(Color.BLACK);
                }
                return oLabel;
            }

            protected JLabel createLabelWithIcon(Object oUserObject, boolean bIsLeaf, boolean anIsExpanded) {
                JLabel oLabel = new JLabel();
                ImageIcon oCollapsedImageIcon = ResourceManager.getInstance().getImage("");
                oLabel.setIcon(oCollapsedImageIcon);
                return oLabel;
            }
        };
    }

    private void addGroupsToTree() {
        List oActivationGroupInfoList = this.m_oGroupManager.getActivateGroupInfoLst();
        int iSize = oActivationGroupInfoList.size();
        for (int index = 0; index < iSize; ++index) {
            ActivationGroupInfo oActivationGroupInfo = (ActivationGroupInfo)oActivationGroupInfoList.get(index);
            DefaultMutableTreeNode oActivationGroupInfoNode = new DefaultMutableTreeNode(oActivationGroupInfo);
            int iGroupId = oActivationGroupInfo.getGroupId();
            List oElementList = this.m_oGroupManager.getElementsFromGroup(iGroupId);
            this.populateElementsInGroupNode(oActivationGroupInfoNode, oElementList);
            this.m_oRootNode.add(oActivationGroupInfoNode);
        }
    }

    private void expandTreeAtRoot() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null == CurrentGroupsTreePanel.this.m_oResourceTree) {
                    return;
                }
                CurrentGroupsTreePanel.this.m_oResourceTree.treeDidChange();
                TreePath rowTreePath = CurrentGroupsTreePanel.this.m_oResourceTree.getPathForRow(0);
                if (CurrentGroupsTreePanel.this.m_oResourceTree.isCollapsed(rowTreePath)) {
                    CurrentGroupsTreePanel.this.m_oResourceTree.expandPath(rowTreePath);
                }
            }
        });
    }

    private void populateElementsInGroupNode(DefaultMutableTreeNode oActivationGroupInfoNode, List oElementList) {
        if (null == oElementList) {
            return;
        }
        int iSize = oElementList.size();
        for (int index = 0; index < iSize; ++index) {
            ActivationElementInfo oElementInfo = (ActivationElementInfo)oElementList.get(index);
            DefaultMutableTreeNode oElementNode = new DefaultMutableTreeNode(oElementInfo);
            oActivationGroupInfoNode.add(oElementNode);
        }
    }

    private void setRootNode() {
        this.m_oRootNode = new DefaultMutableTreeNode(this.m_oResManager.getResString("GROUPS_TREE_ROOT"));
        this.m_oResourceTreeModel.setRoot(this.m_oRootNode);
        this.m_oResourceTree.setSelectionRow(0);
    }

    public List deleteResourcesFromCurrentGroups(ActivationGroupInfo oNewGroup) {
        int[] arrSelecteRows = this.m_oResourceTree.getSelectionRows();
        if (null == arrSelecteRows || 0 == arrSelecteRows.length) {
            return null;
        }
        ArrayList<ActivationElementInfo> oElementList = new ArrayList<ActivationElementInfo>(0);
        for (int i = 0; i < arrSelecteRows.length; ++i) {
            DefaultMutableTreeNode oNode;
            TreePath oPath = this.m_oResourceTree.getPathForRow(arrSelecteRows[i]);
            if (null == oPath || (oNode = (DefaultMutableTreeNode)oPath.getLastPathComponent()) == null || !(oNode.getUserObject() instanceof ActivationElementInfo)) continue;
            ActivationElementInfo oElement = (ActivationElementInfo)oNode.getUserObject();
            ActivationGroupInfo oGroup = this.m_oGroupManager.getGroupForId(oElement.getGroupId());
            if (1 == oNode.getSiblingCount() && this.m_oGroupManager.isDefaultGroup(oGroup)) {
                this.showErrorMessage(this.m_oResManager.getResString("DEFAULT_GROUP_CANNOT_BE_EMPTY"));
                this.refreshPanel();
                return oElementList;
            }
            oElementList.add(oElement);
            oNode.removeFromParent();
            oNode = null;
        }
        this.refreshPanel();
        return oElementList;
    }

    private void refreshPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CurrentGroupsTreePanel.this.m_oResourceTree.updateUI();
                CurrentGroupsTreePanel.this.m_oResourceTreeTableScrollPane.updateUI();
                CurrentGroupsTreePanel.this.updateUI();
            }
        });
    }

    public void addElementsToCurrentGroups(List oElementList) {
        Map oGroupMap = this.getGroupElementsMap(oElementList);
        Integer oGroupId = null;
        Iterator oGroupItr = oGroupMap.entrySet().iterator();
        Map.Entry oGroupEntry = null;
        while (oGroupItr.hasNext()) {
            oGroupEntry = oGroupItr.next();
            oGroupId = (Integer)oGroupEntry.getKey();
            ActivationGroupInfo oGroup = this.m_oGroupManager.getGroupForId(oGroupId);
            DefaultMutableTreeNode oNode = this.getNodeForUserObject(oGroup);
            if (null == oNode) {
                oNode = this.getNodeForUserObject(this.m_oGroupManager.getDefaultGroup());
            }
            List oElementsForGroup = (List)oGroupEntry.getValue();
            this.populateElementsInGroupNode(oNode, oElementsForGroup);
        }
        this.refreshPanel();
    }

    private Map getGroupElementsMap(List oElementList) {
        HashMap<Integer, ArrayList<ActivationElementInfo>> oGroupMap = new HashMap<Integer, ArrayList<ActivationElementInfo>>(0);
        if (null == oElementList || 0 == oElementList.size()) {
            return oGroupMap;
        }
        int iElementCount = oElementList.size();
        Integer oGroupID = null;
        for (int i = 0; i < iElementCount; ++i) {
            ActivationElementInfo oElement = (ActivationElementInfo)oElementList.get(i);
            oGroupID = oElement.getGroupId();
            ArrayList<ActivationElementInfo> oElementsForGroup = (ArrayList<ActivationElementInfo>)oGroupMap.get(oGroupID);
            if (null == oElementsForGroup) {
                oElementsForGroup = new ArrayList<ActivationElementInfo>(0);
                oGroupMap.put(oGroupID, oElementsForGroup);
            }
            oElementsForGroup.add(oElement);
        }
        return oGroupMap;
    }

    private DefaultMutableTreeNode getNodeForUserObject(Object oUserObj) {
        if (null == oUserObj) {
            return null;
        }
        Enumeration<TreeNode> oChildren = this.m_oRootNode.breadthFirstEnumeration();
        while (oChildren.hasMoreElements()) {
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oChildren.nextElement();
            if (!oUserObj.equals(oNode.getUserObject())) continue;
            return oNode;
        }
        return null;
    }

    protected void showErrorMessage(String strErrorMessage) {
        DCOptionPane.showMessageDialog((Component)this, this.m_oResManager.getResString(strErrorMessage), this.m_oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
    }

    public Map getCurrentGroupsWithElements() {
        HashMap<ActivationGroupInfo, List> oCurrentGroups = new HashMap<ActivationGroupInfo, List>(0);
        int iCurrentGroupCount = this.m_oRootNode.getChildCount();
        for (int i = 0; i < iCurrentGroupCount; ++i) {
            DefaultMutableTreeNode oGroupNode = (DefaultMutableTreeNode)this.m_oRootNode.getChildAt(i);
            if (null == oGroupNode || !(oGroupNode.getUserObject() instanceof ActivationGroupInfo)) continue;
            ActivationGroupInfo oGroup = (ActivationGroupInfo)oGroupNode.getUserObject();
            List oResourceList = this.getSelectedResourcesForGroupNode(oGroupNode);
            if (null == oResourceList) continue;
            oCurrentGroups.put(oGroup, oResourceList);
        }
        return oCurrentGroups;
    }

    private List getSelectedResourcesForGroupNode(DefaultMutableTreeNode oGroupNode) {
        ArrayList<ActivationElementInfo> oCurrentResources = new ArrayList<ActivationElementInfo>(0);
        int iResourceCount = oGroupNode.getChildCount();
        for (int i = 0; i < iResourceCount; ++i) {
            ActivationElementInfo oElement;
            DefaultMutableTreeNode oResourceNode = (DefaultMutableTreeNode)oGroupNode.getChildAt(i);
            if (null == oResourceNode || !(oResourceNode.getUserObject() instanceof ActivationGroupInfo) || null == (oElement = (ActivationElementInfo)oResourceNode.getUserObject())) continue;
            oCurrentResources.add(oElement);
        }
        return oCurrentResources;
    }
}

