/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TextFieldFilter;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupManager;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.CurrentGroupsTreePanel;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.SelectedResourcesTablePanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.AbstractDocument;

public class CreateNewGroupDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private static final int GROUP_NAME_FIELD_MAX_SIZE = 20;
    private JPanel m_oGroupPanel;
    private JPanel m_oAddButtonPanel;
    private JLabel m_oGroupNameLabel;
    private JTextField m_oGroupNameTextField;
    private TextFieldFilter m_oGroupNameTextFilter;
    private JButton m_oAddResources;
    private JButton m_oDeleteResources;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private ActivationGroupManager m_oGroupManager;
    private ActivationGroupInfo m_oNewGroup;
    private SelectedResourcesTablePanel m_oSelectedResourcePanel;
    private CurrentGroupsTreePanel m_oResourceTreePanel;

    public CreateNewGroupDlg(ActivationGroupManager oGroupManager) {
        this.m_oGroupManager = oGroupManager;
        this.jbinit();
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }

    private void jbinit() {
        this.setSize(680, 425);
        this.setLayout(null);
        this.setTitle(this.m_oResManager.getResString("CREATE_NEW_ACTIVATION_GROUP"));
        this.m_oNewGroup = this.m_oGroupManager.createNewGroup();
        String strGroupName = this.m_oNewGroup.getGroupName();
        this.initGroupPanel(strGroupName);
        this.m_oSelectedResourcePanel = new SelectedResourcesTablePanel(this.m_oGroupManager);
        this.m_oSelectedResourcePanel.setName("DeviceOperation_CreateNewGroupDlg_m_oSelectedResourcePanel");
        this.m_oSelectedResourcePanel.setBounds(360, 85, 295, 270);
        this.add(this.m_oSelectedResourcePanel);
        this.m_oResourceTreePanel = new CurrentGroupsTreePanel(this.m_oSelectedResourcePanel, this.m_oGroupManager);
        this.m_oResourceTreePanel.setName("DeviceOperation_CreateNewGroupDlg_m_oResourceTreePanel");
        this.m_oResourceTreePanel.setBounds(10, 85, 275, 270);
        this.add(this.m_oResourceTreePanel);
        this.initButtonPanel();
        this.addButtons();
    }

    private void initGroupPanel(String strGroupName) {
        this.m_oGroupPanel = new JPanel();
        this.m_oGroupPanel.setBorder(new TitledBorder(this.m_oResManager.getResString("GROUP_PANEL_TITLE")));
        this.m_oGroupPanel.setBounds(10, 10, 654, 70);
        this.m_oGroupPanel.setLayout(null);
        this.add(this.m_oGroupPanel);
        this.initGroupPanelLabels();
        this.initGroupPanelInputFields(strGroupName);
    }

    private void initGroupPanelInputFields(String strGroupName) {
        this.m_oGroupNameTextField = new JTextField(strGroupName);
        this.m_oGroupNameTextField.setEditable(false);
        AbstractDocument aoVer = (AbstractDocument)this.m_oGroupNameTextField.getDocument();
        this.m_oGroupNameTextFilter = new TextFieldFilter(20);
        aoVer.setDocumentFilter(this.m_oGroupNameTextFilter);
        this.m_oGroupNameTextField.setBounds(100, 30, 190, 22);
        this.m_oGroupPanel.add(this.m_oGroupNameTextField);
    }

    private void initGroupPanelLabels() {
        this.m_oGroupNameLabel = new JLabel(this.m_oResManager.getResString("GROUP_NAME_LABEL"));
        this.m_oGroupNameLabel.setBounds(15, 30, 80, 22);
        this.m_oGroupPanel.add(this.m_oGroupNameLabel);
    }

    private void initButtonPanel() {
        this.m_oAddButtonPanel = new JPanel();
        this.m_oAddButtonPanel.setName("DeviceOperation_CreateNewGroupDlg_m_oAddButtonPanel");
        this.m_oAddButtonPanel.setBounds(295, 185, 65, 55);
        this.m_oAddButtonPanel.setLayout(null);
        this.add(this.m_oAddButtonPanel);
        this.m_oAddResources = new JButton(">");
        this.m_oAddResources.setName("DeviceOperation_CreateNewGroupDlg_m_oAddResources");
        this.m_oAddResources.setFocusable(false);
        this.m_oAddResources.setBounds(0, 0, 55, 25);
        this.m_oAddButtonPanel.add(this.m_oAddResources);
        this.m_oAddResources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oE) {
                List oElementList = CreateNewGroupDlg.this.m_oResourceTreePanel.deleteResourcesFromCurrentGroups(CreateNewGroupDlg.this.m_oNewGroup);
                CreateNewGroupDlg.this.m_oSelectedResourcePanel.addResourcesToTable(oElementList);
            }
        });
        this.m_oDeleteResources = new JButton("<");
        this.m_oDeleteResources.setName("DeviceOperation_CreateNewGroupDlg_m_oDeleteResources");
        this.m_oDeleteResources.setFocusable(false);
        this.m_oDeleteResources.setBounds(0, 30, 55, 25);
        this.m_oDeleteResources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oE) {
                List oElementList = CreateNewGroupDlg.this.m_oSelectedResourcePanel.deleteSelectedResources();
                CreateNewGroupDlg.this.m_oResourceTreePanel.addElementsToCurrentGroups(oElementList);
            }
        });
        this.m_oAddButtonPanel.add(this.m_oDeleteResources);
    }

    @Override
    protected String getCurrentContext() {
        DCDebugTracer.trace("help id is empty in " + CreateNewGroupDlg.class.getName());
        return ResourceManager.getInstance().getResString("", "helpmapfile");
    }

    private void addButtons() {
        this.m_oCancelBtn.setBounds(585, 365, 80, 20);
        this.m_oCancelBtn.setText(this.m_oResManager.getResString("CANCEL_BTN"));
        this.add(this.m_oCancelBtn);
        this.m_oOKBtn.setBounds(500, 365, 80, 20);
        this.m_oOKBtn.setText(this.m_oResManager.getResString("OK_BTN"));
        this.add(this.m_oOKBtn);
    }

    @Override
    protected void oKButton_ActionPerformed() {
        List oCurrentElements = this.m_oSelectedResourcePanel.getCurrentElements();
        if (null == oCurrentElements || 0 == oCurrentElements.size()) {
            int iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_ELEMENTS_IN_GROUP"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            if (0 != iConfirmOutput) {
                return;
            }
            this.closeDialog();
            return;
        }
        this.saveNewGroup(oCurrentElements);
        this.saveCurrentGroups();
        this.m_oGroupManager.clearEmptyGroups();
        this.closeDialog();
    }

    private void saveNewGroup(List oCurrentElements) {
        int iElementCount = oCurrentElements.size();
        for (int i = 0; i < iElementCount; ++i) {
            ActivationElementInfo oElement = (ActivationElementInfo)oCurrentElements.get(i);
            oElement.setGroupId(this.m_oNewGroup.getGroupId());
        }
        this.m_oGroupManager.addGroup(this.m_oNewGroup);
    }

    private void saveCurrentGroups() {
        Map oCurrGroups = this.m_oResourceTreePanel.getCurrentGroupsWithElements();
        Iterator oGroupsItr = oCurrGroups.entrySet().iterator();
        Map.Entry oGroupsEntry = null;
        while (oGroupsItr.hasNext()) {
            oGroupsEntry = oGroupsItr.next();
            ActivationGroupInfo oGroup = (ActivationGroupInfo)oGroupsEntry.getKey();
            List oElements = (List)oGroupsEntry.getValue();
            if (null == oElements || 0 == oElements.size()) continue;
            int oElementCount = oElements.size();
            for (int i = 0; i < oElementCount; ++i) {
                ActivationElementInfo oElement = (ActivationElementInfo)oElements.get(i);
                oElement.setGroupId(oGroup.getGroupId());
            }
        }
    }
}

