/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation.view;

import com.huawei.dc.common.components.DCDateChooser;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.RebootComboBox;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCInmDateChooserFormat;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupManager;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperationUtil;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationType;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationDeviceTreeTablePanel;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationPanelListener;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.view.modifytask.ModifyBasePanel;
import com.huawei.u2000.framework.help.HelpLabel;
import com.swimap.imap12.util.dateChooser.InmDateDocument;
import com.swimap.iview.commstyle.resource.ResourceMng;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.Collator;
import java.util.Calendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ActivationOpPanel
extends JPanel {
    private static final long serialVersionUID = 8921498009199208149L;
    private DCDateChooser m_oActivateTime = null;
    private ComboBoxWithToolTip m_oActivateType = null;
    private JComboBox m_oActivateMode = null;
    private ActivationDeviceTreeTablePanel m_oDeviceTreePanel = null;
    private final boolean isSelectPause;
    public Calendar startTime = null;
    private ActivationPanelListener m_oActionListener;
    private ActivationConfigPara m_oActivateConfigPara;
    private JPanel m_oConfigActivatePanel;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private JCheckBox m_oTimeSelectionCheckBox = null;
    private String m_strDefaultTimeString = "    -  -     :  :  ";
    private ActivationOperation m_oActivateTaskDevOp = null;
    private RebootComboBox m_oRebootComboBox;
    private boolean isStackDevice = false;
    private HelpLabel MODEhelpLable = null;
    private HelpLabel TYPEhelpLable = null;
    private boolean m_isSupportISSU = true;
    private JCheckBox m_oDelayRebootCheckBox = null;
    private ComboBoxWithToolTip m_oDelayRebootComboBox = null;

    public ActivationOpPanel(ActivationOperation oActivateOp, ActivationConfigPara oActivateConfigPara, boolean isSupportISSU) {
        this.setLayout(null);
        this.m_oActivateTaskDevOp = oActivateOp;
        this.m_oActivateConfigPara = oActivateConfigPara;
        this.m_isSupportISSU = isSupportISSU;
        Task taskRef = (Task)oActivateConfigPara.getTaskRef();
        if (taskRef.isStackDevicePresent(3)) {
            this.isStackDevice = true;
            this.m_oActivateConfigPara.setActivationTimeRequired(false);
            this.m_oActivateConfigPara.setDelayRebootRequired(false);
        }
        this.isSelectPause = oActivateOp.isPauseBeforeCurOp();
        this.m_oActionListener = new ActivationPanelListener(this);
        this.setSize(650, 337);
        this.jbInit();
    }

    private void jbInit() {
        this.createDeviceTreePanel();
        this.createConfigActivatePanel();
    }

    private void createConfigActivatePanel() {
        this.m_oConfigActivatePanel = new JPanel();
        this.m_oConfigActivatePanel.setName("DeviceOperation_ActivationOpPanel_m_oConfigActivatePanel");
        this.m_oConfigActivatePanel.setLayout(null);
        this.m_oConfigActivatePanel.setBounds(16, 10, 595, 99);
        TitledBorder oTitledBorder = null;
        Border oBorder = null;
        oBorder = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        oTitledBorder = new TitledBorder(oBorder, this.m_oResManager.getResString("CONFIG_ACTIVATE"));
        this.m_oConfigActivatePanel.setBorder(oTitledBorder);
        if (this.m_oActivateConfigPara.isActivationTimeRequired()) {
            this.m_oConfigActivatePanel.add(this.getTimeSelecCheckBox());
            this.m_oConfigActivatePanel.add((Component)((Object)this.getActivateTimeChooser()));
        }
        if (this.m_oActivateConfigPara.isDelayRebootRequired()) {
            this.m_oConfigActivatePanel.add(this.getReboootSelecCheckBox());
            this.m_oConfigActivatePanel.add(this.getDelayRebootComboBox());
        }
        this.m_oConfigActivatePanel.add(this.getActivateModeLbl());
        this.m_oConfigActivatePanel.add(this.getActivateTypeMode());
        if (!DCFrameWorkUtil.isHelpIDFormSA()) {
            this.m_oConfigActivatePanel.add((Component)this.getMODEhelpLable());
        }
        if (this.m_oActivateConfigPara.isActivationTypeRequired()) {
            this.m_oConfigActivatePanel.add(this.getActivateTypeLabel());
            this.m_oConfigActivatePanel.add(this.getActivateTypeComboBox());
            if (!DCFrameWorkUtil.isHelpIDFormSA()) {
                this.m_oConfigActivatePanel.add((Component)this.getTYPEhelpLable());
            }
        }
        ComboBoxModel comboBoxModel = this.m_oActivateType.getModel();
        String strScheduled = this.m_oResManager.getResString("COMMON_SCHEDULED");
        boolean found = false;
        int size = comboBoxModel.getSize();
        for (int i = 0; i < size; ++i) {
            ActivationType activationType = (ActivationType)comboBoxModel.getElementAt(i);
            String strTarget = activationType.getParaValue().toString();
            if (strTarget.toLowerCase(ResourceMng.getInstance().getLocale()).indexOf(strScheduled) == -1) continue;
            found = true;
        }
        if (!found && this.m_oTimeSelectionCheckBox != null) {
            this.m_oTimeSelectionCheckBox.setEnabled(false);
        }
        this.add(this.m_oConfigActivatePanel);
    }

    public void updateActiveTypeCombo() {
        this.initRebootType();
    }

    private void createDeviceTreePanel() {
        this.m_oActivateConfigPara.setElementInfoLst(ActivationOperationUtil.getElementInfo(this.m_oActivateConfigPara, this.getSelectedActivateMode()));
        this.m_oDeviceTreePanel = new ActivationDeviceTreeTablePanel(this, this.m_oActivateConfigPara);
        this.m_oDeviceTreePanel.setName("DeviceOperation_ActivationOpPanel_m_oDeviceTreePanel");
        this.m_oDeviceTreePanel.setBounds(16, 110, 595, 230);
        this.add(this.m_oDeviceTreePanel);
    }

    public void recreateDeviceTreePanel() {
        this.remove(this.m_oDeviceTreePanel);
        this.m_oDeviceTreePanel = null;
        this.m_oDeviceTreePanel = new ActivationDeviceTreeTablePanel(this, this.m_oActivateConfigPara);
        this.m_oDeviceTreePanel.setBounds(16, 110, 595, 230);
        this.add(this.m_oDeviceTreePanel);
    }

    private DCDateChooser getActivateTimeChooser() {
        DCInmDateChooserFormat oDateFormat = new DCInmDateChooserFormat();
        InmDateDocument.defaultType = oDateFormat.getDateFormat();
        this.m_oActivateTime = new DCDateChooser();
        this.m_oActivateTime.setName("DeviceOperation_ActivationOpPanel_m_oActivateTime");
        this.m_oActivateTime.setCalendar(null);
        this.m_strDefaultTimeString = this.m_oActivateTime.getTextField().getText();
        this.m_oActivateTime.setEnabled(false);
        this.m_oActivateTime.setBounds(420, 24, 165, 21);
        this.m_oActivateTime.setEnabled(false);
        if (null != this.m_oTimeSelectionCheckBox && this.m_oTimeSelectionCheckBox.isSelected()) {
            this.m_oActivateTime.setEnabled(true);
            this.m_oActivateTime.setCalendar(this.m_oActivateConfigPara.getActivationUTCTime());
        }
        return this.m_oActivateTime;
    }

    private JCheckBox getTimeSelecCheckBox() {
        this.m_oTimeSelectionCheckBox = new JCheckBox();
        this.m_oTimeSelectionCheckBox.setName("DeviceOperation_ActivationOpPanel_m_oTimeSelectionCheckBox");
        this.m_oTimeSelectionCheckBox.setText(this.m_oResManager.getResString("ACTIVATE_TIME") + ':');
        this.m_oTimeSelectionCheckBox.setBounds(278, 24, 100, 21);
        this.m_oTimeSelectionCheckBox.setSelected(this.m_oActivateConfigPara.isTimeSelected());
        this.m_oTimeSelectionCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ActivationOpPanel.this.m_oTimeSelectionCheckBox.isSelected() && ActivationOpPanel.this.m_oActivateTaskDevOp.isPauseBeforeCurOp()) {
                    ActivationOpPanel.this.m_oTimeSelectionCheckBox.setSelected(false);
                    DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), ActivationOpPanel.this.m_oResManager.getResString("PAUSE_AND_SCHEDULED_ACTIVATE_CONFLICT_MSG"));
                }
                if (ActivationOpPanel.this.m_oTimeSelectionCheckBox.isSelected()) {
                    ActivationOpPanel.this.m_oActivateTime.setEnabled(true);
                    Calendar oCurrentTime = TaskSyncCommController.getInstance().getCurrentServerTime(true);
                    long millsTime = oCurrentTime.getTimeInMillis() + 3600000L;
                    oCurrentTime.setTimeInMillis(millsTime);
                    ActivationOpPanel.this.m_oActivateTime.setCalendar(oCurrentTime);
                    ActivationOpPanel.this.m_oActivateConfigPara.setActivationUTCTime(oCurrentTime);
                } else {
                    ActivationOpPanel.this.m_oActivateTime.setEnabled(false);
                    ActivationOpPanel.this.m_oActivateTime.setCalendar(null);
                    ActivationOpPanel.this.m_oActivateConfigPara.setActivationUTCTime(null);
                }
            }
        });
        return this.m_oTimeSelectionCheckBox;
    }

    private ComboBoxWithToolTip getDelayRebootComboBox() {
        if (this.m_oDelayRebootComboBox == null) {
            this.m_oDelayRebootComboBox = new ComboBoxWithToolTip();
            this.m_oDelayRebootComboBox.setName("DeviceOperation_ActivationOpPanel_m_oDelayReboot");
            this.m_oDelayRebootComboBox.setEnabled(false);
            this.m_oDelayRebootComboBox.setBounds(420, 60, 165, 21);
            this.m_oDelayRebootComboBox.setEnabled(false);
            this.initDelayRebootComboBox();
            if (null != this.m_oDelayRebootCheckBox && this.m_oDelayRebootCheckBox.isSelected()) {
                this.m_oDelayRebootComboBox.setEnabled(true);
            }
        }
        return this.m_oDelayRebootComboBox;
    }

    private void initDelayRebootComboBox() {
        boolean DELAY_REBOOT_RANGE_BEGIN = true;
        boolean DELAY_REBOOT_RANGE_STEP = true;
        int DELAY_REBOOT_RANGE_END = 10;
        int begin = 0;
        int step = 0;
        int end = 0;
        try {
            begin = Integer.parseInt(this.m_oResManager.getResString("DELAY_REBOOT_RANGE_BEGIN", "config"));
            step = Integer.parseInt(this.m_oResManager.getResString("DELAY_REBOOT_RANGE_STEP", "config"));
            end = Integer.parseInt(this.m_oResManager.getResString("DELAY_REBOOT_RANGE_END", "config"));
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            begin = 1;
            step = 1;
            end = 10;
        }
        long oDelayTime = this.m_oActivateConfigPara.getM_oDelayTime();
        int iselectIndex = 0;
        this.m_oDelayRebootComboBox.removeAllItems();
        for (int i = begin; i <= end && begin <= end; i += step) {
            if ((long)i == oDelayTime) {
                iselectIndex = i;
            }
            CodeValue item = new CodeValue();
            item.setCode(i);
            item.setValue(String.valueOf(i));
            this.m_oDelayRebootComboBox.addItem(item);
        }
        this.m_oDelayRebootComboBox.setSelectedIndex(iselectIndex - 1);
        this.m_oDelayRebootComboBox.repaint();
    }

    private JCheckBox getReboootSelecCheckBox() {
        if (null == this.m_oDelayRebootCheckBox) {
            this.m_oDelayRebootCheckBox = new JCheckBox();
            this.m_oDelayRebootCheckBox.setName("DeviceOperation_ActivationOpPanel_m_oDelayRebootCheckBox");
            this.m_oDelayRebootCheckBox.setText(this.m_oResManager.getResString("Delay_Time_Label") + ':');
            this.m_oDelayRebootCheckBox.setBounds(278, 60, 138, 21);
            this.m_oDelayRebootCheckBox.setSelected(this.m_oActivateConfigPara.isDelayRebootRequired());
            Boolean isSupportDelayReset = false;
            List activateTypeList = this.m_oActivateConfigPara.getActivateTypeList();
            for (ActivationType actType : activateTypeList) {
                if (!actType.getParaValue().getId().equals("DelayReboot")) continue;
                isSupportDelayReset = true;
                break;
            }
            if (!isSupportDelayReset.booleanValue()) {
                this.m_oDelayRebootCheckBox.setSelected(false);
                this.m_oDelayRebootCheckBox.setEnabled(false);
            }
            this.m_oDelayRebootCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ActivationOpPanel.this.m_oDelayRebootCheckBox.isSelected()) {
                        ActivationOpPanel.this.m_oDelayRebootComboBox.setEnabled(true);
                    } else {
                        ActivationOpPanel.this.m_oDelayRebootComboBox.setEnabled(false);
                        ActivationOpPanel.this.setDelayRebootSelectIndex();
                    }
                }
            });
        }
        return this.m_oDelayRebootCheckBox;
    }

    void setDelayRebootSelectIndex() {
        if (this.m_oDelayRebootComboBox == null) {
            return;
        }
        long oDelayTime = this.m_oActivateConfigPara.getM_oDelayTime();
        int iselectIndex = 0;
        int length = this.m_oDelayRebootComboBox.getItemCount();
        for (int index = 0; index < length; ++index) {
            CodeValue item = (CodeValue)this.m_oDelayRebootComboBox.getItemAt(index);
            if ((long)item.getCode() != oDelayTime) continue;
            iselectIndex = index;
            break;
        }
        this.m_oDelayRebootComboBox.setSelectedIndex(iselectIndex);
    }

    private JButton getDefaultGrpButton() {
        JButton oDefaultActConfig = new JButton(this.m_oResManager.getResString("DEFAULT_ACTIVATION_GRP"));
        oDefaultActConfig.setMnemonic('G');
        oDefaultActConfig.setName("DeviceOperation_ActivationOpPanel_oDefaultActConfig");
        oDefaultActConfig.setToolTipText(this.m_oResManager.getResString("GET_DEFAULT_ACTIVATION_GROUP"));
        oDefaultActConfig.setBounds(430, 19, 186, 21);
        return oDefaultActConfig;
    }

    public void setDefaultGroupingOption() {
        ParaValue oParavalue = (ParaValue)this.m_oActivateMode.getSelectedItem();
        if (oParavalue.getId().equals("GroupActivation") && this.m_oActivateConfigPara.isDefaultGroupRequired()) {
            this.m_oDeviceTreePanel.add(this.getDefaultGrpButton());
        }
    }

    public void initDeviceTreePanel() {
        Component[] oPanelComponents = this.m_oDeviceTreePanel.getComponents();
        int iNosComponents = oPanelComponents.length;
        if (iNosComponents > 1) {
            this.m_oDeviceTreePanel.remove(iNosComponents - 1);
        }
        this.m_oDeviceTreePanel.revalidate();
        this.m_oDeviceTreePanel.repaint();
    }

    private ComboBoxWithToolTip getActivateTypeComboBox() {
        this.m_oRebootComboBox = new RebootComboBox();
        this.m_oRebootComboBox.setParentPanel(this);
        this.m_oActivateType = this.m_oRebootComboBox.getRebootCombobox();
        this.m_oActivateType.setName("DeviceOperation_ActivationOpPanel_m_oActivateType");
        this.m_oActivateType.setBounds(111, 24, 120, 21);
        this.initRebootType();
        return this.m_oActivateType;
    }

    public boolean isSelectedManualReboot() {
        ActivationType oActivateType = (ActivationType)this.m_oActivateType.getSelectedItem();
        return null != oActivateType && oActivateType.getParaValue().getId().equals("ManualReboot");
    }

    private JComboBox getActivateTypeMode() {
        this.m_oActivateMode = new JComboBox();
        if (!this.isStackDevice) {
            this.m_oActivateMode.setBounds(111, 60, 120, 21);
        } else {
            this.m_oActivateMode.setBounds(393, 24, 120, 21);
        }
        this.m_oActivateMode.setActionCommand("activate_mode");
        this.m_oActivateMode.addActionListener(this.m_oActionListener);
        this.addActivateModeList();
        return this.m_oActivateMode;
    }

    private HelpLabel getMODEhelpLable() {
        String strMODEHelpID = this.m_oResManager.getResString("HELP_TOPIC_ACTIVATION_MODE", "helpmapfile");
        this.MODEhelpLable = new HelpLabel("", strMODEHelpID);
        this.MODEhelpLable.setIcon((Icon)this.m_oResManager.getImage("help1.png"));
        if (!this.isStackDevice) {
            this.MODEhelpLable.setBounds(233, 60, 20, 21);
        } else {
            this.MODEhelpLable.setBounds(515, 24, 20, 21);
        }
        return this.MODEhelpLable;
    }

    private HelpLabel getTYPEhelpLable() {
        String strTYPEHelpID = this.m_oResManager.getResString("HELP_TOPIC_ACTIVATION_TYPE", "helpmapfile");
        this.TYPEhelpLable = new HelpLabel("", strTYPEHelpID);
        this.TYPEhelpLable.setIcon((Icon)this.m_oResManager.getImage("help1.png"));
        this.TYPEhelpLable.setBounds(233, 24, 20, 21);
        return this.TYPEhelpLable;
    }

    private void addActivateModeList() {
        List oActivateModeLst = this.m_oActivateConfigPara.getActivateModeList();
        ITask oTaskDataObj = this.m_oActivateTaskDevOp.getOperationData();
        int iSizeOfLst = oActivateModeLst.size();
        for (int i = 0; i < iSizeOfLst; ++i) {
            ParaValue oParaValue = (ParaValue)oActivateModeLst.get(i);
            if ((2 == oTaskDataObj.getTaskViewType() || 4 == oTaskDataObj.getTaskViewType()) && oParaValue.getId().equals("GroupActivation")) continue;
            boolean isExist = false;
            int iSize = this.m_oActivateMode.getItemCount();
            for (int j = 0; j < iSize; ++j) {
                ParaValue tempParaValue = (ParaValue)this.m_oActivateMode.getItemAt(j);
                if (!tempParaValue.getId().equals(((ParaValue)oActivateModeLst.get(i)).getId())) continue;
                isExist = true;
            }
            if (isExist) continue;
            this.m_oActivateMode.addItem(oActivateModeLst.get(i));
        }
        if (null != this.m_oActivateConfigPara.getSelectedActivationMode()) {
            if (this.m_oActivateConfigPara.getSelectedActivationMode().getId().equals("VirtualOperation")) {
                this.m_oActivateConfigPara.setManualReboot(true);
            }
            this.m_oActivateMode.setSelectedItem(this.m_oActivateConfigPara.getSelectedActivationMode());
        }
    }

    private JLabel getActivateTypeLabel() {
        JLabel oLabel = new JLabel();
        oLabel.setText(this.m_oResManager.getResString("ACTIVATION_TYPE") + ':');
        oLabel.setBounds(20, 24, 95, 21);
        return oLabel;
    }

    private JLabel getActivateModeLbl() {
        JLabel oActModeLabel = new JLabel();
        oActModeLabel.setText(this.m_oResManager.getResString("ACTIVATION_MODE") + ':');
        if (this.isStackDevice) {
            oActModeLabel.setBounds(300, 24, 95, 21);
        } else {
            oActModeLabel.setBounds(20, 60, 95, 21);
        }
        return oActModeLabel;
    }

    public void updateActivationConfigSelec() {
        if ("GroupActivation".equalsIgnoreCase(this.getSelectedActivateMode())) {
            ActivationGroupManager oManager = this.m_oDeviceTreePanel.getGroupManager();
            if (null != oManager) {
                oManager.clearEmptyGroups();
                this.m_oActivateConfigPara.setElementInfoLst(oManager.getElementInfoLst());
                this.m_oActivateConfigPara.setActivateGroupInfoLst(oManager.getActivateGroupInfoLst());
            }
        } else {
            this.m_oActivateConfigPara.setElementInfoLst(null);
            this.m_oActivateConfigPara.setActivateGroupInfoLst(null);
        }
        if (null != this.m_oActivateMode) {
            ParaValue oParaValue = (ParaValue)this.m_oActivateMode.getSelectedItem();
            this.m_oActivateConfigPara.setActivationMode(oParaValue.getId());
        }
        if (null != this.m_oActivateType) {
            ActivationType oActivationType = (ActivationType)this.m_oActivateType.getSelectedItem();
            this.m_oActivateConfigPara.setSelectedActivateType(oActivationType);
            if (null != oActivationType && oActivationType.getParaValue().getId().equals("ManualReboot")) {
                this.m_oActivateTaskDevOp.setIsPauseBeforeCurOp(true);
            }
        }
        if (null != this.m_oTimeSelectionCheckBox) {
            this.m_oActivateConfigPara.setIsTimeSelected(this.m_oTimeSelectionCheckBox.isSelected());
            this.updateTimeInfo();
        }
        if (null != this.m_oDelayRebootCheckBox) {
            this.m_oActivateConfigPara.setM_bIsDelayTimeSelected(this.m_oDelayRebootCheckBox.isSelected());
            if (null != this.m_oDelayRebootComboBox) {
                CodeValue item = (CodeValue)this.m_oDelayRebootComboBox.getSelectedItem();
                if (null != item) {
                    this.m_oActivateConfigPara.setM_oDelayTime(item.getCode());
                } else {
                    this.m_oActivateConfigPara.setM_oDelayTime(-1);
                }
            }
        }
        if (this.isSelectISSU()) {
            this.setISSUStepStatus(true);
            this.m_oActivateConfigPara.setSelISSU(true);
        } else {
            this.setISSUStepStatus(false);
            this.m_oActivateConfigPara.setSelISSU(false);
        }
    }

    private void setISSUStepStatus(boolean status) {
        List<ITaskDeviceOperation> oprLst = this.m_oActivateTaskDevOp.getOpeLst();
        for (ITaskDeviceOperation oTaskper : oprLst) {
            if (29 != oTaskper.getOperationId()) continue;
            oTaskper.setSelected(status);
            break;
        }
    }

    private void updateTimeInfo() {
        if (this.m_oActivateTime.getTextField().getText().equals(this.m_strDefaultTimeString)) {
            this.m_oActivateConfigPara.setTimeFieldEmpty(true);
            this.m_oActivateConfigPara.setActivationUTCTime(null);
        } else {
            this.m_oActivateConfigPara.setTimeFieldEmpty(false);
            this.m_oActivateConfigPara.setActivationUTCTime(this.m_oActivateTime.getCalendar(true));
        }
    }

    public JComboBox getActivateMode() {
        return this.m_oActivateMode;
    }

    public ActivationDeviceTreeTablePanel getDeviceTreePanel() {
        return this.m_oDeviceTreePanel;
    }

    public void updateDeviceTreeTableData() {
        this.m_oDeviceTreePanel.populateResourcesToTreeTable(ActivationOperationUtil.getElementInfo(this.m_oActivateConfigPara, this.getSelectedActivateMode()));
    }

    public List addDevicesSelected(THashSet<Resource> oResourceList, List oElementInfoList) {
        return ActivationOperationUtil.addDevicesSelected(this.m_oActivateConfigPara, oResourceList, oElementInfoList, this.getSelectedActivateMode());
    }

    public List removeDevicesDeSelected(THashSet<Resource> oResourceList, List oElementInfoList) {
        return ActivationOperationUtil.removeDevicesDeSelected(this.m_oActivateConfigPara, oResourceList, oElementInfoList, this.getSelectedActivateMode());
    }

    public String getSelectedActivateMode() {
        if (null == this.m_oActivateMode) {
            return "";
        }
        ParaValue oParaValue = (ParaValue)this.m_oActivateMode.getSelectedItem();
        return oParaValue.getId();
    }

    public void disableTimeComp() {
        if (this.m_oActivateConfigPara.isActivationTimeRequired()) {
            this.m_oActivateTime.setEnabled(false);
            this.m_oActivateTime.setCalendar(null);
            this.m_oTimeSelectionCheckBox.setSelected(false);
            this.m_oTimeSelectionCheckBox.setEnabled(false);
        }
        if (this.m_oActivateConfigPara.isActivationTimeRequired() && this.getReboootSelecCheckBox() != null) {
            this.getReboootSelecCheckBox().setSelected(false);
            this.getReboootSelecCheckBox().setEnabled(false);
            this.getDelayRebootComboBox().setEnabled(false);
            this.getDelayRebootComboBox().setSelectedIndex(-1);
            this.getDelayRebootComboBox().repaint();
        }
        if (this.isSelectDelayReboot()) {
            this.m_oActivateTaskDevOp.setIsPauseBeforeCurOp(true);
        } else {
            this.m_oActivateTaskDevOp.setIsPauseBeforeCurOp(this.m_oActivateTaskDevOp.isPauseBeforeCurOp());
        }
        this.addActivateModeList();
    }

    public void enabelActivateModeComp(boolean bEnable) {
        this.m_oActivateMode.setEnabled(bEnable);
    }

    public void changeCompSelect() {
        this.m_oTimeSelectionCheckBox.setSelected(false);
        this.m_oTimeSelectionCheckBox.setEnabled(false);
        this.getReboootSelecCheckBox().setSelected(false);
        this.getReboootSelecCheckBox().setEnabled(false);
        this.getDelayRebootComboBox().setEnabled(false);
        this.getDelayRebootComboBox().setSelectedIndex(-1);
        this.getDelayRebootComboBox().repaint();
        if (this.m_oActivateType != null) {
            int iSelIndex = -1;
            int itemCount = this.m_oActivateType.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                String strId;
                ParaValue paraValue;
                ActivationType activationType = (ActivationType)this.m_oActivateType.getItemAt(i);
                if (null == activationType || null == (paraValue = activationType.getParaValue()) || null == (strId = paraValue.getId()) || strId.length() == 0 || !"OSSU".equalsIgnoreCase(strId)) continue;
                iSelIndex = i;
                break;
            }
            this.m_oActivateType.setSelectedIndex(iSelIndex);
            this.m_oActivateType.repaint();
        }
        this.m_oActivateTaskDevOp.setIsPauseBeforeCurOp(this.isSelectPause);
    }

    public void updateCompForSchecActivationTime(Calendar oScheduleActivationTime) {
        this.m_oTimeSelectionCheckBox.setSelected(true);
        this.m_oTimeSelectionCheckBox.setEnabled(true);
        this.m_oActivateTime.setEnabled(true);
        if (null != oScheduleActivationTime) {
            this.m_oActivateTime.setCalendar(oScheduleActivationTime);
        } else {
            Calendar oCurrentTime = TaskSyncCommController.getInstance().getCurrentServerTime(true);
            long millsTime = oCurrentTime.getTimeInMillis() + 3600000L;
            oCurrentTime.setTimeInMillis(millsTime);
            this.m_oActivateTime.setCalendar(oCurrentTime);
        }
        this.getReboootSelecCheckBox().setSelected(false);
        this.getReboootSelecCheckBox().setEnabled(false);
        this.getDelayRebootComboBox().setEnabled(false);
        this.getDelayRebootComboBox().setSelectedIndex(-1);
        this.getDelayRebootComboBox().repaint();
        this.m_oActivateTaskDevOp.setIsPauseBeforeCurOp(this.isSelectPause);
        boolean GROUP_ACTIVATE_MODE = true;
        int ACTIVATE_MODE_CONTAIN_GROUP2 = 2;
        int ACTIVATE_MODE_CONTAIN_GROUP3 = 3;
        int iSize = this.m_oActivateMode.getItemCount();
        if (iSize == 2 || iSize == 3) {
            this.m_oActivateMode.removeItemAt(1);
        }
    }

    public void updateCompForDeLayReboot() {
        this.m_oActivateTime.setEnabled(false);
        this.m_oActivateTime.setCalendar(null);
        this.m_oTimeSelectionCheckBox.setSelected(false);
        this.m_oTimeSelectionCheckBox.setEnabled(false);
        this.getReboootSelecCheckBox().setSelected(true);
        this.getReboootSelecCheckBox().setEnabled(false);
        this.getDelayRebootComboBox().setEnabled(true);
        this.m_oActivateTaskDevOp.setIsPauseBeforeCurOp(true);
        this.setDelayRebootSelectIndex();
        this.getDelayRebootComboBox().repaint();
        int iSize = this.m_oActivateMode.getItemCount();
        if (iSize == 2 || iSize == 3) {
            this.m_oActivateMode.removeItemAt(1);
        }
    }

    public boolean isSelectDelayReboot() {
        if (this.m_oActivateConfigPara.isDelayRebootRequired()) {
            return this.getReboootSelecCheckBox().isSelected();
        }
        return false;
    }

    public boolean isPauseBeforeCurOp() {
        return this.m_oActivateTaskDevOp.isPauseBeforeCurOp();
    }

    public boolean isSelectISSU() {
        if (null == this.m_oActivateType) {
            return false;
        }
        ActivationType activationType = (ActivationType)this.m_oActivateType.getSelectedItem();
        if (null == activationType) {
            return false;
        }
        ParaValue paraValue = activationType.getParaValue();
        String strId = paraValue.getId();
        if (null == strId || strId.length() == 0) {
            return false;
        }
        boolean isSel = false;
        if ("ISSU".equalsIgnoreCase(strId)) {
            isSel = true;
        }
        return isSel;
    }

    public void handleActivationTypeChange(String sOperID) {
        boolean bSelectedManulReboot = sOperID.equals("ManualReboot");
        ParaValue oTmpParaValue = new ParaValue();
        oTmpParaValue.setId("VirtualOperation");
        oTmpParaValue.setDisplayName("");
        this.m_oActivateConfigPara.setManualReboot(bSelectedManulReboot);
        if (bSelectedManulReboot) {
            this.disableTimeComp();
            this.enabelActivateModeComp(false);
            this.m_oActivateConfigPara.addOrDeleteActivationMode("VirtualOperation", true);
            this.modifyActivateModeCombox(oTmpParaValue, true);
        } else {
            this.enabelActivateModeComp(true);
            this.m_oActivateConfigPara.addOrDeleteActivationMode("VirtualOperation", false);
            this.modifyActivateModeCombox(oTmpParaValue, false);
        }
        Container oParentComp = this.getParent();
        if (oParentComp instanceof ModifyBasePanel) {
            ModifyBasePanel oModifyPanel = (ModifyBasePanel)oParentComp;
            oModifyPanel.enableParseB4Checkbox(bSelectedManulReboot);
        }
    }

    private void modifyActivateModeCombox(ParaValue oParaValue, boolean bAdd) {
        if (null == this.m_oActivateMode) {
            return;
        }
        int itemCount = this.m_oActivateMode.getItemCount();
        ParaValue oTmpPara = null;
        for (int i = 0; i < itemCount; ++i) {
            oTmpPara = (ParaValue)this.m_oActivateMode.getItemAt(i);
            if (!oTmpPara.getId().equals(oParaValue.getId())) continue;
            if (bAdd) {
                this.m_oActivateMode.setSelectedIndex(i);
                return;
            }
            this.m_oActivateMode.removeItemAt(i);
            return;
        }
        if (bAdd) {
            this.m_oActivateMode.addItem(oParaValue);
            this.m_oActivateMode.setSelectedItem(oParaValue);
        }
    }

    private void initRebootType() {
        if (null != this.m_oRebootComboBox) {
            List oActivateTypeLst = this.m_oActivateConfigPara.getActivateTypeList();
            if (!this.m_isSupportISSU) {
                int iSize = oActivateTypeLst.size();
                for (int i = 0; i < iSize; ++i) {
                    ActivationType oActivationType = (ActivationType)oActivateTypeLst.get(i);
                    String actionTypeId = oActivationType.getParaValue().getId();
                    if (!"ISSU".equals(actionTypeId)) continue;
                    oActivateTypeLst.remove(i);
                    break;
                }
            }
            this.m_oRebootComboBox.initRebootComboBox(this.m_oActivateType, oActivateTypeLst, this.m_oActivateConfigPara);
        }
    }

    public Calendar getActivateTime() {
        if (this.m_oTimeSelectionCheckBox.isSelected()) {
            String strTime = this.m_oActivateTime.getTextField().getText();
            if (0 == Collator.getInstance().compare(strTime, "  /  /       :  :  ")) {
                return null;
            }
            this.startTime = this.m_oActivateTime.getCalendar(true);
            return this.startTime;
        }
        return null;
    }

    public void enablePreUpgradeAndUpgradePatchInPostUpgrade() {
        this.m_oActivateTaskDevOp.enablePreUpgradeAndUpgradePatchInPostUpgrade();
    }

    public void detectedPreUpgrade() {
        this.m_oActivateTaskDevOp.detectedPreUpgrade();
    }

    public void disablePreUpgradeAndUpgradePatchInPostUpgrade() {
        this.detectedPreUpgrade();
        this.disablePostUpPatch();
    }

    private void disablePostUpPatch() {
        this.m_oActivateTaskDevOp.disablePostUpPatch();
    }

    public ITask getTaskInfo() {
        return this.m_oActivateTaskDevOp.getOperationData();
    }
}

