/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationOpPanel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommController;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.taskmgmt.view.createtask.ValidateISSU;
import gnu.trove.THashSet;
import java.awt.Component;
import java.math.BigInteger;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ActivationDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private ActivationConfigPara m_oActivateConfigPara;
    private ActivationOpPanel m_oActivateOpPanel = null;
    private ResourceManager oResMgr = ResourceManager.getInstance();
    private ActivationOperation m_oActivationOp;
    private ActivationConfigPara activateConfigParaClone;
    private ITask m_oTask;

    public ActivationDlg(ITask oTask, ActivationConfigPara oActivateConfigPara, ActivationOperation oActivateOp) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        this.m_oTask = oTask;
        this.activateConfigParaClone = (ActivationConfigPara)CloneUtil.getClone(oActivateConfigPara);
        this.m_oActivateConfigPara = oActivateConfigPara;
        this.m_oActivationOp = oActivateOp;
        this.jbinit();
        this.setSize(627, 410);
        this.setResizable(false);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(this.oResMgr.getResString("CONFIGURE_ACTIVATE_OPERATION"));
        this.setDefaultCloseOperation(2);
    }

    private void jbinit() {
        boolean isSupportIssu = true;
        if (this.m_oTask.getTaskTypeId() == 1 && DCCommonUtil.isContainsDevTypeID(this.m_oTask, 1332)) {
            isSupportIssu = false;
        }
        this.m_oActivateOpPanel = new ActivationOpPanel(this.m_oActivationOp, this.m_oActivateConfigPara, isSupportIssu);
        this.m_oOKBtn.setText(this.oResMgr.getResString("OK"));
        this.m_oOKBtn.setName("DeviceOperation_ActivationDlg_oOkButton");
        this.m_oOKBtn.setBounds(441, 349, 80, 21);
        this.m_oCancelBtn.setText(this.oResMgr.getResString("CANCEL"));
        this.m_oCancelBtn.setName("DeviceOperation_ActivationDlg_oCancelBtn");
        this.m_oCancelBtn.setBounds(527, 349, 80, 21);
        this.getContentPane().add(this.m_oActivateOpPanel);
        this.getContentPane().add(this.m_oOKBtn);
        this.getContentPane().add(this.m_oCancelBtn);
        this.getContentPane().setLayout(null);
    }

    @Override
    protected void oKButton_ActionPerformed() {
        if (!this.m_oActivationOp.checkISSUwithPreUpgrade()) {
            return;
        }
        this.m_oActivateOpPanel.updateActivationConfigSelec();
        if (this.m_oActivateConfigPara.isM_bIsDelayTimeSelected()) {
            this.validateDelayRebootSelectedDevices();
        } else {
            ValidateISSU oValidateIssu;
            ValidationResult oValidateResult = new ValidationResult();
            oValidateResult.setErrorCode(0);
            oValidateResult.setErrorMessage(this.oResMgr.getResString("OPERATION_SUCCESS"));
            if (this.m_oActivateConfigPara.isSelISSU() && 5 == (oValidateResult = (oValidateIssu = new ValidateISSU(this.m_oTask)).validateISSUSelectedDevices()).getErrorType()) {
                return;
            }
            if (0 == oValidateResult.getErrorCode()) {
                oValidateResult = this.m_oActivationOp.validateOperationConfigurations();
            }
            if (0 == oValidateResult.getErrorCode()) {
                this.dispose();
            } else {
                DCOptionPane.showMessageDialog((Component)((Object)this), oValidateResult.getErrorMessage(), this.oResMgr.getResString("ERROR"), 0);
            }
        }
        if (null != DCFrameWorkUtil.getTaskMgmtOperationSelecPanel()) {
            DCFrameWorkUtil.getTaskMgmtOperationSelecPanel().refreshTable();
        }
    }

    @Override
    protected void closeDialog() {
        ActivationOperation oActivationOperation = (ActivationOperation)TaskCommUtil.getTaskOperation(this.m_oTask.getSupportedOperation(), "ActivateSoftware");
        if (null != this.activateConfigParaClone) {
            oActivationOperation.setActivateConfigPara(this.activateConfigParaClone);
        }
        this.doPreUpgradeAndUpgradePatchInPostUpgrade();
        super.closeDialog();
    }

    void validateOperationConfigurations() {
        ValidationResult oValidateResult = this.m_oActivationOp.validateOperationConfigurations();
        if (0 == oValidateResult.getErrorCode()) {
            this.dispose();
        } else {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oValidateResult.getErrorMessage(), this.oResMgr.getResString("ERROR"), 0);
        }
    }

    void autoRemoveDoNotSupportDelayRebootDevices(List<Integer> doNotSupportDeviceLst) {
        THashSet<Resource> resLst = this.m_oActivateConfigPara.getTaskRef().getDeviceType().getResources();
        for (int iDevId : doNotSupportDeviceLst) {
            Iterator iterator = resLst.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (iDevId != resource.getDeviceID()) continue;
                iterator.remove();
            }
        }
    }

    void changeActivationType() {
        DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), this.oResMgr.getResString("DEVICE_CHANGE_DELAY_REBOOT_ACTIVATE"), true);
        this.m_oActivateOpPanel.changeCompSelect();
        this.m_oActivationOp.setIsPauseBeforeCurOp(false);
    }

    private void validateDelayRebootSelectedDevices() {
        THashSet<Resource> resLst = this.m_oActivateConfigPara.getTaskRef().getDeviceType().getResources();
        int[] m_iArrdeviceIds = new int[resLst.size()];
        Iterator oResItor = resLst.iterator();
        int i = 0;
        while (oResItor.hasNext()) {
            m_iArrdeviceIds[i] = ((Resource)oResItor.next()).getDeviceID();
            ++i;
        }
        String strDlgTitle = this.oResMgr.getResString("UPGRADE_DELAY_REBOOT_VALIDATION_TITLE");
        ProgressDlg oProgressDlg = new ProgressDlg(43988, m_iArrdeviceIds){
            private static final long serialVersionUID = -1345521038347237919L;
            final Vector<Integer> doNotSupportDeviceLst;
            private boolean m_isHasError;
            {
                this.doNotSupportDeviceLst = new Vector();
                this.m_isHasError = false;
            }

            @Override
            public void doCleanUp() {
                if (this.isHasError()) {
                    if (this.doNotSupportDeviceLst.size() < this.getM_oDetailsTableModel().getDataVector().size()) {
                        int confirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CONFIRM_SUPPORT_DELAY_REBOOT_EXIT"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                        if (confirm == 0) {
                            this.getM_oDetailsTableModel().getDataVector().removeAllElements();
                            DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("DEVICE_DELETE_WARNING_FOR_DELAY_REBOOT"), true);
                            ActivationDlg.this.autoRemoveDoNotSupportDelayRebootDevices(this.doNotSupportDeviceLst);
                            ActivationDlg.this.validateOperationConfigurations();
                        } else {
                            ActivationDlg.this.changeActivationType();
                        }
                    } else {
                        ActivationDlg.this.changeActivationType();
                    }
                    this.dispose();
                } else {
                    if (this.m_closeBtn.isEnabled()) {
                        this.getM_oDetailsTableModel().getDataVector().removeAllElements();
                        this.dispose();
                    }
                    if (!this.m_bCancelOpPerformed) {
                        ActivationDlg.this.validateOperationConfigurations();
                    }
                }
            }

            @Override
            public void setProgress(String strDisplayName, String strOpResult, int iProgress, int iDeviceId) {
                if (null == strOpResult || strOpResult.length() == 0) {
                    return;
                }
                String error = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(0L));
                if (!Collator.getInstance().equals(strOpResult, error)) {
                    this.doNotSupportDeviceLst.add(iDeviceId);
                    this.setHasError(true);
                }
                super.setProgress(strDisplayName, strOpResult, iProgress, iDeviceId);
            }

            private boolean isHasError() {
                return this.m_isHasError;
            }

            private void setHasError(boolean hasError) {
                this.m_isHasError = hasError;
            }
        };
        oProgressDlg.setTitle(strDlgTitle);
        oProgressDlg.setDefaultCloseOperation(2);
        TaskAsynCommController.getInstance().checkDevicesIsSupportDelayReboot(oProgressDlg, m_iArrdeviceIds);
    }

    public ActivationOpPanel getActivateOpPanel() {
        return this.m_oActivateOpPanel;
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        this.doPreUpgradeAndUpgradePatchInPostUpgrade();
        super.cancelButton_ActionPerformed();
    }

    private void doPreUpgradeAndUpgradePatchInPostUpgrade() {
        if (null != this.m_oActivateConfigPara && null != this.m_oActivateOpPanel && TaskInfoUtil.bContainV8Dev(this.m_oActivationOp.getOperationData())) {
            if (this.m_oActivateConfigPara.isSelISSU()) {
                this.m_oActivateOpPanel.disablePreUpgradeAndUpgradePatchInPostUpgrade();
            } else {
                this.m_oActivateOpPanel.enablePreUpgradeAndUpgradePatchInPostUpgrade();
            }
        }
    }
}

