/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation.view;

import com.huawei.dc.common.components.treetable.model.DCTreeTableModel;
import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableNode;
import com.huawei.dc.common.components.treetable.model.TreeTableNodeCellData;
import com.huawei.dc.common.components.treetable.model.TreeTableRowData;
import com.huawei.dc.common.components.treetable.view.DCTreeTableCellRenderer;
import com.huawei.dc.common.components.treetable.view.JSortTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupManager;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationDeviceTreeUtil;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationOpPanel;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationPanelListener;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.CreateNewGroupDlg;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreePath;

public class ActivationDeviceTreeTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ResourceManager m_oResourceMgr;
    private JSortTreeTable m_oDeviceTreeTable;
    private DCTreeTableModel m_oDeviceTreeTableModel;
    private TreeTableNode m_oRootNode;
    private JScrollPane m_oDeviceTableScrollPane;
    private static int COLUMN_SIZE = 5;
    private String m_strActivationMode;
    private ActivationConfigPara m_oActivationConfigPara;
    private ActivationGroupManager m_oGroupManager;
    private boolean m_bIsGroupLevelView;
    private JButton m_oCreateGroup = null;
    private JButton m_oDeleteGroup = null;
    private boolean isDragged = false;
    private String finalGroupName = "";
    private int selectedRowCount = 0;
    private List lExportRowData = new ArrayList(0);
    private List lInitialGroupName = new ArrayList(0);
    private List lExportRowNode = new ArrayList(0);
    private List lParentSourceGroupNode = new ArrayList(0);
    int[] rows;
    int clickCount = 1;
    int isDraggedOverGroup = 0;
    private transient MouseMotionListener m_oDeviceTreeTableMouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent draggedEvent) {
            ActivationDeviceTreeTablePanel.this.lExportRowData.clear();
            ActivationDeviceTreeTablePanel.this.lExportRowNode.clear();
            ActivationDeviceTreeTablePanel.this.lInitialGroupName.clear();
            ActivationDeviceTreeTablePanel.this.lParentSourceGroupNode.clear();
            if (null == ActivationDeviceTreeTablePanel.this.rows || 0 == ActivationDeviceTreeTablePanel.this.rows.length) {
                this.selectCurrentRow(draggedEvent);
            }
            if (this.draggedOverGroup(draggedEvent)) {
                ActivationDeviceTreeTablePanel.this.isDraggedOverGroup = 1;
            }
            if (ActivationDeviceTreeTablePanel.this.m_bIsGroupLevelView && ActivationDeviceTreeTablePanel.this.m_oGroupManager.getActivateGroupInfoLst().size() > 1) {
                for (int index = 0; index < ActivationDeviceTreeTablePanel.this.selectedRowCount; ++index) {
                    TreePath oTreePath = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getTree().getPathForRow(ActivationDeviceTreeTablePanel.this.rows[index]);
                    TreeTableNode oExportRowNode = (TreeTableNode)oTreePath.getLastPathComponent();
                    TreeTableRowData exportRowData = (TreeTableRowData)oExportRowNode.getUserObject();
                    ActivationDeviceTreeTablePanel.this.lExportRowNode.add(oExportRowNode);
                    ActivationDeviceTreeTablePanel.this.lExportRowData.add(exportRowData);
                    TreePath parentPath = oTreePath.getParentPath();
                    TreeTableNode oParentSourceGroupNode = (TreeTableNode)parentPath.getLastPathComponent();
                    ActivationDeviceTreeTablePanel.this.lParentSourceGroupNode.add(oParentSourceGroupNode);
                    TreeTableRowData parentGroupRowData = (TreeTableRowData)oParentSourceGroupNode.getUserObject();
                    if (parentGroupRowData == null) continue;
                    ActivationDeviceTreeTablePanel.this.isDragged = true;
                    TreeTableNodeCellData groupData = (TreeTableNodeCellData)parentGroupRowData.getColumnData(0);
                    String initialGroupName = groupData.getCellDataValue().toString();
                    ActivationDeviceTreeTablePanel.this.lInitialGroupName.add(initialGroupName);
                    Cursor moveCursor = new Cursor(13);
                    DCFrameWorkUtil.setCursor((Component)((Object)ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable), moveCursor);
                    ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.setRowSelectionAllowed(false);
                }
            }
        }

        public boolean draggedOverGroup(MouseEvent mouseEvent) {
            Point p = mouseEvent.getPoint();
            int row = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.rowAtPoint(p);
            TreePath oTreePath = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getTree().getPathForRow(row);
            TreePath parentPath = oTreePath.getParentPath();
            TreeTableNode oParentGroupNode = (TreeTableNode)parentPath.getLastPathComponent();
            TreeTableRowData parentGroupRowData = (TreeTableRowData)oParentGroupNode.getUserObject();
            return parentGroupRowData == null;
        }

        private void selectCurrentRow(MouseEvent draggedEvent) {
            int x = draggedEvent.getX();
            int y = draggedEvent.getY();
            int iRow = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getTree().getRowForLocation(x, y);
            if (-1 != iRow) {
                ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getSelectionModel().setSelectionInterval(iRow, iRow);
                ActivationDeviceTreeTablePanel.this.rows = new int[]{iRow};
                ActivationDeviceTreeTablePanel.this.selectedRowCount = 1;
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            Cursor normalCursor = new Cursor(0);
            DCFrameWorkUtil.setCursor((Component)((Object)ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable), normalCursor);
            ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.setRowSelectionAllowed(true);
        }
    };

    public ActivationDeviceTreeTablePanel(ActivationOpPanel oActivationMainPanel, ActivationConfigPara oConfigPara) {
        this.m_strActivationMode = oActivationMainPanel.getSelectedActivateMode();
        this.m_oActivationConfigPara = oConfigPara;
        this.m_oResourceMgr = ResourceManager.getInstance();
        this.m_bIsGroupLevelView = false;
        if ("GroupActivation".equalsIgnoreCase(this.m_strActivationMode)) {
            this.m_bIsGroupLevelView = true;
            this.m_oGroupManager = new ActivationGroupManager(oConfigPara.getElementInfoLst(), oConfigPara.getActivateGroupInfoLst());
        }
        this.createTreeTableModel();
        this.createTreeTable();
        this.createToolBarPanel();
        this.populateDataBasedOnActivationMode();
        this.initializeEventListeners();
        this.m_oDeviceTableScrollPane = new JScrollPane((Component)((Object)this.m_oDeviceTreeTable));
        this.m_oDeviceTableScrollPane.setName("DeviceOperation_ActivationDeviceTree_m_oDeviceTableScrollPane");
        this.m_oDeviceTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        if (this.m_bIsGroupLevelView) {
            this.m_oDeviceTableScrollPane.setBounds(0, 33, 595, 197);
        } else {
            this.m_oDeviceTableScrollPane.setBounds(0, 2, 595, 225);
        }
        Border oTreeBorder = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        TitledBorder oTreeTitledBorder = new TitledBorder(oTreeBorder, ResourceManager.getInstance().getResString("SELECTED_RESOURCE_PANEL_TITLE"));
        this.m_oDeviceTableScrollPane.setBorder(oTreeTitledBorder);
        this.setLayout(null);
        this.add(this.m_oDeviceTableScrollPane);
        this.setMinimumSize(new Dimension(540, 100));
        this.setPreferredSize(new Dimension(540, 400));
    }

    private void populateDataBasedOnActivationMode() {
        if ("GroupActivation".equalsIgnoreCase(this.m_strActivationMode)) {
            List oGroupList = this.m_oGroupManager.getActivateGroupInfoLst();
            this.populateGroupsToTable(oGroupList);
        } else {
            List oResourceList = this.m_oActivationConfigPara.getElementInfoLst();
            this.populateResourcesToTreeTable(oResourceList);
        }
    }

    private void createTreeTableModel() {
        Vector<String> oTableHeader = new Vector<String>(4);
        if (this.m_bIsGroupLevelView) {
            oTableHeader.add(this.m_oResourceMgr.getResString("ACTIVATION_TABLE_GROUP_NAME_COLUMN"));
        }
        oTableHeader.add(this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_NAME"));
        oTableHeader.add(this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_IP"));
        oTableHeader.add(this.m_oResourceMgr.getResString("DEVICE_TABLE_HEADER_RESOURCE_VERSION"));
        Class[] arrColumnTypes = new Class[]{TreeTableModel.class, String.class, String.class, String.class, String.class};
        boolean[] arrSortableColumns = new boolean[]{true, false, false, false};
        boolean[] arrEditableColumns = new boolean[]{true, false, false, false};
        this.m_oDeviceTreeTableModel = new DCTreeTableModel(oTableHeader.toArray(new String[0]), arrColumnTypes, arrSortableColumns, arrEditableColumns);
        this.m_oRootNode = this.m_oDeviceTreeTableModel.getRoot();
    }

    private void createTreeTable() {
        this.m_oDeviceTreeTable = new JSortTreeTable(this.m_oDeviceTreeTableModel);
        this.m_oDeviceTreeTable.setName("DeviceOperation_ActivationDeviceTree_m_oDeviceTreeTable");
        this.m_oDeviceTreeTable.setOpaque(true);
        this.m_oDeviceTreeTable.getTableHeader().setReorderingAllowed(false);
        this.m_oDeviceTreeTable.getTableHeader().setPreferredSize(new Dimension(this.m_oDeviceTreeTable.getSize().width, 20));
        this.m_oDeviceTreeTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.m_oDeviceTreeTable.getColumnModel().getColumn(0).setMaxWidth(250);
        this.m_oDeviceTreeTable.setRowHeight(20);
        DefaultListSelectionModel devSelection = new DefaultListSelectionModel();
        devSelection.setSelectionMode(2);
        this.m_oDeviceTreeTable.setSelectionModel(devSelection);
        this.m_oDeviceTreeTable.getTree().setToggleClickCount(2);
        this.initializeTableCellRenderer();
        this.initializeDeleteKeyEventHandler();
        this.m_oDeviceTreeTable.setSelectionMode(2);
    }

    private void createToolBarPanel() {
        if (!this.m_bIsGroupLevelView) {
            return;
        }
        ActivationPanelListener oToolBarActionListener = new ActivationPanelListener(this);
        ResourceManager oResManager = ResourceManager.getInstance();
        this.m_oCreateGroup = new JButton();
        this.m_oCreateGroup.setName("DeviceOperation_ActivationDeviceTree_m_oCreateGroup");
        this.setButtonProperties(this.m_oCreateGroup, "new_activation_group.gif");
        this.m_oCreateGroup.setActionCommand("create_group");
        this.m_oCreateGroup.setBounds(0, 0, 25, 25);
        this.m_oCreateGroup.setToolTipText(oResManager.getResString("CREATE_GROUP_BUTTON_TOOL_TIP"));
        this.m_oDeleteGroup = new JButton();
        this.m_oDeleteGroup.setName("DeviceOperation_ActivationDeviceTree_m_oDeleteGroup");
        this.setButtonProperties(this.m_oDeleteGroup, "delete.gif");
        this.m_oDeleteGroup.setActionCommand("delete_group");
        this.m_oDeleteGroup.setBounds(28, 0, 25, 25);
        this.m_oDeleteGroup.setToolTipText(oResManager.getResString("DELETE_GROUP_BUTTON_TOOL_TIP"));
        this.m_oCreateGroup.addActionListener(oToolBarActionListener);
        this.m_oDeleteGroup.addActionListener(oToolBarActionListener);
        this.updateStatusForToolBarButtons();
        JPanel oToolBarPanel = new JPanel();
        oToolBarPanel.setLayout(null);
        oToolBarPanel.setBounds(8, 8, 105, 25);
        oToolBarPanel.add(this.m_oCreateGroup);
        oToolBarPanel.add(this.m_oDeleteGroup);
        this.add(oToolBarPanel);
    }

    private void setButtonProperties(JButton oButton, String strImageFileName) {
        ImageIcon oCreateIcon = ResourceManager.getInstance().getImage(strImageFileName);
        oButton.setIcon(oCreateIcon);
    }

    private void initializeEventListeners() {
        this.isDragged = false;
        this.m_oDeviceTreeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.hasFocus()) {
                    ActivationDeviceTreeTablePanel.this.updateStatusForToolBarButtons();
                }
            }
        });
        this.m_oDeviceTreeTable.addMouseMotionListener(this.m_oDeviceTreeTableMouseMotionListener);
        this.m_oDeviceTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.setRowSelectionAllowed(true);
                ActivationDeviceTreeTablePanel.this.rows = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getSelectedRows();
                ActivationDeviceTreeTablePanel.this.selectedRowCount = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getSelectedRowCount();
            }

            @Override
            public void mousePressed(MouseEvent pressedEvent) {
                ActivationDeviceTreeTablePanel.this.rows = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getSelectedRows();
                ActivationDeviceTreeTablePanel.this.selectedRowCount = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getSelectedRowCount();
            }

            @Override
            public void mouseReleased(MouseEvent releasedEvent) {
                ActivationDeviceTreeTablePanel.this.updateStatusForToolBarButtons();
                ArrayList<ActivationGroupInfo> lExpActiveGroup = new ArrayList<ActivationGroupInfo>(0);
                TreeTableNode oImportRowNode = null;
                Cursor normalCursor = new Cursor(0);
                int row = 0;
                DCFrameWorkUtil.setCursor((Component)((Object)ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable), normalCursor);
                try {
                    if (ActivationDeviceTreeTablePanel.this.isDragged && ActivationDeviceTreeTablePanel.this.m_bIsGroupLevelView && ActivationDeviceTreeTablePanel.this.m_oGroupManager.getActivateGroupInfoLst().size() > 1 && ActivationDeviceTreeTablePanel.this.isDraggedOverGroup == 1) {
                        int groupRows = 0;
                        for (int index = 0; index < ActivationDeviceTreeTablePanel.this.selectedRowCount; ++index) {
                            Point p = releasedEvent.getPoint();
                            row = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.rowAtPoint(p);
                            TreePath oTreePath = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getTree().getPathForRow(row);
                            oImportRowNode = (TreeTableNode)oTreePath.getLastPathComponent();
                            TreePath parentPath = oTreePath.getParentPath();
                            TreeTableNode oParentGroupNode = (TreeTableNode)parentPath.getLastPathComponent();
                            TreeTableRowData parentGroupRowData = (TreeTableRowData)oParentGroupNode.getUserObject();
                            if (parentGroupRowData == null) {
                                oParentGroupNode = oImportRowNode;
                                parentGroupRowData = (TreeTableRowData)oParentGroupNode.getUserObject();
                            }
                            TreeTableNodeCellData groupData = (TreeTableNodeCellData)parentGroupRowData.getColumnData(0);
                            ActivationDeviceTreeTablePanel.this.finalGroupName = groupData.getCellDataValue().toString();
                            ActivationGroupInfo impActiveGroup = (ActivationGroupInfo)((TreeTableRowData)oParentGroupNode.getUserObject()).getColumnData(0).getCellDataValue();
                            if (((TreeTableNode)ActivationDeviceTreeTablePanel.this.lParentSourceGroupNode.get(index)).getUserObject() == null) {
                                ++groupRows;
                                continue;
                            }
                            ActivationGroupInfo expActiveGroup = (ActivationGroupInfo)((TreeTableRowData)((TreeTableNode)ActivationDeviceTreeTablePanel.this.lParentSourceGroupNode.get(index)).getUserObject()).getColumnData(0).getCellDataValue();
                            lExpActiveGroup.add(expActiveGroup);
                            if (Collator.getInstance().equals(ActivationDeviceTreeTablePanel.this.finalGroupName, (String)ActivationDeviceTreeTablePanel.this.lInitialGroupName.get(index - groupRows))) continue;
                            if (1 == ((TreeTableNode)ActivationDeviceTreeTablePanel.this.lExportRowNode.get(index)).getSiblingCount() && ActivationDeviceTreeTablePanel.this.m_oGroupManager.isDefaultGroup((ActivationGroupInfo)lExpActiveGroup.get(index - groupRows))) {
                                ActivationDeviceTreeTablePanel.this.showErrorMessage(ResourceManager.getInstance().getResString("DEFAULT_GROUP_CANNOT_BE_EMPTY"));
                                ActivationDeviceTreeTablePanel.this.updateUI();
                                continue;
                            }
                            ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.removeRowSelectionInterval(0, ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getRowCount() - 1);
                            int iConfirmOutput = 0;
                            if (1 == ((TreeTableNode)ActivationDeviceTreeTablePanel.this.lParentSourceGroupNode.get(index)).getChildCount() && 0 != (iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("GROUP_DELETE_CONFIRM_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0))) continue;
                            ((TreeTableNode)ActivationDeviceTreeTablePanel.this.lExportRowNode.get(index)).removeFromParent();
                            oParentGroupNode.add((TreeTableNode)ActivationDeviceTreeTablePanel.this.lExportRowNode.get(index));
                            if (0 == ((TreeTableNode)ActivationDeviceTreeTablePanel.this.lParentSourceGroupNode.get(index)).getChildCount()) {
                                ActivationDeviceTreeTablePanel.this.m_oRootNode.remove((TreeTableNode)ActivationDeviceTreeTablePanel.this.lParentSourceGroupNode.get(index));
                            }
                            List impElementList = ActivationDeviceTreeTablePanel.this.m_oGroupManager.getElementsFromGroup(impActiveGroup.getGroupId());
                            List expElementList = ActivationDeviceTreeTablePanel.this.m_oGroupManager.getElementsFromGroup(((ActivationGroupInfo)lExpActiveGroup.get(index - groupRows)).getGroupId());
                            for (int count = 0; count < expElementList.size(); ++count) {
                                if (!Collator.getInstance().equals(expElementList.get(count).toString(), ((TreeTableRowData)((TreeTableNode)ActivationDeviceTreeTablePanel.this.lExportRowNode.get(index)).getUserObject()).getColumnData(1).toString())) continue;
                                impElementList.add(expElementList.get(count));
                                expElementList.remove(count);
                            }
                            ActivationDeviceTreeTablePanel.this.m_oGroupManager.setGroupIdForElements(impElementList, impActiveGroup.getGroupId());
                            ActivationDeviceTreeTablePanel.this.m_oGroupManager.setGroupIdForElements(expElementList, ((ActivationGroupInfo)lExpActiveGroup.get(index - groupRows)).getGroupId());
                            ActivationDeviceTreeTablePanel.this.m_oGroupManager.clearEmptyGroups();
                        }
                        ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getSelectionModel().clearSelection();
                        ActivationDeviceTreeTablePanel.this.refreshTable();
                    }
                    for (int i = 0; i < ActivationDeviceTreeTablePanel.this.rows.length; ++i) {
                        ActivationDeviceTreeTablePanel.this.rows[i] = -1;
                    }
                    ActivationDeviceTreeTablePanel.this.selectedRowCount = 0;
                    ActivationDeviceTreeTablePanel.this.isDragged = false;
                    ActivationDeviceTreeTablePanel.this.lExportRowData.clear();
                    ActivationDeviceTreeTablePanel.this.lExportRowNode.clear();
                    ActivationDeviceTreeTablePanel.this.lParentSourceGroupNode.clear();
                    lExpActiveGroup.clear();
                    ActivationDeviceTreeTablePanel.this.lInitialGroupName.clear();
                }
                catch (RuntimeException ex) {
                    DCDebugTracer.trace(ex);
                }
                ActivationDeviceTreeTablePanel.this.isDraggedOverGroup = 0;
            }
        });
    }

    private void initializeTableCellRenderer() {
        DCTreeTableCellRenderer oDefaultCellRenderer = new DCTreeTableCellRenderer(this.m_oDeviceTreeTable);
        int iColumnCount = this.m_oDeviceTreeTable.getColumnModel().getColumnCount();
        for (int i = 0; i < iColumnCount; ++i) {
            this.m_oDeviceTreeTable.getColumnModel().getColumn(i).setCellRenderer(oDefaultCellRenderer);
        }
    }

    public void populateResourcesToTreeTable(List oResourceList) {
        if (null == oResourceList || 0 == oResourceList.size()) {
            return;
        }
        this.m_oRootNode.removeAllChildren();
        int iResourceCount = oResourceList.size();
        for (int i = 0; i < iResourceCount; ++i) {
            ActivationElementInfo oElementInfo = (ActivationElementInfo)oResourceList.get(i);
            if (3 == oElementInfo.getResource().getRoleType() && -1 != oElementInfo.getResource().getStackId()) continue;
            this.addResourceToTableModel(oElementInfo, this.m_oRootNode);
        }
        this.m_oDeviceTreeTable.getSelectionModel().setSelectionInterval(0, 0);
        this.refreshTable();
    }

    public void populateGroupsToTable(List oGroupList) {
        if (null == oGroupList || 0 == oGroupList.size()) {
            return;
        }
        this.m_oRootNode.removeAllChildren();
        int iGroupCount = oGroupList.size();
        for (int i = 0; i < iGroupCount; ++i) {
            ActivationGroupInfo oGroup = (ActivationGroupInfo)oGroupList.get(i);
            this.addGroupToTableModel(oGroup);
        }
        this.m_oDeviceTreeTable.getSelectionModel().setSelectionInterval(0, 0);
        this.m_oDeviceTreeTable.updateUI();
        this.updateUI();
        this.updateStatusForToolBarButtons();
        this.refreshTable();
    }

    private void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getTableHeader().updateUI();
                ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.updateUI();
            }
        });
    }

    private void addResourceToTableModel(ActivationElementInfo oElementInfo, TreeTableNode oNode) {
        TreeTableCellData[] oTreeTableCellData = this.fillRowForElementInfo(oElementInfo);
        TreeTableRowData oRowData = new TreeTableRowData(oTreeTableCellData);
        TreeTableNode oElementNode = new TreeTableNode(oRowData);
        int iNodeIndex = 0;
        if (this.m_bIsGroupLevelView) {
            iNodeIndex = 1;
        }
        ((TreeTableNodeCellData)oTreeTableCellData[iNodeIndex]).setAttachedTreeNode(oNode);
        oNode.add(oElementNode);
    }

    private void addGroupToTableModel(ActivationGroupInfo oGroupInfo) {
        TreeTableCellData[] oTreeTableCellData = this.fillRowForGroupInfo(oGroupInfo);
        TreeTableRowData oRowData = new TreeTableRowData(oTreeTableCellData);
        TreeTableNode oNode = new TreeTableNode(oRowData);
        ((TreeTableNodeCellData)oTreeTableCellData[0]).setAttachedTreeNode(oNode);
        this.m_oRootNode.add(oNode);
        List oElementList = this.m_oGroupManager.getElementsFromGroup(oGroupInfo.getGroupId());
        int iElementCount = oElementList.size();
        for (int i = 0; i < iElementCount; ++i) {
            ActivationElementInfo oElement = (ActivationElementInfo)oElementList.get(i);
            this.addResourceToTableModel(oElement, oNode);
        }
    }

    private TreeTableCellData[] fillRowForElementInfo(ActivationElementInfo oElementInfo) {
        TreeTableCellData[] oTreeTableCellData = null;
        if (this.m_bIsGroupLevelView) {
            oTreeTableCellData = new TreeTableCellData[COLUMN_SIZE];
            oTreeTableCellData[1] = this.getTableNodeData(oElementInfo);
            Resource oResource = oElementInfo.getResource();
            oTreeTableCellData[2] = this.getCellData(oResource.getDeviceIP());
            oTreeTableCellData[3] = this.getCellData(oResource.getDeviceVersion());
        } else {
            oTreeTableCellData = new TreeTableCellData[COLUMN_SIZE - 1];
            oTreeTableCellData[0] = this.getTableNodeData(oElementInfo);
            Resource oResource = oElementInfo.getResource();
            oTreeTableCellData[1] = this.getCellData(oResource.getDeviceIP());
            oTreeTableCellData[2] = this.getCellData(oResource.getDeviceVersion());
        }
        return oTreeTableCellData;
    }

    private TreeTableCellData[] fillRowForGroupInfo(ActivationGroupInfo oGroupInfo) {
        TreeTableCellData[] oTreeTableCellData = null;
        oTreeTableCellData = this.m_bIsGroupLevelView ? new TreeTableCellData[COLUMN_SIZE] : new TreeTableCellData[COLUMN_SIZE - 1];
        oTreeTableCellData[0] = this.getTableNodeData(oGroupInfo);
        return oTreeTableCellData;
    }

    private TreeTableCellData getCellData(Object colValue) {
        return new TreeTableCellData(colValue);
    }

    private TreeTableNodeCellData getTableNodeData(Object oNodeInfo) {
        TreeTableNodeCellData oDeviceNodeData = new TreeTableNodeCellData();
        if (oNodeInfo instanceof ActivationElementInfo) {
            oDeviceNodeData.setNodeClosedIcon("");
            oDeviceNodeData.setNodeOpenedIcon("");
            oDeviceNodeData.setNodeLeafIcon("");
        }
        oDeviceNodeData.setCellDataValue(oNodeInfo);
        return oDeviceNodeData;
    }

    public List getSelectedElementInfoList() {
        ArrayList<ActivationElementInfo> oSelectedElementList = new ArrayList<ActivationElementInfo>(0);
        int iSequenceCount = 0;
        int iRowCount = this.m_oDeviceTreeTable.getRowCount();
        for (int i = 0; i < iRowCount; ++i) {
            TreeTableCellData oCellData = null;
            TreePath oTreePath = this.m_oDeviceTreeTable.getTree().getPathForRow(i);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            TreeTableRowData oRowData = (TreeTableRowData)oNode.getUserObject();
            oCellData = oRowData.getColumnData(0);
            ActivationElementInfo oElementInfo = (ActivationElementInfo)oCellData.getCellDataValue();
            oSelectedElementList.add(oElementInfo);
            if (!oElementInfo.isSelected()) continue;
            oElementInfo.setSequenceId(++iSequenceCount);
        }
        return oSelectedElementList;
    }

    private void updateStatusForToolBarButtons() {
        if (!this.m_bIsGroupLevelView) {
            return;
        }
        int[] arrSelectedRows = this.m_oDeviceTreeTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            this.m_oCreateGroup.setEnabled(true);
            this.m_oDeleteGroup.setEnabled(false);
            this.repaint();
            return;
        }
        for (int iCount = 0; iCount < arrSelectedRows.length; ++iCount) {
            TreePath oTreePath = this.m_oDeviceTreeTable.getTree().getPathForRow(arrSelectedRows[iCount]);
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ActivationGroupInfo oGroup = ActivationDeviceTreeUtil.getGroupFromNode(oNode);
            if (null != oGroup && !this.m_oGroupManager.isDefaultGroup(oGroup)) continue;
            this.m_oCreateGroup.setEnabled(true);
            this.m_oDeleteGroup.setEnabled(false);
            this.repaint();
            return;
        }
        this.m_oCreateGroup.setEnabled(true);
        this.m_oDeleteGroup.setEnabled(true);
        if (this.isAnyResourceSelected(arrSelectedRows)) {
            this.m_oDeleteGroup.setEnabled(false);
        }
        this.updateUI();
    }

    private boolean isAnyResourceSelected(int[] arrSelectedRows) {
        boolean bIsAnyResourceSelected = false;
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            TreeTableNode oNode;
            TreePath oTreePath = this.m_oDeviceTreeTable.getTree().getPathForRow(arrSelectedRows[i]);
            if (null == oTreePath || null == oTreePath.getLastPathComponent() || null == ActivationDeviceTreeUtil.getElementInfoFromNode(oNode = (TreeTableNode)oTreePath.getLastPathComponent())) continue;
            bIsAnyResourceSelected = true;
        }
        return bIsAnyResourceSelected;
    }

    public JSortTreeTable getDeviceTreeTable() {
        return this.m_oDeviceTreeTable;
    }

    public boolean isGroupLevelView() {
        return this.m_bIsGroupLevelView;
    }

    public void createNewGroup() {
        CreateNewGroupDlg oDlg = new CreateNewGroupDlg(this.m_oGroupManager);
        oDlg.setVisible(true);
        this.populateGroupsToTable(this.m_oGroupManager.getActivateGroupInfoLst());
    }

    public void deleteGroup() {
        int iConfirmOutput;
        int[] arrSelectedPaths = this.m_oDeviceTreeTable.getSelectedRows();
        if (null == arrSelectedPaths || 0 == arrSelectedPaths.length) {
            return;
        }
        TreePath oTreePath = this.m_oDeviceTreeTable.getTree().getPathForRow(arrSelectedPaths[0]);
        if (1 == arrSelectedPaths.length) {
            if (null == oTreePath) {
                return;
            }
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ActivationGroupInfo oGroup = ActivationDeviceTreeUtil.getGroupFromNode(oNode);
            if (null == oGroup) {
                return;
            }
            if (this.m_oGroupManager.isDefaultGroup(oGroup)) {
                this.showErrorMessage(ResourceManager.getInstance().getResString("DEFAULT_GROUP_DELETE_ERROR"));
                return;
            }
        }
        if (0 != (iConfirmOutput = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("GROUP_DELETE_CONFIRM_MSG"), ResourceManager.getInstance().getResString("CONFIRM"), 0))) {
            return;
        }
        for (int i = arrSelectedPaths.length - 1; i >= 0; --i) {
            oTreePath = this.m_oDeviceTreeTable.getTree().getPathForRow(arrSelectedPaths[i]);
            if (null == oTreePath) continue;
            TreeTableNode oNode = (TreeTableNode)oTreePath.getLastPathComponent();
            ActivationGroupInfo oGroup = ActivationDeviceTreeUtil.getGroupFromNode(oNode);
            if (null == oGroup) {
                return;
            }
            if (this.m_oGroupManager.isDefaultGroup(oGroup)) {
                this.showErrorMessage(ResourceManager.getInstance().getResString("DEFAULT_GROUP_DELETE_ERROR"));
                continue;
            }
            this.m_oGroupManager.deleteGroup(oGroup);
            TreeTableNode oGroupNode = ActivationDeviceTreeUtil.getNodeForGroup(this.m_oRootNode, oGroup);
            if (null != oGroupNode) {
                this.m_oRootNode.remove(oGroupNode);
            }
            this.populateGroupsToTable(this.m_oGroupManager.getActivateGroupInfoLst());
        }
        this.refreshTable();
        this.resetTableSelection(arrSelectedPaths[0], this.m_oDeviceTreeTable.getRowCount() - 1);
    }

    protected void showErrorMessage(String strErrorMessage) {
        ResourceManager oResManager = ResourceManager.getInstance();
        DCOptionPane.showMessageDialog((Component)this, oResManager.getResString(strErrorMessage), oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
    }

    private void resetTableSelection(int iFirstSelectedRow, int iTotalRowCount) {
        if (iFirstSelectedRow + 1 <= iTotalRowCount) {
            this.m_oDeviceTreeTable.setRowSelectionInterval(iFirstSelectedRow, iFirstSelectedRow);
        } else {
            this.m_oDeviceTreeTable.setRowSelectionInterval(0, 0);
        }
    }

    public ActivationGroupManager getGroupManager() {
        return this.m_oGroupManager;
    }

    private void initializeDeleteKeyEventHandler() {
        ActionListener oDeleteKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] arrSelectedRows = ActivationDeviceTreeTablePanel.this.m_oDeviceTreeTable.getSelectedRows();
                if (null != arrSelectedRows && !ActivationDeviceTreeTablePanel.this.isAnyResourceSelected(arrSelectedRows)) {
                    ActivationDeviceTreeTablePanel.this.deleteGroup();
                }
            }
        };
        KeyStroke oDeleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
        this.m_oDeviceTreeTable.registerKeyboardAction(oDeleteKeyHandler, oDeleteKeyStroke, 0);
    }
}

