/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation;

import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ActivationOperationUtil {
    public static List getElementInfo(ActivationConfigPara oConfigPara, String strActivationMode) {
        List oElementInfoList = oConfigPara.getElementInfoLst();
        if (null == oElementInfoList) {
            oElementInfoList = new ArrayList(8);
        }
        THashSet<Resource> oResourceList = oConfigPara.getTaskRef().getSelectedDeviceType().getResources();
        oElementInfoList = ActivationOperationUtil.addDevicesSelected(oConfigPara, oResourceList, oElementInfoList, strActivationMode);
        oElementInfoList = ActivationOperationUtil.removeDevicesDeSelected(oConfigPara, oResourceList, oElementInfoList, strActivationMode);
        return oElementInfoList;
    }

    public static List addDevicesSelected(ActivationConfigPara oConfigPara, THashSet<Resource> oResourceList, List oElementInfoList, String strActivationMode) {
        int iNosOfElement = oElementInfoList.size();
        ActivationElementInfo oNewElementInfo = null;
        ActivationElementInfo oElementInfo = null;
        Resource oResource = null;
        boolean bIsDevicePresent = false;
        Iterator oResItor = oResourceList.iterator();
        while (oResItor.hasNext()) {
            bIsDevicePresent = false;
            oResource = (Resource)oResItor.next();
            oNewElementInfo = new ActivationElementInfo();
            for (int j = 0; j < iNosOfElement; ++j) {
                oElementInfo = (ActivationElementInfo)oElementInfoList.get(j);
                if (oResource.getDeviceID() != oElementInfo.getResource().getDeviceID() || oResource.getFrameId() != oElementInfo.getResource().getFrameId() || oResource.getSlotId() != oElementInfo.getResource().getSlotId() || oResource.getSubSlotId() != oElementInfo.getResource().getSubSlotId()) continue;
                bIsDevicePresent = true;
                break;
            }
            if (bIsDevicePresent) continue;
            oNewElementInfo.setResource(oResource);
            oNewElementInfo.setSelected(true);
            if ("GroupActivation".equalsIgnoreCase(strActivationMode)) {
                oNewElementInfo.setGroupId(oConfigPara.getDefaultGroup().getGroupId());
            }
            oElementInfoList.add(oNewElementInfo);
        }
        oConfigPara.setElementInfoLst(oElementInfoList);
        return oElementInfoList;
    }

    public static List removeDevicesDeSelected(ActivationConfigPara oConfigPara, THashSet<Resource> oResourceList, List oElementInfoList, String strActivationMode) {
        int iNosOfElement = oElementInfoList.size();
        ActivationElementInfo oElementInfo = null;
        Resource oResource2 = null;
        boolean bIsDeviceSelected = false;
        for (int i = iNosOfElement - 1; i >= 0; --i) {
            ActivationGroupInfo oGroup;
            List<ActivationElementInfo> oElemList;
            bIsDeviceSelected = false;
            oElementInfo = (ActivationElementInfo)oElementInfoList.get(i);
            for (Resource oResource2 : oResourceList) {
                if (oElementInfo.getResource().getDeviceID() != oResource2.getDeviceID() || oElementInfo.getResource().getFrameId() != oResource2.getFrameId() || oElementInfo.getResource().getSlotId() != oResource2.getSlotId() || oElementInfo.getResource().getSubSlotId() != oResource2.getSubSlotId()) continue;
                bIsDeviceSelected = true;
                break;
            }
            if (bIsDeviceSelected) continue;
            if ("GroupActivation".equalsIgnoreCase(strActivationMode) && (oElemList = oConfigPara.getElementsFromGroup((oGroup = oConfigPara.getGroupForId(oElementInfo.getGroupId())).getGroupId())).size() == 1) {
                oConfigPara.deleteGroup(oGroup);
            }
            oElementInfoList.remove(i);
        }
        return oElementInfoList;
    }
}

