/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.OperationAdapter;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationSubOpr;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationType;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationDlg;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationOpPanel;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ViewActivationPanel;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.ActivationPackageDlg;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackage.view.ActivationPackagePanel;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view.GroupingActiveForDevDlg;
import com.huawei.dc.devicemanagement.deviceoperation.activationpackagefordev.view.GroupingActiveForDevPan;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PostUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.UpgradeSubOperation;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.ActiveBoardInfo;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.ITaskSubOperation;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.format.TimeFormatService;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ActivationOperation
extends OperationAdapter
implements ITaskDeviceOperation {
    private static final long serialVersionUID = 1L;
    private static IUpgradeSubOperation oUpgradePatch = null;
    private int m_iOperationId = -1;
    private String m_strOperationName;
    private String m_strOperationIdString;
    private String m_strOperationDesc;
    private boolean m_bIsOPSelected;
    private int m_iOpDependsOnId;
    private List m_oDependentOpLst;
    private boolean m_bIsPauseB4Op;
    private int m_iOperationLevel;
    private ActivationConfigPara m_oActivateConfigPara = new ActivationConfigPara();
    private int iInnerTaskTypeId = -1;
    private ITask m_oTask;
    private IParaList m_oParaList;
    private transient ActivationOpPanel m_oActivationPanel = null;
    private StringBuffer oStrBufOperation;
    private transient Component m_oActivationGroupComponent = null;
    private transient ActivationDlg oActivationDlg = null;
    private boolean m_bIsEnabled = true;
    private ActivationSubOpr m_oActivationSubOpr = null;

    public void setActivateConfigPara(ActivationConfigPara mOActivateConfigPara) {
        this.m_oActivateConfigPara = mOActivateConfigPara;
    }

    @Override
    public boolean isSelected() {
        return this.m_bIsOPSelected;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.m_bIsOPSelected = isSelected;
    }

    public List getDependentOperation() {
        return this.m_oDependentOpLst;
    }

    public void setDependentOperation(List oDevDependentLst) {
        this.m_oDependentOpLst = oDevDependentLst;
    }

    @Override
    public int getDependsOnOperation() {
        return this.m_iOpDependsOnId;
    }

    @Override
    public void setDependsOnOperation(int iDevOpDependsOnId) {
        this.m_iOpDependsOnId = iDevOpDependsOnId;
    }

    @Override
    public boolean isPauseBeforeCurOp() {
        return this.m_bIsPauseB4Op;
    }

    @Override
    public void setIsPauseBeforeCurOp(boolean bIsPauseBeforeCurOp) {
        this.m_bIsPauseB4Op = bIsPauseBeforeCurOp;
    }

    @Override
    public Component getView(int iContext) {
        Component oActivationComponent = null;
        switch (iContext) {
            case 0: {
                oActivationComponent = this.getViewForCreateTask(this.iInnerTaskTypeId);
                break;
            }
            case 2: {
                oActivationComponent = this.getViewForViewTask(this.iInnerTaskTypeId);
                break;
            }
            case 1: {
                oActivationComponent = this.getViewForModifyTask(this.iInnerTaskTypeId);
                break;
            }
        }
        return oActivationComponent;
    }

    public Object getActivationPanel() {
        return this.m_oActivationPanel;
    }

    private Component getViewForCreateTask(int taskId) {
        ActivationDlg oActivationComponent = null;
        if (taskId == 3) {
            if (this.m_oTask.getLoadSimPackageInfo() == null) {
                String strErrorMsg = "";
                strErrorMsg = ResourceManager.getInstance().getResString("NO_SELECT_LOAD_PACKAGE");
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
                return null;
            }
            this.m_oActivationGroupComponent = new ActivationPackageDlg(this, "dc", 0);
            return this.m_oActivationGroupComponent;
        }
        if (taskId == 4 || taskId == 13) {
            this.m_oActivationGroupComponent = new GroupingActiveForDevDlg(this.m_oActivateConfigPara, this.m_oTask, 0);
            return this.m_oActivationGroupComponent;
        }
        if (taskId == 5 || taskId == 12) {
            if (this.m_oTask.getUpgradeLevel() == 1) {
                this.m_oActivationGroupComponent = new GroupingActiveForDevDlg(this.m_oActivateConfigPara, this.m_oTask, 0);
                return this.m_oActivationGroupComponent;
            }
            if (this.m_oTask.getUpgradeLevel() == 2) {
                if (this.m_oTask.getLoadFileInfoListParam() == null || this.m_oTask.getLoadFileInfoListParam().getNumberOfFiles() <= 0) {
                    String strErrorMsg = "";
                    strErrorMsg = ResourceManager.getInstance().getResString("NO_SELECT_LOAD_PACKAGE");
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strErrorMsg, ResourceManager.getInstance().getResString("ERROR"), 0);
                    return null;
                }
                this.m_oActivationGroupComponent = new ActivationPackageDlg(this, "dc", 0);
                return this.m_oActivationGroupComponent;
            }
            return null;
        }
        try {
            this.m_oActivateConfigPara.initConfig();
        }
        catch (Exception e) {
            DebugTracer.trace((String)"Init configure parameter failed. ");
        }
        oActivationComponent = this.oActivationDlg = new ActivationDlg(this.m_oTask, this.m_oActivateConfigPara, this);
        this.m_oActivationPanel = this.oActivationDlg.getActivateOpPanel();
        return oActivationComponent;
    }

    private Component getViewForViewTask(int taskId) {
        ViewActivationPanel oActivationComponent = null;
        if (taskId == 3) {
            this.m_oActivationGroupComponent = new ActivationPackagePanel(this.m_oTask, 2);
            ActivationPackagePanel acPacPan = (ActivationPackagePanel)this.m_oActivationGroupComponent;
            acPacPan.setBoundsForViewSimBoardLevel();
            acPacPan.updateStatisticTable(this.m_oTask.getActivationInfo());
            acPacPan.setDisableAllComp();
            return this.m_oActivationGroupComponent;
        }
        if (taskId == 4 || taskId == 13) {
            this.m_oActivationGroupComponent = new GroupingActiveForDevPan(this.m_oActivateConfigPara, this.m_oTask, 2);
            GroupingActiveForDevPan acPacPan = (GroupingActiveForDevPan)this.m_oActivationGroupComponent;
            acPacPan.setBoundsForViewForDevLevel();
            acPacPan.setDisableAllComp();
            return this.m_oActivationGroupComponent;
        }
        if (taskId == 5 || taskId == 12) {
            if (this.m_oTask.getUpgradeLevel() == 1) {
                this.m_oActivationGroupComponent = new GroupingActiveForDevPan(this.m_oActivateConfigPara, this.m_oTask, 2);
                GroupingActiveForDevPan acPacPan = (GroupingActiveForDevPan)this.m_oActivationGroupComponent;
                acPacPan.setBoundsForViewForDevLevel();
                acPacPan.setDisableAllComp();
                return this.m_oActivationGroupComponent;
            }
            if (this.m_oTask.getUpgradeLevel() == 2) {
                this.m_oActivationGroupComponent = new ActivationPackagePanel(this.m_oTask, 2);
                ActivationPackagePanel acPacPan = (ActivationPackagePanel)this.m_oActivationGroupComponent;
                acPacPan.setBoundsForViewForBoardLevel();
                acPacPan.setDisableAllComp();
                return this.m_oActivationGroupComponent;
            }
            return null;
        }
        oActivationComponent = new ViewActivationPanel(this.m_oActivateConfigPara, this.m_oTask);
        return oActivationComponent;
    }

    private Component getViewForModifyTask(int taskId) {
        ActivationOpPanel oActivationComponent = null;
        if (taskId == 3) {
            if (!this.isSelected()) {
                this.m_oTask.setActivationInfo(null);
            }
            this.m_oActivationGroupComponent = new ActivationPackagePanel(this.m_oTask, 1);
            ActivationPackagePanel acPacPan = (ActivationPackagePanel)this.m_oActivationGroupComponent;
            acPacPan.updateStatisticTable(this.m_oTask.getActivationInfo());
            return this.m_oActivationGroupComponent;
        }
        if (taskId == 4 || taskId == 13) {
            this.m_oActivationGroupComponent = new GroupingActiveForDevPan(this.m_oActivateConfigPara, this.m_oTask, 1);
            return this.m_oActivationGroupComponent;
        }
        if (taskId == 5 || taskId == 12) {
            if (this.m_oTask.getUpgradeLevel() == 1) {
                this.m_oActivationGroupComponent = new GroupingActiveForDevPan(this.m_oActivateConfigPara, this.m_oTask, 1);
                return this.m_oActivationGroupComponent;
            }
            if (this.m_oTask.getUpgradeLevel() == 2) {
                if (!this.isSelected()) {
                    this.m_oTask.setActivationInfo(null);
                }
                this.m_oActivationGroupComponent = new ActivationPackagePanel(this.m_oTask, 1);
                return this.m_oActivationGroupComponent;
            }
            return null;
        }
        boolean isSupportIssu = true;
        if (taskId == 1 && DCCommonUtil.isContainsDevTypeID(this.m_oTask, 1332)) {
            isSupportIssu = false;
        }
        oActivationComponent = this.m_oActivationPanel = new ActivationOpPanel(this, this.m_oActivateConfigPara, isSupportIssu);
        return oActivationComponent;
    }

    @Override
    public Object getConfiguredPara() {
        return this.m_oActivateConfigPara;
    }

    public Object getGroupingActivationPan() {
        return this.m_oActivationGroupComponent;
    }

    @Override
    public ValidationResult validateOperationConfigurations() {
        ValidationResult oValidationResult = new ValidationResult();
        if (!this.checkISSUwithPreUpgrade()) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorType(4);
            return oValidationResult;
        }
        oValidationResult.setErrorCode(0);
        oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("OPERATION_SUCCESS"));
        if (this.iInnerTaskTypeId == 3) {
            if (this.m_oActivationGroupComponent instanceof ActivationPackagePanel) {
                ActivationPackagePanel activationPackagePan = (ActivationPackagePanel)this.m_oActivationGroupComponent;
                oValidationResult = activationPackagePan.validateTaskTime();
                if (0 != oValidationResult.getErrorCode()) {
                    return oValidationResult;
                }
                oValidationResult = activationPackagePan.validateData();
                if (0 != oValidationResult.getErrorCode()) {
                    return oValidationResult;
                }
                activationPackagePan.updateGroupingConfiguration();
                return oValidationResult;
            }
            if (this.m_oTask.getActivationInfo() == null) {
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_GROUP_ACTIVATION_CONFIG"));
                return oValidationResult;
            }
            ActivationPackageDlg dlg = (ActivationPackageDlg)((Object)this.m_oActivationGroupComponent);
            ((ActivationPackagePanel)dlg.getMainPan()).updateGroupingConfiguration();
            return oValidationResult;
        }
        if (this.iInnerTaskTypeId == 4 || this.iInnerTaskTypeId == 13) {
            return this.validatePackageUpdateData();
        }
        if (this.iInnerTaskTypeId == 5 || this.iInnerTaskTypeId == 12) {
            if (this.m_oTask.getUpgradeLevel() == 1) {
                return this.validatePackageUpdateData();
            }
            if (this.m_oTask.getUpgradeLevel() == 2) {
                if (this.m_oActivationGroupComponent instanceof ActivationPackagePanel) {
                    ActivationPackagePanel activationPackagePan = (ActivationPackagePanel)this.m_oActivationGroupComponent;
                    oValidationResult = activationPackagePan.validateTaskTime();
                    if (0 != oValidationResult.getErrorCode()) {
                        return oValidationResult;
                    }
                    oValidationResult = activationPackagePan.validateData();
                    if (0 != oValidationResult.getErrorCode()) {
                        return oValidationResult;
                    }
                    activationPackagePan.updateGroupingConfigurationForDiffusion();
                    return oValidationResult;
                }
                if (this.m_oTask.getActivationInfo() == null) {
                    oValidationResult.setErrorCode(-1);
                    oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("NO_GROUP_ACTIVATION_CONFIG"));
                    return oValidationResult;
                }
                ActivationPackageDlg dlg = (ActivationPackageDlg)((Object)this.m_oActivationGroupComponent);
                ((ActivationPackagePanel)dlg.getMainPan()).updateGroupingConfigurationForDiffusion();
                return oValidationResult;
            }
            return oValidationResult;
        }
        if (null != this.m_oActivationPanel) {
            this.m_oActivationPanel.updateActivationConfigSelec();
        }
        if ((oValidationResult = this.validateDeviceSelection()).getErrorCode() == 0 && this.m_oActivateConfigPara.isActivationTimeRequired()) {
            oValidationResult = this.validateActivateTimeSelection();
        }
        if (oValidationResult.getErrorCode() == 0) {
            oValidationResult = this.validateActivationType();
        }
        return oValidationResult;
    }

    private ValidationResult validatePackageUpdateData() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("OPERATION_SUCCESS"));
        if (this.m_oActivationGroupComponent instanceof GroupingActiveForDevPan) {
            GroupingActiveForDevPan activationPackagePan = (GroupingActiveForDevPan)this.m_oActivationGroupComponent;
            oValidationResult = activationPackagePan.validateTaskTime();
            if (activationPackagePan.groupTablePan.getRootNode().getChildCount() == 0) {
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("DOESNOT_GROUPING_FOR_DEVICES"));
            }
            THashSet<Resource> oResourcesLst = this.m_oTask.getSelectedDeviceType().getResources();
            activationPackagePan.updateGroupingConfiguration(oResourcesLst);
            activationPackagePan.updateSelectedDeviceType(this.m_oTask);
            activationPackagePan.updateActivationConfigSelec();
            return oValidationResult;
        }
        GroupingActiveForDevDlg dlg = (GroupingActiveForDevDlg)((Object)this.m_oActivationGroupComponent);
        if (dlg == null) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("DOESNOT_GROUPING_FOR_DEVICES"));
            return oValidationResult;
        }
        oValidationResult = dlg.mainPan.validateTaskTime();
        if (dlg.mainPan.groupTablePan.getRootNode().getChildCount() == 0) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("DOESNOT_GROUPING_FOR_DEVICES"));
            return oValidationResult;
        }
        THashSet<Resource> oResourcesLst = this.m_oTask.getSelectedDeviceType().getResources();
        ((GroupingActiveForDevPan)dlg.getMainPan()).updateGroupingConfiguration(oResourcesLst);
        ((GroupingActiveForDevPan)dlg.getMainPan()).updateActivationConfigSelec();
        return oValidationResult;
    }

    private ValidationResult validateActivationType() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        ActivationType oActivationType = this.m_oActivateConfigPara.getSelectedActivateType();
        if (null == oActivationType) {
            return oValidationResult;
        }
        ParaValue oParaValue = oActivationType.getParaValue();
        if (null != oParaValue && "ScheduledReboot".equals(oParaValue.getId()) && (null == oActivationType.getScheduledActivationTime() || this.m_oActivateConfigPara.isTimeFieldEmpty())) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("SCHEDULED_ACTIVATE_TIME_EMPTY"));
            return oValidationResult;
        }
        DeviceType deviceType = this.m_oTask.getDeviceType();
        boolean isSupport = deviceType.isUpgradeModeSupportedByAllDevices(4096);
        if (!isSupport) {
            return oValidationResult;
        }
        if (null != oParaValue && "ISSU".equals(oParaValue.getId())) {
            ITaskDeviceOperation oTaskPreUpgrade;
            if (this.oActivationDlg != null && this.oActivationDlg.isVisible()) {
                return oValidationResult;
            }
            boolean isHaveErr = false;
            List<ITaskDeviceOperation> oprLst = this.getOpeLst();
            for (ITaskDeviceOperation oTaskper : oprLst) {
                if (null == oTaskper || 6 != oTaskper.getOperationId()) continue;
                if (oTaskper.isSelected()) {
                    LoadSoftwareOperation loadSoftOpe = (LoadSoftwareOperation)oTaskper;
                    LoadFileInfoListParam oLoadParam = (LoadFileInfoListParam)loadSoftOpe.getConfiguredPara();
                    if (null == oLoadParam) {
                        isHaveErr = false;
                        break;
                    }
                    List<LoadFileInfo> oloadFileInfoLst = oLoadParam.getLoadFileInfoList();
                    if (null == oloadFileInfoLst || oloadFileInfoLst.size() == 0) {
                        isHaveErr = false;
                        break;
                    }
                    isHaveErr = this.isHasErr(oloadFileInfoLst);
                    break;
                }
                boolean isContainATN = DCCommonUtil.isContainsDevTypeID(this.m_oTask, 1332);
                if (isContainATN) {
                    isHaveErr = false;
                    break;
                }
                isHaveErr = true;
                break;
            }
            if (isHaveErr && (oTaskPreUpgrade = TaskInfoUtil.getTaskOperation(this.m_oTask, 32)) instanceof PrepareUpgradeOperation) {
                PrepareUpgradeOperation oPreOper = (PrepareUpgradeOperation)oTaskPreUpgrade;
                List<IUpgradeSubOperation> oIUpgradeSubOperationLst = oPreOper.getUpgradeSubOperationList();
                for (int i = 0; i < oIUpgradeSubOperationLst.size(); ++i) {
                    StartupConfigParam oStartupConfigParam;
                    HashMap<Integer, List<LoadFileInfo>> oHashMap;
                    UpgradeSubOperation oUpgradeSubOperation = (UpgradeSubOperation)oIUpgradeSubOperationLst.get(i);
                    IOperationConfigPara oIOperationConfigPara = oUpgradeSubOperation.getUpgradeSubOperationConfig();
                    if (!(oIOperationConfigPara instanceof StartupConfigParam) || !oPreOper.isSelected() || null == (oHashMap = (oStartupConfigParam = (StartupConfigParam)oIOperationConfigPara).getDeviceLoadFileInfoMap()) || oHashMap.size() <= 0) continue;
                    for (int iDevID : oHashMap.keySet()) {
                        List<LoadFileInfo> oLoadFileList = oHashMap.get(iDevID);
                        isHaveErr = this.isHasErr(oLoadFileList);
                    }
                    break;
                }
            }
            if (isHaveErr) {
                oValidationResult.setErrorCode(-1);
                oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("ISSU_FILE_SELECT_PPROGRAM_MSG"));
                return oValidationResult;
            }
        }
        return oValidationResult;
    }

    private boolean isHasErr(List<LoadFileInfo> oloadFileInfoLst) {
        boolean isHaveProgram = DCCommonUtil.isHaveTargetFileType(oloadFileInfoLst, 1);
        boolean isContainATN = DCCommonUtil.isContainsDevTypeID(this.m_oTask, 1332);
        boolean isHaveErr = isContainATN ? !isContainATN : !isHaveProgram;
        return isHaveErr;
    }

    private ValidationResult validateActivateTimeSelection() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        if (!this.m_oActivateConfigPara.isTimeSelected()) {
            return oValidationResult;
        }
        if (this.m_oActivateConfigPara.isTimeFieldEmpty()) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("ACTIVATION_TIME_EMPTY"));
            return oValidationResult;
        }
        if (!this.m_oActivateConfigPara.isTimeFieldEmpty() && null == this.m_oTask.getStartTime()) {
            oValidationResult = this.validateWithCurrentTime();
        } else if (!this.m_oActivateConfigPara.isTimeFieldEmpty() && null != this.m_oTask.getStartTime()) {
            Calendar oActivatetimeCal = this.m_oActivateConfigPara.getActivationUTCTime();
            oValidationResult = this.validateWithStartTime(oActivatetimeCal, ResourceManager.getInstance().getResString("ACTIVATION_TIME_LESSER_START_TIME"));
        }
        ActivationType oActivationType = this.m_oActivateConfigPara.getSelectedActivateType();
        if (null == oActivationType) {
            return oValidationResult;
        }
        if ("ScheduledReboot".equals(oActivationType.getParaValue().getId())) {
            oActivationType.setScheduledActivationTime(this.m_oActivateConfigPara.getActivationUTCTime());
            this.m_oActivateConfigPara.setActivationUTCTime(null);
            this.m_oActivateConfigPara.setIsTimeSelected(false);
        }
        return oValidationResult;
    }

    private ValidationResult validateWithStartTime(Calendar oSelectedTimeCal, String strErrorMsg) {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        if (oSelectedTimeCal.equals(this.m_oTask.getStartTime()) || oSelectedTimeCal.before(this.m_oTask.getStartTime())) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(strErrorMsg);
        }
        return oValidationResult;
    }

    private ValidationResult validateWithCurrentTime() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        Calendar oCurrentTime = TaskSyncCommController.getInstance().getCurrentServerTime(true);
        Calendar oActivatetimeCal = this.m_oActivateConfigPara.getActivationUTCTime();
        if (oActivatetimeCal.equals(oCurrentTime) || oActivatetimeCal.before(oCurrentTime)) {
            String sCurrentTime = TimeFormatService.getString((Calendar)oCurrentTime);
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("ACTIVATION_TIME_LESS_CURRENT_TIME", new String[]{sCurrentTime}));
        }
        return oValidationResult;
    }

    private ValidationResult validateDeviceSelection() {
        ValidationResult oValidationResult = new ValidationResult();
        oValidationResult.setErrorCode(0);
        List oElementInfoLst = this.m_oActivateConfigPara.getElementInfoLst();
        if (null == oElementInfoLst) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("ACTIVATE_DEVICE_SELECTION"));
            return oValidationResult;
        }
        int iSizeOfLst = oElementInfoLst.size();
        boolean bIsDeviceSelected = false;
        for (int i = 0; i < iSizeOfLst; ++i) {
            ActivationElementInfo oElementInfo = (ActivationElementInfo)oElementInfoLst.get(i);
            if (!oElementInfo.isSelected()) continue;
            bIsDeviceSelected = true;
            break;
        }
        if (!bIsDeviceSelected) {
            oValidationResult.setErrorCode(-1);
            oValidationResult.setErrorMessage(ResourceManager.getInstance().getResString("ACTIVATE_DEVICE_SELECTION"));
        }
        return oValidationResult;
    }

    @Override
    public int getOperationId() {
        return this.m_iOperationId;
    }

    @Override
    public void setOperationId(int iOperationId) {
        this.m_iOperationId = iOperationId;
    }

    @Override
    public String getOperationIdString() {
        return this.m_strOperationIdString;
    }

    @Override
    public void setOperationIdString(String strOperationId) {
        this.m_strOperationIdString = strOperationId;
    }

    @Override
    public String getOperationName() {
        return this.m_strOperationName;
    }

    @Override
    public void setOperationName(String strOperationName) {
        this.m_strOperationName = strOperationName;
    }

    @Override
    public String getOperationDesc() {
        return this.m_strOperationDesc;
    }

    @Override
    public void setOperationDesc(String strOperationDesc) {
        this.m_strOperationDesc = strOperationDesc;
    }

    @Override
    public void setOPerationParaList(IParaList oParaList) {
        this.m_oParaList = oParaList;
        this.m_oActivateConfigPara.setParaList(oParaList);
    }

    @Override
    public int getOperationLevel() {
        return this.m_iOperationLevel;
    }

    @Override
    public void setOperationLevel(int iOperationLevel) {
        this.m_iOperationLevel = iOperationLevel;
    }

    @Override
    public IParaList getoPerationParaList() {
        return this.m_oParaList;
    }

    @Override
    public String toString() {
        this.oStrBufOperation = new StringBuffer();
        if (this.iInnerTaskTypeId == 3 || (this.iInnerTaskTypeId == 5 || this.iInnerTaskTypeId == 12) && this.m_oTask.getUpgradeLevel() == 2) {
            this.appendActivateParaByT2000(this.oStrBufOperation);
        } else {
            this.appendActivatePara(this.oStrBufOperation);
        }
        return this.oStrBufOperation.toString();
    }

    private void appendActivateParaByT2000(StringBuffer oStrBufOperation) {
        if (this.m_oTask.getActivationInfo().getStartTime() != null) {
            oStrBufOperation.append(ResourceManager.getInstance().getResString("ACTIVE_START_TIME_FOR_MIMIC"));
            oStrBufOperation.append(DCTimeDateUtil.getLocaleDisplayTime(this.m_oTask.getActivationInfo().getStartTime()));
            oStrBufOperation.append("<br>");
        }
        oStrBufOperation.append(ResourceManager.getInstance().getResString("GROUPING_FILE_PATH"));
        oStrBufOperation.append(this.m_oTask.getActivationInfo().getFilePath());
        oStrBufOperation.append("<br>");
        oStrBufOperation.append(ResourceManager.getInstance().getResString("GROUPING_INFO_TABLE"));
        String[] colHead = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("BOARD_NALE"), ResourceManager.getInstance().getResString("BOARD_TYPE_T2000"), ResourceManager.getInstance().getResString("IS_DELETE_DATABASE"), ResourceManager.getInstance().getResString("PAUSE_BEFOR_CURRENT_GROUP")};
        String tableHead = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"1\">";
        String columeHead = this.createCloumHead(colHead);
        StringBuffer rowsData = this.createRowsData();
        String tableLast = "</table>";
        oStrBufOperation.append(tableHead);
        oStrBufOperation.append(columeHead);
        oStrBufOperation.append(rowsData);
        oStrBufOperation.append(tableLast);
    }

    private String createCloumHead(String[] colHead) {
        StringBuffer columeHead = new StringBuffer(0);
        columeHead.append("<dl><dd></dl><tr high = 0>");
        for (int i = 0; i < colHead.length; ++i) {
            columeHead.append("<td>" + colHead[i] + "</td>");
        }
        columeHead.append("</tr>");
        return columeHead.toString();
    }

    private StringBuffer createRowsData() {
        StringBuffer rowsData = new StringBuffer(0);
        ActiveInfo oActiveInfo = this.m_oTask.getActivationInfo();
        Vector<ActiveGroupInfo> groupList = oActiveInfo.getGroupList();
        int groupCount = groupList.size();
        for (int i = 0; i < groupCount; ++i) {
            ActiveGroupInfo groupInfo = groupList.get(i);
            String groupName = "";
            groupName = Short.MAX_VALUE == groupInfo.getGroupId() ? ResourceManager.getInstance().getResString("MANUAL_ACTIVATE_GROUP_NAME") : ResourceManager.getInstance().getResString("GROUP") + groupInfo.getGroupId();
            int pause = groupInfo.getIsPause();
            String isPause = pause == 0 ? "false" : "true";
            Vector<String> rowData = new Vector<String>(6);
            rowData.add(0, groupName);
            rowData.add(1, null);
            rowData.add(2, null);
            rowData.add(3, null);
            rowData.add(4, null);
            rowData.add(5, isPause);
            this.createRowData(rowData, rowsData);
            Vector devList = groupInfo.getActivationInfoLst();
            int devCount = devList.size();
            for (int j = 0; j < devCount; ++j) {
                ActiveDevInfo devInfo = (ActiveDevInfo)devList.get(j);
                rowData = new Vector(6);
                rowData.add(0, null);
                rowData.add(1, devInfo.getDevName());
                rowData.add(2, null);
                rowData.add(3, null);
                rowData.add(4, null);
                rowData.add(5, null);
                this.createRowData(rowData, rowsData);
                Vector boardList = devInfo.getBoardList();
                int boardCount = boardList.size();
                for (int l = 0; l < boardCount; ++l) {
                    ActiveBoardInfo boardInfo = (ActiveBoardInfo)boardList.get(l);
                    rowData = new Vector(6);
                    rowData.add(0, null);
                    rowData.add(1, null);
                    rowData.add(2, boardInfo.getSlotLabel() + '_' + boardInfo.getSlotId());
                    rowData.add(3, boardInfo.getResourceType());
                    if (boardInfo.getIsDeleteDatabase() != 0) {
                        rowData.add(4, "yes");
                    } else {
                        rowData.add(4, "no");
                    }
                    rowData.add(5, null);
                    this.createRowData(rowData, rowsData);
                }
            }
        }
        return rowsData;
    }

    private void createRowData(Vector rowData, StringBuffer rowsData) {
        rowsData.append("<dl><dd></dl><tr high = 0>");
        for (int m = 0; m < rowData.size(); ++m) {
            Object data = rowData.get(m);
            if (data == null) {
                rowsData.append("<td></td>");
                continue;
            }
            rowsData.append("<td>" + data + "</td>");
        }
        rowsData.append("</tr>");
    }

    private void appendActivatePara(StringBuffer oStrBufOperation) {
        if (this.m_oActivateConfigPara.isActivationTypeRequired()) {
            oStrBufOperation.append(ResourceManager.getInstance().getResString("ACTIVATION_TYPE"));
            oStrBufOperation.append(": ");
            if (null != this.m_oActivateConfigPara.getSelectedActivateType()) {
                oStrBufOperation.append(this.m_oActivateConfigPara.getSelectedActivateType().toString());
            } else {
                oStrBufOperation.append("null");
            }
            oStrBufOperation.append("<br>");
        }
        if (this.m_oActivateConfigPara.getSelectedActivationMode() != null) {
            oStrBufOperation.append(ResourceManager.getInstance().getResString("ACTIVATION_MODE"));
            oStrBufOperation.append(": ");
            oStrBufOperation.append(this.m_oActivateConfigPara.getSelectedActivationMode().toString());
            oStrBufOperation.append("<br>");
        }
        if (null != this.m_oActivateConfigPara.getSelectedActivateType()) {
            if (this.m_oActivateConfigPara.getSelectedActivateType().getParaValue().getId().equals("ScheduledReboot") && null != this.m_oActivateConfigPara.getSelectedActivateType().getScheduledActivationTime()) {
                oStrBufOperation.append(ResourceManager.getInstance().getResString("ACTIVATE_TIME"));
                oStrBufOperation.append(": ");
                oStrBufOperation.append(DCTimeDateUtil.getLocaleDisplayTime(this.m_oActivateConfigPara.getSelectedActivateType().getScheduledActivationTime()));
                oStrBufOperation.append("<br>");
            }
            if (this.m_oActivateConfigPara.getSelectedActivateType().getParaValue().getId().equals("DelayReboot")) {
                oStrBufOperation.append(ResourceManager.getInstance().getResString("Delay_Time_Label"));
                oStrBufOperation.append(": ");
                oStrBufOperation.append(this.m_oActivateConfigPara.getM_oDelayTime());
                oStrBufOperation.append("<br>");
            }
        }
        this.updateSelectedDeviceDetails(oStrBufOperation);
    }

    private void updateSelectedDeviceDetails(StringBuffer strBufOperation) {
        String[] colHead = new String[]{ResourceManager.getInstance().getResString("GROUP_NAME_COLUMN"), ResourceManager.getInstance().getResString("DEVICE_NAME"), ResourceManager.getInstance().getResString("RESOURCE_TYPE"), ResourceManager.getInstance().getResString("DEVICE_IP"), ResourceManager.getInstance().getResString("DEVICE_VERSION")};
        String tableHead = "<table cellpadding=\"0\" cellspacing=\"0\" border=\"1\"";
        String columeHead = this.createCloumHead(colHead);
        String rowsData = this.createRowsDataForPackageUpgrade();
        if (null == rowsData || 0 == rowsData.length()) {
            return;
        }
        String tableLast = "</table>";
        strBufOperation.append(tableHead);
        strBufOperation.append(columeHead);
        strBufOperation.append(rowsData);
        strBufOperation.append(tableLast);
    }

    private String createRowsDataForPackageUpgrade() {
        StringBuffer rowsData = new StringBuffer(0);
        String strActMode = this.m_oActivateConfigPara.getSelectedActivationMode().getId();
        if (null == strActMode || !"GroupActivation".equalsIgnoreCase(strActMode)) {
            return rowsData.toString();
        }
        List<ActivationGroupInfo> groupList = this.m_oActivateConfigPara.getActivateGroupInfoLst();
        List devList = this.m_oActivateConfigPara.getElementInfoLst();
        int groupCount = groupList.size();
        Vector<String> groupData = null;
        for (int i = 0; i < groupCount; ++i) {
            ActivationGroupInfo oActivateGroupInfo = groupList.get(i);
            groupData = new Vector<String>(5);
            groupData.add(0, oActivateGroupInfo.getGroupName());
            groupData.add(1, null);
            groupData.add(2, null);
            groupData.add(3, null);
            groupData.add(4, null);
            this.createRowData(groupData, rowsData);
            int devCount = devList.size();
            for (int j = 0; j < devCount; ++j) {
                ActivationElementInfo oElementInfo = (ActivationElementInfo)devList.get(j);
                if (oActivateGroupInfo.getGroupId() != oElementInfo.getGroupId()) continue;
                Resource oResource = oElementInfo.getResource();
                Vector<String> devData = new Vector<String>(5);
                devData.add(0, null);
                devData.add(1, oResource.getDeviceName());
                devData.add(2, oResource.getDeviceType());
                devData.add(3, oResource.getDeviceIP());
                devData.add(4, oResource.getDeviceVersion());
                this.createRowData(devData, rowsData);
            }
        }
        return rowsData.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public boolean isEnabled() {
        return this.m_bIsEnabled;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.m_bIsEnabled = isEnabled;
    }

    public ITask getOperationData() {
        return this.m_oTask;
    }

    @Override
    public boolean isConfigReq() {
        return true;
    }

    public boolean isConfigActivationTime() {
        return this.m_oActivateConfigPara.isActivationTimeRequired();
    }

    public boolean isConfigActiveGroup() {
        if (this.iInnerTaskTypeId == 4 || this.iInnerTaskTypeId == 13 || this.iInnerTaskTypeId == 5) {
            if (this.m_oActivationGroupComponent instanceof GroupingActiveForDevPan) {
                GroupingActiveForDevPan activationPackagePan = (GroupingActiveForDevPan)this.m_oActivationGroupComponent;
                if (activationPackagePan.groupTablePan.getRootNode().getChildCount() != 0) {
                    return true;
                }
            } else if (this.m_oActivationGroupComponent instanceof GroupingActiveForDevDlg) {
                GroupingActiveForDevDlg dlg = (GroupingActiveForDevDlg)((Object)this.m_oActivationGroupComponent);
                if (dlg != null && dlg.mainPan.groupTablePan.getRootNode().getChildCount() != 0) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public ActivationOpPanel getM_oActivationPanel() {
        return this.m_oActivationPanel;
    }

    @Override
    public ITaskSubOperation getSubOperationData() {
        if (null == this.m_oActivationSubOpr) {
            this.m_oActivationSubOpr = new ActivationSubOpr();
        }
        return this.m_oActivationSubOpr;
    }

    @Override
    public ArrayList getOperationIDnName() {
        ArrayList<Object> oData = null;
        if (this.isSelected()) {
            oData = new ArrayList<Object>();
            oData.add(this.getOperationName());
            oData.add(this.getOperationId());
        }
        return oData;
    }

    public List<ITaskDeviceOperation> getOpeLst() {
        return this.m_oTask.getSupportedOperation();
    }

    public Component getActivationPakagePanel() {
        return this.m_oActivationGroupComponent;
    }

    public void rePopulateActivateTable(boolean highefficiencymode) {
        ActiveInfo oActiveInfo = this.m_oTask.getActivationInfo();
        if (null != oActiveInfo) {
            Vector<ActiveGroupInfo> activeGroupList = oActiveInfo.getGroupList();
            ActiveGroupInfo oGroupInfo = null;
            int iGroupSize = activeGroupList.size();
            for (int i = 0; i < iGroupSize; ++i) {
                oGroupInfo = activeGroupList.get(i);
                if (highefficiencymode) {
                    oGroupInfo.setIsPause(1);
                    continue;
                }
                oGroupInfo.setIsPause(0);
            }
            if (this.m_oActivationGroupComponent instanceof ActivationPackagePanel) {
                ((ActivationPackagePanel)this.m_oActivationGroupComponent).createGroupTablePan();
            }
        }
    }

    public ActivationConfigPara getActivateConfigPara() {
        return this.m_oActivateConfigPara;
    }

    @Override
    public void setToNullSubOperationData() {
        this.m_oActivationSubOpr = null;
    }

    @Override
    public String getCurrentContext() {
        String sCurrentContext = "";
        if (null == this.m_oTask) {
            return "";
        }
        int iTaskTypeID = this.iInnerTaskTypeId;
        switch (iTaskTypeID) {
            case 0: {
                sCurrentContext = "HELP_TOPIC_SW_U_ACTIVATE";
                break;
            }
            case 1: {
                sCurrentContext = "HELP_TOPIC_SW_D_ACTIVATE";
                break;
            }
            case 2: {
                sCurrentContext = "HELP_TOPIC_PATCH_U_ACTIVATE";
                break;
            }
            case 3: {
                sCurrentContext = "HELP_TOPIC_MINIC_ACTIVATE";
                break;
            }
            case 4: {
                sCurrentContext = "HELP_TOPIC_PACKAGE_U_ACTIVATE";
                break;
            }
            case 13: {
                sCurrentContext = "HELP_TOPIC_PACKAGE_D_ACTIVATE";
                break;
            }
            case 5: {
                sCurrentContext = "HELP_TOPIC_PKGDIF_U_ACTIVATE";
                break;
            }
            case 12: {
                sCurrentContext = "HELP_TOPIC_PKGDIF_D_ACTIVATE";
                break;
            }
        }
        return sCurrentContext;
    }

    @Override
    public void setOperationData(ITask oTask) {
        this.m_oTask = oTask;
        this.setInnerTaskTypeId(this.m_oTask.getTaskTypeId());
        int innerId = TaskInfoUtil.getInnerTaskTypeIDByTaskObj(this.m_oTask);
        if (-1 != innerId) {
            this.setInnerTaskTypeId(innerId);
        }
        this.m_oActivateConfigPara.setTaskRef(oTask);
        this.m_oActivateConfigPara.initConfig();
    }

    @Override
    public int getInnerTaskTypeId() {
        return this.iInnerTaskTypeId;
    }

    @Override
    public void setInnerTaskTypeId(int taskTypeId) {
        this.iInnerTaskTypeId = taskTypeId;
    }

    public boolean checkISSUwithPreUpgrade() {
        LoadSoftwareOperation oLoadSoftwareOperation;
        Resource oResource = this.m_oTask.getDeviceType().getFirstResource();
        DeviceTypeInfo oDeviceTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfoByDevId(oResource.getDeviceID());
        if (oDeviceTypeInfo.getDevDomain() != 2) {
            return true;
        }
        boolean bCheckISSUwithPreUpgrade = true;
        PrepareUpgradeOperation oPreOper = null;
        StartupConfigParam oStartupConfigParam = null;
        ITaskDeviceOperation oTaskPreUpgrade = TaskInfoUtil.getTaskOperation(this.m_oTask, 32);
        if (oTaskPreUpgrade instanceof PrepareUpgradeOperation) {
            oPreOper = (PrepareUpgradeOperation)oTaskPreUpgrade;
            oStartupConfigParam = this.getStartupConfigParam(oPreOper);
        }
        if (null != oStartupConfigParam) {
            DCDebugTracer.trace("ActivationOperation#checkISSUwithPreUpgrade :getStartupType:" + oStartupConfigParam.getStartupType());
        }
        boolean bSelectPreOpr = false;
        if (null != oPreOper) {
            bSelectPreOpr = oPreOper.isSelected();
        }
        DCDebugTracer.trace("ActivationOperation#checkISSUwithPreUpgrade start");
        ITaskDeviceOperation oTaskLoadSoftWare = TaskInfoUtil.getTaskOperation(this.m_oTask, 6);
        if (oTaskLoadSoftWare instanceof LoadSoftwareOperation && (oLoadSoftwareOperation = (LoadSoftwareOperation)oTaskLoadSoftWare).isSelected()) {
            if (bSelectPreOpr && oStartupConfigParam.getStartupType() == 3) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("NO_ISSU_ACTIVATE_AYPT_ISSU_FILE"));
                return false;
            }
            return true;
        }
        boolean bSelectISSU = false;
        if (null != this.m_oActivationPanel) {
            bSelectISSU = this.m_oActivationPanel.isSelectISSU();
        } else if (null != this.m_oActivateConfigPara) {
            bSelectISSU = this.m_oActivateConfigPara.isSelISSU();
        }
        DCDebugTracer.trace("ActivationOperation#checkISSUwithPreUpgrade isSelectISSU:" + bSelectISSU);
        if (!bSelectPreOpr && bSelectISSU) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("NO_LOAD_FILE_SELECTED"));
            bCheckISSUwithPreUpgrade = false;
        } else if (bSelectPreOpr && oStartupConfigParam.getStartupType() == 3 && !bSelectISSU) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("NO_ISSU_ACTIVATE_AYPT_ISSU_FILE"));
            bCheckISSUwithPreUpgrade = false;
        } else if (bSelectISSU) {
            if (oStartupConfigParam.getStartupType() == 1) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("STARTUP_CONFIG_OPR_ERROR"));
                bCheckISSUwithPreUpgrade = false;
            } else if (oStartupConfigParam.getStartupType() != 3 && bSelectISSU) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("ISSU_ACTIVATE_TYPE_NO_ISSU_FILE"));
                bCheckISSUwithPreUpgrade = false;
            }
        }
        DCDebugTracer.trace("ActivationOperation#checkISSUwithPreUpgrade End bCheckISSUwithPreUpgrade:" + bCheckISSUwithPreUpgrade);
        return bCheckISSUwithPreUpgrade;
    }

    private StartupConfigParam getStartupConfigParam(PrepareUpgradeOperation oPreOper) {
        StartupConfigParam oStartupConfigParam = null;
        List<IUpgradeSubOperation> oIUpgradeSubOperationLst = oPreOper.getUpgradeSubOperationList();
        for (int i = 0; i < oIUpgradeSubOperationLst.size(); ++i) {
            UpgradeSubOperation oUpgradeSubOperation = (UpgradeSubOperation)oIUpgradeSubOperationLst.get(i);
            IOperationConfigPara oIOperationConfigPara = oUpgradeSubOperation.getUpgradeSubOperationConfig();
            if (!(oIOperationConfigPara instanceof StartupConfigParam)) continue;
            oStartupConfigParam = (StartupConfigParam)oIOperationConfigPara;
        }
        return oStartupConfigParam;
    }

    public void enablePreUpgradeAndUpgradePatchInPostUpgrade() {
        ITaskDeviceOperation oTaskPostUpgrade;
        ITaskDeviceOperation oTaskPreUpgrade = TaskInfoUtil.getTaskOperation(this.m_oTask, 32);
        if (null != oTaskPreUpgrade && oTaskPreUpgrade instanceof PrepareUpgradeOperation) {
            PrepareUpgradeOperation oPreOper = (PrepareUpgradeOperation)oTaskPreUpgrade;
            oPreOper.setEnabled(true);
        }
        if (null != (oTaskPostUpgrade = TaskInfoUtil.getTaskOperation(this.m_oTask, 33)) && oTaskPostUpgrade instanceof PostUpgradeOperation) {
            PostUpgradeOperation oPostOper = (PostUpgradeOperation)oTaskPostUpgrade;
            List<IUpgradeSubOperation> oSubOprLst = oPostOper.getUpgradeSubOperationList();
            if (null != oUpgradePatch) {
                boolean bContainUpgradePatch = false;
                for (IUpgradeSubOperation oSubOpr : oSubOprLst) {
                    if (null == oSubOpr || !oSubOpr.getOperationIdString().equals("UpgradePatch")) continue;
                    bContainUpgradePatch = true;
                    break;
                }
                if (null != oUpgradePatch && !bContainUpgradePatch) {
                    oSubOprLst.add(oUpgradePatch);
                }
            }
        }
    }

    public void detectedPreUpgrade() {
        ITaskDeviceOperation oTaskLoadSoftware = TaskInfoUtil.getTaskOperation(this.m_oTask, 6);
        if (null != oTaskLoadSoftware && oTaskLoadSoftware instanceof LoadSoftwareOperation && !oTaskLoadSoftware.isSelected()) {
            this.disablePreUpgrade(this.m_oTask, true);
            return;
        }
        this.disablePreUpgrade(this.m_oTask, false);
    }

    private void disablePreUpgrade(ITask m_oTask, boolean bValue) {
        ITaskDeviceOperation oTaskPreUpgrade = TaskInfoUtil.getTaskOperation(m_oTask, 32);
        if (null != oTaskPreUpgrade && oTaskPreUpgrade instanceof PrepareUpgradeOperation) {
            PrepareUpgradeOperation oPreOper = (PrepareUpgradeOperation)oTaskPreUpgrade;
            if (!bValue) {
                oPreOper.setSelected(bValue);
            }
            oPreOper.setEnabled(bValue);
        }
    }

    public void disablePreUpgradeAndUpgradePatchInPostUpgrade() {
        this.detectedPreUpgrade();
        this.disablePostUpPatch();
    }

    public void disablePostUpPatch() {
        ITaskDeviceOperation oTaskPostUpgrade = TaskInfoUtil.getTaskOperation(this.m_oTask, 33);
        if (null != oTaskPostUpgrade && oTaskPostUpgrade instanceof PostUpgradeOperation) {
            PostUpgradeOperation oPostOper = (PostUpgradeOperation)oTaskPostUpgrade;
            List<IUpgradeSubOperation> oSubOprLst = oPostOper.getUpgradeSubOperationList();
            for (IUpgradeSubOperation oSubOpr : oSubOprLst) {
                if (null == oSubOpr || !oSubOpr.getOperationIdString().equals("UpgradePatch")) continue;
                oUpgradePatch = oSubOpr;
                oSubOpr.setSelected(false);
                oSubOprLst.remove(oSubOpr);
                break;
            }
        }
    }
}

