/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ActivationGroupManager {
    private List m_oActivateGroupInfoLst;
    private List m_oElementInfoLst = null;

    public ActivationGroupManager(List oElementList, List oGroupList) {
        if (null != oElementList) {
            this.m_oElementInfoLst = new ArrayList(oElementList);
            Collections.copy(this.m_oElementInfoLst, oElementList);
            if (null == oGroupList || 0 == oGroupList.size()) {
                this.m_oActivateGroupInfoLst = new ArrayList(0);
                this.addElementsToDefaultGroup();
            } else {
                this.m_oActivateGroupInfoLst = new ArrayList(oGroupList);
                Collections.copy(this.m_oActivateGroupInfoLst, oGroupList);
                this.updateElementInfoLstWithGrpId(this.m_oElementInfoLst);
                this.clearEmptyGroups();
            }
        }
    }

    private void updateElementInfoLstWithGrpId(List oElementInfoLst) {
        int iSizeOfLst = oElementInfoLst.size();
        ActivationElementInfo oActivateElementInfo = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oActivateElementInfo = (ActivationElementInfo)this.m_oElementInfoLst.get(i);
            if (0 != oActivateElementInfo.getGroupId()) continue;
            oActivateElementInfo.setGroupId(this.getDefaultGroup().getGroupId());
        }
    }

    private void addElementsToDefaultGroup() {
        ActivationGroupInfo oDefaultGroup = this.createNewGroup();
        this.addGroup(oDefaultGroup);
        this.setGroupIdForElements(this.m_oElementInfoLst, oDefaultGroup.getGroupId());
    }

    public List getActivateGroupInfoLst() {
        return this.m_oActivateGroupInfoLst;
    }

    public void setActivateGroupInfoLst(List oActivateGroupInfoLst) {
        this.m_oActivateGroupInfoLst = oActivateGroupInfoLst;
    }

    public ActivationGroupInfo getDefaultGroup() {
        if (null == this.m_oActivateGroupInfoLst || 0 == this.m_oActivateGroupInfoLst.size()) {
            ActivationGroupInfo oDefaultGrp = this.createNewGroup();
            this.m_oActivateGroupInfoLst.add(oDefaultGrp);
            return oDefaultGrp;
        }
        return (ActivationGroupInfo)this.m_oActivateGroupInfoLst.get(0);
    }

    public ActivationGroupInfo getGroupForId(int iGroupid) {
        int iGroupCount = this.m_oActivateGroupInfoLst.size();
        for (int i = 0; i < iGroupCount; ++i) {
            ActivationGroupInfo oGroup = (ActivationGroupInfo)this.m_oActivateGroupInfoLst.get(i);
            if (oGroup.getGroupId() != iGroupid) continue;
            return oGroup;
        }
        return null;
    }

    public void clearGroups() {
        this.m_oActivateGroupInfoLst.clear();
    }

    public ActivationGroupInfo createNewGroup() {
        int iNewGroupId = 1;
        if (0 < this.m_oActivateGroupInfoLst.size()) {
            ActivationGroupInfo oLastGroup = (ActivationGroupInfo)this.m_oActivateGroupInfoLst.get(this.m_oActivateGroupInfoLst.size() - 1);
            iNewGroupId = oLastGroup.getGroupId() + 1;
        }
        String strGroupName = ResourceManager.getInstance().getResString("ACTIVATION_GROUP_NAME_KEY") + '_' + iNewGroupId;
        ActivationGroupInfo oGroup = new ActivationGroupInfo();
        oGroup.setGroupId(iNewGroupId);
        oGroup.setGroupName(strGroupName);
        return oGroup;
    }

    public void addGroup(ActivationGroupInfo oGroup) {
        if (null != oGroup && !this.m_oActivateGroupInfoLst.contains(oGroup)) {
            this.m_oActivateGroupInfoLst.add(oGroup);
        }
    }

    public void clearEmptyGroups() {
        int iGroupCount = this.m_oActivateGroupInfoLst.size();
        for (int i = iGroupCount - 1; i >= 0; --i) {
            ActivationGroupInfo oGroup = (ActivationGroupInfo)this.m_oActivateGroupInfoLst.get(i);
            List oElemList = this.getElementsFromGroup(oGroup.getGroupId());
            if (null != oElemList && 0 != oElemList.size()) continue;
            this.m_oActivateGroupInfoLst.remove(oGroup);
        }
    }

    public boolean isDefaultGroup(ActivationGroupInfo oGroup) {
        int iIndex;
        return null != oGroup && 0 == (iIndex = this.m_oActivateGroupInfoLst.indexOf(oGroup));
    }

    public ActivationGroupInfo getPreviousGroup(ActivationGroupInfo oGroup) {
        int iIndex = this.m_oActivateGroupInfoLst.indexOf(oGroup);
        if (0 < iIndex) {
            return (ActivationGroupInfo)this.m_oActivateGroupInfoLst.get(iIndex - 1);
        }
        return null;
    }

    public void deleteGroup(ActivationGroupInfo oGroup) {
        if (null == oGroup || !this.m_oActivateGroupInfoLst.contains(oGroup)) {
            return;
        }
        int iIndex = this.m_oActivateGroupInfoLst.indexOf(oGroup);
        if (0 == iIndex) {
            return;
        }
        List oElements = this.getElementsFromGroup(oGroup.getGroupId());
        ActivationGroupInfo oPrevGroup = (ActivationGroupInfo)this.m_oActivateGroupInfoLst.get(iIndex - 1);
        this.setGroupIdForElements(oElements, oPrevGroup.getGroupId());
        this.m_oActivateGroupInfoLst.remove(oGroup);
    }

    public void setGroupIdForElements(List oElementList, int iGroupId) {
        if (null == oElementList) {
            return;
        }
        int iElementCount = oElementList.size();
        for (int j = 0; j < iElementCount; ++j) {
            ActivationElementInfo oElement = (ActivationElementInfo)oElementList.get(j);
            oElement.setGroupId(iGroupId);
        }
    }

    public List getElementInfoLst() {
        return this.m_oElementInfoLst;
    }

    public void setElementInfoLst(List oElementInfoLst) {
        this.m_oElementInfoLst = oElementInfoLst;
    }

    public List getElementsFromGroup(int iGroupId) {
        ArrayList<ActivationElementInfo> oElementList = new ArrayList<ActivationElementInfo>(0);
        if (null == this.m_oElementInfoLst || 0 == this.m_oElementInfoLst.size()) {
            return oElementList;
        }
        int iElementCount = this.m_oElementInfoLst.size();
        ActivationElementInfo oElementInfo = null;
        for (int i = 0; i < iElementCount; ++i) {
            oElementInfo = (ActivationElementInfo)this.m_oElementInfoLst.get(i);
            if (iGroupId != oElementInfo.getGroupId()) continue;
            oElementList.add(oElementInfo);
        }
        return oElementList;
    }
}

