/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation.activation;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.configuration.licence.LicenseMonitor;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationElementInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationGroupInfo;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationType;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ActivationConfigPara
implements IOperationConfigPara {
    private static final long serialVersionUID = 1L;
    private ParaValue m_oSelectedActivationMode;
    private ActivationType m_oSelectedActivateType;
    private IParaList m_oParaList;
    private boolean m_bIsActivationTypeRequired = true;
    private boolean m_bIsActivationTimeRequired;
    private boolean m_bIsDefaultGroupRequired;
    private boolean m_bIsBoardLevel;
    private Calendar m_oActivationUTCTime;
    private long m_oDelayTime = -1L;
    private List m_oActivationModeList = new ArrayList(8);
    private List m_oActivationTypeDataList = new ArrayList(8);
    private List m_oActivationTypeConfigList;
    private List m_oActivationTypeDataBoardList;
    private List m_oActivationTypeConfigBoardList;
    private List m_oCurrentActivationTypeLst;
    private IOperationPara m_oActivateTimeParameter;
    private IOperationPara m_oDelayRebootParameter;
    private IOperationPara m_oDefaultActivationParameter;
    private ITask m_oTaskRef = null;
    private List m_oElementInfoLst = new ArrayList(0);
    private List<ActivationGroupInfo> m_oActivateGroupInfoLst;
    private boolean m_bIsTimeSelected = false;
    private boolean m_bIsDelayTimeSelected = false;
    private boolean m_bIsTimeFieldEmpty = false;
    private boolean m_bIsDelayRebootRequired = false;
    private IOperationPara m_oActivationTypeDataParameter;
    private IOperationPara m_oActivationTypeConfigParameter;
    private boolean isSelISSU = false;
    private boolean m_bManualReboot = false;
    private boolean bIsConfSendToBoard = true;
    private String oActivationType = null;

    public ActivationConfigPara() {
        this.m_oActivationTypeConfigList = new ArrayList(8);
        this.m_oActivateGroupInfoLst = new ArrayList<ActivationGroupInfo>(0);
        this.m_oActivationTypeDataBoardList = new ArrayList(4);
        this.m_oActivationTypeConfigBoardList = new ArrayList(4);
    }

    public ITask getTaskRef() {
        return this.m_oTaskRef;
    }

    public void setTaskRef(ITask oTaskRef) {
        this.m_oTaskRef = oTaskRef;
    }

    public ActivationType getSelectedActivateType() {
        return this.m_oSelectedActivateType;
    }

    public void setSelectedActivateType(ActivationType oSelectedActivateType) {
        this.m_oSelectedActivateType = oSelectedActivateType;
        if (null != this.m_oSelectedActivateType && this.m_oSelectedActivateType.getParaValue().getId().equals("ManualReboot")) {
            this.m_bManualReboot = true;
        }
    }

    public ParaValue getSelectedActivationMode() {
        return this.m_oSelectedActivationMode;
    }

    public void setSelectedActivationMode(ParaValue oSelectedActivationMode) {
        this.m_oSelectedActivationMode = oSelectedActivationMode;
    }

    @Override
    public IParaList getParaList() {
        return this.m_oParaList;
    }

    @Override
    public void setParaList(IParaList oParaList) {
        this.m_oParaList = oParaList;
        this.initConfig();
    }

    public List getActivateModeList() {
        return this.m_oActivationModeList;
    }

    public List getActivateTypeList() {
        return this.m_oCurrentActivationTypeLst;
    }

    public void setCurrentActivationTypeLst(String strTaskContentType, int iViewType, ITask oTaskObj) {
        String strConf = "";
        if (null != oTaskObj && oTaskObj.getTaskTypeId() == 13) {
            strConf = "OSSU";
        }
        int DOWNGRADE_RECOVER_DB = 0;
        if (null != oTaskObj && oTaskObj.getTaskTypeId() == 13 && TaskSrcDstVersionCheck.getInstance().getDownGradeType(oTaskObj) == DOWNGRADE_RECOVER_DB) {
            strConf = "";
        }
        this.setCurrentActivationTypeLst(strTaskContentType, strConf, iViewType);
    }

    public void setCurrentActivationTypeLst(String strTaskContentType, String strActivationType, int iViewType) {
        if ("CONFIGURATIONFILE".equals(strTaskContentType)) {
            this.m_oCurrentActivationTypeLst = 1 == iViewType || 3 == iViewType ? this.m_oActivationTypeConfigList : this.m_oActivationTypeConfigBoardList;
        } else {
            this.oActivationType = strActivationType;
            this.m_oCurrentActivationTypeLst = this.m_oActivationTypeDataList;
            if (1 == iViewType || 3 == iViewType) {
                this.m_oCurrentActivationTypeLst = this.m_oActivationTypeDataList;
                if (this.m_oActivationTypeDataList.size() == 0 && this.m_oActivationTypeConfigList.size() > 0) {
                    this.m_oCurrentActivationTypeLst = this.m_oActivationTypeConfigList;
                }
            } else {
                this.m_oCurrentActivationTypeLst = this.m_oActivationTypeDataBoardList;
            }
        }
        int iSizeOfLst = this.m_oCurrentActivationTypeLst.size();
        if (iSizeOfLst > 0) {
            this.m_oSelectedActivateType = (ActivationType)this.m_oCurrentActivationTypeLst.get(0);
        }
    }

    synchronized void initConfig() {
        this.initActivationMode();
        this.initActivationTime();
        this.initDelayReboot();
        this.initActivationtypeConfig();
        this.initActivationtypeData();
        this.initDefaultGroupActivation();
        this.initActivateElementInfo();
    }

    private synchronized void initActivateElementInfo() {
        if (null != this.m_oTaskRef) {
            THashSet<Resource> oResources = this.m_oTaskRef.getSelectedDeviceType().getResources();
            for (Resource oResource : oResources) {
                ActivationElementInfo oActivationElementInfo = this.getElementInfoForResource(oResource);
                if (null != oActivationElementInfo) {
                    if (!this.m_oSelectedActivationMode.getId().equals("ParallelActivation")) continue;
                    oActivationElementInfo.setGroupId(0);
                    continue;
                }
                oActivationElementInfo = new ActivationElementInfo();
                oActivationElementInfo.setSelected(true);
                oActivationElementInfo.setResource(oResource);
                this.m_oElementInfoLst.add(oActivationElementInfo);
            }
        }
    }

    private synchronized void initDefaultGroupActivation() {
        this.m_oDefaultActivationParameter = this.m_oParaList.getParameter("GetDefaultActivationGroup");
        if (null != this.m_oDefaultActivationParameter) {
            this.m_bIsDefaultGroupRequired = this.m_oDefaultActivationParameter.isRequired();
        }
    }

    private synchronized void initActivationtypeData() {
        this.m_oActivationTypeDataParameter = this.m_oParaList.getParameter("ActivateContentTypeDATAFILE");
        if (null != this.m_oActivationTypeDataParameter) {
            this.changeParaToActivateLst(this.m_oActivationTypeDataList, this.m_oActivationTypeDataParameter);
            this.initBoardActivationLst(this.m_oActivationTypeDataList, this.m_oActivationTypeDataBoardList);
        }
    }

    private synchronized void initActivationtypeConfig() {
        this.m_oActivationTypeConfigParameter = this.m_oParaList.getParameter("ActivateContentTypeCONFIGURATIONFILE");
        if (null != this.m_oActivationTypeConfigParameter) {
            this.changeParaToActivateLst(this.m_oActivationTypeConfigList, this.m_oActivationTypeConfigParameter);
            this.initBoardActivationLst(this.m_oActivationTypeConfigList, this.m_oActivationTypeConfigBoardList);
        }
    }

    private synchronized void changeParaToActivateLst(List oActivationTypeList, IOperationPara oActivationTypeParameter) {
        ActivationType oWOSIActivationType;
        boolean isCluster = false;
        boolean isStackDevice = false;
        boolean isCSSStackDevice = false;
        boolean bLicenseValid = LicenseMonitor.getInstance().isCurrStatusValid();
        if (this.m_oTaskRef != null) {
            isCluster = this.checkIfSupportCluster(this.m_oTaskRef);
            isStackDevice = this.m_oTaskRef.isStackDevicePresent(3);
            isCSSStackDevice = this.m_oTaskRef.isStackDevicePresent(4);
        }
        List oParaValueLst = oActivationTypeParameter.getParameterValueList();
        int iSizeOfLst = oParaValueLst.size();
        ActivationType oActivationType = null;
        ParaValue oParaValue = null;
        oActivationTypeList.clear();
        for (int i = 0; i < iSizeOfLst; ++i) {
            oParaValue = (ParaValue)oParaValueLst.get(i);
            oActivationType = new ActivationType();
            oActivationType.setParaValue(oParaValue);
            if ((isCluster && bLicenseValid || isStackDevice) && (oActivationType.getParaValue().getId().equals("DelayReboot") || oActivationType.getParaValue().getId().equals("ScheduledReboot")) || isCSSStackDevice && oActivationType.getParaValue().getId().equals("ISSU")) continue;
            oActivationTypeList.add(oActivationType);
        }
        if (null == this.m_oTaskRef) {
            return;
        }
        ITaskDeviceOperation oSetWorkModeOp = TaskCommUtil.getTaskOperation(this.m_oTaskRef.getSupportedOperation(), "SetWorkMode");
        if (this.m_oTaskRef.getDeviceType().isUpgradeModeSupportedByAllDevices(256) && this.m_oTaskRef.getDeviceType().isUpgradeModeSupportedByAllDevices(128) && null != oSetWorkModeOp && oSetWorkModeOp.isSelected() && null != (oWOSIActivationType = this.getUpgradeModeBasedActivationType(oActivationTypeList, "ISSU")) && !oActivationTypeList.contains(oWOSIActivationType)) {
            oActivationTypeList.add(oWOSIActivationType);
        }
    }

    private synchronized void initBoardActivationLst(List<ActivationType> oActivationTypeLst, List<ActivationType> oActivationTypeBoardLst) {
        int iSizeOfLst = oActivationTypeLst.size();
        oActivationTypeBoardLst.clear();
        for (int i = 0; i < iSizeOfLst; ++i) {
            ActivationType oActivationType = oActivationTypeLst.get(i);
            if ("ActivationWithServiceBoards".equals(oActivationType.getParaValue().getId())) continue;
            oActivationTypeBoardLst.add(oActivationType);
        }
    }

    private ActivationType getUpgradeModeBasedActivationType(List oActivationTypeList, String strActivateType) {
        int iSizeOfLst = oActivationTypeList.size();
        ActivationType oActivationType = null;
        ActivationType oTempActivationType = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oTempActivationType = (ActivationType)oActivationTypeList.get(i);
            if (!strActivateType.equals(oTempActivationType.getParaValue().getId())) continue;
            oActivationType = oTempActivationType;
            break;
        }
        return oActivationType;
    }

    private void initActivationTime() {
        this.m_oActivateTimeParameter = this.m_oParaList.getParameter("ActivationTime");
        if (null != this.m_oActivateTimeParameter) {
            this.m_bIsActivationTimeRequired = this.m_oActivateTimeParameter.isRequired();
        }
    }

    private void initDelayReboot() {
        this.m_oDelayRebootParameter = this.m_oParaList.getParameter("DelayReboot");
        if (null != this.m_oDelayRebootParameter) {
            this.m_bIsDelayRebootRequired = this.m_oDelayRebootParameter.isRequired();
        }
    }

    private void initActivationMode() {
        this.m_oActivationModeList = this.getModeParaValueLst();
        if (this.m_oActivationModeList.size() > 0 && null == this.m_oSelectedActivationMode) {
            this.m_oSelectedActivationMode = (ParaValue)this.m_oActivationModeList.get(0);
        }
    }

    private List getModeParaValueLst() {
        ArrayList<ParaValue> oParaValueLst = new ArrayList<ParaValue>(0);
        ParaValue oParaValue = new ParaValue();
        oParaValue.setId("ParallelActivation");
        oParaValue.setDisplayName(ResourceManager.getInstance().getResString("ACTIVATION_MODE_PARALLEL"));
        oParaValueLst.add(oParaValue);
        if (null != this.m_oTaskRef && !this.m_oTaskRef.isStackDevicePresent(3) && !this.isClusterDevice(this.m_oTaskRef)) {
            ParaValue oGroupParaVal = new ParaValue();
            oGroupParaVal.setId("GroupActivation");
            oGroupParaVal.setDisplayName(ResourceManager.getInstance().getResString("ACTIVATION_MODE_GROUP"));
            oParaValueLst.add(oGroupParaVal);
        }
        return oParaValueLst;
    }

    public void addOrDeleteActivationMode(String sActivationModeID, boolean bAdd) {
        if (null == this.m_oActivationModeList && bAdd) {
            this.m_oActivationModeList = new ArrayList(0);
        }
        if (null == this.m_oActivationModeList) {
            return;
        }
        ParaValue oParaValue = null;
        for (int i = 0; i < this.m_oActivationModeList.size(); ++i) {
            oParaValue = (ParaValue)this.m_oActivationModeList.get(i);
            if (!oParaValue.getId().equals(sActivationModeID)) continue;
            if (bAdd) {
                return;
            }
            this.m_oActivationModeList.remove(i);
            return;
        }
        if (bAdd) {
            ParaValue oTmpParaValue = new ParaValue();
            oTmpParaValue.setId("VirtualOperation");
            oTmpParaValue.setDisplayName("");
            this.m_oActivationModeList.add(oTmpParaValue);
        }
    }

    public boolean isActivationTypeRequired() {
        return this.m_bIsActivationTypeRequired;
    }

    public void setActivationTypeRequired(boolean isActivationTypeRequired) {
        this.m_bIsActivationTypeRequired = isActivationTypeRequired;
    }

    public boolean isActivationTimeRequired() {
        return this.m_bIsActivationTimeRequired;
    }

    public boolean isDelayRebootRequired() {
        return this.m_bIsDelayRebootRequired;
    }

    public void setDelayRebootRequired(boolean IsDelayRebootRequired) {
        this.m_bIsDelayRebootRequired = IsDelayRebootRequired;
    }

    public void setActivationTimeRequired(boolean isActivationTimeRequired) {
        this.m_bIsActivationTimeRequired = isActivationTimeRequired;
    }

    public List getActivationModeList() {
        return this.m_oActivationModeList;
    }

    public boolean isDefaultGroupRequired() {
        return this.m_bIsDefaultGroupRequired;
    }

    public void setDefaultGroupRequired(boolean isDefaultGroupRequired) {
        this.m_bIsDefaultGroupRequired = isDefaultGroupRequired;
    }

    public Calendar getActivationUTCTime() {
        return this.m_oActivationUTCTime;
    }

    public void setActivationUTCTime(Calendar activationUTCTime) {
        this.m_oActivationUTCTime = activationUTCTime;
    }

    public List getElementInfoLst() {
        return this.m_oElementInfoLst;
    }

    public void setElementInfoLst(List elementInfoLst) {
        if (null != elementInfoLst) {
            this.m_oElementInfoLst = elementInfoLst;
        }
    }

    public List<ActivationGroupInfo> getActivateGroupInfoLst() {
        return this.m_oActivateGroupInfoLst;
    }

    public void addActivationGroupInfo(ActivationGroupInfo oGroup) {
        if (null != oGroup && !this.m_oActivateGroupInfoLst.contains(oGroup)) {
            this.m_oActivateGroupInfoLst.add(oGroup);
        }
    }

    public void setActivateGroupInfoLst(List activateGroupInfoLst) {
        this.m_oActivateGroupInfoLst = activateGroupInfoLst;
    }

    public boolean isBoardLevel() {
        return this.m_bIsBoardLevel;
    }

    public void setIsBoardLevel(boolean isBoardLevel) {
        this.m_bIsBoardLevel = isBoardLevel;
    }

    public void setoActivationType(String oActivationType) {
        this.oActivationType = oActivationType;
    }

    public String getoActivationType() {
        return this.oActivationType;
    }

    public void setActivationType(ContentType oTaskContentType, String strActivationType, int iTaskViewType) {
        if (null == oTaskContentType) {
            this.setCurrentActivationTypeLst("", strActivationType, iTaskViewType);
        } else {
            this.setCurrentActivationTypeLst(oTaskContentType.getId(), strActivationType, iTaskViewType);
        }
        this.setSelectedActivateType(this.getActivationTypePara(strActivationType));
    }

    public void setActivationMode(String activationMode) {
        this.setSelectedActivationMode(this.getActivationModePara(activationMode));
    }

    private ParaValue getActivationModePara(String strParaId) {
        ParaValue oValue = null;
        if (Collator.getInstance().equals(strParaId, "VirtualOperation")) {
            this.addOrDeleteActivationMode("VirtualOperation", true);
        }
        int iSizeOfLst = this.m_oActivationModeList.size();
        for (int i = 0; i < iSizeOfLst; ++i) {
            ParaValue oParaValue = (ParaValue)this.m_oActivationModeList.get(i);
            if (!strParaId.equals(oParaValue.getId())) continue;
            oValue = oParaValue;
            break;
        }
        return oValue;
    }

    public ActivationType getActivationTypePara(String strParaId) {
        int iSizeOfLst = this.m_oCurrentActivationTypeLst.size();
        ActivationType oActivationType = null;
        ActivationType oTempActivationType = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oTempActivationType = (ActivationType)this.m_oCurrentActivationTypeLst.get(i);
            if (!strParaId.equals(oTempActivationType.getParaValue().getId())) continue;
            oActivationType = oTempActivationType;
            break;
        }
        return oActivationType;
    }

    public boolean isTimeSelected() {
        return this.m_bIsTimeSelected;
    }

    public void setIsTimeSelected(boolean isTimeSelected) {
        this.m_bIsTimeSelected = isTimeSelected;
    }

    public boolean isTimeFieldEmpty() {
        return this.m_bIsTimeFieldEmpty;
    }

    public void setTimeFieldEmpty(boolean isTimeFieldEmpty) {
        this.m_bIsTimeFieldEmpty = isTimeFieldEmpty;
    }

    public void setScheduledActivationTime(Calendar oScheduledActivationTime) {
        this.m_oSelectedActivateType.setScheduledActivationTime(oScheduledActivationTime);
    }

    public List<ActivationElementInfo> getElementsFromGroup(int iGroupId) {
        ArrayList<ActivationElementInfo> oElementList = new ArrayList<ActivationElementInfo>(0);
        if (null == this.m_oElementInfoLst || 0 == this.m_oElementInfoLst.size()) {
            return oElementList;
        }
        int iElementCount = this.m_oElementInfoLst.size();
        ActivationElementInfo oElementInfo = null;
        for (int i = 0; i < iElementCount; ++i) {
            oElementInfo = (ActivationElementInfo)this.m_oElementInfoLst.get(i);
            if (iGroupId != oElementInfo.getGroupId()) continue;
            oElementList.add(oElementInfo);
        }
        return oElementList;
    }

    public ActivationGroupInfo getDefaultGroup() {
        if (null == this.m_oActivateGroupInfoLst || 0 == this.m_oActivateGroupInfoLst.size()) {
            ActivationGroupInfo oDefaultGrp = this.createNewGroup();
            this.m_oActivateGroupInfoLst.add(oDefaultGrp);
            return oDefaultGrp;
        }
        return this.m_oActivateGroupInfoLst.get(0);
    }

    public ActivationGroupInfo createNewGroup() {
        int iNewGroupId = 1;
        if (0 < this.m_oActivateGroupInfoLst.size()) {
            ActivationGroupInfo oLastGroup = this.m_oActivateGroupInfoLst.get(this.m_oActivateGroupInfoLst.size() - 1);
            iNewGroupId = oLastGroup.getGroupId() + 1;
        }
        String strGroupName = ResourceManager.getInstance().getResString("ACTIVATION_GROUP_NAME_KEY") + '_' + iNewGroupId;
        ActivationGroupInfo oGroup = new ActivationGroupInfo();
        oGroup.setGroupId(iNewGroupId);
        oGroup.setGroupName(strGroupName);
        return oGroup;
    }

    public ActivationGroupInfo getGroupForId(int iGroupid) {
        int iGroupCount = this.m_oActivateGroupInfoLst.size();
        for (int i = 0; i < iGroupCount; ++i) {
            ActivationGroupInfo oGroup = this.m_oActivateGroupInfoLst.get(i);
            if (oGroup.getGroupId() != iGroupid) continue;
            return oGroup;
        }
        return null;
    }

    public void deleteGroup(ActivationGroupInfo oGroup) {
        if (null == oGroup || !this.m_oActivateGroupInfoLst.contains(oGroup)) {
            return;
        }
        int iIndex = this.m_oActivateGroupInfoLst.indexOf(oGroup);
        if (0 == iIndex) {
            return;
        }
        List<ActivationElementInfo> oElements = this.getElementsFromGroup(oGroup.getGroupId());
        ActivationGroupInfo oPrevGroup = this.m_oActivateGroupInfoLst.get(iIndex - 1);
        this.setGroupIdForElements(oElements, oPrevGroup.getGroupId());
        this.m_oActivateGroupInfoLst.remove(oGroup);
    }

    public void setGroupIdForElements(List oElementList, int iGroupId) {
        if (null == oElementList) {
            return;
        }
        int iElementCount = oElementList.size();
        for (int j = 0; j < iElementCount; ++j) {
            ActivationElementInfo oElement = (ActivationElementInfo)oElementList.get(j);
            oElement.setGroupId(iGroupId);
        }
    }

    public ActivationElementInfo getElementInfoForResource(Resource oResource) {
        if (0 >= this.m_oElementInfoLst.size() || null == oResource) {
            return null;
        }
        int iElementCOunt = this.m_oElementInfoLst.size();
        ActivationElementInfo oElementInfo = null;
        for (int i = 0; i < iElementCOunt; ++i) {
            oElementInfo = (ActivationElementInfo)this.m_oElementInfoLst.get(i);
            if (!oResource.equals(oElementInfo.getResource())) continue;
            return oElementInfo;
        }
        return null;
    }

    public long getM_oDelayTime() {
        return this.m_oDelayTime;
    }

    public void setM_oDelayTime(int delayTime) {
        this.m_oDelayTime = delayTime;
    }

    public boolean isM_bIsDelayTimeSelected() {
        return this.m_bIsDelayTimeSelected;
    }

    public void setM_bIsDelayTimeSelected(boolean isDelayTimeSelected) {
        this.m_bIsDelayTimeSelected = isDelayTimeSelected;
    }

    public boolean isSelISSU() {
        return this.isSelISSU;
    }

    public void setSelISSU(boolean isSelISSU) {
        this.isSelISSU = isSelISSU;
    }

    public boolean isManualReboot() {
        return this.m_bManualReboot;
    }

    public void setManualReboot(boolean isManualReboot) {
        this.m_bManualReboot = isManualReboot;
    }

    private boolean checkIfSupportCluster(ITask m_oTask) {
        if (null == m_oTask) {
            return false;
        }
        boolean isClusterDevice = m_oTask.isClusterChildDevice() && m_oTask.getDeviceType().isUpgradeModeSupportedByAllDevices(1);
        return isClusterDevice;
    }

    private boolean isClusterDevice(ITask m_oTask) {
        if (null == m_oTask) {
            return false;
        }
        boolean isClusterDevice = m_oTask.isClusterDevice();
        return isClusterDevice;
    }

    public void setIsConfSendToBoard(boolean m_bIsConfSendToBoard) {
        this.bIsConfSendToBoard = m_bIsConfSendToBoard;
    }

    public boolean isConfSendToBoard() {
        return this.bIsConfSendToBoard;
    }
}

