/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LoadFileInfoListParam
implements IOperationConfigPara {
    private static final long serialVersionUID = 1L;
    private boolean m_bIsContentTypeRequired;
    private boolean m_bIsPacketCustomizedRequired = false;
    private boolean m_bIsDeviceTypeInfoRequired;
    private List<LoadFileInfo> m_oLoadFileInfoList;
    private boolean bAutoDelImage = false;
    private int m_packetCustomizedResult = 0;
    private IParaList m_oParaList;
    private Object[] m_oContentTypeList = new Object[0];
    private IOperationPara m_oContentTypeParameter;
    private IOperationPara m_oPacketCustomizedParameter;

    public boolean isbAutoDelImage() {
        return this.bAutoDelImage;
    }

    public void setbAutoDelImage(boolean bAutoDelImage) {
        this.bAutoDelImage = bAutoDelImage;
    }

    public int getNumberOfFiles() {
        return this.m_oLoadFileInfoList.size();
    }

    public LoadFileInfo getLoadFileInfo(int iLoadFileInfoIndex) {
        return this.m_oLoadFileInfoList.get(iLoadFileInfoIndex);
    }

    public LoadFileInfoListParam() {
        this.m_oLoadFileInfoList = new ArrayList<LoadFileInfo>(0);
    }

    public List<LoadFileInfo> getLoadFileInfoList() {
        return this.m_oLoadFileInfoList;
    }

    public void setLoadFileInfoList(List<LoadFileInfo> strServerFileList) {
        this.m_oLoadFileInfoList = strServerFileList;
    }

    public void addServerFile(LoadFileInfo oServerFile) {
        if (null != oServerFile) {
            if (-1 != oServerFile.getDeviceId()) {
                this.checkifExitsAndAdd(oServerFile);
            } else {
                this.m_oLoadFileInfoList.add(oServerFile);
            }
        }
    }

    private void checkifExitsAndAdd(LoadFileInfo oLoadFileInfo) {
        int iSizeofLst = this.m_oLoadFileInfoList.size();
        if (iSizeofLst == 0) {
            this.m_oLoadFileInfoList.add(oLoadFileInfo);
            return;
        }
        DeviceTypeInfo oDevTypeInfo = oLoadFileInfo.getDeviceTypeInfo();
        DeviceTypeInfo oTmpDevTypeInfo = null;
        LoadFileInfo oLoadFileLstInfo = null;
        boolean bIsPresent = false;
        for (int i = 0; i < iSizeofLst; ++i) {
            oLoadFileLstInfo = this.m_oLoadFileInfoList.get(i);
            oTmpDevTypeInfo = oLoadFileLstInfo.getDeviceTypeInfo();
            if (!oLoadFileLstInfo.getFileName().equals(oLoadFileInfo.getFileName()) && !oLoadFileInfo.getFileName().equals("") || oLoadFileLstInfo.getDeviceId() != oLoadFileInfo.getDeviceId() || (null != oDevTypeInfo || null != oTmpDevTypeInfo) && (null == oDevTypeInfo || null == oTmpDevTypeInfo || !oDevTypeInfo.equals(oTmpDevTypeInfo))) continue;
            bIsPresent = true;
            break;
        }
        if (!bIsPresent) {
            this.m_oLoadFileInfoList.add(oLoadFileInfo);
        }
    }

    public void addServerFiles(LoadFileInfo[] arrServerFiles) {
        if (null == arrServerFiles) {
            return;
        }
        LoadFileInfo oFile = null;
        boolean bExist = false;
        for (int i = 0; i < arrServerFiles.length; ++i) {
            oFile = arrServerFiles[i];
            if (!this.isDeviceTypeInfoRequired()) {
                bExist = this.bContainsInLst(this.m_oLoadFileInfoList, oFile);
            }
            if (bExist) continue;
            int fileNum = this.m_oLoadFileInfoList.size();
            oFile.setSequenceNo(fileNum + 1);
            this.m_oLoadFileInfoList.add(oFile);
        }
    }

    public void removeFileFromList(LoadFileInfo oFile) {
        if (null != oFile && this.m_oLoadFileInfoList.contains(oFile)) {
            this.m_oLoadFileInfoList.remove(oFile);
        }
    }

    public void clearAllFilesFromList() {
        this.m_oLoadFileInfoList.clear();
    }

    @Override
    public IParaList getParaList() {
        return this.m_oParaList;
    }

    @Override
    public void setParaList(IParaList paraList) {
        this.m_oParaList = paraList;
        this.m_oContentTypeParameter = this.m_oParaList.getParameter("ContentType");
        if (null != this.m_oContentTypeParameter) {
            this.setContentTypeRequired(this.m_oContentTypeParameter.isRequired());
            this.m_oContentTypeList = ParamUtil.getInstance().getContentTypeList(this.m_oParaList);
        }
    }

    public void setPacketCustomizedPara(IParaList paraList) {
        this.m_oParaList = paraList;
        this.m_oPacketCustomizedParameter = this.m_oParaList.getParameter("PacketCustomized");
        if (null != this.m_oPacketCustomizedParameter) {
            this.setIsPacketCustomizedRequired(this.m_oPacketCustomizedParameter.isRequired());
        }
    }

    public Object[] getContentTypeList() {
        return this.m_oContentTypeList;
    }

    public boolean isContentTypeRequired() {
        return this.m_bIsContentTypeRequired;
    }

    public void setContentTypeRequired(boolean isContentTypeRequired) {
        this.m_bIsContentTypeRequired = isContentTypeRequired;
    }

    public void addNewDeviceSelected(THashSet<Resource> oResourceList) {
        LoadFileInfo oLoadFileInfo = null;
        Resource oResource = null;
        Object oSelectedContentType = null;
        if (this.m_oContentTypeList.length > 0) {
            oSelectedContentType = this.m_oContentTypeList[0];
        }
        Iterator oResItor = oResourceList.iterator();
        int iIndex = 0;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            oLoadFileInfo = new LoadFileInfo();
            oLoadFileInfo.setDeviceId(oResource.getDeviceID());
            oLoadFileInfo.setLoadDefaultFile(true);
            oLoadFileInfo.setSequenceNo(iIndex);
            if (null != oSelectedContentType) {
                oLoadFileInfo.setContentType((ContentType)oSelectedContentType);
            }
            this.addServerFile(oLoadFileInfo);
            ++iIndex;
        }
    }

    public void upDateTable(THashSet<Resource> oResourceList) {
        Resource oResource2 = null;
        LoadFileInfo oLoadFileInfo = null;
        boolean isPresent = false;
        Iterator<LoadFileInfo> oFileItor = this.m_oLoadFileInfoList.iterator();
        while (oFileItor.hasNext()) {
            oLoadFileInfo = oFileItor.next();
            isPresent = false;
            for (Resource oResource2 : oResourceList) {
                if (oLoadFileInfo.getDeviceId() != oResource2.getDeviceID()) continue;
                isPresent = true;
                break;
            }
            if (isPresent) continue;
            oFileItor.remove();
        }
    }

    public void addPacketTool(LoadFileInfo oPacketTool) {
        if (null == oPacketTool || !DCConstants.PACKET_TOOL_CONTENT_TYPE.equals(oPacketTool.getContentType())) {
            return;
        }
        LoadFileInfo oExistingPacketTool = this.getPacketTool();
        if (null != oExistingPacketTool) {
            this.m_oLoadFileInfoList.remove(oExistingPacketTool);
        }
        this.m_oLoadFileInfoList.add(oPacketTool);
    }

    public LoadFileInfo getPacketTool() {
        if (null == this.m_oLoadFileInfoList || 0 == this.m_oLoadFileInfoList.size()) {
            return null;
        }
        int iFileSize = this.m_oLoadFileInfoList.size();
        LoadFileInfo oLoadFileInfo = null;
        for (int i = 0; i < iFileSize; ++i) {
            oLoadFileInfo = this.m_oLoadFileInfoList.get(i);
            if (null == oLoadFileInfo || !DCConstants.PACKET_TOOL_CONTENT_TYPE.equals(oLoadFileInfo.getContentType())) continue;
            return oLoadFileInfo;
        }
        return null;
    }

    public boolean isDeviceTypeInfoRequired() {
        return this.m_bIsDeviceTypeInfoRequired;
    }

    public void setDeviceTypeInfoRequired(boolean bDeviceTypeInfoRequired) {
        this.m_bIsDeviceTypeInfoRequired = bDeviceTypeInfoRequired;
    }

    public void removeFileInfoByDevID(int Devid) {
        List<LoadFileInfo> m_oLoadFileInfoList = this.getLoadFileInfoList();
        for (int i = m_oLoadFileInfoList.size() - 1; i >= 0; --i) {
            LoadFileInfo fileInfo = m_oLoadFileInfoList.get(i);
            if (fileInfo.getDeviceId() != Devid) continue;
            m_oLoadFileInfoList.remove(i);
        }
    }

    private boolean bContainsInLst(List m_oLoadFileInfoList, LoadFileInfo oFile) {
        if (null == m_oLoadFileInfoList || m_oLoadFileInfoList.size() == 0 || null == oFile) {
            return false;
        }
        Iterator itor = m_oLoadFileInfoList.iterator();
        Collator oCollator = Collator.getInstance();
        LoadFileInfo oTmpFile = null;
        DeviceTypeInfo oSourceType = null;
        DeviceInfo oSourceDeviceInfo = null;
        DeviceTypeInfo oDestType = null;
        DeviceInfo oDestDeviceInfo = null;
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        while (itor.hasNext()) {
            oTmpFile = (LoadFileInfo)itor.next();
            if (!oCollator.equals(oTmpFile.getFileName(), oFile.getFileName())) continue;
            oSourceDeviceInfo = oDevMgr.getDevice(oTmpFile.getDeviceId());
            if (null != oSourceDeviceInfo) {
                oSourceType = oSourceDeviceInfo.getDeviceTypeInfo();
            }
            if (null != (oDestDeviceInfo = oDevMgr.getDevice(oFile.getDeviceId()))) {
                oDestType = oDestDeviceInfo.getDeviceTypeInfo();
            }
            if (oDestDeviceInfo == null || oSourceType == null) {
                DCDebugTracer.trace("bContainsInLst#oTmpFile.getDeviceId()=" + oTmpFile.getDeviceId());
                DCDebugTracer.trace("bContainsInLst#oFile.getDeviceId()=" + oFile.getDeviceId());
                return false;
            }
            if (oSourceType != oDestType && !oSourceType.equals(oDestType) || oTmpFile.getDeviceId() != oFile.getDeviceId()) continue;
            return true;
        }
        return false;
    }

    public void addDeviceLevelFile(List oFileList) {
        if (null == oFileList) {
            return;
        }
        LoadFileInfo oFile = null;
        for (int i = 0; i < oFileList.size(); ++i) {
            oFile = (LoadFileInfo)oFileList.get(i);
            if (1 != oFile.getFileSelectionLevel()) continue;
            this.m_oLoadFileInfoList.add(oFile);
        }
    }

    public List getFilesFromLevel(int iFileSelectionLevel) {
        ArrayList<LoadFileInfo> oFileInfoList = new ArrayList<LoadFileInfo>(0);
        LoadFileInfo oFile = null;
        if (null != this.m_oLoadFileInfoList) {
            for (int i = 0; i < this.m_oLoadFileInfoList.size(); ++i) {
                oFile = this.m_oLoadFileInfoList.get(i);
                if (iFileSelectionLevel != oFile.getFileSelectionLevel()) continue;
                oFileInfoList.add(oFile);
            }
        }
        return oFileInfoList;
    }

    public void setIsPacketCustomizedRequired(boolean obIsPacketCustomizedRequired) {
        this.m_bIsPacketCustomizedRequired = obIsPacketCustomizedRequired;
    }

    public boolean getIsPacketCustomizedRequired() {
        return this.m_bIsPacketCustomizedRequired;
    }

    public void setPacketCustomizedResult(int oPacketCustomizedResult) {
        this.m_packetCustomizedResult = oPacketCustomizedResult;
    }

    public int getpacketCustomizedResult() {
        return this.m_packetCustomizedResult;
    }
}

