/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation;

import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import java.io.Serializable;
import java.util.Calendar;

public class LoadFileInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int m_iDeviceId = 0;
    private ContentType m_oContentType;
    private String m_strFileName;
    private int m_iSequenceNumber;
    private DeviceTypeInfo m_oDevTypeInfo;
    private boolean m_bLoadDefaultFile;
    private ISystemManager m_oSystemManager;
    private int m_iFileSelectLevel = 0;
    private Calendar m_oStartTime = null;
    private Calendar m_oEndTime = null;
    private String m_strErrMsg = ResourceManager.getInstance().getResString("TASK_STATE_NOT_RUN");

    public LoadFileInfo(int iSequenceNo, String strFileName, ContentType oContentType, DeviceTypeInfo oDevTypeInfo) {
        this.m_iSequenceNumber = iSequenceNo;
        this.m_oContentType = oContentType;
        this.m_strFileName = strFileName;
        this.m_bLoadDefaultFile = false;
        this.m_oDevTypeInfo = oDevTypeInfo;
        this.m_oSystemManager = new SystemManager();
        this.initializeSystemInfo();
    }

    public LoadFileInfo(int iSequenceNo, String strFileName, ContentType oContentType) {
        this.m_iSequenceNumber = iSequenceNo;
        this.m_oContentType = oContentType;
        this.m_strFileName = strFileName;
        this.m_bLoadDefaultFile = false;
        this.m_oSystemManager = new SystemManager();
        this.initializeSystemInfo();
    }

    public LoadFileInfo(int iSequenceNo, ContentType oContentType) {
        this.m_iSequenceNumber = iSequenceNo;
        this.m_oContentType = oContentType;
        this.m_bLoadDefaultFile = true;
        this.initializeSystemInfo();
    }

    public LoadFileInfo() {
        this.initializeSystemInfo();
    }

    protected void initializeSystemInfo() {
    }

    public ContentType getContentType() {
        return this.m_oContentType;
    }

    public void setContentType(ContentType aContentType) {
        this.m_oContentType = aContentType;
    }

    public String getFileName() {
        return this.m_strFileName;
    }

    public void setFileName(String aFileName) {
        this.m_strFileName = aFileName;
        this.setLoadDefaultFileFlag();
    }

    private void setLoadDefaultFileFlag() {
        this.m_bLoadDefaultFile = null == this.m_strFileName || "".equals(this.m_strFileName.trim());
    }

    public String toString() {
        if (null == this.m_strFileName || null == this.m_oContentType || null == this.m_oContentType.getStrContentType()) {
            return "";
        }
        return this.m_strFileName + ',' + this.m_oContentType.getStrContentType();
    }

    public int getSequenceNo() {
        return this.m_iSequenceNumber;
    }

    public void setSequenceNo(int iSequenceNo) {
        this.m_iSequenceNumber = iSequenceNo;
    }

    public boolean equals(Object oObject) {
        if (null == oObject || !(oObject instanceof LoadFileInfo)) {
            return false;
        }
        LoadFileInfo oOtherFile = (LoadFileInfo)oObject;
        if (null == oOtherFile.getFileName() || null == this.getFileName()) {
            return false;
        }
        if (1 == oOtherFile.getFileSelectionLevel() && 1 == this.getFileSelectionLevel() && oOtherFile.getDeviceId() != this.getDeviceId()) {
            return false;
        }
        return oOtherFile.getFileName().equals(this.getFileName());
    }

    public int hashCode() {
        int iHashCode = 0;
        iHashCode += Integer.valueOf(this.m_iSequenceNumber).hashCode();
        if (null != this.m_strFileName) {
            iHashCode += this.m_strFileName.hashCode();
        }
        if (null != this.m_oContentType) {
            iHashCode += this.m_oContentType.hashCode();
        }
        return iHashCode;
    }

    public String getAbsoluteFilePath() {
        StringBuffer strAbsoluteFilePath = new StringBuffer("");
        String strFileName = this.getFileName();
        if (null == strFileName) {
            return strAbsoluteFilePath.toString();
        }
        if (null != this.m_oSystemManager) {
            strAbsoluteFilePath.append(this.m_oSystemManager.getFTSInfo().getRootDirectory().replace('\\', '/'));
            strAbsoluteFilePath.append("/");
        }
        strAbsoluteFilePath.append(strFileName);
        return strAbsoluteFilePath.toString();
    }

    public boolean isLoadDefaultFile() {
        return this.m_bLoadDefaultFile;
    }

    public void setLoadDefaultFile(boolean loadDefaultFile) {
        this.m_bLoadDefaultFile = loadDefaultFile;
        if (this.m_bLoadDefaultFile) {
            this.m_strFileName = "";
        }
    }

    public int getDeviceId() {
        return this.m_iDeviceId;
    }

    public void setDeviceId(int deviceId) {
        this.m_iDeviceId = deviceId;
    }

    public DeviceTypeInfo getDeviceTypeInfo() {
        return this.m_oDevTypeInfo;
    }

    public void setDeviceTypeInfo(DeviceTypeInfo oDevTypeInfo) {
        this.m_oDevTypeInfo = oDevTypeInfo;
    }

    public int getFileSelectionLevel() {
        return this.m_iFileSelectLevel;
    }

    public void setFileSelectionLevel(int fileSelectLevel) {
        this.m_iFileSelectLevel = fileSelectLevel;
    }

    public Calendar getStartTime() {
        return this.m_oStartTime;
    }

    public String getStrStartTime() {
        return StringUtils.convertTimeToString(this.m_oStartTime);
    }

    public void setStartTime(Calendar startTime) {
        this.m_oStartTime = startTime;
    }

    public Calendar getEndTime() {
        return this.m_oEndTime;
    }

    public String getStrEndTime() {
        return StringUtils.convertTimeToString(this.m_oEndTime);
    }

    public void setEndTime(Calendar endTime) {
        this.m_oEndTime = endTime;
    }

    public String getErrMsg() {
        return this.m_strErrMsg;
    }

    public void setErrMsg(String errMsg) {
        this.m_strErrMsg = errMsg;
    }
}

