/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.deviceoperation;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.DCGUIUtil;
import com.huawei.dc.common.asndatacenter.AsnCheckUpgradeDevInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceBoardNotification;
import com.huawei.dc.common.asndatacenter.AsnDCFile;
import com.huawei.dc.common.asndatacenter.AsnDCFileLst;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfo;
import com.huawei.dc.common.asndatacenter.AsnDevSetInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfo;
import com.huawei.dc.common.asndatacenter.AsnDevUpgrModeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnGetDevUpgradeModeRsp;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.components.table.model.DCList;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.activationdatabase.ActivationDataBaseOperation;
import com.huawei.dc.devicemanagement.deviceoperation.backup.ManualDeviceBackupDlg;
import com.huawei.dc.devicemanagement.deviceoperation.recover.DCRecoverDlg;
import com.huawei.dc.devicemanagement.deviceoperation.recover.IUpdateRecoverFile;
import com.huawei.dc.devicemanagement.deviceoperation.recover.RecoverFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.save.ManualSaveOperation;
import com.huawei.dc.devicemanagement.deviceview.common.DeviceIDDataObject;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableUtil;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.RecoverInfoManager;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.standalone.IManualOperation;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.huawei.dc.standalone.controller.StandAloneSyncCtrller;
import com.huawei.dc.standalone.model.RouterDevInfoObj;
import com.huawei.dc.standalone.snmpparams.model.SnmpParaInfo;
import com.huawei.dc.taskmgmt.controller.ITaskNotificationListener;
import com.huawei.dc.taskmgmt.controller.TaskEvent;
import com.huawei.dc.taskmgmt.controller.TaskInfoNotifier;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.Task;
import com.huawei.dc.taskmgmt.view.common.TaskMenuItemHandlerHelper;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class DeviceCommonManualOpr
implements ITaskNotificationListener,
IUpdateRecoverFile {
    private IDeviceOperationManager m_oDeviceOperationMgr;
    private Object m_oSyncUpdateUpModeObj = new Object();
    private Object m_oSyncModeObject = new Object();
    private ProgressDlg m_dlg = null;
    private IManualOperation m_oManualOperation;
    private ProgressDlg m_progressDlg = null;
    private HashMap<Integer, DCList<RecoverFileInfo>> m_oFileInfoMap;
    private int iReqIdForProgressDlg = 0;

    public DeviceCommonManualOpr(IManualOperation oManualOperation) {
        this.m_oDeviceOperationMgr = DCFrameWorkUtil.getDeviceOperationManager();
        this.m_oManualOperation = oManualOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskNotification(TaskEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        Object oSource = oEvent.getSource();
        AsnGetDevUpgradeModeRsp asnGetDevUpgradeModeRsp = null;
        if (!(oSource instanceof AsnGetDevUpgradeModeRsp)) {
            return;
        }
        asnGetDevUpgradeModeRsp = (AsnGetDevUpgradeModeRsp)oSource;
        AsnDevUpgrModeInfoLst oDevUpgrModeInfoLst = asnGetDevUpgradeModeRsp.oDevUpgrModeInfoLst;
        AsnDevUpgrModeInfo asnDevUpgrModeInfo = null;
        int iUpMode = -1;
        AsnCheckUpgradeDevInfo oCheckUpgradeDevInfo = null;
        AsnDevSetInfoLst oDevSetInfoLst = null;
        AsnDevSetInfo asnDevSetInfo = null;
        int iDevID = -1;
        IDeviceInfoManager oDeviceInfoMgr = DeviceInfoManagerImpl.getInstance();
        DeviceInfo oDevInfo = null;
        for (int i = 0; i < oDevUpgrModeInfoLst.size(); ++i) {
            asnDevUpgrModeInfo = (AsnDevUpgrModeInfo)oDevUpgrModeInfoLst.get(i);
            iUpMode = asnDevUpgrModeInfo.iUpgradeMode == null ? -1 : asnDevUpgrModeInfo.iUpgradeMode.intValue();
            oCheckUpgradeDevInfo = asnDevUpgrModeInfo.oCheckUpgradeDevInfo;
            oDevSetInfoLst = oCheckUpgradeDevInfo.oDevSetInfoLst;
            for (int j = 0; j < oDevSetInfoLst.size(); ++j) {
                asnDevSetInfo = (AsnDevSetInfo)oDevSetInfoLst.get(j);
                if (null == asnDevSetInfo || null == (oDevInfo = oDeviceInfoMgr.getDevice(iDevID = asnDevSetInfo.iDevId != null ? asnDevSetInfo.iDevId.intValue() : -1))) continue;
                oDevInfo.setUpgradeMode(iUpMode);
            }
        }
        Object object = this.m_oSyncUpdateUpModeObj;
        synchronized (object) {
            this.m_oSyncUpdateUpModeObj.notifyAll();
        }
        this.updateProgressValue(0, "");
    }

    public void save(int[] iSelectedDevIds) {
        DeviceInfo[] arrDevInfo = this.getSelectedDevInfos(iSelectedDevIds);
        if (null == arrDevInfo || 0 >= arrDevInfo.length) {
            return;
        }
        DeviceInfo oDeviceInfo = arrDevInfo[0];
        IDeviceTypeConfigModel deviceTypeConfigmodel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceInfo.getDevId());
        if (null != deviceTypeConfigmodel) {
            ManualSaveOperation oManualSave = (ManualSaveOperation)deviceTypeConfigmodel.getCloneOperationObj(0, 1);
            oManualSave.setSelectedDeviceId(arrDevInfo);
            oManualSave.setDeviceOperationManager(this.m_oDeviceOperationMgr);
            oManualSave.setManualOperation(this.m_oManualOperation);
            Component oSaveOpView = oManualSave.getView(0);
            oSaveOpView.setVisible(true);
        }
    }

    public void backup(int[] iSelectedDevIds) {
        DeviceInfo[] arrDeviceInfo = this.getSelectedDevInfos(iSelectedDevIds);
        this.backup(arrDeviceInfo);
    }

    public void backup(DeviceInfo[] arrDeviceInfo) {
        if (null == arrDeviceInfo || 0 >= arrDeviceInfo.length) {
            return;
        }
        DCDebugTracer.trace("DC::do backup");
        HashMap<DeviceInfo, IOperation> oDevOperationMap = this.getManualOperationObjLst(arrDeviceInfo, 2);
        ManualDeviceBackupDlg oBackupDlg = new ManualDeviceBackupDlg(oDevOperationMap, this.m_oManualOperation);
        oBackupDlg.setVisible(true);
    }

    public void backupByBlock(DeviceInfo[] arrDeviceInfo, InternalLocalMsg oInternalmsg) {
        if (null == arrDeviceInfo || 0 >= arrDeviceInfo.length) {
            return;
        }
        HashMap<DeviceInfo, IOperation> oDevOperationMap = this.getManualOperationObjLst(arrDeviceInfo, 2);
        ManualDeviceBackupDlg oBackupDlg = new ManualDeviceBackupDlg(oDevOperationMap, this.m_oManualOperation);
        oBackupDlg.setoInternalmsg(oInternalmsg);
        DCFrameWorkUtil.getDCModuleManager();
        DCGUIUtil.setInnerModalDialogParent(oBackupDlg, 1, false);
        oBackupDlg.setVisible(true);
    }

    public void recover(int[] iSelectedDevIds) {
        DeviceInfo[] arrDevInfo = this.getSelectedDevInfos(iSelectedDevIds);
        this.recover(arrDevInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(DeviceInfo[] arrDevInfo, boolean isCAM) {
        if (null == arrDevInfo || 0 >= arrDevInfo.length) {
            return;
        }
        DCDebugTracer.trace("DC::do recover");
        try {
            this.m_oFileInfoMap = new HashMap();
            this.prepareToRecover(arrDevInfo, isCAM);
            HashMap<DeviceInfo, IOperation> oDevOperationMap = this.getManualOperationObjLst(arrDevInfo, 3);
            DCRecoverDlg oRecoverDlg = new DCRecoverDlg(oDevOperationMap, this.m_oFileInfoMap, this.m_oManualOperation, isCAM);
            oRecoverDlg.setVisible(true);
        }
        catch (DCException e) {
            if (989855908 != e.getErrorCode()) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCDebugTracer.trace(e);
            }
        }
        finally {
            if (null != this.m_oFileInfoMap) {
                this.m_oFileInfoMap.clear();
                this.m_oFileInfoMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverByBlock(DeviceInfo[] arrDevInfo, boolean isCAM, InternalLocalMsg oInternalmsg) {
        if (null == arrDevInfo || 0 >= arrDevInfo.length) {
            return;
        }
        try {
            this.m_oFileInfoMap = new HashMap();
            this.prepareToRecover(arrDevInfo, isCAM);
            HashMap<DeviceInfo, IOperation> oDevOperationMap = this.getManualOperationObjLst(arrDevInfo, 3);
            DCRecoverDlg oRecoverDlg = new DCRecoverDlg(oDevOperationMap, this.m_oFileInfoMap, this.m_oManualOperation, isCAM);
            oRecoverDlg.setoInternalmsg(oInternalmsg);
            DCFrameWorkUtil.getDCModuleManager();
            DCGUIUtil.setInnerModalDialogParent(oRecoverDlg, 1, false);
            oRecoverDlg.setVisible(true);
        }
        catch (DCException e) {
            if (989855908 != e.getErrorCode()) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCDebugTracer.trace(e);
            }
        }
        finally {
            if (null != this.m_oFileInfoMap) {
                this.m_oFileInfoMap.clear();
                this.m_oFileInfoMap = null;
            }
        }
    }

    public synchronized void getVersion(int[] iSelectedDevIds) {
        DeviceInfo[] arrDevInfo = this.getSelectedDevInfos(iSelectedDevIds);
        if (null == arrDevInfo || 0 >= arrDevInfo.length) {
            return;
        }
        int iReqId = DCFrameWorkUtil.generateRequestId();
        this.initializeProgressDialog(arrDevInfo, 43829);
        this.m_dlg.setProgressDlgId(iReqId);
        try {
            DeviceInfoManagerImpl.getInstance().getDevicesVersion(iReqId, arrDevInfo);
        }
        catch (DCException e) {
            this.m_dlg.dispose();
            DCDebugTracer.trace(e);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceCommonManualOpr.this.m_dlg.showDetailInfo();
                DeviceCommonManualOpr.this.m_dlg.setVisible(true);
            }
        });
    }

    public void setVersionProgress(AsnDCDeviceBoardNotification oAsnDCDeviceBoardNotification) {
        if (null == oAsnDCDeviceBoardNotification) {
            return;
        }
        if (!oAsnDCDeviceBoardNotification.bIsFinal) {
            int iDevId = oAsnDCDeviceBoardNotification.oVersionInfo.iDeviceId.intValue();
            int ErrorCode = oAsnDCDeviceBoardNotification.oErrorInfo.iErrorNo.intValue();
            String error = "";
            error = 0 == ErrorCode ? ResourceManager.getInstance().getResString("OPERTION_SUCCESS") : ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(ErrorCode));
            DeviceInfo deviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevId);
            String strDisplayName = "";
            if (null != deviceInfo) {
                String devName = deviceInfo.getDevName();
                String devIPAdd = deviceInfo.getDevIPAddress();
                strDisplayName = devName + '(' + devIPAdd + ')';
            } else {
                strDisplayName = ResourceManager.getInstance().getResString("TABLE_DEVICEID") + " : " + iDevId;
                error = ResourceManager.getInstance().getResString("DEVICE_DELETED");
            }
            if (null != this.m_dlg && this.m_dlg.getProgressDlgId() == oAsnDCDeviceBoardNotification.oProgressInfo.oReqID.intValue()) {
                this.m_dlg.setProgress(strDisplayName, error, oAsnDCDeviceBoardNotification.oProgressInfo.iPercentageProgress.intValue(), iDevId, new ErrorInfo(oAsnDCDeviceBoardNotification.oErrorInfo));
            }
        }
    }

    public void softwareUpgradeDowngrade(int[] iSelectedDevIds) {
        DCFrameWorkUtil.waitCursor();
        DCFrameWorkUtil.getDCModuleManager().taskManagement();
        Task oTaskObj = new Task();
        oTaskObj.setDeviceTypes(DeviceTableUtil.getDeviceTypeList(this.getSelectedResources(iSelectedDevIds)));
        oTaskObj.setDeviceTypes(DeviceTableUtil.getDeviceTypeList(this.getSelectedResourcesHs(iSelectedDevIds)));
        if (1 == oTaskObj.getDeviceTypesList().size()) {
            oTaskObj.setDeviceTypes(null);
        }
        oTaskObj.setDeviceType(DeviceTableUtil.createDeviceTypeModel(this.getSelectedResourcesHs(iSelectedDevIds)));
        oTaskObj.setTaskTypeId(0);
        TaskMenuItemHandlerHelper.createTaskDialog(oTaskObj, true);
    }

    public void patchUpdate(int[] iSelectedDevIds) {
        DCFrameWorkUtil.waitCursor();
        DCFrameWorkUtil.getDCModuleManager().taskManagement();
        Task oTaskObj = new Task();
        oTaskObj.setTaskTypeId(2);
        oTaskObj.setDeviceTypes(DeviceTableUtil.getDeviceTypeList(this.getSelectedResources(iSelectedDevIds)));
        oTaskObj.setDeviceTypes(DeviceTableUtil.getDeviceTypeList(this.getSelectedResourcesHs(iSelectedDevIds)));
        if (1 == oTaskObj.getDeviceTypesList().size()) {
            oTaskObj.setDeviceTypes(null);
        }
        oTaskObj.setDeviceType(DeviceTableUtil.createDeviceTypeModel(this.getSelectedResourcesHs(iSelectedDevIds)));
        TaskMenuItemHandlerHelper.createTaskDialog(oTaskObj, true);
    }

    public void telnetTerminal(int[] iSelectedDevIds) {
        DeviceInfo[] arrDevInfo = this.getSelectedDevInfos(iSelectedDevIds);
        if (null == arrDevInfo || 1 != arrDevInfo.length) {
            return;
        }
        DeviceInfo oDevInfo = arrDevInfo[0];
        DeviceTypeInfo oDevTypeInfo = oDevInfo.getDeviceTypeInfo();
        DeviceInfo oRowData = arrDevInfo[0];
        Resource oResource = new Resource();
        String strDevName = oRowData.getDevName();
        int iDeviceid = -1;
        if (null == strDevName) {
            strDevName = "";
        }
        oResource.setDeviceName(strDevName);
        String strDevIP = oRowData.getDevIPAddress();
        if (null == strDevIP) {
            strDevIP = "";
        }
        oResource.setDeviceIP(strDevIP);
        DeviceIDDataObject oDeviceId = new DeviceIDDataObject(oRowData.getDevId());
        if (null != oDeviceId) {
            iDeviceid = oDeviceId.getDeviceID();
        }
        oResource.setDeviceID(iDeviceid);
        List<RouterDevInfoObj> routerDevExtInfoLst = null;
        try {
            if (4 == oDevTypeInfo.getDeviceType()) {
                ArrayList<Integer> devIdLst = new ArrayList<Integer>();
                devIdLst.add(oResource.getDeviceID());
                routerDevExtInfoLst = StandAloneSyncCtrller.getInstance().getRouterDevExtInfo(devIdLst);
            } else {
                SnmpParaInfo snmpParaInfo = StandAloneSyncCtrller.getInstance().getSNMPParaForResource(oResource);
                oResource.setUserName(snmpParaInfo.getUserName());
            }
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (null != routerDevExtInfoLst && 0 < routerDevExtInfoLst.size()) {
            String puttyVersion = DCCommonUtil.getPuttyVer();
            RouterDevInfoObj devInfoObj = routerDevExtInfoLst.get(0);
            int protocolType = devInfoObj.getIProtocolType();
            String cmdStr = this.getTelnetCmdStr(oResource, puttyVersion, devInfoObj);
            if (6 == protocolType) {
                cmdStr = this.getSSHCmdStr(oResource, puttyVersion, devInfoObj);
            }
            try {
                File file = new File(puttyVersion);
                if (!file.exists()) {
                    DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_DO_NOT_EXIST", new String[]{puttyVersion}));
                    DCDebugTracer.trace(cmdStr);
                    return;
                }
                Process oTelnetProcess = Runtime.getRuntime().exec(cmdStr);
                DCFrameWorkUtil.setTelnetTerminalProcess(oTelnetProcess);
            }
            catch (IOException e) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage());
                DCDebugTracer.trace(e);
            }
        }
    }

    private String getTelnetCmdStr(Resource oResource, String puttyVersion, RouterDevInfoObj devInfoObj) {
        String deviceIp = oResource.getDeviceIP();
        String user = devInfoObj.getUserName();
        String port = devInfoObj.getPort();
        StringBuffer telnetCommand = new StringBuffer();
        telnetCommand.append(puttyVersion).append(" ").append("-telnet -P ").append(port);
        telnetCommand.append(" ").append(deviceIp);
        if (null != user && !"".equals(user)) {
            telnetCommand.append(" -l ");
            telnetCommand.append(user);
        }
        return telnetCommand.toString();
    }

    private String getSSHCmdStr(Resource oResource, String puttyVersion, RouterDevInfoObj devInfoObj) {
        String deviceIp = oResource.getDeviceIP();
        String user = devInfoObj.getUserName();
        StringBuffer telnetCommand = new StringBuffer();
        telnetCommand.append(puttyVersion).append(" ").append("-ssh");
        if (null != user && !"".equals(user)) {
            telnetCommand.append(" -l ");
            telnetCommand.append(user);
        }
        telnetCommand.append(" ").append(deviceIp);
        if (6 == devInfoObj.getIProtocolType()) {
            char[] pwd = DCEncryptServiceUtil.decrypt(devInfoObj.getPassword());
            if (null != pwd && !StringUtils.isNullOrEmptyChar(pwd)) {
                telnetCommand.append(" -pw ");
                telnetCommand.append(pwd);
            }
            StringUtils.clearCharCipher(pwd);
        }
        return telnetCommand.toString();
    }

    private DeviceInfo[] getSelectedDevInfos(int[] iSelectedDevIds) {
        DeviceInfo[] arrDevInfo = new DeviceInfo[iSelectedDevIds.length];
        DeviceInfo oDeviceInfo = null;
        for (int i = 0; i < iSelectedDevIds.length; ++i) {
            arrDevInfo[i] = oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(iSelectedDevIds[i]);
        }
        return arrDevInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshUpmode(DeviceInfo[] arrDevInfo) {
        TaskInfoNotifier.getInstance().addTaskNotificationListener(this);
        try {
            TaskSyncCommController.getInstance().updateDevUpgradeMode(arrDevInfo);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        try {
            Object e = this.m_oSyncUpdateUpModeObj;
            synchronized (e) {
                this.m_oSyncUpdateUpModeObj.wait(DCConstants.DEFAULT_WAIT_TIME);
            }
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace(e);
        }
        TaskInfoNotifier.getInstance().removeTaskNotificationListener(this);
    }

    private void initializeProgressDialog(DeviceInfo[] oDeviceInfos, int iCmdCode) {
        int iNosOfDevs = oDeviceInfos.length;
        int[] iArrdeviceIds = new int[iNosOfDevs];
        for (int i = 0; i < oDeviceInfos.length; ++i) {
            iArrdeviceIds[i] = oDeviceInfos[i].getDevId();
        }
        if (43829 == iCmdCode) {
            String[] columnNames = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("OPERATE_RESULT"), ResourceManager.getInstance().getResString("ERROR_INFO")};
            this.m_dlg = new ProgressDlg(iCmdCode, iArrdeviceIds, columnNames);
        } else {
            this.m_dlg = new ProgressDlg(iCmdCode, iArrdeviceIds);
        }
        this.m_dlg.setName("DeviceView_DeviceTablePanel_m_dlg");
        String strTitle = "";
        if (43829 == iCmdCode) {
            strTitle = ResourceManager.getInstance().getResString("VERSION_INFO_DLG_TITLE");
            DCHelpManager.getInstance().enableF1HelpKey(this.m_dlg.getContentPane(), "HELP_TOPIC_UPDATE_NE_VERSION");
            this.m_dlg.customizeTableForTelnetError();
        } else if (43974 == iCmdCode) {
            strTitle = ResourceManager.getInstance().getResString("SET_AUTO_LOAD_TITLE");
        }
        this.m_dlg.setTitle(strTitle);
        this.m_dlg.setDefaultCloseOperation(2);
    }

    public List<Resource> getSelectedResources(int[] iSelectedDevIds) {
        ArrayList<Resource> oResourcelist = new ArrayList<Resource>(0);
        int iLength = iSelectedDevIds.length;
        Resource oResource = null;
        for (int index = 0; index < iLength; ++index) {
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(iSelectedDevIds[index]);
            oResourcelist.add(oResource);
        }
        return oResourcelist;
    }

    public THashSet<Resource> getSelectedResourcesHs(int[] iSelectedDevIds) {
        THashSet oResHs = new THashSet();
        int iLength = iSelectedDevIds.length;
        Resource oResource = null;
        for (int index = 0; index < iLength; ++index) {
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(iSelectedDevIds[index]);
            oResHs.add((Object)oResource);
        }
        return oResHs;
    }

    public HashMap<DeviceInfo, IOperation> getManualOperationObjLst(DeviceInfo[] arrDevInfo, int iOperationId) {
        HashMap<DeviceInfo, IOperation> oManualOperationMap = new HashMap<DeviceInfo, IOperation>();
        HashMap<String, IOperation> oTmpDevTypeAndOperationMap = new HashMap<String, IOperation>();
        for (DeviceInfo oTmpDevInfo : arrDevInfo) {
            String strKey;
            String strDevTypeName = oTmpDevInfo.getDeviceTypeInfo().getDevTypeName();
            String strDevTypeVerName = oTmpDevInfo.getDeviceTypeInfo().getDevTypeVersionName();
            DeviceTypeInfo oDeviceTypeInfo = oTmpDevInfo.getDeviceTypeInfo();
            int[] iDeviceIdLst = new int[]{oTmpDevInfo.getDevId()};
            if (oTmpDevInfo.getDeviceTypeInfo().isDMSDomain() && DeviceInfoUtil.isSupportUpgradeMode(oTmpDevInfo, 4096) && !DeviceInfoUtil.isClusterNE(oTmpDevInfo)) {
                strDevTypeVerName = strDevTypeVerName + "_telnet";
                oDeviceTypeInfo = DCFrameWorkUtil.addPostFixTelnet(oDeviceTypeInfo);
            }
            if (!oTmpDevTypeAndOperationMap.containsKey(strKey = strDevTypeName + "_" + strDevTypeVerName)) {
                IDeviceTypeConfigModel deviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
                if (null == deviceTypeConfigModel) {
                    String msg = ResourceManager.getInstance().getResString("GET_XML_CONF_FILE_NO_FOUND");
                    String infoMsg = MessageFormat.format(msg, oTmpDevInfo.getDevName());
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), infoMsg, ResourceManager.getInstance().getResString("INFORMATION"), 1);
                    return null;
                }
                IOperation oManualOpr = deviceTypeConfigModel.getCloneOperationObj(0, iOperationId);
                oTmpDevTypeAndOperationMap.put(strKey, oManualOpr);
            }
            oDeviceTypeInfo = DCFrameWorkUtil.removePostFixTelnet(oDeviceTypeInfo);
            oManualOperationMap.put(oTmpDevInfo, (IOperation)oTmpDevTypeAndOperationMap.get(strKey));
        }
        oTmpDevTypeAndOperationMap.clear();
        return oManualOperationMap;
    }

    private DeviceInfo getDevInfo(int iDevId, DeviceInfo[] oArrDevInfo) {
        for (DeviceInfo oDevInfo : oArrDevInfo) {
            if (iDevId != oDevInfo.getDevId()) continue;
            return oDevInfo;
        }
        return null;
    }

    private void prepareToRecover(DeviceInfo[] oArrDevInfo, boolean bIsCam) throws DCException {
        final Vector<DeviceInfo> oTmpDevInfoVecForGetFile = new Vector<DeviceInfo>();
        final boolean isCam = bIsCam;
        final DeviceInfo[] oArrDevInfoTmp = oArrDevInfo;
        final Vector<DeviceInfo> oDMSDevInfoVec = new Vector<DeviceInfo>();
        for (DeviceInfo oDevInfo : oArrDevInfo) {
            if (!DCFrameWorkUtil.getIsSingleClient()) {
                if (oDevInfo.getDeviceTypeInfo().isDMSDomain()) {
                    oDMSDevInfoVec.add(oDevInfo);
                }
                oTmpDevInfoVecForGetFile.add(oDevInfo);
                continue;
            }
            if (oDevInfo.getDeviceTypeInfo().isDMSDomain()) {
                oDMSDevInfoVec.add(oDevInfo);
                continue;
            }
            oTmpDevInfoVecForGetFile.add(oDevInfo);
        }
        Vector<Integer> oAgentDevInfoVec = new Vector<Integer>();
        if (DCFrameWorkUtil.getIsSingleClient() && 2 == StandAloneDomainInfo.getInstance().getSelectedDomain()) {
            int iSize = oDMSDevInfoVec.size();
            ArrayList<Integer> devIdLst = new ArrayList<Integer>(iSize);
            for (DeviceInfo oDevInfo : oDMSDevInfoVec) {
                devIdLst.add(oDevInfo.getDevId());
            }
            List<RouterDevInfoObj> devInfoObjLst = StandAloneSyncCtrller.getInstance().getRouterDevExtInfo(devIdLst);
            for (RouterDevInfoObj oRouterDevInfo : devInfoObjLst) {
                if (null == oRouterDevInfo.getParentDevInfoObj()) {
                    DeviceInfo oDevInfo = this.getDevInfo(oRouterDevInfo.getDevID(), oArrDevInfo);
                    if (null == oDevInfo) continue;
                    oTmpDevInfoVecForGetFile.add(oDevInfo);
                    continue;
                }
                oAgentDevInfoVec.add(oRouterDevInfo.getDevID());
            }
        }
        if (0 < oDMSDevInfoVec.size() || 0 < oTmpDevInfoVecForGetFile.size()) {
            JLabel oLabel = new JLabel(ResourceManager.getInstance().getResString("GETTING_MULDEVICE_RECOVER_DLG_PROGRESSBAR_TITLE"));
            this.m_progressDlg = new ProgressDlg(43821, oLabel, 20){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void cancelButtonActionPerformed() {
                    super.cancelButtonActionPerformed();
                    Object object = DeviceCommonManualOpr.this.m_oSyncUpdateUpModeObj;
                    synchronized (object) {
                        DeviceCommonManualOpr.this.m_oSyncUpdateUpModeObj.notifyAll();
                    }
                }
            };
            this.iReqIdForProgressDlg = DCFrameWorkUtil.generateRequestId();
            this.m_progressDlg.setProgressDlgId(this.iReqIdForProgressDlg);
            this.m_progressDlg.setSize(500, 128);
            this.m_progressDlg.setTitle(ResourceManager.getInstance().getResString("MULDEVICE_RECOVER_DLG_PROGRESSBAR_TITLE"));
            this.m_progressDlg.setName("DeviceOperation_RecoverDlg_m_dlg");
            Thread oTmpThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (0 < oDMSDevInfoVec.size()) {
                        DeviceCommonManualOpr.this.refreshUpmode(oDMSDevInfoVec.toArray(new DeviceInfo[0]));
                    }
                    if (DeviceCommonManualOpr.this.m_progressDlg.isM_bCancelOpPerformed()) {
                        return;
                    }
                    DeviceInfo[] oTmpArrayDevInfo = oTmpDevInfoVecForGetFile.toArray(new DeviceInfo[0]);
                    if (0 < oTmpArrayDevInfo.length) {
                        if (isCam) {
                            AsnDCFileLst oFileList = new AsnDCFileLst();
                            for (int j = 0; j < oArrDevInfoTmp.length; ++j) {
                                DeviceCommonManualOpr.this.addFileForDev(oArrDevInfoTmp[j].getDevId(), oFileList);
                            }
                            DeviceCommonManualOpr.this.updateProgressValue(100, "");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DeviceCommonManualOpr.this.m_progressDlg.dispose();
                                }
                            });
                        } else {
                            RecoverInfoManager oRecoverMgr = RecoverInfoManager.getInstance();
                            if (0 == DeviceCommonManualOpr.this.iReqIdForProgressDlg) {
                                DeviceCommonManualOpr.this.iReqIdForProgressDlg = DCFrameWorkUtil.generateRequestId();
                                DeviceCommonManualOpr.this.m_progressDlg.setProgressDlgId(DeviceCommonManualOpr.this.iReqIdForProgressDlg);
                            }
                            oRecoverMgr.setNotifyObj(DeviceCommonManualOpr.this, DeviceCommonManualOpr.this.m_oSyncModeObject);
                            int iErrCode = oRecoverMgr.openRecoverDialog(DeviceCommonManualOpr.this.iReqIdForProgressDlg, oTmpArrayDevInfo);
                            if (0 != iErrCode) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DeviceCommonManualOpr.this.m_progressDlg.dispose();
                                    }
                                });
                            }
                        }
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DeviceCommonManualOpr.this.m_progressDlg.dispose();
                            }
                        });
                    }
                }
            });
            oTmpThread.setName("DeviceCommonManualOpr#prepareToRecover->m_progressDlg");
            oTmpThread.start();
            this.m_progressDlg.setVisible(true);
            if (this.m_progressDlg.isM_bCancelOpPerformed()) {
                throw new DCException(989855908, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(989855908L)));
            }
        }
        Iterator i$ = oAgentDevInfoVec.iterator();
        while (i$.hasNext()) {
            int iDevId = (Integer)i$.next();
            DCList<RecoverFileInfo> oRecoverFile = new DCList<RecoverFileInfo>();
            RecoverFileInfo oNonRecoverFileInfo = new RecoverFileInfo();
            oNonRecoverFileInfo.setDevid(iDevId);
            oRecoverFile.addData(oNonRecoverFileInfo);
            oRecoverFile.setCurrSelectedIndex(0);
            this.m_oFileInfoMap.put(iDevId, oRecoverFile);
        }
    }

    @Override
    public void addFileForDev(int iDevId, AsnDCFileLst oFileList) {
        DCList<RecoverFileInfo> oRecoverFile = new DCList<RecoverFileInfo>();
        RecoverFileInfo oNonRecoverFileInfo = new RecoverFileInfo();
        oNonRecoverFileInfo.setDevid(iDevId);
        oRecoverFile.addData(oNonRecoverFileInfo);
        RecoverFileInfo oBrowseInfo = new RecoverFileInfo();
        oBrowseInfo.setDevid(iDevId);
        oBrowseInfo.setFileName(ResourceManager.getInstance().getResString("RECOVER_BROWSE_BTN"));
        oRecoverFile.addData(oBrowseInfo);
        int iNoOfFiles = oFileList.size();
        for (int index = 0; index < iNoOfFiles; ++index) {
            AsnDCFile oFile = (AsnDCFile)oFileList.get(index);
            RecoverFileInfo oRecoverFileInfo = new RecoverFileInfo();
            oRecoverFileInfo.setDevid(iDevId);
            oRecoverFileInfo.setFileName(new String(oFile.strTimeOrFileName));
            if (null != oFile.strVersion) {
                oRecoverFileInfo.setBackupVerInfo(new String(oFile.strVersion));
            }
            oRecoverFile.addData(oRecoverFileInfo);
        }
        oRecoverFile.setCurrSelectedIndex(iNoOfFiles + 1);
        this.m_oFileInfoMap.put(iDevId, oRecoverFile);
    }

    @Override
    public void updateProgressValue(int iProgressValue, String strDeviceName) {
        String strOperationResult = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(0L));
        this.m_progressDlg.setProgress(strDeviceName, strOperationResult, 50 + iProgressValue / 2);
        if (iProgressValue >= 100 && !this.m_progressDlg.isM_bCancelOpPerformed()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeviceCommonManualOpr.this.m_progressDlg.setVisible(false);
                    DeviceCommonManualOpr.this.m_progressDlg.dispose();
                }
            });
        }
    }

    public void activateDataBase(int[] iSelectedDevIds) {
        DeviceInfo[] arrDeviceInfo = this.getSelectedDevInfos(iSelectedDevIds);
        DeviceInfo oDeviceInfo = arrDeviceInfo[0];
        if (null == oDeviceInfo || null == oDeviceInfo.getDeviceTypeInfo()) {
            DCDebugTracer.trace("DC::activateDataBase error ,dev or dev type is null");
            return;
        }
        int[] iDeviceIdLst = new int[]{oDeviceInfo.getDevId()};
        IDeviceTypeConfigModel deviceTypeConfigmodel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceInfo.getDeviceTypeInfo(), iDeviceIdLst);
        if (null != deviceTypeConfigmodel) {
            ActivationDataBaseOperation oActivationDataBaseOperation = (ActivationDataBaseOperation)deviceTypeConfigmodel.getCloneOperationObj(0, 20);
            oActivationDataBaseOperation.setSelectedRowDevId(arrDeviceInfo);
            oActivationDataBaseOperation.getView(0);
        }
    }

    public void rollbackdatabase() {
    }

    public void deleteDataBase() {
    }

    public void copyDatabase() {
    }
}

