/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCConnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCConnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCConnectionOperationReq;
import com.huawei.dc.common.asndatacenter.AsnDCConnectionOperationRsp;
import com.huawei.dc.common.asndatacenter.AsnDCExportDeviceReq;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheck;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheckLst;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheckReq;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheckRsp;
import com.huawei.dc.common.asndatacenter.AsnDCExtendCheckRspLst;
import com.huawei.dc.common.asndatacenter.AsnDCGetBoardsReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetConnectInfoReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetConnectInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCGetMultipleBoardsReq;
import com.huawei.dc.common.asndatacenter.AsnDCSmallFileTransfer;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnGetProgramAreaReq;
import com.huawei.dc.common.asndatacenter.AsnGetProgramAreaRsp;
import com.huawei.dc.common.components.dialog.ASynProgressDlg;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.IOStreamClose;
import com.huawei.dc.devicemanagement.connectivity.view.ConnectTestInfo;
import com.huawei.dc.devicemanagement.controller.DeviceInfoAsyncCtrller;
import com.huawei.dc.devicemanagement.controller.IDeviceInfoSyncCtrller;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.util.SyncCommand;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class DeviceInfoSyncCtrller
implements IDeviceInfoSyncCtrller,
IDCObjectDeallocator {
    private static IDeviceInfoSyncCtrller m_oInstance;
    private BaseCommManager m_oCommManager;
    private DeviceInfoAsyncCtrller asyncDevInfoController;

    private DeviceInfoSyncCtrller() {
        this.initControllers();
    }

    protected void initControllers() {
        this.m_oCommManager = DCFrameWorkUtil.getCommManager();
        this.asyncDevInfoController = new DeviceInfoAsyncCtrller();
    }

    public static synchronized IDeviceInfoSyncCtrller getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new DeviceInfoSyncCtrller();
            DCObjectDestructor.getInstance().addObjectForDestructor((DeviceInfoSyncCtrller)m_oInstance);
        }
        return m_oInstance;
    }

    @Override
    public void setToNULL() {
        this.asyncDevInfoController.setToNULL();
        this.m_oCommManager = null;
        m_oInstance = null;
    }

    @Override
    public void getMultiDevBoards(int iRequestId, List oDeviceLst) throws DCException {
        int iSizeOfLst = oDeviceLst.size();
        Integer oDeviceId = null;
        AsnDCGetMultipleBoardsReq oAsnDCGetMultipleBoardsReq = new AsnDCGetMultipleBoardsReq();
        AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        AsnDCGetBoardsReq oAsnDCGetBoardsReq = null;
        oAsnDCGetMultipleBoardsReq.oReqID = BigInteger.valueOf(iRequestId);
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnDCGetBoardsReq = new AsnDCGetBoardsReq();
            oDeviceId = (Integer)oDeviceLst.get(i);
            oAsnDCGetBoardsReq.iDevId = BigInteger.valueOf(oDeviceId.intValue());
            oAsnDCGetMultipleBoardsReq.oAsnDCGetMultipleBoardsLst.add((Object)oAsnDCGetBoardsReq);
        }
        int iErrorcode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43851), (FStruct)oAsnDCGetMultipleBoardsReq, (FStruct)oRsp);
        if (iErrorcode != 0) {
            throw new DCException(iErrorcode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorcode = oRsp.oErrorInfo.iErrorNo.intValue();
        if (iErrorcode != 0) {
            throw new DCException(iErrorcode, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
    }

    @Override
    public ArrayList<ConnectTestInfo> getConnInfoFromServer(int aDevId) throws DCException {
        AsnDCGetConnectInfoReq l_getConReq = new AsnDCGetConnectInfoReq();
        l_getConReq.iDevId = BigInteger.valueOf(aDevId);
        AsnDCGetConnectInfoRsp l_getConRsp = new AsnDCGetConnectInfoRsp();
        int l_errorCode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43997), (FStruct)l_getConReq, (FStruct)l_getConRsp);
        if (0 != l_errorCode) {
            throw new DCException(l_errorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        l_errorCode = l_getConRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != l_errorCode) {
            throw new DCException(l_errorCode, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
        AsnDCConnInfoLst l_AsnDCConnInfoList = l_getConRsp.oAsnDCConnInfoLst;
        if (null == l_AsnDCConnInfoList) {
            return null;
        }
        AsnDCConnInfo l_AsnDCConnInfo = null;
        ArrayList<ConnectTestInfo> l_testStructList = new ArrayList<ConnectTestInfo>();
        ConnectTestInfo l_conStruct = null;
        for (int i = 0; i < l_AsnDCConnInfoList.size(); ++i) {
            l_AsnDCConnInfo = (AsnDCConnInfo)l_AsnDCConnInfoList.get(i);
            l_conStruct = new ConnectTestInfo();
            l_conStruct.setCheckMode(l_AsnDCConnInfo.iCheckMode.intValue());
            l_conStruct.setCheckContent(new String(l_AsnDCConnInfo.strContent));
            l_testStructList.add(l_conStruct);
        }
        return l_testStructList;
    }

    @Override
    public boolean sendStopConnInfo(int operationType) throws DCException {
        AsnDCConnectionOperationReq l_asnOpReq = new AsnDCConnectionOperationReq();
        l_asnOpReq.iOperation = BigInteger.valueOf(operationType);
        AsnDCConnectionOperationRsp l_asnOpRsp = new AsnDCConnectionOperationRsp();
        int l_errorCode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43996), (FStruct)l_asnOpReq, (FStruct)l_asnOpRsp);
        if (0 != l_errorCode) {
            throw new DCException(l_errorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        l_errorCode = l_asnOpRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != l_errorCode) {
            throw new DCException(l_errorCode, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public AsnDCExtendCheckRspLst sendExtendCheckFileToServer(DeviceType oDeviceType, File file, String oDevTargetVersion) throws DCException {
        final AsnDCExtendCheckRsp oAsnDCExtendCheckRsp = new AsnDCExtendCheckRsp();
        final AsnDCExtendCheckReq oAsnDCExtendCheckReq = new AsnDCExtendCheckReq();
        AsnDCSmallFileTransfer oAsnDCSmallFileTransfer = new AsnDCSmallFileTransfer();
        AsnDCExtendCheckLst oAsnDCExtendCheckLst = new AsnDCExtendCheckLst();
        AsnDCExtendCheck oAsnDCExtendCheck = null;
        oAsnDCSmallFileTransfer.oSize = new BigInteger(String.valueOf(file.length()));
        oAsnDCSmallFileTransfer.oSourcePathAndFileName = file.getPath().getBytes();
        byte[] xml = new byte[]{};
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            int len = fis.available();
            xml = new byte[len];
            fis.read(xml);
        }
        catch (FileNotFoundException e) {
            DCDebugTracer.trace("sendExtendCheckFileToServer");
            DCDebugTracer.trace(e);
            IOStreamClose.close(fis);
        }
        catch (IOException e2) {
            DCDebugTracer.trace("sendExtendCheckFileToServer");
            DCDebugTracer.trace(e2);
            {
                catch (Throwable throwable) {
                    IOStreamClose.close(fis);
                    throw throwable;
                }
            }
            IOStreamClose.close(fis);
        }
        IOStreamClose.close(fis);
        oAsnDCSmallFileTransfer.oContent = xml;
        THashSet<Resource> oResourceList = oDeviceType.getResources();
        Resource oResource222222222 = null;
        for (Resource oResource222222222 : oResourceList) {
            oAsnDCExtendCheck = new AsnDCExtendCheck();
            oAsnDCExtendCheck.iDevID = new BigInteger(String.valueOf(oResource222222222.getDeviceID()));
            oAsnDCExtendCheck.oDevTypeName = oResource222222222.getDeviceType().getBytes();
            oAsnDCExtendCheck.oDevSourceVersion = oResource222222222.getDeviceVersion().getBytes();
            oAsnDCExtendCheck.oDevTargetVersion = oDevTargetVersion.getBytes();
            oAsnDCExtendCheckLst.add((Object)oAsnDCExtendCheck);
        }
        oAsnDCExtendCheckReq.oAsnDCExtendCheckLst = oAsnDCExtendCheckLst;
        oAsnDCExtendCheckReq.oAsnDCSmallFileTransfer = oAsnDCSmallFileTransfer;
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DeviceInfoSyncCtrller.this.m_oCommManager;
                DeviceInfoSyncCtrller.this.m_oCommManager;
                int i_ErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43855), (FStruct)oAsnDCExtendCheckReq, (FStruct)oAsnDCExtendCheckRsp);
                return i_ErrorCode;
            }
        };
        int i_ErrorCode = 0;
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        i_ErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (0 != i_ErrorCode) {
            throw new DCException(i_ErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        i_ErrorCode = oAsnDCExtendCheckRsp.oErrorInfo.iErrorNo.intValue();
        if (0 != i_ErrorCode) {
            throw new DCException(i_ErrorCode, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
        return oAsnDCExtendCheckRsp.oAsnDCExtendCheckRspLst;
    }

    @Override
    public AsnGetProgramAreaRsp queryDevAreaInfo(int iDevId) {
        int returnCode;
        final AsnGetProgramAreaReq oRep = new AsnGetProgramAreaReq();
        final AsnGetProgramAreaRsp oRsp = new AsnGetProgramAreaRsp();
        oRep.iDevId = BigInteger.valueOf(iDevId);
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44079), (FStruct)oRep, (FStruct)oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            oRsp.oErrorNo.iErrorNo = BigInteger.valueOf(returnCode);
        }
        return oRsp;
    }

    @Override
    public void exportDevices(AsnDCExportDeviceReq oReq) {
        DCDebugTracer.trace("DeviceInfoSyncCtrller#exportDevices start");
        AsnDCSyncRsp rsp = new AsnDCSyncRsp();
        DCFrameWorkUtil.getCommManager().addMessageListener(44099, (MSGListener)this.asyncDevInfoController);
        int errorCode = DCFrameWorkUtil.getCommManager().sendSyncMsgWithSyncCommand(44099, (FStruct)oReq, (FStruct)rsp);
        if (errorCode != 0) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(44099, (MSGListener)this.asyncDevInfoController);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(errorCode), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        if (null == rsp.oErrorInfo || null == rsp.oErrorInfo.iErrorNo || 0 == rsp.oErrorInfo.iErrorNo.intValue()) {
            this.asyncDevInfoController.setExportRequestId(rsp.oReqID.intValue());
            final String filePath = DCCommonUtil.convertByteArrayToStr(oReq.strFilePath);
            final ASynProgressDlg progressDlg = new ASynProgressDlg(rsp.oReqID.intValue(), DCFrameWorkUtil.getLocalizedString("EXPORT_DEVICE_INFO")){
                private static final long serialVersionUID = -1873274685262015291L;

                @Override
                public void oKButton_ActionPerformed() {
                    super.oKButton_ActionPerformed();
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("EXPORT_DEVICE_INFO_SUC_MSG", new String[]{filePath}), ResourceManager.getInstance().getResString("INFORMATION"), 1);
                    DCFrameWorkUtil.getCommManager().removeMessageListener(44099, (MSGListener)DeviceInfoSyncCtrller.this.asyncDevInfoController);
                }
            };
            this.asyncDevInfoController.setoProgressPaint(progressDlg);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressDlg.setVisible(true);
                }
            });
        } else {
            DCFrameWorkUtil.getCommManager().removeMessageListener(44099, (MSGListener)this.asyncDevInfoController);
            if (null != rsp.oErrorInfo && null != rsp.oErrorInfo.iErrorNo) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(rsp.oErrorInfo.iErrorNo.intValue()), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        }
        DCDebugTracer.trace("DeviceInfoSyncCtrller#exportDevices end..");
    }
}

