/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.controller;

import com.huawei.dc.common.ProgressManager;
import com.huawei.dc.common.asndatacenter.AsnDCBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCBoardList;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceBoardNotification;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceBoards;
import com.huawei.dc.common.asndatacenter.AsnDCExportDeviceRsp;
import com.huawei.dc.common.asndatacenter.AsnDCFrameInfo;
import com.huawei.dc.common.asndatacenter.AsnDCFrameList;
import com.huawei.dc.common.asndatacenter.AsnDCSubSlotInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubSlotList;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.event.ProgressDetail;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.event.DeviceInfoEvent;
import com.huawei.dc.devicemanagement.event.DeviceInfoNotifier;
import com.huawei.dc.devicemanagement.model.deviceinfo.DeviceInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.FrameInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SlotInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubslotInformation;
import com.huawei.dc.framework.ErrorCodeReader;
import com.swimap.iview.communicate.MSGPacketExt;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.commustru.fstru.FStruct;

public class DeviceInfoAsyncCtrller
extends AbstractDCMSGReceiver {
    private BaseCommManager m_oCommManager = DCFrameWorkUtil.getCommManager();
    private int exportRequestId = -1;
    private ProgressManager oProgressManager = null;

    public void setoProgressPaint(ProgressManager oProgressPaint) {
        this.oProgressManager = oProgressPaint;
    }

    public void setExportRequestId(int exportRequestId) {
        this.exportRequestId = exportRequestId;
    }

    DeviceInfoAsyncCtrller() {
        super(43851);
    }

    protected void processMessage(MSGPacketExt oPacketExt) {
        try {
            DCDebugTracer.trace("receive asyn msg cmdCode=" + oPacketExt.mheader.cmdCode);
            switch (oPacketExt.mheader.cmdCode) {
                case 43851: {
                    this.handleGetBoardRsp(oPacketExt);
                    break;
                }
                case 44099: {
                    this.handleExportDeviceRsp(oPacketExt);
                    break;
                }
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void handleExportDeviceRsp(MSGPacketExt oPacketExt) {
        AsnDCExportDeviceRsp oAsnDCExportDeviceRsp = new AsnDCExportDeviceRsp();
        int iErrorCode = this.m_oCommManager.decodeAsn1Data((FStruct)oAsnDCExportDeviceRsp, oPacketExt.getData());
        if (0 != iErrorCode) {
            this.oProgressManager.end();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), BigInteger.valueOf(iErrorCode), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        if (oAsnDCExportDeviceRsp.oReqID.intValue() != this.exportRequestId) {
            DCDebugTracer.trace("reuqestID is not the same :  " + this.exportRequestId);
            return;
        }
        if (null != oAsnDCExportDeviceRsp.oErrorInfo && null != oAsnDCExportDeviceRsp.oErrorInfo.iErrorNo && 0 != oAsnDCExportDeviceRsp.oErrorInfo.iErrorNo.intValue()) {
            this.oProgressManager.end();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ErrorCodeReader.getInstance().getErrorDesc(oAsnDCExportDeviceRsp.oErrorInfo.iErrorNo), ResourceManager.getInstance().getResString("ERROR"), 0);
        }
        if (oAsnDCExportDeviceRsp.iProgress.intValue() <= 100) {
            DCDebugTracer.trace("ExportDevice iProgress:" + oAsnDCExportDeviceRsp.iProgress);
            this.oProgressManager.updateProgress(oAsnDCExportDeviceRsp.iProgress.intValue());
        }
    }

    private synchronized void handleGetBoardRsp(MSGPacketExt oPacketExt) {
        AsnDCDeviceBoardNotification oAsnDCDevBoardNotification = new AsnDCDeviceBoardNotification();
        int iErrorCode = this.m_oCommManager.decodeAsn1Data((FStruct)oAsnDCDevBoardNotification, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        ProgressDetail oProgress = new ProgressDetail();
        oProgress.setRequestId(oAsnDCDevBoardNotification.oProgressInfo.oReqID.intValue());
        oProgress.setFinal(oAsnDCDevBoardNotification.bIsFinal);
        oProgress.setProgress(oAsnDCDevBoardNotification.oProgressInfo.iPercentageProgress.intValue());
        DeviceInformation oDevInfo = this.populateDeviceInfoStructure(oAsnDCDevBoardNotification);
        if (null != oDevInfo) {
            oProgress.setProgressObject(oDevInfo);
            HashMap<Integer, BigInteger> oMap = new HashMap<Integer, BigInteger>(1);
            oMap.put(oDevInfo.getDeviceId(), oAsnDCDevBoardNotification.oErrorInfo.iErrorNo);
            oProgress.setErrorCodeMap(oMap);
        }
        if (0 == iErrorCode) {
            DeviceInfoEvent oEvent = new DeviceInfoEvent(oProgress, 3);
            DeviceInfoNotifier.getInstance().notifyEvent(oEvent);
        }
    }

    private DeviceInformation populateDeviceInfoStructure(AsnDCDeviceBoardNotification oAsnDCDevBoardNotification) {
        AsnDCDeviceBoards oAsnDCDeviceBoards = oAsnDCDevBoardNotification.oBoardsInfo;
        if (null == oAsnDCDeviceBoards) {
            return null;
        }
        DeviceInformation oDevInformation = new DeviceInformation();
        oDevInformation.setDeviceId(oAsnDCDeviceBoards.iDevId.intValue());
        List oFrameList = this.getFrameList(oDevInformation, oAsnDCDeviceBoards.oFrameList);
        oDevInformation.setFrameList(oFrameList);
        return oDevInformation;
    }

    private List getFrameList(DeviceInformation oDevInformation, AsnDCFrameList oAsnFrameList) {
        ArrayList<FrameInformation> oFrameList = new ArrayList<FrameInformation>(0);
        int iSizeOfList = oAsnFrameList.size();
        AsnDCFrameInfo oAsnFrameInfo = null;
        FrameInformation oFrameInfo = null;
        String strFrameName = null;
        List oBoardList = null;
        for (int i = 0; i < iSizeOfList; ++i) {
            oFrameInfo = new FrameInformation(oDevInformation);
            oAsnFrameInfo = (AsnDCFrameInfo)oAsnFrameList.get(i);
            oFrameInfo.setFrameId(oAsnFrameInfo.iFrameId.intValue());
            oFrameInfo.setFrameType(oAsnFrameInfo.iFrameType.intValue());
            if (null != oAsnFrameInfo.strFrameLabel) {
                strFrameName = new String(oAsnFrameInfo.strFrameLabel);
                oFrameInfo.setFrameName(strFrameName);
            }
            oBoardList = this.getBoardInfoLst(oFrameInfo, oAsnFrameInfo.oBoardList);
            oFrameInfo.setBoardInformationList(oBoardList);
            oFrameList.add(oFrameInfo);
        }
        return oFrameList;
    }

    private List getBoardInfoLst(FrameInformation oFrameInfo, AsnDCBoardList oAsnBoardList) {
        ArrayList<SlotInformation> oBoardInformationLst = new ArrayList<SlotInformation>(0);
        int iSizeOfLst = oAsnBoardList.size();
        AsnDCBoardInfo oAsnDCBoardInfo = null;
        SlotInformation oBoardInformation = null;
        String strBoardName = null;
        String strBoardVersion = null;
        List oSlotInformationLst = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnDCBoardInfo = (AsnDCBoardInfo)oAsnBoardList.get(i);
            oBoardInformation = new SlotInformation(oFrameInfo);
            oBoardInformation.setBoardId(oAsnDCBoardInfo.iSlotId.intValue());
            oBoardInformation.setBoardType(oAsnDCBoardInfo.iBoardType.intValue());
            if (null != oAsnDCBoardInfo.strBoardVersion) {
                strBoardVersion = new String(oAsnDCBoardInfo.strBoardVersion);
                oBoardInformation.setBoardVersion(strBoardVersion);
            }
            if (null != oAsnDCBoardInfo.strSlotLabel) {
                strBoardName = new String(oAsnDCBoardInfo.strSlotLabel);
                oBoardInformation.setBoardName(strBoardName);
            }
            if (null != oAsnDCBoardInfo.oSlotList) {
                oSlotInformationLst = this.getSlotInformation(oBoardInformation, oAsnDCBoardInfo.oSlotList);
                oBoardInformation.setSubslotList(oSlotInformationLst);
            }
            oBoardInformationLst.add(oBoardInformation);
        }
        return oBoardInformationLst;
    }

    private List getSlotInformation(SlotInformation oBoardInformation, AsnDCSubSlotList oAsnSlotList) {
        ArrayList<SubslotInformation> oSlotInfoLst = new ArrayList<SubslotInformation>(0);
        int iSizeOfLst = oSlotInfoLst.size();
        AsnDCSubSlotInfo oAsnDCSubSlotInfo = null;
        SubslotInformation oSlotInformation = null;
        String strSlotName = null;
        String strSlotVersion = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnDCSubSlotInfo = (AsnDCSubSlotInfo)oSlotInfoLst.get(i);
            oSlotInformation = new SubslotInformation(oBoardInformation);
            oSlotInformation.setSlotId(oAsnDCSubSlotInfo.iSubSlotId.intValue());
            oSlotInformation.setSlotType(oAsnDCSubSlotInfo.iSubSlotType.intValue());
            if (null != oAsnDCSubSlotInfo.strSubSlotLabel) {
                strSlotName = new String(oAsnDCSubSlotInfo.strSubSlotLabel);
                oSlotInformation.setSlotName(strSlotName);
            }
            if (null != oAsnDCSubSlotInfo.strBoardVersion) {
                strSlotVersion = new String(oAsnDCSubSlotInfo.strBoardVersion);
                oSlotInformation.setSlotVersion(strSlotVersion);
            }
            oSlotInfoLst.add(oSlotInformation);
        }
        return oSlotInfoLst;
    }

    @Override
    public void timeout(int arg0, Character arg1) {
    }

    public void setToNULL() {
        this.closeReceiver();
        this.m_oCommManager = null;
    }
}

