/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.OperationIdStore;
import com.huawei.dc.common.asndatacenter.AsnCheckOperationDef;
import com.huawei.dc.common.asndatacenter.AsnCheckOperationLst;
import com.huawei.dc.common.asndatacenter.AsnCustomOperationDef;
import com.huawei.dc.common.asndatacenter.AsnCustomOperationList;
import com.huawei.dc.common.asndatacenter.AsnDCNodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDevOperationLst;
import com.huawei.dc.common.asndatacenter.AsnDevTypeInfo;
import com.huawei.dc.common.asndatacenter.AsnDevTypeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDevTypeVerXMLInfo;
import com.huawei.dc.common.asndatacenter.AsnDevTypeVerXMLInfoList;
import com.huawei.dc.common.asndatacenter.AsnDevTypeVerXMLListRsp;
import com.huawei.dc.common.asndatacenter.AsnDevViewMenuDefList;
import com.huawei.dc.common.asndatacenter.AsnMenuOpDef;
import com.huawei.dc.common.asndatacenter.AsnMenuOpLst;
import com.huawei.dc.common.asndatacenter.AsnOperParamDef;
import com.huawei.dc.common.asndatacenter.AsnOperParamDefLst;
import com.huawei.dc.common.asndatacenter.AsnOperation;
import com.huawei.dc.common.asndatacenter.AsnOperationConfig;
import com.huawei.dc.common.asndatacenter.AsnOptionInfo;
import com.huawei.dc.common.asndatacenter.AsnOptionInfoLst;
import com.huawei.dc.common.asndatacenter.AsnOtherOperationDef;
import com.huawei.dc.common.asndatacenter.AsnOtherOperationLst;
import com.huawei.dc.common.asndatacenter.AsnPatchDef;
import com.huawei.dc.common.asndatacenter.AsnPatchItem;
import com.huawei.dc.common.asndatacenter.AsnPatchItemLst;
import com.huawei.dc.common.asndatacenter.AsnPatchOperationLst;
import com.huawei.dc.common.asndatacenter.AsnPatchStateConfigLst;
import com.huawei.dc.common.asndatacenter.AsnPatchStateDef;
import com.huawei.dc.common.asndatacenter.AsnPatchStateLst;
import com.huawei.dc.common.asndatacenter.AsnPatchTypeMenuDef;
import com.huawei.dc.common.asndatacenter.AsnPatchViewMenuOpList;
import com.huawei.dc.common.asndatacenter.AsnTaskConfigInfoLst;
import com.huawei.dc.common.asndatacenter.AsnTaskConfigInfoOperation;
import com.huawei.dc.common.asndatacenter.AsnTaskConfigOperation;
import com.huawei.dc.common.asndatacenter.AsnTaskConfigOperationLst;
import com.huawei.dc.common.asndatacenter.AsnTaskOperationDef;
import com.huawei.dc.common.asndatacenter.AsnTaskOperationList;
import com.huawei.dc.common.asndatacenter.AsnTaskOperationLst;
import com.huawei.dc.common.asndatacenter.AsnUpgradeOperationDef;
import com.huawei.dc.common.asndatacenter.AsnUpgradeOperationLst;
import com.huawei.dc.common.asndatacenter.AsnUpgradeSubOperationDef;
import com.huawei.dc.common.asndatacenter.AsnUpgradeSubOperationLst;
import com.huawei.dc.common.asndatacenter.AsnViewConfig;
import com.huawei.dc.common.configtree.ConfigTreeNodeInfo;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.DeviceOpViewFactory;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ICheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationPara;
import com.huawei.dc.devicemanagement.deviceoperation.IOtherOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.deviceoperation.IPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ParaList;
import com.huawei.dc.devicemanagement.deviceoperation.ParaValue;
import com.huawei.dc.devicemanagement.deviceoperation.Parameter;
import com.huawei.dc.devicemanagement.deviceoperation.checkoperation.CheckOperationConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.CustomOperationInfo;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.UpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTablePanel;
import com.huawei.dc.devicemanagement.model.GUITempleteInfo;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IOperationConfig;
import com.huawei.dc.devicemanagement.model.xmlconfig.IPatchConfig;
import com.huawei.dc.devicemanagement.model.xmlconfig.IViewConfiguration;
import com.huawei.dc.devicemanagement.model.xmlconfig.MenuConfig;
import com.huawei.dc.devicemanagement.model.xmlconfig.OperationConfig;
import com.huawei.dc.devicemanagement.model.xmlconfig.PatchConfig;
import com.huawei.dc.devicemanagement.model.xmlconfig.TaskTypeConfiguration;
import com.huawei.dc.devicemanagement.model.xmlconfig.ViewConfiguration;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;

public class DeviceConfigModelCtrller
extends AbstractDCMSGReceiver
implements IDCObjectDeallocator {
    private BaseCommManager m_oCommManager = DCFrameWorkUtil.getCommManager();
    private static DeviceConfigModelCtrller m_oDevConfigModelCtrller = null;
    private boolean m_bIsLast = false;
    private int m_iAddingDeviceID = -1;

    private DeviceConfigModelCtrller() {
        super(43875);
    }

    public static synchronized DeviceConfigModelCtrller getInstance() {
        if (null == m_oDevConfigModelCtrller) {
            m_oDevConfigModelCtrller = new DeviceConfigModelCtrller();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oDevConfigModelCtrller);
        }
        return m_oDevConfigModelCtrller;
    }

    @Override
    public void setToNULL() {
        if (null != m_oDevConfigModelCtrller) {
            this.m_bIsLast = true;
            this.closeReceiver();
            this.m_oCommManager = null;
            m_oDevConfigModelCtrller = null;
        }
    }

    protected void processMessage(MSGPacketExt oMsgPacket) {
        try {
            DCDebugTracer.trace("receive asyn msg cmdCode=" + oMsgPacket.mheader.cmdCode);
            this.processAsynMessage(oMsgPacket);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    protected void processAsynMessage(MSGPacketExt oMsgPacket) {
        try {
            if (null == DCFrameWorkUtil.getCommManager()) {
                DCDebugTracer.trace("[DEVCFG] commMgr is null");
                return;
            }
            DCDebugTracer.trace("[DEVCFG] receive asyn msg cmdCode= " + oMsgPacket.mheader.cmdCode);
            if (43875 == oMsgPacket.mheader.cmdCode) {
                AsnDevTypeVerXMLListRsp oAsnDevTypeVerXMLListRsp = new AsnDevTypeVerXMLListRsp();
                int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDevTypeVerXMLListRsp, oMsgPacket.getData());
                if (0 == iErrorcode) {
                    DeviceTypeXmlParserThread oDeviceTypeXmlParserThread = new DeviceTypeXmlParserThread(oAsnDevTypeVerXMLListRsp);
                    new Thread(oDeviceTypeXmlParserThread).start();
                }
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public void updateDeviceXmlDataModel(AsnDevTypeVerXMLInfo oAsnDevTypeVerXmlInfo) {
        DeviceTypeConfigModel oDevTypeConfigModel = new DeviceTypeConfigModel();
        String m_strDevTypeName = new String(oAsnDevTypeVerXmlInfo.oAsnDevTypeInfo.strDevTypeName);
        String m_strDevTypeVerName = new String(oAsnDevTypeVerXmlInfo.oAsnDevTypeInfo.strDevTypeVersionName);
        oDevTypeConfigModel.setDeviceType(m_strDevTypeName);
        oDevTypeConfigModel.setDeviceTypeVersion(m_strDevTypeVerName);
        this.updateOpConfigInfo(oDevTypeConfigModel, oAsnDevTypeVerXmlInfo.oAsnOperationConfig);
        this.updateTaskConfigInfo(oDevTypeConfigModel, oAsnDevTypeVerXmlInfo.oAsnTaskConfigInfoLst);
        this.updateViewConfigInfo(oDevTypeConfigModel, oAsnDevTypeVerXmlInfo.oAsnViewConfig);
        this.updatePatchConfigInfo(oDevTypeConfigModel, oAsnDevTypeVerXmlInfo.oAsnOperationConfig.oAsnPatchStateConfigLst);
        DeviceXMLConfigModel.getInstance().addDeviceTypeConfigModel(oAsnDevTypeVerXmlInfo, oDevTypeConfigModel);
    }

    private void updatePatchConfigInfo(IDeviceTypeConfigModel oDevTypeConfigModel, AsnPatchStateConfigLst oAsnPatchStateConfigLst) {
        int iSizeOfLst = oAsnPatchStateConfigLst.size();
        AsnPatchDef oAsnPatchDef = null;
        PatchConfig oPatchConfig = new PatchConfig();
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnPatchDef = (AsnPatchDef)oAsnPatchStateConfigLst.get(i);
            if (0 == oAsnPatchDef.enPatchType.value) {
                this.updateHotPatchConfig(oDevTypeConfigModel, oPatchConfig, oAsnPatchDef.stPatchStateLst);
                continue;
            }
            this.updateColdPatchConfig(oDevTypeConfigModel, oPatchConfig, oAsnPatchDef.stPatchStateLst);
        }
        oDevTypeConfigModel.setPatchConfiguration(oPatchConfig);
    }

    private void updateColdPatchConfig(IDeviceTypeConfigModel oDevTypeConfigModel, IPatchConfig oPatchConfigInfo, AsnPatchStateLst oAsnStPatchStateLst) {
        int iSizeofPatchStateLst = oAsnStPatchStateLst.size();
        String strPatchStateId = null;
        AsnPatchStateDef oAsnPatchStateDef = null;
        int iPatchStateOpId = -1;
        ArrayList oPatchSuppLst = null;
        for (int i = 0; i < iSizeofPatchStateLst; ++i) {
            oPatchSuppLst = new ArrayList(4);
            oAsnPatchStateDef = (AsnPatchStateDef)oAsnStPatchStateLst.get(i);
            strPatchStateId = new String(oAsnPatchStateDef.strPatchStateId);
            iPatchStateOpId = OperationIdStore.getInstance().getOperationId(strPatchStateId);
            this.getSuppPatchOpLst(oDevTypeConfigModel, oPatchSuppLst, oAsnPatchStateDef.stPatchItemLst);
            oPatchConfigInfo.addPatch(2, iPatchStateOpId, oPatchSuppLst);
        }
    }

    private void updateHotPatchConfig(IDeviceTypeConfigModel oDevTypeConfigModel, IPatchConfig oPatchConfigInfo, AsnPatchStateLst oAsnPatchStateLst) {
        int iSizeofPatchStateLst = oAsnPatchStateLst.size();
        String strPatchStateId = null;
        AsnPatchStateDef oAsnPatchStateDef = null;
        int iPatchStateOpId = -1;
        ArrayList oPatchSuppLst = null;
        for (int i = 0; i < iSizeofPatchStateLst; ++i) {
            oPatchSuppLst = new ArrayList(4);
            oAsnPatchStateDef = (AsnPatchStateDef)oAsnPatchStateLst.get(i);
            strPatchStateId = new String(oAsnPatchStateDef.strPatchStateId);
            iPatchStateOpId = OperationIdStore.getInstance().getOperationId(strPatchStateId);
            this.getSuppPatchOpLst(oDevTypeConfigModel, oPatchSuppLst, oAsnPatchStateDef.stPatchItemLst);
            oPatchConfigInfo.addPatch(0, iPatchStateOpId, oPatchSuppLst);
        }
    }

    private void getSuppPatchOpLst(IDeviceTypeConfigModel oDevTypeConfigModel, List oPatchSuppLst, AsnPatchItemLst oAsnStPatchItemLst) {
        int iSizeOfLst = oAsnStPatchItemLst.size();
        AsnPatchItem oAsnPatchItem = null;
        String strOperationId = null;
        int iOperationid = -1;
        int iOperationType = -1;
        IPatchOperation oPatchOperation = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnPatchItem = (AsnPatchItem)oAsnStPatchItemLst.get(i);
            strOperationId = new String(oAsnPatchItem.strOperationId);
            iOperationid = OperationIdStore.getInstance().getOperationId(strOperationId);
            iOperationType = this.getOperationType(oAsnPatchItem.enOpertypeRef.value);
            oPatchOperation = (IPatchOperation)oDevTypeConfigModel.getCloneOperationObj(iOperationType, iOperationid);
            oPatchSuppLst.add(oPatchOperation);
        }
    }

    private void updateOpConfigInfo(IDeviceTypeConfigModel oDevTypeConfigModel, AsnOperationConfig oAsnOperationConfig) {
        OperationConfig oOperationConfig = new OperationConfig();
        DeviceTypeInfo oDevTypeInfo = this.getDevTypeByName(oDevTypeConfigModel.getDeviceType(), oDevTypeConfigModel.getDeviceTypeVersion());
        this.updateDevOPLst(oDevTypeInfo, oOperationConfig, oAsnOperationConfig.oAsnDevOperationLst);
        this.updateTaskOpLst(oDevTypeInfo, oOperationConfig, oAsnOperationConfig.oAsnTaskOperationLst);
        this.updateCheckOpLst(oDevTypeInfo, oOperationConfig, oAsnOperationConfig.oAsnCheckOperationLst);
        this.updateOtherOpLst(oDevTypeInfo, oOperationConfig, oAsnOperationConfig.oAsnOtherOperationLst);
        this.updatePatchOpLst(oDevTypeInfo, oOperationConfig, oAsnOperationConfig.oAsnPatchOperationLst);
        this.updateCustomOpLst(oDevTypeInfo, oOperationConfig, oAsnOperationConfig.oAsnCustomOperationList);
        this.updateUpgradeOpLst(oDevTypeInfo, oOperationConfig, oAsnOperationConfig.oAsnUpgradeOperationLst);
        oDevTypeConfigModel.setOperationConfiguration(oOperationConfig);
    }

    private void updateCustomOpLst(DeviceTypeInfo oDevTypeInfo, IOperationConfig oOperationConfig, AsnCustomOperationList oAsnCustomOperationList) {
        int iSizeOFLst = oAsnCustomOperationList.size();
        String strOperationId = null;
        String strOpName = null;
        AsnCustomOperationDef oAsnCustomOperationDef = null;
        CustomOperationInfo oCustomOperationInfo = null;
        for (int i = 0; i < iSizeOFLst; ++i) {
            oAsnCustomOperationDef = (AsnCustomOperationDef)oAsnCustomOperationList.get(i);
            strOperationId = new String(oAsnCustomOperationDef.strCustomOpId);
            int iOperationId = OperationIdStore.getInstance().getOperationId(strOperationId);
            oCustomOperationInfo = (CustomOperationInfo)DeviceOpViewFactory.createOperationObj(4, iOperationId);
            if (null == oCustomOperationInfo) continue;
            oCustomOperationInfo.setOperationIdString(strOperationId);
            oCustomOperationInfo.setOperationId(iOperationId);
            oCustomOperationInfo.setShortCutKey(new String(oAsnCustomOperationDef.strShortcutKey));
            oCustomOperationInfo.setWhereToShow(this.getAvailableInValue(oAsnCustomOperationDef.enAvailableIn.value));
            oCustomOperationInfo.setOperationLevel(this.getOperationLevel(oAsnCustomOperationDef.enOperLevel.value));
            strOpName = ResourceManager.getInstance().getResString(oDevTypeInfo, strOperationId);
            oCustomOperationInfo.setResourceClass(new String(oAsnCustomOperationDef.strResouceClassName));
            oCustomOperationInfo.setOperationName(strOpName);
            oOperationConfig.addCustomOperation(oCustomOperationInfo);
        }
    }

    private int getAvailableInValue(int value) {
        int iWhere2Show = -1;
        switch (value) {
            case 0: {
                iWhere2Show = 0;
                break;
            }
            case 1: {
                iWhere2Show = 1;
                break;
            }
        }
        return iWhere2Show;
    }

    private void updatePatchOpLst(DeviceTypeInfo oDevTypeInfo, IOperationConfig oOperationConfig, AsnPatchOperationLst oAsnPatchOperationLst) {
        int iSizeOFLst = oAsnPatchOperationLst.size();
        IPatchOperation oPatchOPeration = null;
        AsnOperation oAsnOperation = null;
        String strOperationId = null;
        String strOpName = null;
        IParaList oParaList = null;
        for (int i = 0; i < iSizeOFLst; ++i) {
            oAsnOperation = (AsnOperation)oAsnPatchOperationLst.get(i);
            strOperationId = new String(oAsnOperation.strOperId);
            int iOperationId = OperationIdStore.getInstance().getOperationId(strOperationId);
            oPatchOPeration = (IPatchOperation)DeviceOpViewFactory.createOperationObj(2, iOperationId);
            if (null == oPatchOPeration) continue;
            oPatchOPeration.setOperationId(iOperationId);
            oPatchOPeration.setOperationIdString(strOperationId);
            oPatchOPeration.setOperationLevel(this.getOperationLevel(oAsnOperation.enOperLevel.value));
            strOpName = ResourceManager.getInstance().getResString(oDevTypeInfo, strOperationId);
            oPatchOPeration.setOperationName(strOpName);
            oParaList = this.getParameterFrmAsn(oDevTypeInfo, oAsnOperation.stOperParaLst);
            oPatchOPeration.setOPerationParaList(oParaList);
            oOperationConfig.addPatchOperation(oPatchOPeration);
        }
    }

    private void updateCheckOpLst(DeviceTypeInfo oDevTypeInfo, IOperationConfig operationConfig, AsnCheckOperationLst oAsnCheckOperationLst) {
        int iSize = oAsnCheckOperationLst.size();
        AsnCheckOperationDef oAsnCheckOperationDef = null;
        String strDisplayName = null;
        ICheckOperation oCheckOperation = null;
        String strTaskOperationId = null;
        for (int i = 0; i < iSize; ++i) {
            oAsnCheckOperationDef = (AsnCheckOperationDef)oAsnCheckOperationLst.get(i);
            strTaskOperationId = new String(oAsnCheckOperationDef.strOperId);
            int iOperationId = OperationIdStore.getInstance().getOperationId(strTaskOperationId);
            oCheckOperation = (ICheckOperation)DeviceOpViewFactory.getCheckOperation(iOperationId);
            if (null == oCheckOperation) continue;
            strDisplayName = ResourceManager.getInstance().getResString(oDevTypeInfo, strTaskOperationId);
            oCheckOperation.setOperationName(strDisplayName);
            oCheckOperation.setOperationId(iOperationId);
            oCheckOperation.setOperationIdString(strTaskOperationId);
            oCheckOperation.setOperationLevel(oAsnCheckOperationDef.enOperLevel.value);
            oCheckOperation.setCheckTaskType(oAsnCheckOperationDef.enTaskType.value);
            this.updateCheckOpCheckTypes(oCheckOperation, oAsnCheckOperationDef.oAsnDCNodeInfo);
            operationConfig.addCheckOperation(oCheckOperation);
        }
    }

    private void updateCheckOpCheckTypes(ICheckOperation oTaskCheckOperation, AsnDCNodeInfo oAsnDCNodeInfo) {
        ConfigTreeNodeInfo l_treeInfo = TaskCommUtil.getTreeNodeInfoFromAsn(oAsnDCNodeInfo);
        TaskCommUtil.setNodeSelectedState(l_treeInfo);
        CheckOperationConfigParam oCheckOperationConfigParam = new CheckOperationConfigParam();
        oCheckOperationConfigParam.setConfigTreeNode(l_treeInfo);
        oTaskCheckOperation.setCheckOperationConfig(oCheckOperationConfigParam);
    }

    private void updateUpgradeOpLst(DeviceTypeInfo oDevTypeInfo, IOperationConfig operationConfig, AsnUpgradeOperationLst oAsnUpgradeOperationLst) {
        int iSize = oAsnUpgradeOperationLst.size();
        AsnUpgradeOperationDef oAsnUpgradeOperationDef = null;
        String strDisplayName = null;
        ITaskDeviceOperation oTaskDeviceOperation = null;
        String strTaskOperationId = null;
        for (int i = 0; i < iSize; ++i) {
            oAsnUpgradeOperationDef = (AsnUpgradeOperationDef)oAsnUpgradeOperationLst.get(i);
            strTaskOperationId = new String(oAsnUpgradeOperationDef.strOperId);
            int iOperationId = OperationIdStore.getInstance().getOperationId(strTaskOperationId);
            oTaskDeviceOperation = (ITaskDeviceOperation)DeviceOpViewFactory.createOperationObj(6, iOperationId);
            if (null == oTaskDeviceOperation) continue;
            strDisplayName = ResourceManager.getInstance().getResString(oDevTypeInfo, strTaskOperationId);
            oTaskDeviceOperation.setOperationName(strDisplayName);
            oTaskDeviceOperation.setOperationId(iOperationId);
            oTaskDeviceOperation.setOperationIdString(strTaskOperationId);
            oTaskDeviceOperation.setOperationLevel(oAsnUpgradeOperationDef.enOperLevel.value);
            this.updateUpgradeOpSubOperation(oDevTypeInfo, (IUpgradeOperation)oTaskDeviceOperation, oAsnUpgradeOperationDef.stSubOprList);
            operationConfig.addUpgradeOperation((IUpgradeOperation)oTaskDeviceOperation);
        }
    }

    private void updateUpgradeOpSubOperation(DeviceTypeInfo oDevTypeInfo, IUpgradeOperation oUpgradeOperation, AsnUpgradeSubOperationLst oAsnUpgradeSubOperationLst) {
        int iSize = oAsnUpgradeSubOperationLst.size();
        ArrayList<IUpgradeSubOperation> oUpgradeSubOperationList = new ArrayList<IUpgradeSubOperation>(0);
        UpgradeSubOperation oUpgradeSubOperation = null;
        String strUpgradeSubOperationId = null;
        String strUpgradeSubOpName = null;
        IParaList oParaList = null;
        AsnUpgradeSubOperationDef oAsnUpgradeSubOperationDef = null;
        StartupConfigParam oStartupConfigParam = null;
        for (int i = 0; i < iSize; ++i) {
            oAsnUpgradeSubOperationDef = (AsnUpgradeSubOperationDef)oAsnUpgradeSubOperationLst.get(i);
            strUpgradeSubOperationId = new String(oAsnUpgradeSubOperationDef.strOperId);
            oUpgradeSubOperation = new UpgradeSubOperation();
            if (null == oUpgradeSubOperation) continue;
            oUpgradeSubOperation.setOperationIdString(strUpgradeSubOperationId);
            oUpgradeSubOperation.setOperationLevel(this.getOperationLevel(oAsnUpgradeSubOperationDef.enOperLevel.value));
            strUpgradeSubOpName = ResourceManager.getInstance().getResString(oDevTypeInfo, strUpgradeSubOperationId);
            oUpgradeSubOperation.setOperationName(strUpgradeSubOpName);
            if (null != oAsnUpgradeSubOperationDef.stOperParaLst) {
                oParaList = this.getParameterFrmAsn(oDevTypeInfo, oAsnUpgradeSubOperationDef.stOperParaLst);
            }
            oUpgradeSubOperation.setOPerationParaList(oParaList);
            this.setIsConfigReq(oUpgradeSubOperation, oParaList);
            if (oUpgradeSubOperation.isConfigReq()) {
                oUpgradeSubOperation.setOperationDesc(strUpgradeSubOpName);
            } else {
                oUpgradeSubOperation.setOperationDesc("");
            }
            oUpgradeSubOperation.setSelected(true);
            if (oUpgradeOperation instanceof PrepareUpgradeOperation && oParaList != null) {
                oStartupConfigParam = new StartupConfigParam();
                oStartupConfigParam.setParaList(oParaList);
                oUpgradeSubOperation.setUpgradeSubOperationConfig(oStartupConfigParam);
            }
            oUpgradeSubOperationList.add(oUpgradeSubOperation);
        }
        oUpgradeOperation.setUpgradeSubOperationList(oUpgradeSubOperationList);
    }

    private void setIsConfigReq(IUpgradeSubOperation oUpgradeSubOperation, IParaList oParaList) {
        if (oParaList == null) {
            oUpgradeSubOperation.setIsConfigReq(false);
            return;
        }
        IOperationPara operationPara = oParaList.getParameter("hyperlink");
        if (operationPara == null) {
            oUpgradeSubOperation.setIsConfigReq(false);
            return;
        }
        oUpgradeSubOperation.setIsConfigReq(operationPara.isRequired());
    }

    private void updateTaskOpLst(DeviceTypeInfo oDevTypeInfo, IOperationConfig oOperationConfig, AsnTaskOperationLst oAsnTaskOperationLst) {
        int iSizeOFLst = oAsnTaskOperationLst.size();
        ITaskDeviceOperation oTaskDevOPeration = null;
        String strTaskOperationId = null;
        String strTaskOpName = null;
        IParaList oParaList = null;
        AsnOperation oAsnOperation = null;
        for (int i = 0; i < iSizeOFLst; ++i) {
            oAsnOperation = (AsnOperation)oAsnTaskOperationLst.get(i);
            strTaskOperationId = new String(oAsnOperation.strOperId);
            int iOperationId = OperationIdStore.getInstance().getOperationId(strTaskOperationId);
            oTaskDevOPeration = (ITaskDeviceOperation)DeviceOpViewFactory.createOperationObj(1, iOperationId);
            if (null == oTaskDevOPeration) continue;
            oTaskDevOPeration.setOperationId(iOperationId);
            oTaskDevOPeration.setOperationIdString(strTaskOperationId);
            oTaskDevOPeration.setOperationLevel(this.getOperationLevel(oAsnOperation.enOperLevel.value));
            oTaskDevOPeration.setIsCancelable(oAsnOperation.bIsCancelable);
            strTaskOpName = ResourceManager.getInstance().getResString(oDevTypeInfo, strTaskOperationId);
            oTaskDevOPeration.setOperationName(strTaskOpName);
            oParaList = this.getParameterFrmAsn(oDevTypeInfo, oAsnOperation.stOperParaLst);
            oTaskDevOPeration.setOPerationParaList(oParaList);
            oOperationConfig.addTaskOperation(oTaskDevOPeration);
        }
    }

    private void updateDevOPLst(DeviceTypeInfo oDevTypeInfo, IOperationConfig oOperationConfig, AsnDevOperationLst oAsnDevOperationLst) {
        int iSizeOFLst = oAsnDevOperationLst.size();
        IDeviceOperation oDevOPeration = null;
        AsnOperation oAsnOperation = null;
        String strOperationId = null;
        String strOpName = null;
        IParaList oParaList = null;
        for (int i = 0; i < iSizeOFLst; ++i) {
            oAsnOperation = (AsnOperation)oAsnDevOperationLst.get(i);
            strOperationId = new String(oAsnOperation.strOperId);
            int iOperationId = OperationIdStore.getInstance().getOperationId(strOperationId);
            oDevOPeration = (IDeviceOperation)DeviceOpViewFactory.createOperationObj(0, iOperationId);
            if (null == oDevOPeration) continue;
            oDevOPeration.setOperationId(iOperationId);
            oDevOPeration.setOperationIdString(strOperationId);
            oDevOPeration.setOperationLevel(this.getOperationLevel(oAsnOperation.enOperLevel.value));
            oDevOPeration.setIsCancelable(oAsnOperation.bIsCancelable);
            strOpName = ResourceManager.getInstance().getResString(oDevTypeInfo, strOperationId);
            oDevOPeration.setOperationName(strOpName);
            oParaList = this.getParameterFrmAsn(oDevTypeInfo, oAsnOperation.stOperParaLst);
            oDevOPeration.setOPerationParaList(oParaList);
            oOperationConfig.addDeviceOperation(oDevOPeration);
        }
    }

    private int getOperationLevel(int iAsnOperationLevelEnum) {
        int iOperationLevel = -1;
        switch (iAsnOperationLevelEnum) {
            case 0: {
                iOperationLevel = 0;
                break;
            }
            case 1: {
                iOperationLevel = 1;
                break;
            }
            case 2: {
                iOperationLevel = 2;
                break;
            }
        }
        return iOperationLevel;
    }

    private void updateOtherOpLst(DeviceTypeInfo oDevTypeInfo, IOperationConfig oOperationConfig, AsnOtherOperationLst oAsnOtherOperationLst) {
        if (null == oAsnOtherOperationLst) {
            return;
        }
        AsnOtherOperationDef oAsnOtherOperation = null;
        IOtherOperation oOtherOperation = null;
        String strOperationID = null;
        IParaList oParaList = null;
        int iOperationCount = oAsnOtherOperationLst.size();
        for (int i = 0; i < iOperationCount; ++i) {
            oAsnOtherOperation = (AsnOtherOperationDef)oAsnOtherOperationLst.get(i);
            strOperationID = new String(oAsnOtherOperation.strOperId);
            int iOperationId = OperationIdStore.getInstance().getOperationId(strOperationID);
            oOtherOperation = (IOtherOperation)DeviceOpViewFactory.createOperationObj(5, iOperationId);
            oOtherOperation.setOperationIdString(strOperationID);
            oOtherOperation.setOperationId(iOperationId);
            oOtherOperation.setOperationName(ResourceManager.getInstance().getResString(oDevTypeInfo, strOperationID));
            oOtherOperation.setSupported(oAsnOtherOperation.bisSupported);
            oParaList = this.getParameterFrmAsn(oDevTypeInfo, oAsnOtherOperation.stOperParaLst);
            oOtherOperation.setOPerationParaList(oParaList);
            oOperationConfig.addOtherOperation(oOtherOperation);
        }
    }

    private IParaList getParameterFrmAsn(DeviceTypeInfo oDevTypeInfo, AsnOperParamDefLst stOperParaLst) {
        int iSizeOfParaLst = stOperParaLst.size();
        ParaList oParaList = new ParaList();
        Parameter oOpParameter = null;
        String strParaId = null;
        String strParaName = null;
        AsnOptionInfoLst oAsnOPtionInfoLst = null;
        ParaValue oParaValue = null;
        AsnOptionInfo oAsnOptionInfo = null;
        String strOptionParaId = null;
        String strOptionParaName = null;
        String strParameterVal = "";
        for (int i = 0; i < iSizeOfParaLst; ++i) {
            oOpParameter = new Parameter();
            AsnOperParamDef oAsnOperParam = (AsnOperParamDef)stOperParaLst.get(i);
            oOpParameter.setIsRequired(oAsnOperParam.bIsRequired);
            if (null != oAsnOperParam.strValue) {
                strParameterVal = new String(oAsnOperParam.strValue);
            }
            oOpParameter.setParameterValue(strParameterVal);
            strParaId = new String(oAsnOperParam.strParaId);
            strParaName = ResourceManager.getInstance().getResString(oDevTypeInfo, strParaId);
            if (strParaId.equals("ActivateContentType")) {
                strParaId = strParaId + strParameterVal.trim();
                if (!strParameterVal.equals("CONFIGURATIONFILE") && !strParameterVal.equals("DATAFILE")) {
                    DCDebugTracer.trace("DCbomb: " + oAsnOperParam);
                }
            }
            oOpParameter.setParameterId(strParaId);
            oOpParameter.setParamterName(strParaName);
            oAsnOPtionInfoLst = oAsnOperParam.stOptInfoLst;
            int iNosOfParavalues = oAsnOPtionInfoLst.size();
            for (int j = 0; j < iNosOfParavalues; ++j) {
                oAsnOptionInfo = (AsnOptionInfo)oAsnOPtionInfoLst.get(j);
                oParaValue = new ParaValue();
                strOptionParaId = new String(oAsnOptionInfo.strOptId);
                oParaValue.setId(strOptionParaId);
                strOptionParaName = ResourceManager.getInstance().getResString(oDevTypeInfo, strOptionParaId);
                oParaValue.setDisplayName(strOptionParaName);
                oParaValue.setValue(oAsnOptionInfo.iValue.intValue());
                if (null != oAsnOptionInfo.strDestination) {
                    oParaValue.setDestination(new String(oAsnOptionInfo.strDestination));
                }
                oOpParameter.addParamater(oParaValue);
            }
            oParaList.addParameter(oOpParameter);
        }
        return oParaList;
    }

    private void updateViewConfigInfo(IDeviceTypeConfigModel oDevTypeConfigModel, AsnViewConfig oAsnViewConfig) {
        ViewConfiguration oViewConfiguration = new ViewConfiguration();
        this.updateDeviceViewInfo(oAsnViewConfig.oAsnDevViewMenuDefList, oViewConfiguration, 0);
        this.updatePatchViewInfo(oAsnViewConfig.oAsnPatchViewMenuOpList, oViewConfiguration);
        this.updateDeviceViewInfo(oAsnViewConfig.oAsnDevViewTabDefList, oViewConfiguration, 3);
        oDevTypeConfigModel.setViewConfiguration(oViewConfiguration);
    }

    private void updateDeviceViewInfo(AsnDevViewMenuDefList oAsnDevViewMenuDefList, IViewConfiguration oViewConfiguration, int iCfgType) {
        int iSizeLst = oAsnDevViewMenuDefList.size();
        AsnMenuOpDef oAsnMenuOpDef = null;
        MenuConfig oMenuConfig = new MenuConfig();
        String strValue = null;
        for (int i = 0; i < iSizeLst; ++i) {
            oAsnMenuOpDef = (AsnMenuOpDef)oAsnDevViewMenuDefList.get(i);
            strValue = new String(oAsnMenuOpDef.strOpId);
            oMenuConfig.addMenuValue(oAsnMenuOpDef.enOpertypeRef.value, strValue);
        }
        oViewConfiguration.setViewConfiguration(iCfgType, oMenuConfig);
    }

    private void updatePatchViewInfo(AsnPatchViewMenuOpList oAsnPatchViewMenuOpList, IViewConfiguration oViewConfiguration) {
        int iSizeLst = oAsnPatchViewMenuOpList.size();
        AsnMenuOpDef oAsnMenuOpDef = null;
        MenuConfig oMenuConfig = null;
        String strValue = null;
        for (int i = 0; i < iSizeLst; ++i) {
            oMenuConfig = new MenuConfig();
            AsnPatchTypeMenuDef oAsnPatchTypeMenuDef = (AsnPatchTypeMenuDef)oAsnPatchViewMenuOpList.get(i);
            AsnMenuOpLst oAsnMenuOpLst = oAsnPatchTypeMenuDef.stMenuOperLst;
            int iMenuLst = oAsnMenuOpLst.size();
            for (int j = 0; j < iMenuLst; ++j) {
                oAsnMenuOpDef = (AsnMenuOpDef)oAsnMenuOpLst.get(j);
                strValue = new String(oAsnMenuOpDef.strOpId);
                oMenuConfig.addMenuValue(oAsnMenuOpDef.enOpertypeRef.value, strValue);
            }
            if (0 == oAsnPatchTypeMenuDef.enPatchType.value) {
                oViewConfiguration.setViewConfiguration(1, oMenuConfig);
                continue;
            }
            oViewConfiguration.setViewConfiguration(2, oMenuConfig);
        }
    }

    private void updateTaskConfigInfo(IDeviceTypeConfigModel oDevTypeConfigModel, AsnTaskConfigInfoLst oAsnTaskConfigLst) {
        int iSizeOfTaskLst = oAsnTaskConfigLst.size();
        TaskTypeConfiguration oTaskTypeConfig = new TaskTypeConfiguration();
        AsnTaskConfigInfoOperation oAsnTaskConfigInfoOperation = null;
        AsnTaskConfigOperation oAsnTaskConfigOperation = null;
        AsnTaskConfigOperationLst oAsnTaskConfigOperationLst = null;
        AsnOperParamDefLst stOperParaLst = new AsnOperParamDefLst();
        ITaskDeviceOperation oTaskOperations = null;
        AsnTaskOperationList oAsnTaskOpLst = null;
        AsnTaskOperationDef oAsnTaskOpDef = null;
        String strOPId = null;
        String strOpDesc = null;
        IParaList oParaList = null;
        DeviceTypeInfo tmpDevTypeInfo = null;
        tmpDevTypeInfo = this.getDevTypeByName(oDevTypeConfigModel.getDeviceType(), oDevTypeConfigModel.getDeviceTypeVersion());
        for (int i = 0; i < iSizeOfTaskLst; ++i) {
            int iTaskType;
            oAsnTaskConfigInfoOperation = (AsnTaskConfigInfoOperation)oAsnTaskConfigLst.get(i);
            int iTaskTypeKey = iTaskType = this.getTaskTypeFrmAsn(oAsnTaskConfigInfoOperation.enTaskTypeName.value);
            if (null != oAsnTaskConfigInfoOperation.strGUITemplete && 0 != oAsnTaskConfigInfoOperation.strGUITemplete.length) {
                String guiTemleteName = new String(oAsnTaskConfigInfoOperation.strGUITemplete);
                DebugTracer.trace((String)("DeviceConfigModelCtrller#updateTaskConfigInfo#guiTemleteName=" + guiTemleteName));
                oDevTypeConfigModel.setGuiTempleteInfo(this.createGUITempleteInfo(guiTemleteName));
            }
            oAsnTaskConfigOperationLst = oAsnTaskConfigInfoOperation.oAsnTaskConfigOperationLst;
            for (int k = 0; k < oAsnTaskConfigOperationLst.size(); ++k) {
                ParaValue oParaValue;
                List oList;
                IOperationPara OIOperationPara;
                oAsnTaskConfigOperation = (AsnTaskConfigOperation)oAsnTaskConfigOperationLst.get(k);
                stOperParaLst.clear();
                stOperParaLst.add((Object)oAsnTaskConfigOperation.stOperPara);
                oParaList = this.getParameterFrmAsn(tmpDevTypeInfo, stOperParaLst);
                if (13 == iTaskType && null != (OIOperationPara = oParaList.getParameter("DowngradeType")) && (oList = OIOperationPara.getParameterValueList()).size() > 0 && null != (oParaValue = (ParaValue)oList.get(0))) {
                    iTaskTypeKey = iTaskType * 10 + oParaValue.getValue() - 1;
                }
                oTaskTypeConfig.setParaList(iTaskTypeKey, oParaList);
                oAsnTaskOpLst = oAsnTaskConfigOperation.stTaskOperation;
                int iNosOfOp = oAsnTaskOpLst.size();
                String strDependsOnId = null;
                for (int j = 0; j < iNosOfOp; ++j) {
                    oAsnTaskOpDef = (AsnTaskOperationDef)oAsnTaskOpLst.get(j);
                    strOPId = new String(oAsnTaskOpDef.strOperId);
                    int iOPerationId = OperationIdStore.getInstance().getOperationId(strOPId);
                    int iOperationType = this.getOperationType(oAsnTaskOpDef.enOpertypeRef.value);
                    oTaskOperations = 3 == iOperationType ? (2 == iTaskType ? (ITaskDeviceOperation)oDevTypeConfigModel.getCheckCloneOperObjForPatchTask(iOPerationId) : (ITaskDeviceOperation)oDevTypeConfigModel.getCheckCloneOperObj(iOPerationId)) : (ITaskDeviceOperation)oDevTypeConfigModel.getCloneOperationObj(iOperationType, iOPerationId);
                    if (null == oTaskOperations) continue;
                    oTaskOperations.setOperationId(iOPerationId);
                    oTaskOperations.setOperationIdString(strOPId);
                    String str = new String(oAsnTaskOpDef.strTaskOpDesc);
                    strOpDesc = ResourceManager.getInstance().getResString(tmpDevTypeInfo, str);
                    oTaskOperations.setOperationDesc(strOpDesc);
                    strDependsOnId = new String(oAsnTaskOpDef.strdependsOn);
                    oTaskOperations.setDependsOnOperation(OperationIdStore.getInstance().getOperationId(strDependsOnId));
                    oTaskTypeConfig.addTaskOperation(iTaskTypeKey, oTaskOperations);
                }
            }
        }
        oDevTypeConfigModel.setTaskTaskTypeConfiguration(oTaskTypeConfig);
    }

    public int getTaskTypeFrmAsn(int iAsnTaskType) {
        int iTaskType = -1;
        switch (iAsnTaskType) {
            case 0: {
                iTaskType = 0;
                break;
            }
            case 1: {
                iTaskType = 1;
                break;
            }
            case 2: {
                iTaskType = 2;
                break;
            }
            case 6: {
                iTaskType = 0;
                break;
            }
            case 3: {
                iTaskType = 3;
                break;
            }
            case 4: {
                iTaskType = 4;
                break;
            }
            case 13: {
                iTaskType = 13;
                break;
            }
            case 5: {
                iTaskType = 5;
                break;
            }
            case 12: {
                iTaskType = 12;
                break;
            }
            case 7: {
                iTaskType = 7;
                break;
            }
        }
        return iTaskType;
    }

    private int getOperationType(int iAsnOpTypeValue) {
        int iOperationType = -1;
        switch (iAsnOpTypeValue) {
            case 0: {
                iOperationType = 0;
                break;
            }
            case 2: {
                iOperationType = 2;
                break;
            }
            case 5: {
                iOperationType = 5;
                break;
            }
            case 1: {
                iOperationType = 1;
                break;
            }
            case 3: {
                iOperationType = 3;
                break;
            }
            case 4: {
                iOperationType = 4;
                break;
            }
            case 6: {
                iOperationType = 6;
                break;
            }
        }
        return iOperationType;
    }

    public boolean isConfigDataRecieved() {
        return this.m_bIsLast;
    }

    public void getDeviceSpecificConfigInfo(String strDeviceType, String strDevTypeVerName) throws DCException {
        AsnDevTypeInfo oAsnDevTypeInfo = new AsnDevTypeInfo();
        oAsnDevTypeInfo.strDevTypeName = strDeviceType.getBytes();
        oAsnDevTypeInfo.strDevTypeVersionName = strDevTypeVerName.getBytes();
        DCDebugTracer.trace("DC: DeviceConfigModelCtrller#getDeviceSpecificConfigInfo--->strDevTypeName:" + strDeviceType + "strDeviceTypeVersion=" + strDevTypeVerName);
        final AsnDevTypeInfoLst oAsnDevTypeInfoLst = new AsnDevTypeInfoLst();
        oAsnDevTypeInfoLst.add(0, (Object)oAsnDevTypeInfo);
        final AsnDevTypeVerXMLListRsp oAsnDevTypeVerXMLListRsp = new AsnDevTypeVerXMLListRsp();
        int iErrorCode = 0;
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                if (DCFrameWorkUtil.getCommManager() == null) {
                    DCDebugTracer.trace("DC:getDeviceSpecificConfigInfo():DCFrameWorkUtil.getCommManager( ) is null");
                }
                BaseCommManager baseCommManager = DeviceConfigModelCtrller.this.m_oCommManager;
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43962), (FStruct)oAsnDevTypeInfoLst, (FStruct)oAsnDevTypeVerXMLListRsp);
                return iErrorCode;
            }
        };
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            DCDebugTracer.trace("DeviceConfigModelCtrller#getDeviceSpecificConfigInfo:ASNErrorcode:" + iErrorCode);
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        AsnDevTypeVerXMLInfoList oAsnDevTypeVerXMLInfoLst = oAsnDevTypeVerXMLListRsp.oAsnDevTypeVerXMLInfoList;
        for (int i = 0; i < oAsnDevTypeVerXMLInfoLst.size(); ++i) {
            AsnDevTypeVerXMLInfo oAsnDevTypeVerXMLInfo = (AsnDevTypeVerXMLInfo)oAsnDevTypeVerXMLInfoLst.get(i);
            iErrorCode = oAsnDevTypeVerXMLInfo.oErrorInfo.iErrorNo.intValue();
            if (iErrorCode != 0) {
                DCDebugTracer.trace("DeviceConfigModelCtrller#getDeviceSpecificConfigInfo:XMLErrorcode:" + iErrorCode);
                continue;
            }
            this.updateDeviceXmlDataModel(oAsnDevTypeVerXMLInfo);
        }
    }

    public void getDeviceTypeConfigData() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseCommManager m_oCommManager = DCFrameWorkUtil.getCommManager();
                m_oCommManager.sendAsyncMsg(BaseCommManager.getMSGHead(43875), null, null);
                DCFrameWorkUtil.defaultCursor();
            }
        };
        Thread oThreadObj = new Thread(runnable);
        oThreadObj.start();
    }

    @Override
    public void timeout(int arg0, Character arg1) {
    }

    public int getAddingDeviceID() {
        return this.m_iAddingDeviceID;
    }

    public void setAddingDeviceID(int iAddingDeviceID) {
        this.m_iAddingDeviceID = iAddingDeviceID;
    }

    private DeviceTypeInfo getDevTypeByName(String strDevTypeName, String strDevTypeVerName) {
        DeviceTypeInfo oDevTypeInfo = new DeviceTypeInfo();
        String sTmpTypeVerName = strDevTypeVerName;
        if (strDevTypeVerName.endsWith("_telnet")) {
            int index = strDevTypeVerName.lastIndexOf("_telnet");
            sTmpTypeVerName = strDevTypeVerName.substring(0, index);
        }
        oDevTypeInfo.setDevTypeName(strDevTypeName);
        oDevTypeInfo.setDevTypeVersionName(strDevTypeVerName);
        DeviceTypeInfo[] devTypeInfos = DeviceInfoManagerImpl.getInstance().getDeviceTypes();
        if (null != devTypeInfos) {
            int iDevTypeCount = devTypeInfos.length;
            for (int i = 0; i < iDevTypeCount; ++i) {
                if (!devTypeInfos[i].getDevTypeName().equals(strDevTypeName) || !devTypeInfos[i].getDevTypeVersionName().equals(sTmpTypeVerName) && !devTypeInfos[i].getDevTypeVersionName().equals(strDevTypeName)) continue;
                return devTypeInfos[i];
            }
        }
        return oDevTypeInfo;
    }

    public GUITempleteInfo createGUITempleteInfo(String strGUITempleteName) {
        GUITempleteInfo value = new GUITempleteInfo(strGUITempleteName);
        return value;
    }

    class DeviceTypeXmlParserThread
    implements Runnable {
        private AsnDevTypeVerXMLListRsp m_oAsnDevTypeVerXMLListRsp = null;

        DeviceTypeXmlParserThread(AsnDevTypeVerXMLListRsp oAsnDevTypeVerXMLListRsp) {
            this.m_oAsnDevTypeVerXMLListRsp = oAsnDevTypeVerXMLListRsp;
        }

        @Override
        public void run() {
            if (this.m_oAsnDevTypeVerXMLListRsp.oAsnDevTypeVerXMLInfoList == null || 0 == this.m_oAsnDevTypeVerXMLListRsp.oAsnDevTypeVerXMLInfoList.size()) {
                DCDebugTracer.trace("DC:: DeviceTypeXmlParserThread::m_oAsnDevTypeVerXMLListRsp.oAsnDevTypeVerXMLInfoList->null/size = 0");
                return;
            }
            int iSize = this.m_oAsnDevTypeVerXMLListRsp.oAsnDevTypeVerXMLInfoList.size();
            AsnDevTypeVerXMLInfo oAsnDevTypeVerXMLInfo = null;
            DeviceConfigModelCtrller.this.m_bIsLast = this.m_oAsnDevTypeVerXMLListRsp.bIsLastInfo;
            for (int iXMLInfoIndex = 0; iXMLInfoIndex < iSize; ++iXMLInfoIndex) {
                oAsnDevTypeVerXMLInfo = (AsnDevTypeVerXMLInfo)this.m_oAsnDevTypeVerXMLListRsp.oAsnDevTypeVerXMLInfoList.get(iXMLInfoIndex);
                if (0 == oAsnDevTypeVerXMLInfo.oErrorInfo.iErrorNo.intValue()) {
                    DeviceConfigModelCtrller.this.updateDeviceXmlDataModel(oAsnDevTypeVerXMLInfo);
                    continue;
                }
                DCDebugTracer.trace("DC:: DeviceTypeXmlParserThread::ErrorCode" + oAsnDevTypeVerXMLInfo.oErrorInfo.iErrorNo.intValue());
            }
            if (DeviceConfigModelCtrller.this.m_bIsLast) {
                DeviceTablePanel deviceTablePanel = DCFrameWorkUtil.getDeviceTablePanel();
                if (null != deviceTablePanel) {
                    deviceTablePanel.refreshTable();
                } else {
                    DCDebugTracer.trace("DC:: DeviceTypeXmlParserThread::deviceTablePanel is null");
                }
            }
        }
    }
}

