/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.controller;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.controller.IBoardTypeManager;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.util.DebugTracer;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BoardTypeManager
implements IBoardTypeManager,
IDCObjectDeallocator {
    Hashtable m_oBoardTypeHashTable;
    private String language = ConfigurationInfo.getInstance().getLocale().getLanguage().toUpperCase(ResourceMng.getInstance().getLocale());
    private static IBoardTypeManager _instance;

    private BoardTypeManager() {
        String boardtypeDirectoryName = ConfigurationInfo.getInstance().getStyleDirectory() + "boardtype";
        if (ConfigurationInfo.getInstance().isConfigFilesInJar()) {
            this.loadFromJar(boardtypeDirectoryName);
        } else {
            File boardTypeDirectory = new File(boardtypeDirectoryName);
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File aFilePath) {
                    if (aFilePath.isFile()) {
                        String strFileName = aFilePath.getName();
                        return strFileName.toLowerCase(ResourceMng.getInstance().getLocale()).endsWith(".xml");
                    }
                    return aFilePath.isDirectory();
                }
            };
            File[] boardTypeXmlFiles = boardTypeDirectory.listFiles(fileFilter);
            if (boardTypeXmlFiles != null && boardTypeXmlFiles.length > 0) {
                this.m_oBoardTypeHashTable = new Hashtable();
                int filelistLength = boardTypeXmlFiles.length;
                for (int i = 0; i < filelistLength; ++i) {
                    Document boardTypeDocument = ConfigurationInfo.getInstance().loadDocumentFromFile(boardTypeXmlFiles[i].getAbsolutePath());
                    if (null == boardTypeDocument) continue;
                    this.load(boardTypeDocument, this.m_oBoardTypeHashTable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromJar(String boardtypeDirectoryName) {
        JarFile jarFile = null;
        try {
            jarFile = ConfigurationInfo.getInstance().getDCJarFile();
            if (null == jarFile) {
                return;
            }
            Enumeration<JarEntry> filesEnum = jarFile.entries();
            JarEntry entry = null;
            String fileName = "";
            this.m_oBoardTypeHashTable = new Hashtable();
            Document boardTypeDocument = null;
            while (filesEnum.hasMoreElements()) {
                entry = filesEnum.nextElement();
                fileName = entry.getName();
                if (!fileName.startsWith(boardtypeDirectoryName) || !fileName.endsWith(".xml") || null == (boardTypeDocument = ConfigurationInfo.getInstance().loadDocumentFromFile(fileName))) continue;
                this.load(boardTypeDocument, this.m_oBoardTypeHashTable);
            }
        }
        catch (Exception e) {
            DebugTracer.trace((Exception)e);
        }
        finally {
            if (null != jarFile) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    DebugTracer.trace((Exception)e);
                }
            }
        }
    }

    public static synchronized IBoardTypeManager getInstance() {
        if (_instance == null) {
            _instance = new BoardTypeManager();
            DCObjectDestructor.getInstance().addObjectForDestructor((BoardTypeManager)_instance);
        }
        return _instance;
    }

    public Hashtable load(Document document, Hashtable hashTable) {
        if (null == document) {
            return null;
        }
        Element rootNode = document.getDocumentElement();
        rootNode.normalize();
        NodeList rootNodeList = rootNode.getElementsByTagName("AREADESC");
        Element areanameNode = (Element)rootNodeList.item(0);
        NodeList descNodeList = areanameNode.getElementsByTagName("DESC");
        String displayProperties = "DISPLAYNAME_" + this.language;
        for (int i = 0; i < descNodeList.getLength(); ++i) {
            Node descNode = descNodeList.item(i);
            NamedNodeMap descNodeMap = descNode.getAttributes();
            Node mainDeviceTypeAttrNode = descNodeMap.getNamedItem("maindevicetype");
            String mainDeviceType = "";
            if (mainDeviceTypeAttrNode != null) {
                mainDeviceType = mainDeviceTypeAttrNode.getNodeValue();
            }
            Node versionAttrNode = descNodeMap.getNamedItem("version");
            String mainVersion = "";
            if (versionAttrNode != null) {
                mainVersion = versionAttrNode.getNodeValue();
            }
            Hashtable<String, String> deviceTypeHashtable = new Hashtable<String, String>();
            Hashtable<String, String> deviceTypeWithRebootHashtable = new Hashtable<String, String>();
            NodeList alternateDeviceTypesNode = ((Element)descNode).getElementsByTagName("ALTERNATEDEVICETYPES");
            if (alternateDeviceTypesNode != null && alternateDeviceTypesNode.getLength() == 1) {
                NodeList alternateDeviceTypes = ((Element)alternateDeviceTypesNode.item(0)).getElementsByTagName("DEVICETYPEDESC");
                int alternateSupportedDeviceTypesLength = alternateDeviceTypes.getLength();
                for (int l = 0; l < alternateSupportedDeviceTypesLength; ++l) {
                    NamedNodeMap alternateDeviceTypeNodeMap = alternateDeviceTypes.item(l).getAttributes();
                    Node alternateDeviceTypeNameNode = alternateDeviceTypeNodeMap.getNamedItem("name");
                    String alternateDeviceType = "";
                    if (alternateDeviceTypeNameNode != null) {
                        alternateDeviceType = alternateDeviceTypeNameNode.getNodeValue();
                    }
                    Node alternateDeviceTypeVersionNode = alternateDeviceTypeNodeMap.getNamedItem("version");
                    String alternateDeviceTypeVersion = "";
                    if (alternateDeviceTypeVersionNode != null) {
                        alternateDeviceTypeVersion = alternateDeviceTypeVersionNode.getNodeValue();
                    }
                    if (alternateDeviceTypeVersion.length() <= 0 || alternateDeviceType.length() <= 0) continue;
                    String alternateDeviceTypeWithVersion = alternateDeviceType + "," + alternateDeviceTypeVersion;
                    hashTable.put(alternateDeviceTypeWithVersion, deviceTypeHashtable);
                }
            }
            NodeList parameters = ((Element)descNode).getElementsByTagName("PARAS");
            int parametersLength = parameters.getLength();
            for (int j = 0; j < parametersLength; ++j) {
                NodeList paramNameValueList = ((Element)parameters.item(j)).getElementsByTagName("PARA");
                int parameterLength = paramNameValueList.getLength();
                String code = "";
                String displayname = "";
                String rebootValue = "0";
                for (int k = 0; k < parameterLength; ++k) {
                    Node parameter = paramNameValueList.item(k);
                    NamedNodeMap map = parameter.getAttributes();
                    Node nameNode = map.getNamedItem("name");
                    String name = "";
                    if (nameNode != null) {
                        name = nameNode.getNodeValue();
                    }
                    Node valueNode = map.getNamedItem("value");
                    String value = "";
                    if (valueNode != null) {
                        value = valueNode.getNodeValue();
                    }
                    if (name.equals("code")) {
                        code = value;
                        continue;
                    }
                    if (name.equals("REBOOT")) {
                        rebootValue = value;
                        continue;
                    }
                    if (!name.equals(displayProperties)) continue;
                    displayname = value;
                }
                if (code.length() > 0) {
                    deviceTypeHashtable.put(code, displayname);
                }
                if (null == deviceTypeWithRebootHashtable || rebootValue.length() <= 0) continue;
                deviceTypeWithRebootHashtable.put(code, rebootValue);
            }
            if (mainDeviceType.length() <= 0 || mainVersion.length() <= 0) continue;
            String mainDeviceTypeWithVersion = mainDeviceType + "," + mainVersion;
            hashTable.put(mainDeviceTypeWithVersion, deviceTypeHashtable);
        }
        return hashTable;
    }

    @Override
    public String getBoardTypeDescription(String deviceType, String deviceTypeVersion, int boardType) {
        String boardTypeDesc = null;
        try {
            Object boardTypeDescObj;
            if (boardType == -1) {
                return "-1";
            }
            String strBoardType = Integer.valueOf(boardType).toString();
            Hashtable hashtable = (Hashtable)this.m_oBoardTypeHashTable.get(deviceType + "," + deviceTypeVersion);
            if (hashtable != null && (boardTypeDescObj = hashtable.get(strBoardType)) != null) {
                boardTypeDesc = boardTypeDescObj.toString();
            }
            if (boardTypeDesc == null) {
                boardTypeDesc = strBoardType;
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        return boardTypeDesc;
    }

    @Override
    public Hashtable getBoardTypes(String deviceType, String deviceTypeVersion) {
        try {
            Hashtable hashtable = (Hashtable)this.m_oBoardTypeHashTable.get(deviceType + "," + deviceTypeVersion);
            return hashtable;
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
            return null;
        }
    }

    @Override
    public void setToNULL() {
        this.m_oBoardTypeHashTable.clear();
        _instance = null;
    }
}

