/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.connectivity.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.devicemanagement.connectivity.view.ConnectTestInfo;
import com.huawei.dc.devicemanagement.controller.DeviceInfoSyncCtrller;
import com.huawei.dc.taskmgmt.view.modifytask.CopyModifyTaskDialog;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ConnectTestPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JPanel m_radioPnl = null;
    JPanel m_filePnl = null;
    JPanel m_contentPnl = null;
    private JTextArea m_cmdArea = null;
    private String m_pingContent = "";
    private String m_tracertContent = "";
    private String m_pingFieldContent = null;
    private String m_tracertFieldContent = null;
    private boolean isPingType = true;
    private JTextField m_fileField = null;
    private boolean isValid = false;
    private static final String PING = "ping";
    private static final String TRACERT = "tracert";
    private int devId;
    private JRadioButton m_pingRadio = null;
    private JRadioButton m_tracertRadio = null;
    private ResourceManager m_resMgr = ResourceManager.getInstance();
    private JButton m_selectButton = null;
    private JButton m_clearButton = null;

    public ConnectTestPanel(int aDevId) {
        this.devId = aDevId;
        this.initRadioPanel();
        this.initFilePnl();
        this.initTestContentPanel();
        this.setComponentName();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_radioPnl, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 1, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.m_filePnl, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 1, new Insets(0, 11, 12, 12), 0, 0));
        this.add((Component)this.m_contentPnl, new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 12, 0, 12), 0, 0));
    }

    private void initRadioPanel() {
        DCDebugTracer.trace("Entering initRadioPanel");
        this.m_radioPnl = new JPanel();
        JLabel l_itemName = new JLabel(this.m_resMgr.getResString("CHECKMODE"));
        l_itemName.setPreferredSize(new Dimension(100, 21));
        l_itemName.setMinimumSize(new Dimension(100, 21));
        this.m_pingRadio = new JRadioButton(this.m_resMgr.getResString("PINGRADIO"));
        this.m_pingRadio.setFocusable(false);
        this.m_pingRadio.setPreferredSize(new Dimension(100, 21));
        this.m_pingRadio.setMinimumSize(new Dimension(100, 21));
        this.m_tracertRadio = new JRadioButton(this.m_resMgr.getResString("TRACERTRADIO"));
        this.m_tracertRadio.setPreferredSize(new Dimension(100, 21));
        this.m_tracertRadio.setMinimumSize(new Dimension(100, 21));
        this.m_tracertRadio.setFocusable(false);
        this.m_pingRadio.setSelected(true);
        this.addRadioListener();
        this.m_radioPnl.setLayout(new FlowLayout(0));
        this.m_radioPnl.add(l_itemName);
        this.m_radioPnl.add(Box.createHorizontalStrut(12));
        this.m_radioPnl.add(this.m_pingRadio);
        this.m_radioPnl.add(this.m_tracertRadio);
        DCDebugTracer.trace("Exiting initRadioPanel");
    }

    private void addRadioListener() {
        final ButtonGroup l_group = new ButtonGroup();
        l_group.add(this.m_pingRadio);
        l_group.add(this.m_tracertRadio);
        String l_pingAction = "pingAction";
        String l_tracertAction = "tracertAction";
        this.m_pingRadio.setActionCommand("pingAction");
        this.m_tracertRadio.setActionCommand("tracertAction");
        ActionListener l_listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String l_choice = l_group.getSelection().getActionCommand();
                if ("pingAction".equals(l_choice)) {
                    ConnectTestPanel.this.m_tracertContent = ConnectTestPanel.this.m_cmdArea.getText();
                    ConnectTestPanel.this.isPingType = true;
                    ConnectTestPanel.this.m_cmdArea.setText(ConnectTestPanel.this.m_pingContent);
                    ConnectTestPanel.this.m_fileField.setText(ConnectTestPanel.this.m_pingFieldContent);
                    ConnectTestPanel.this.m_fileField.setToolTipText(ConnectTestPanel.this.m_pingFieldContent);
                } else {
                    ConnectTestPanel.this.m_pingContent = ConnectTestPanel.this.m_cmdArea.getText();
                    ConnectTestPanel.this.isPingType = false;
                    ConnectTestPanel.this.m_cmdArea.setText(ConnectTestPanel.this.m_tracertContent);
                    ConnectTestPanel.this.m_fileField.setText(ConnectTestPanel.this.m_tracertFieldContent);
                    ConnectTestPanel.this.m_fileField.setToolTipText(ConnectTestPanel.this.m_tracertFieldContent);
                }
            }
        };
        this.m_pingRadio.addActionListener(l_listener);
        this.m_tracertRadio.addActionListener(l_listener);
    }

    private void initFilePnl() {
        DCDebugTracer.trace("Entering initFilePnl");
        this.m_filePnl = new JPanel();
        this.m_filePnl.setPreferredSize(new Dimension(420, 21));
        this.m_filePnl.setMinimumSize(new Dimension(420, 21));
        JLabel l_filepath = new JLabel(this.m_resMgr.getResString("FILEPATH"));
        l_filepath.setMinimumSize(new Dimension(120, 21));
        l_filepath.setPreferredSize(new Dimension(120, 21));
        this.m_fileField = new JTextField();
        this.m_fileField.setMinimumSize(new Dimension(120, 21));
        this.m_fileField.setPreferredSize(new Dimension(120, 21));
        this.m_fileField.setEditable(false);
        this.m_fileField.setToolTipText(null);
        this.m_selectButton = new JButton("...");
        this.m_selectButton.setMaximumSize(new Dimension(20, 21));
        this.m_selectButton.setMinimumSize(new Dimension(20, 21));
        this.m_selectButton.setPreferredSize(new Dimension(20, 21));
        this.m_clearButton = new JButton(this.m_resMgr.getResString("CLEARBUTTON"));
        this.m_clearButton.setMaximumSize(new Dimension(70, 21));
        this.m_clearButton.setMinimumSize(new Dimension(70, 21));
        this.m_clearButton.setPreferredSize(new Dimension(70, 21));
        this.m_clearButton.setMnemonic('C');
        this.m_selectButton.setActionCommand("SelectFile");
        this.m_clearButton.setActionCommand("ClearContent");
        ActionListener l_listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("SelectFile")) {
                    ConnectTestPanel.this.selectFile();
                }
                if (e.getActionCommand().equalsIgnoreCase("ClearContent")) {
                    ConnectTestPanel.this.clearContent();
                }
            }
        };
        this.m_selectButton.addActionListener(l_listener);
        this.m_clearButton.addActionListener(l_listener);
        this.m_selectButton.setName("ConnectTestPanel_m_selectButton");
        this.m_clearButton.setName("ConnectTestPanel_m_clearButton");
        JPanel l_buttonPnl = new JPanel(new BorderLayout());
        l_buttonPnl.add((Component)this.m_fileField, "Center");
        l_buttonPnl.add((Component)this.m_selectButton, "East");
        BorderLayout l_border = new BorderLayout();
        l_border.setHgap(7);
        this.m_filePnl.setLayout(l_border);
        this.m_filePnl.add((Component)l_filepath, "West");
        this.m_filePnl.add((Component)l_buttonPnl, "Center");
        this.m_filePnl.add((Component)this.m_clearButton, "East");
        DCDebugTracer.trace("Exiting initFilePnl");
    }

    private void initTestContentPanel() {
        DCDebugTracer.trace("Entering initTestContentPanel");
        this.m_contentPnl = new JPanel();
        JLabel l_conTestTitle = new JLabel(this.m_resMgr.getResString("TESTCOTENTBORDER"));
        this.m_contentPnl.setPreferredSize(new Dimension(420, 230));
        this.m_contentPnl.setMinimumSize(new Dimension(420, 230));
        this.m_cmdArea = new JTextArea();
        this.m_cmdArea.setEditable(true);
        this.m_cmdArea.setLineWrap(true);
        this.m_cmdArea.setWrapStyleWord(true);
        JScrollPane l_scrollPnl = new JScrollPane(this.m_cmdArea);
        this.m_contentPnl.setLayout(new BorderLayout(12, 12));
        this.m_contentPnl.add((Component)l_conTestTitle, "North");
        this.m_contentPnl.add((Component)l_scrollPnl, "Center");
        DCDebugTracer.trace("Exiting initTestContentPanel");
    }

    private void setComponentName() {
        this.m_contentPnl.setName("ConnectTestPanel_m_contentPnl");
        this.m_cmdArea.setName("ConnectTestPanel_m_cmdArea");
        this.m_filePnl.setName("ConnectTestPanel_m_filePnl");
        this.m_fileField.setName("ConnectTestPanel_m_fileField");
        this.m_pingRadio.setName("ConnectTestPanel_m_pingRadio");
        this.m_tracertRadio.setName("ConnectTestPanel_m_tracertRadio");
        this.m_radioPnl.setName("ConnectTestPanel_m_radioPnl");
        this.setName("ConnectTestPanel");
    }

    public void initConnInfo(ConnectTestInfo oTestInfo) {
        DCDebugTracer.trace("Entering initConnInfo");
        this.m_fileField.setText("");
        this.m_cmdArea.setText("");
        if (null != oTestInfo) {
            if (0 == oTestInfo.getCheckMode()) {
                this.isPingType = true;
                this.m_pingRadio.setSelected(true);
                this.m_tracertRadio.setSelected(false);
            } else {
                this.isPingType = false;
                this.m_pingRadio.setSelected(false);
                this.m_tracertRadio.setSelected(true);
            }
            this.m_cmdArea.setText(oTestInfo.getCheckContent());
            return;
        }
        try {
            ArrayList<ConnectTestInfo> l_testInfo = DeviceInfoSyncCtrller.getInstance().getConnInfoFromServer(this.devId);
            if (null == l_testInfo) {
                return;
            }
            for (int i = 0; i < l_testInfo.size(); ++i) {
                if (0 == l_testInfo.get(i).getCheckMode()) {
                    this.m_pingRadio.setSelected(true);
                    this.m_tracertRadio.setSelected(false);
                    this.m_cmdArea.setText(l_testInfo.get(i).getCheckContent());
                    continue;
                }
                this.m_pingRadio.setSelected(false);
                this.m_tracertRadio.setSelected(true);
                this.m_tracertContent = l_testInfo.get(i).getCheckContent();
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        DCDebugTracer.trace("Exiting initConnInfo");
    }

    private void selectFile() {
        DCDebugTracer.trace("Entering selectFile");
        String strApproveButton = this.m_resMgr.getResString("OPENFILE");
        String strToolTip = this.m_resMgr.getResString("OPENFILE");
        String strTitle = this.m_resMgr.getResString("SELECT_FILE");
        DCFileChooser oFileChooser = new DCFileChooser();
        oFileChooser.setFileFilter(1);
        oFileChooser.setAcceptAllFileFilterUsed(false);
        oFileChooser.setTitle(strTitle);
        oFileChooser.setApproveButtonText(strApproveButton);
        oFileChooser.setApproveButtonToolTipText(strToolTip);
        PrintSupportor.setIsFileSelection(false);
        oFileChooser.setApproveButtonMnemonic('I');
        int iReturnVal = -1;
        iReturnVal = oFileChooser.showOpenDialog(this);
        if (0 != iReturnVal) {
            return;
        }
        if (null == oFileChooser.getSelectedFile()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("PRINT_FILENAME_ERROR"), this.m_resMgr.getResString("WARNING"), 2);
            return;
        }
        File file = oFileChooser.getSelectedFile();
        if (1024L < file.length()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("FILETOOBIGINFO"), this.m_resMgr.getResString("WARNING"), 2);
            return;
        }
        if (0L == file.length()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("FILE_EMPTY"), this.m_resMgr.getResString("WARNING"), 2);
            return;
        }
        String sFileName = oFileChooser.getFullFileName();
        this.m_fileField.setText(sFileName);
        this.m_fileField.setToolTipText(sFileName);
        if (this.isPingType) {
            this.m_pingFieldContent = sFileName;
        } else {
            this.m_tracertFieldContent = sFileName;
        }
        this.fillCommandInfo(file);
        DCDebugTracer.trace("Exiting selectFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCommandInfo(File file) {
        BufferedReader l_buf = null;
        this.m_cmdArea.setText("");
        try {
            FileReader l_fileReader = new FileReader(file);
            l_buf = new BufferedReader(l_fileReader);
            String l_str = l_buf.readLine();
            while (null != l_str) {
                this.m_cmdArea.append(l_str);
                this.m_cmdArea.append(System.getProperty("line.separator"));
                l_str = l_buf.readLine();
            }
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
        }
        finally {
            if (null != l_buf) {
                try {
                    l_buf.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace("failed to close buttfer reader");
                }
            }
        }
    }

    private void clearContent() {
        if (this.isPingType) {
            this.m_pingFieldContent = null;
        } else {
            this.m_tracertFieldContent = null;
        }
        this.m_fileField.setText("");
        this.m_cmdArea.setText("");
    }

    public boolean testIsValid() {
        DCDebugTracer.trace("Entering isValid");
        this.isValid = this.isPingType ? this.checkStrValid(PING) : this.checkStrValid(TRACERT);
        DCDebugTracer.trace("Exiting isValid");
        return this.isValid;
    }

    private boolean checkStrValid(String checkType) {
        DCDebugTracer.trace("Entering checkStrValid");
        boolean l_isValid = true;
        String testArea = this.m_cmdArea.getText();
        if (0 == testArea.trim().length()) {
            return false;
        }
        if (1024 < testArea.getBytes().length) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_resMgr.getResString("CONTENT_MAXSIZE"), this.m_resMgr.getResString("WARNING"), 2);
            this.resetSelectTab();
            l_isValid = false;
            return l_isValid;
        }
        String[] testContent = testArea.split("\n");
        boolean bStartWithstr = false;
        for (int i = 0; i < testContent.length; ++i) {
            bStartWithstr = testContent[i].toLowerCase(ResourceMng.getInstance().getLocale()).startsWith(checkType);
            if (bStartWithstr) continue;
            DCOptionPane.showMessageDialog((Component)((Object)DCFrameWorkUtil.getCopyModifyTaskDialog()), this.m_resMgr.getResString("CONTENTINVALID"), this.m_resMgr.getResString("WARNING"), 2);
            this.resetSelectTab();
            l_isValid = false;
            break;
        }
        DCDebugTracer.trace("Exiting checkStrValid");
        return l_isValid;
    }

    public ConnectTestInfo getConnectTestInfo() {
        DCDebugTracer.trace("Entering getTestStruct");
        ConnectTestInfo l_testStruct = new ConnectTestInfo();
        l_testStruct.setDeviceId(this.devId);
        if (this.isPingType) {
            l_testStruct.setCheckMode(0);
        } else {
            l_testStruct.setCheckMode(1);
        }
        l_testStruct.setCheckContent(this.m_cmdArea.getText());
        DCDebugTracer.trace("Exiting getTestStruct");
        return l_testStruct;
    }

    public String getTestContent() {
        return this.m_cmdArea.getText();
    }

    public boolean isPingMode() {
        return this.isPingType;
    }

    public int getCmdCount() {
        String testArea = this.m_cmdArea.getText();
        String[] testContent = testArea.split("\n");
        return testContent.length;
    }

    public JTextArea getCmdTextArea() {
        return this.m_cmdArea;
    }

    public JTextField getConnTextField() {
        return this.m_fileField;
    }

    public void setContentEditable(boolean isEdit) {
        this.m_clearButton.setEnabled(isEdit);
        this.m_selectButton.setEnabled(isEdit);
        this.m_cmdArea.setEditable(isEdit);
    }

    private void resetSelectTab() {
        CopyModifyTaskDialog oCopyModifyTaskDialog = DCFrameWorkUtil.getCopyModifyTaskDialog();
        if (null == oCopyModifyTaskDialog) {
            return;
        }
    }
}

