/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.deviceinfo;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import java.io.Serializable;
import java.text.Collator;

public class DeviceTypeInfo
implements Comparable,
Serializable {
    private static final long serialVersionUID = 5796221524794833491L;
    static final String strClassName = "DeviceTypeInfo";
    private static final int MXU_TYPE = 1;
    private static final int CREATE_AUTO = 1;
    private int devTypeID;
    private String devTypeName;
    private int devTypeVersionId;
    private String devTypeVersionName;
    private boolean bSNMPType = false;
    private boolean m_bIsMxu = false;
    private int m_iDevicetype;
    private int m_iDeviceDomain;
    private boolean iscreateauto = false;

    public int getDevTypeID() {
        return this.devTypeID;
    }

    public int getDevDomain() {
        return this.m_iDeviceDomain;
    }

    public void setDevDomain(int iDevDomain) {
        this.m_iDeviceDomain = iDevDomain;
    }

    public void setDevTypeID(int aDevTypeID) {
        this.devTypeID = aDevTypeID;
    }

    public String getDevTypeName() {
        return this.devTypeName;
    }

    public void setDevTypeName(String aDevTypeName) {
        this.devTypeName = aDevTypeName;
    }

    public int getDevTypeVersionId() {
        return this.devTypeVersionId;
    }

    public void setDevTypeVersionId(int aDevTypeVersionId) {
        this.devTypeVersionId = aDevTypeVersionId;
    }

    public String getDevTypeVersionName() {
        return this.devTypeVersionName;
    }

    public void setDevTypeVersionName(String aDevTypeVersionName) {
        this.devTypeVersionName = aDevTypeVersionName;
    }

    public boolean isSNMPType() {
        this.bSNMPType = this.m_iDevicetype == 1;
        return this.bSNMPType;
    }

    public int getDeviceType() {
        return this.m_iDevicetype;
    }

    public void setDeviceType(int deviceType) {
        this.m_iDevicetype = deviceType;
    }

    public String toString() {
        if (-1 == this.devTypeID) {
            return DCConstants.ALL_TYPE;
        }
        if (this.m_iDeviceDomain == 1) {
            return this.devTypeName + "(" + StringUtils.removePostfix(this.devTypeVersionName, "_telnet") + ")";
        }
        return this.devTypeVersionName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DeviceTypeInfo) {
            DeviceTypeInfo devObj = (DeviceTypeInfo)obj;
            if (devObj.devTypeID == this.devTypeID && devObj.devTypeVersionId == this.devTypeVersionId) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.devTypeID;
    }

    public int compareTo(Object o) {
        try {
            String s1 = new String(this.toString().getBytes("GB2312"), "UTF-8");
            String s2 = new String(o.toString().getBytes("GB2312"), "UTF-8");
            int iCompareResult = Collator.getInstance().compare(s1, s2);
            if (0 != iCompareResult) {
                if (DCConstants.ALL_TYPE.equals(s1)) {
                    return 1;
                }
                if (DCConstants.ALL_TYPE.equals(s2)) {
                    return -1;
                }
                return iCompareResult;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        return 0;
    }

    public void setIscreateauto(int iType) {
        this.iscreateauto = false;
        if (1 == iType) {
            this.iscreateauto = true;
        }
    }

    public boolean getIscreateauto() {
        return this.iscreateauto;
    }

    public void setIsMxuDevice(int iType) {
        this.m_bIsMxu = false;
        if (1 == iType) {
            this.m_bIsMxu = true;
        }
    }

    public boolean getIsMXUDevice() {
        return this.m_bIsMxu;
    }

    public String getDevTypeIDAndVersionID() {
        return this.devTypeID + "_" + this.devTypeVersionId;
    }

    public boolean isDMSDomain() {
        return 2 == this.m_iDeviceDomain;
    }

    public boolean isBMSDomain() {
        return 1 == this.m_iDeviceDomain;
    }

    public boolean isT2000Domain() {
        return 4 == this.m_iDeviceDomain;
    }

    public boolean isALLType() {
        return -1 == this.devTypeID;
    }
}

