/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.deviceinfo;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DevIpInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceinfo.DeviceVersionInfo;
import com.huawei.dc.deviceoperation.util.OperationStatus;
import com.huawei.dc.framework.ErrorCodeReader;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.Collator;

public class DeviceInfo
implements Comparable<DeviceInfo>,
Serializable {
    private static final long serialVersionUID = -8873769671305754483L;
    private int m_iDevRoleType;
    private int m_iDevId;
    private int m_iNEDevId;
    private String m_strNeTId;
    private int m_iProtocol;
    private String m_strDevName;
    private int m_iDevTypeVersionId;
    private DeviceTypeInfo m_oDevTypeInfo;
    private DeviceVersionInfo m_oDevVersion;
    private String m_strDevIPAddress;
    private String m_strDevAreaName;
    private String m_strDevBoardType;
    private int m_iLastOperationErrorCode = -1;
    private transient ResourceManager oResourceManager;
    private OperationStatus m_oDeviceOperationStatus;
    private DevIpInfo m_oDevIpInfo = new DevIpInfo();
    private int m_iUpgradeMode = 0;
    private int m_iUpgradeModeConfig = 0;

    public String getDevBoardType() {
        return this.m_strDevBoardType;
    }

    public void setDevBoardType(String m_strDevBoardType) {
        this.m_strDevBoardType = m_strDevBoardType;
    }

    public DeviceInfo() {
        this.oResourceManager = ResourceManager.getInstance();
        this.m_oDeviceOperationStatus = new OperationStatus();
    }

    public int getDevId() {
        return this.m_iDevId;
    }

    public void setDevId(int iDevId) {
        this.m_iDevId = iDevId;
    }

    public int getDevTypeVersionId() {
        return this.m_iDevTypeVersionId;
    }

    public void setDevTypeVersionId(int iDevTypeVersionId) {
        this.m_iDevTypeVersionId = iDevTypeVersionId;
    }

    public String getDevName() {
        return this.m_strDevName;
    }

    public void setDevName(String strDevName) {
        this.m_strDevName = strDevName;
    }

    public DeviceTypeInfo getDeviceTypeInfo() {
        return this.m_oDevTypeInfo;
    }

    public void setDevType(DeviceTypeInfo aDeviceTypeInfo) {
        this.m_oDevTypeInfo = aDeviceTypeInfo;
    }

    public DeviceVersionInfo getDevVersion() {
        if (null == this.m_oDevVersion) {
            this.m_oDevVersion = new DeviceVersionInfo();
        }
        return this.m_oDevVersion;
    }

    public void setDevVersion(DeviceVersionInfo oDevVersion) {
        this.m_oDevVersion = oDevVersion;
    }

    public void setDevVersionId(DeviceVersionInfo aDevVersionId) {
        this.m_oDevVersion = aDevVersionId;
    }

    public String getDevIPAddress() {
        return this.m_strDevIPAddress;
    }

    public void setDevIPAddress(String strDevIPAddress) {
        this.m_strDevIPAddress = strDevIPAddress;
        this.m_oDevIpInfo.setstrDeviceIp(this.m_strDevIPAddress);
        this.m_oDevIpInfo.setDevIp(DCCommonUtil.convertStringtoLong(this.m_strDevIPAddress));
    }

    public DevIpInfo getDevIpAddressInfo() {
        return this.m_oDevIpInfo;
    }

    public String getDevAreaName() {
        return this.m_strDevAreaName;
    }

    public void setDevAreaName(String strDevAreaName) {
        this.m_strDevAreaName = strDevAreaName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_iDevId;
        result = 31 * result + (this.m_strDevIPAddress == null ? 0 : this.m_strDevIPAddress.hashCode());
        result = 31 * result + (this.m_strDevName == null ? 0 : this.m_strDevName.hashCode());
        return result;
    }

    public String toString() {
        return "DeviceInfo [m_iDevId=" + this.m_iDevId + ", m_iDevRoleType=" + this.m_iDevRoleType + ", m_strDevIPAddress=" + this.m_strDevIPAddress + ", m_strDevName=" + this.m_strDevName + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)obj;
        return this.m_iDevId == other.m_iDevId;
    }

    public CodeValue getDisplayPolicyWeekDay(int iBackupWeekDay) {
        CodeValue codeValue = new CodeValue();
        switch (iBackupWeekDay) {
            case 5: {
                codeValue.setCode(5);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_WEEKDAY_FRIDAY"));
                break;
            }
            case 1: {
                codeValue.setCode(1);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_WEEKDAY_MONDAY"));
                break;
            }
            case 6: {
                codeValue.setCode(6);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_WEEKDAY_SATURDAY"));
                break;
            }
            case 0: {
                codeValue.setCode(0);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_WEEKDAY_SUNDAY"));
                break;
            }
            case 4: {
                codeValue.setCode(4);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_WEEKDAY_THRUSDAY"));
                break;
            }
            case 2: {
                codeValue.setCode(2);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_WEEKDAY_TUESDAY"));
                break;
            }
            case 3: {
                codeValue.setCode(3);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_WEEKDAY_WEDNESDAY"));
                break;
            }
        }
        return codeValue;
    }

    @Override
    public int compareTo(DeviceInfo o) {
        try {
            String s1 = new String(this.toString().getBytes("GB2312"), "UTF-8");
            String s2 = new String(o.toString().getBytes("GB2312"), "UTF-8");
            return Collator.getInstance().compare(s1, s2);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return 0;
        }
    }

    public void setLastOperationType(int iLastOperationType) {
        this.m_oDeviceOperationStatus.setOperationType(iLastOperationType);
    }

    public OperationStatus getDeviceOperationStatus() {
        return this.m_oDeviceOperationStatus;
    }

    public void setDeviceOperationStatus(OperationStatus oDeviceOperationStatus) {
        this.m_oDeviceOperationStatus = oDeviceOperationStatus;
    }

    public void setRoleType(int iRoleType) {
        this.m_iDevRoleType = iRoleType;
    }

    public int getRoleType() {
        return this.m_iDevRoleType;
    }

    public int getLastOperationErrorCode() {
        return this.m_iLastOperationErrorCode;
    }

    public void setLastOperationErrorCode(int iLastOperationErrorCode, String strResult) {
        this.m_iLastOperationErrorCode = iLastOperationErrorCode;
        String strOperationResult = null;
        strOperationResult = iLastOperationErrorCode == 0 ? DCConstants.OPERTION_SUCCESS : ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iLastOperationErrorCode));
        if (null != strResult) {
            strOperationResult = strResult;
        }
        this.m_oDeviceOperationStatus.setIFailureReason(iLastOperationErrorCode);
        this.m_oDeviceOperationStatus.setFailureReason(strOperationResult);
    }

    public int getNEDevId() {
        return this.m_iNEDevId;
    }

    public void setNEDevId(int devId) {
        this.m_iNEDevId = devId;
    }

    public String getNeTId() {
        return this.m_strNeTId;
    }

    public void setNeTId(String neTId) {
        this.m_strNeTId = neTId;
    }

    public int getProtocol() {
        return this.m_iProtocol;
    }

    public void setProtocol(int protocol) {
        this.m_iProtocol = protocol;
    }

    public int getUpgradeMode() {
        return this.m_iUpgradeMode;
    }

    public void setUpgradeMode(int mIUpgradeMode) {
        this.m_iUpgradeMode = mIUpgradeMode;
    }

    public int getUpgradeModeConfig() {
        return this.m_iUpgradeModeConfig;
    }

    public void setUpgradeModeConfig(int mIUpgradeModeConfig) {
        this.m_iUpgradeModeConfig = mIUpgradeModeConfig;
    }

    public CodeValue getDisplayPeriod(int iBackupPeriod) {
        CodeValue codeValue = new CodeValue();
        switch (iBackupPeriod) {
            case 2: {
                codeValue.setCode(2);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_PERIOD_DAILY"));
                break;
            }
            case 0: {
                codeValue.setCode(0);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_PERIOD_MONTHLY"));
                break;
            }
            case 1: {
                codeValue.setCode(1);
                codeValue.setValue(this.oResourceManager.getResString("POLICY_INFO_PERIOD_WEEKLY"));
                break;
            }
        }
        return codeValue;
    }

    public void setLastOperationErrorCode(int iLastOperationErrorCode, int iOperationResultStatus) {
        this.m_iLastOperationErrorCode = iLastOperationErrorCode;
        String strOperationResult = DeviceInfo.getFailureReasonFromResoureFile(iLastOperationErrorCode, iOperationResultStatus);
        this.m_oDeviceOperationStatus.setIFailureReason(iLastOperationErrorCode);
        if (iOperationResultStatus != 3) {
            this.m_oDeviceOperationStatus.setIsProgress(false);
        }
        this.m_oDeviceOperationStatus.setIOperationResultStatus(iOperationResultStatus);
        this.m_oDeviceOperationStatus.setFailureReason(strOperationResult);
    }

    public static String getFailureReasonFromResoureFile(int iFailureReason, int iOperationResultStatus) {
        String strFailureReason = "";
        if (0 == iOperationResultStatus) {
            strFailureReason = ResourceManager.getInstance().getResString("OPERTION_SUCCESS");
        } else if (1 == iOperationResultStatus) {
            strFailureReason = ResourceManager.getInstance().getResString("OPERTION_FAILED");
            strFailureReason = strFailureReason + " " + ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iFailureReason));
        } else {
            strFailureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iOperationResultStatus));
        }
        return strFailureReason;
    }
}

