/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system.externalftp;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.configuration.system.externalftp.IUpdateExternalFTPInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ExternalFTPSettingForUpgradeTaskPanel
extends JPanel
implements IUpdateExternalFTPInfo {
    private static final long serialVersionUID = -5255278179329170528L;
    private ComboBoxWithToolTip m_oThirdFTPServerCombox;
    private JCheckBox m_oCheckBox;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private String m_strSelectServerName = "";
    private SystemSettingDlg m_oSystemSettingDlg;

    public ExternalFTPSettingForUpgradeTaskPanel(SystemSettingDlg oSystemSettingDlg, String strSelectServerName) {
        this.m_oSystemSettingDlg = oSystemSettingDlg;
        this.m_strSelectServerName = strSelectServerName;
        this.jInit();
    }

    private void jInit() {
        this.setLayout(new BorderLayout(0, 10));
        this.m_oCheckBox = new JCheckBox(this.m_oResMgr.getResString("SELECT_EXTERNAL_FTP_SERVER"));
        this.m_oCheckBox.setName("com.huawei.dc.configuration.system.ExternalFTPSettingForUpgradeTaskPanel.m_oCheckBox");
        this.m_oThirdFTPServerCombox = new ComboBoxWithToolTip();
        this.m_oThirdFTPServerCombox.setName("com.huawei.dc.configuration.system.ExternalFTPSettingForUpgradeTaskPanel.m_oThirdFTPServerCombox");
        this.m_oThirdFTPServerCombox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExternalFTPSettingForUpgradeTaskPanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }
        });
        if ("".equals(this.m_strSelectServerName)) {
            this.setSelectStatus(false);
        } else {
            this.setSelectStatus(true);
        }
        this.m_oCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    ExternalFTPSettingForUpgradeTaskPanel.this.setSelectStatus(true);
                } else {
                    ExternalFTPSettingForUpgradeTaskPanel.this.setSelectStatus(false);
                }
                ExternalFTPSettingForUpgradeTaskPanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }
        });
    }

    private void setSelectStatus(boolean isSelected) {
        this.m_oThirdFTPServerCombox.setEnabled(isSelected);
        this.m_oCheckBox.setSelected(isSelected);
        if (isSelected) {
            this.m_oCheckBox.setForeground(Color.BLACK);
        } else {
            this.m_oCheckBox.setForeground(Color.GRAY);
        }
    }

    @Override
    public void addExternalFTPInfo(ExternalFTPInfo externalFTPInfo) {
        this.m_oThirdFTPServerCombox.addItem(externalFTPInfo);
        if (this.m_strSelectServerName.equals(externalFTPInfo.getServerName())) {
            this.m_oThirdFTPServerCombox.setSelectedItem(externalFTPInfo);
        }
    }

    @Override
    public void deleteExteranlFTPInfo(ExternalFTPInfo externalFTPInfo) {
        int iCount = this.m_oThirdFTPServerCombox.getItemCount();
        for (int i = 0; i < iCount; ++i) {
            ExternalFTPInfo oTmpExternalFTPInfo = (ExternalFTPInfo)this.m_oThirdFTPServerCombox.getItemAt(i);
            if (!oTmpExternalFTPInfo.isSame(externalFTPInfo)) continue;
            this.m_oThirdFTPServerCombox.removeItemAt(i);
            break;
        }
        if (0 >= this.m_oThirdFTPServerCombox.getItemCount()) {
            this.setSelectStatus(false);
        }
    }

    @Override
    public void modifyExternalFTPInfo(String strOldServerName, ExternalFTPInfo oExternalFTPInfo) {
        int iCount = this.m_oThirdFTPServerCombox.getItemCount();
        for (int i = 0; i < iCount; ++i) {
            ExternalFTPInfo oTmpExternalFTPInfo = (ExternalFTPInfo)this.m_oThirdFTPServerCombox.getItemAt(i);
            if (!oTmpExternalFTPInfo.getServerName().equals(strOldServerName)) continue;
            oTmpExternalFTPInfo.setServerName(oExternalFTPInfo.getServerName());
            oTmpExternalFTPInfo.setServerIP(oExternalFTPInfo.getServerIP());
            oTmpExternalFTPInfo.setType(oExternalFTPInfo.getType());
            oTmpExternalFTPInfo.setPort(oExternalFTPInfo.getPort());
            oTmpExternalFTPInfo.setUserName(oExternalFTPInfo.getUserName());
            oTmpExternalFTPInfo.setPassword(oExternalFTPInfo.getPassword());
            break;
        }
    }

    public String getSelectedServerName() {
        ExternalFTPInfo oSelectExternalFTPInfo;
        if (this.m_oCheckBox.isSelected() && null != (oSelectExternalFTPInfo = (ExternalFTPInfo)this.m_oThirdFTPServerCombox.getSelectedItem())) {
            return oSelectExternalFTPInfo.getServerName();
        }
        return "";
    }
}

