/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system.externalftp;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDeleteThirdFTPInfo;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDeleteThirdFTPRsp;
import com.huawei.dc.common.asndatacenter.AsnDCCheckDeleteThirdFTPRspSeqOf;
import com.huawei.dc.common.asndatacenter.AsnProtocolEnum;
import com.huawei.dc.common.asndatacenter.DCStringList;
import com.huawei.dc.common.components.table.DCTable;
import com.huawei.dc.common.components.table.model.DCTableModel;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.ProtocolConfigInfo;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg;
import com.huawei.dc.configuration.system.externalftp.DCExternalFTPTableInfo;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.configuration.system.externalftp.IUpdateExternalFTPInfo;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExternalFTPServerSettingPanel
extends JPanel {
    private static final long serialVersionUID = -1935344798875773443L;
    private DCTable m_oTable;
    private DCTableModel m_oTableModel;
    private JButton m_oAddBtn;
    private JButton m_oModifyBtn;
    private JButton m_oDeleteBtn;
    private JButton m_oTestBtn;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private IUpdateExternalFTPInfo m_oUpdateExternalFTPInfo;
    private SystemSettingDlg m_oSystemSettingDlg;

    public ExternalFTPServerSettingPanel(SystemSettingDlg oSystemSettingDlg, ExternalFTPInfo[] oExternalFTPInfos) {
        this.m_oSystemSettingDlg = oSystemSettingDlg;
        this.jInit();
        this.initExternalFTPInfos(oExternalFTPInfos);
        this.updateBtnStatus();
    }

    private void jInit() {
        this.setLayout(new BorderLayout());
        Border oEmptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        TitledBorder oTitleBorder = BorderFactory.createTitledBorder(this.m_oResMgr.getResString("EXTERNAL_FTP_SETTING_TITLE"));
        CompoundBorder oBorder = BorderFactory.createCompoundBorder(oTitleBorder, oEmptyBorder);
        this.setBorder(oBorder);
        DCExternalFTPTableInfo oTableInfo = new DCExternalFTPTableInfo();
        this.m_oTableModel = new DCTableModel(oTableInfo){
            private static final long serialVersionUID = 4528574749271586185L;

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.m_oTable = new DCTable(this.m_oTableModel);
        this.m_oTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExternalFTPServerSettingPanel.this.updateBtnStatus();
            }
        });
        this.m_oTable.getColumn(oTableInfo.getHeader()[1]).setPreferredWidth(100);
        JScrollPane sp = new JScrollPane(this.m_oTable);
        this.add((Component)sp, "Center");
        this.add((Component)this.getBtnPanel(), "East");
    }

    private JPanel getBtnPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        btnPanel.setLayout(new BoxLayout(btnPanel, 3));
        Dimension oBtnSize = new Dimension(85, 21);
        Dimension oBtnSpace = new Dimension(0, 10);
        this.m_oAddBtn = new JButton(this.m_oResMgr.getResString("SYS_SETTING_MULTIPLE_NIC_ADD_BTN"));
        this.m_oAddBtn.setName("com.huawei.dc.configuration.system.ExternalFTPServerSettingPanel.m_oAddBtn");
        this.m_oAddBtn.setMnemonic('A');
        this.m_oAddBtn.setMinimumSize(oBtnSize);
        this.m_oAddBtn.setPreferredSize(oBtnSize);
        this.m_oAddBtn.setMaximumSize(oBtnSize);
        this.m_oAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFTPServerSettingPanel.this.addFTPServer();
            }
        });
        btnPanel.add(this.m_oAddBtn);
        btnPanel.add(Box.createRigidArea(oBtnSpace));
        this.m_oModifyBtn = new JButton(this.m_oResMgr.getResString("SYS_SETTING_MULTIPLE_NIC_MODIFY_BTN"));
        this.m_oModifyBtn.setName("com.huawei.dc.configuration.system.ExternalFTPServerSettingPanel.m_oModifyBtn");
        this.m_oModifyBtn.setMnemonic('M');
        this.m_oModifyBtn.setMinimumSize(oBtnSize);
        this.m_oModifyBtn.setPreferredSize(oBtnSize);
        this.m_oModifyBtn.setMaximumSize(oBtnSize);
        this.m_oModifyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFTPServerSettingPanel.this.modifyFTPServer();
            }
        });
        btnPanel.add(this.m_oModifyBtn);
        btnPanel.add(Box.createRigidArea(oBtnSpace));
        this.m_oDeleteBtn = new JButton(this.m_oResMgr.getResString("SYS_SETTING_MULTIPLE_NIC_DELETE_BTN"));
        this.m_oDeleteBtn.setName("com.huawei.dc.configuration.system.ExternalFTPServerSettingPanel.m_oDeleteBtn");
        this.m_oDeleteBtn.setMnemonic('D');
        this.m_oDeleteBtn.setMinimumSize(oBtnSize);
        this.m_oDeleteBtn.setPreferredSize(oBtnSize);
        this.m_oDeleteBtn.setMaximumSize(oBtnSize);
        this.m_oDeleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFTPServerSettingPanel.this.deleteFTPServer();
            }
        });
        btnPanel.add(this.m_oDeleteBtn);
        btnPanel.add(Box.createRigidArea(oBtnSpace));
        this.m_oTestBtn = new JButton(this.m_oResMgr.getResString("SYS_SETTING_TEST_BTN"));
        this.m_oTestBtn.setName("com.huawei.dc.configuration.system.ExternalFTPServerSettingPanel.m_oTestBtn");
        this.m_oTestBtn.setMnemonic('T');
        this.m_oTestBtn.setMinimumSize(oBtnSize);
        this.m_oTestBtn.setPreferredSize(oBtnSize);
        this.m_oTestBtn.setMaximumSize(oBtnSize);
        this.m_oTestBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFTPServerSettingPanel.this.testFTP();
            }
        });
        btnPanel.add(this.m_oTestBtn);
        return btnPanel;
    }

    private void initExternalFTPInfos(ExternalFTPInfo[] oExternalFTPInfos) {
        for (ExternalFTPInfo oExternalFTPInfo : oExternalFTPInfos) {
            this.m_oTableModel.addRow(oExternalFTPInfo);
        }
    }

    public ExternalFTPInfo[] getSelectedFTPInfos() {
        int[] iSelectRows = this.m_oTable.getSelectedRows();
        ExternalFTPInfo[] oSelectExternalFTPInfos = new ExternalFTPInfo[iSelectRows.length];
        for (int i = 0; i < iSelectRows.length; ++i) {
            oSelectExternalFTPInfos[i] = (ExternalFTPInfo)this.m_oTableModel.getRowData(iSelectRows[i]);
        }
        return oSelectExternalFTPInfos;
    }

    public ExternalFTPInfo[] getAllExternalFTPInfos() {
        int iRowCount = this.m_oTableModel.getRowCount();
        ExternalFTPInfo[] oExternalFTPInfos = new ExternalFTPInfo[iRowCount];
        for (int i = 0; i < iRowCount; ++i) {
            oExternalFTPInfos[i] = (ExternalFTPInfo)this.m_oTableModel.getRowData(i);
        }
        return oExternalFTPInfos;
    }

    private ExternalFTPInfo getExternalFTPInfoByServerName(String strServerName) {
        int iRowCount = this.m_oTableModel.getRowCount();
        for (int i = 0; i < iRowCount; ++i) {
            ExternalFTPInfo oExternalFTPInfo = (ExternalFTPInfo)this.m_oTableModel.getRowData(i);
            if (!strServerName.equals(oExternalFTPInfo.getServerName())) continue;
            return oExternalFTPInfo;
        }
        return null;
    }

    public boolean isExistFTPServer(ExternalFTPInfo oExternalFTPInfo) {
        ExternalFTPInfo[] oExternalFTPInfos;
        for (ExternalFTPInfo oTmpExternalFTPInfo : oExternalFTPInfos = this.getAllExternalFTPInfos()) {
            if (!oTmpExternalFTPInfo.isSame(oExternalFTPInfo)) continue;
            return true;
        }
        return false;
    }

    private void updateBtnStatus() {
        int iSelectRowCount = this.m_oTable.getSelectedRowCount();
        if (0 >= iSelectRowCount) {
            this.m_oModifyBtn.setEnabled(false);
            this.m_oTestBtn.setEnabled(false);
            this.m_oDeleteBtn.setEnabled(false);
        } else if (1 == iSelectRowCount) {
            this.m_oModifyBtn.setEnabled(true);
            this.m_oTestBtn.setEnabled(true);
            this.m_oDeleteBtn.setEnabled(true);
        } else {
            this.m_oModifyBtn.setEnabled(false);
            this.m_oTestBtn.setEnabled(false);
            this.m_oDeleteBtn.setEnabled(true);
        }
    }

    public void addFTPServer() {
        ConfigExternalFTPDlg oDlg = new ConfigExternalFTPDlg(this);
        oDlg.setVisible(true);
        ExternalFTPInfo oExternalFTPInfo = oDlg.getExternalFTPInfo();
        if (null != oExternalFTPInfo) {
            this.m_oTableModel.addRow(oExternalFTPInfo);
            this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            if (null != this.m_oUpdateExternalFTPInfo) {
                this.m_oUpdateExternalFTPInfo.addExternalFTPInfo(oExternalFTPInfo);
            }
        }
    }

    public void modifyFTPServer() {
        ConfigExternalFTPDlg oDlg = new ConfigExternalFTPDlg(this, true);
        oDlg.setVisible(true);
        String strServerName = oDlg.getOldServerName();
        ExternalFTPInfo oExternalFTPInfo = this.getExternalFTPInfoByServerName(strServerName);
        ExternalFTPInfo oTmpExternalFTPInfo = oDlg.getExternalFTPInfo();
        if (null != oTmpExternalFTPInfo) {
            oExternalFTPInfo.setServerName(oTmpExternalFTPInfo.getServerName());
            oExternalFTPInfo.setServerIP(oTmpExternalFTPInfo.getServerIP());
            oExternalFTPInfo.setType(oTmpExternalFTPInfo.getType());
            oExternalFTPInfo.setPort(oTmpExternalFTPInfo.getPort());
            oExternalFTPInfo.setUserName(oTmpExternalFTPInfo.getUserName());
            oExternalFTPInfo.setPassword(oTmpExternalFTPInfo.getPassword());
            this.m_oTable.updateUI();
            this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            if (null != this.m_oUpdateExternalFTPInfo) {
                this.m_oUpdateExternalFTPInfo.modifyExternalFTPInfo(strServerName, oExternalFTPInfo);
            }
        }
    }

    public void deleteFTPServer() {
        int iConfirm = DCOptionPane.showConfirmDialog((Component)this, this.m_oResMgr.getResString("DELETE_EXTERNAL_FTP_PROMPT_INFO"), this.m_oResMgr.getResString("CONFIRM"), 0);
        if (iConfirm != 0) {
            return;
        }
        SystemManager oSysMgr = new SystemManager();
        ExternalFTPInfo[] oSelectExternalFTPInfos = this.getSelectedFTPInfos();
        AsnDCCheckDeleteThirdFTPRspSeqOf oAsnCheckDeleteThirdFTPInfoLst = new AsnDCCheckDeleteThirdFTPRspSeqOf();
        try {
            AsnDCCheckDeleteThirdFTPRsp oRsp = oSysMgr.checkDeleteThirdFTP(oSelectExternalFTPInfos);
            int iErrorCode = oRsp.oErrorInfo.iErrorNo.intValue();
            if (0 != iErrorCode) {
                DCOptionPane.showErrorDialog((Component)this, iErrorCode);
                return;
            }
            oAsnCheckDeleteThirdFTPInfoLst = oRsp.oDCCheckDeleteThirdFTPInfoLst;
        }
        catch (DCException e) {
            DCOptionPane.showMessageDialog((Component)this, e.getErrorCode(), this.m_oResMgr.getResString("INFO"), 1);
            return;
        }
        int iSize = oAsnCheckDeleteThirdFTPInfoLst.size();
        if (0 < iSize) {
            String[] strColumns = new String[]{this.m_oResMgr.getResString("EXTERNAL_FTP_SERVER_NAME"), this.m_oResMgr.getResString("BACKUP_TABLE_DEVICETYPE"), this.m_oResMgr.getResString("USER_ROT_EXTERNAL_FTP")};
            TaskOperationResultDialog oResultDlg = new TaskOperationResultDialog(this.m_oResMgr.getResString("SUGGESTION"), 0, true, strColumns);
            oResultDlg.setMessage(this.m_oResMgr.getResString("EXTERNAL_FTP_DELETE_PROMPT"));
            for (int i = 0; i < iSize; ++i) {
                Vector<Object> rowData;
                AsnDCCheckDeleteThirdFTPInfo oAsnFTPInfo = (AsnDCCheckDeleteThirdFTPInfo)oAsnCheckDeleteThirdFTPInfoLst.get(i);
                String strServerName = new String(oAsnFTPInfo.strSelectedServerName);
                boolean isAddServerName = false;
                DCStringList oTaskNameLst = oAsnFTPInfo.strTaskNameLst;
                int iNameSize = oTaskNameLst.size();
                for (int j = 0; j < iNameSize; ++j) {
                    Vector<Object> rowData2 = new Vector<Object>();
                    String strTaskName = new String((byte[])oTaskNameLst.get(j));
                    if (!isAddServerName) {
                        rowData2.add(strServerName);
                        rowData2.add(this.m_oResMgr.getResString("EXTERNAL_TYPE_TASK"));
                        isAddServerName = true;
                    } else {
                        rowData2.add("");
                        rowData2.add("");
                    }
                    rowData2.add(strTaskName);
                    oResultDlg.addRowInModel(rowData2);
                }
                boolean isAddPolicyType = false;
                DCStringList oPolicyNameLst = oAsnFTPInfo.strPolicyNameLst;
                iNameSize = oPolicyNameLst.size();
                for (int j = 0; j < iNameSize; ++j) {
                    String strPolicyName = new String((byte[])oPolicyNameLst.get(j));
                    rowData = new Vector<Object>();
                    if (!isAddServerName) {
                        rowData.add(strServerName);
                        isAddServerName = true;
                    } else {
                        rowData.add("");
                    }
                    if (!isAddPolicyType) {
                        rowData.add(this.m_oResMgr.getResString("EXTERNAL_TYPE_POLICY"));
                        isAddPolicyType = true;
                    } else {
                        rowData.add("");
                    }
                    rowData.add(strPolicyName);
                    oResultDlg.addRowInModel(rowData);
                }
                boolean isUsedByDisasterRecovery = oAsnFTPInfo.bIsUsedByDisasterRecovery;
                if (!isUsedByDisasterRecovery) continue;
                String str = this.m_oResMgr.getResString("POLICY_MANAGEMENT_HA_SERVER_TAB");
                rowData = new Vector();
                if (!isAddServerName) {
                    rowData.add(strServerName);
                } else {
                    rowData.add("");
                }
                rowData.add(str);
                rowData.add(str);
                oResultDlg.addRowInModel(rowData);
            }
            oResultDlg.setVisible(true);
            return;
        }
        for (ExternalFTPInfo oSelectExternalFTPInfo : oSelectExternalFTPInfos) {
            this.m_oTableModel.removeRow(oSelectExternalFTPInfo);
            this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            if (null == this.m_oUpdateExternalFTPInfo) continue;
            this.m_oUpdateExternalFTPInfo.deleteExteranlFTPInfo(oSelectExternalFTPInfo);
        }
        this.m_oTable.updateUI();
    }

    public void testFTP() {
        ExternalFTPInfo[] oSelectExternalFTPInfos = this.getSelectedFTPInfos();
        if (1 == oSelectExternalFTPInfos.length) {
            ExternalFTPInfo oExternalFTPInfo = oSelectExternalFTPInfos[0];
            ProtocolConfigInfo oProtocolConfigInfo = new ProtocolConfigInfo();
            oProtocolConfigInfo.setServerIP(oExternalFTPInfo.getServerIP());
            oProtocolConfigInfo.setUserName(oExternalFTPInfo.getUserName());
            oProtocolConfigInfo.setPassword(oExternalFTPInfo.getPassword());
            oProtocolConfigInfo.setPortNumber(oExternalFTPInfo.getPort());
            oProtocolConfigInfo.setServerName(oExternalFTPInfo.getServerName());
            String strType = oExternalFTPInfo.getType();
            AsnProtocolEnum oAsnProtocolType = new AsnProtocolEnum();
            oAsnProtocolType.value = "SFTP".equals(strType) ? 2 : 1;
            oProtocolConfigInfo.setProtocolType(oAsnProtocolType);
            SystemManager oSysMgr = new SystemManager();
            int iErrorCode = oSysMgr.testProtocolSetting(oProtocolConfigInfo, "");
            if (iErrorCode == 0) {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("OPERTION_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
            } else {
                DCOptionPane.showMessageDialog((Component)this, iErrorCode, ResourceManager.getInstance().getResString("MODIFY_FTP_USER_ERROR"), 0);
            }
        }
    }

    public void addUpdateExternalFTPInfoListener(IUpdateExternalFTPInfo oUpdateExternalFTPInfo) {
        ExternalFTPInfo[] oExternalFTPInfos;
        this.m_oUpdateExternalFTPInfo = oUpdateExternalFTPInfo;
        for (ExternalFTPInfo oExternalFTPInfo : oExternalFTPInfos = this.getAllExternalFTPInfos()) {
            this.m_oUpdateExternalFTPInfo.addExternalFTPInfo(oExternalFTPInfo);
        }
    }
}

