/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system.externalftp;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPServerSettingPanel;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPSettingForUpgradeTaskPanel;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ExternalFTPConfigPanel
extends JPanel {
    private static final long serialVersionUID = 3208928784515751605L;
    private ExternalFTPServerSettingPanel m_oFTPServerSettingPanel;
    private ExternalFTPSettingForUpgradeTaskPanel m_oFTPSettingForUpgradeTaskPanel;

    public ExternalFTPConfigPanel(SystemSettingDlg oSystemSettingDlg, String strSelectServerName, ExternalFTPInfo[] oExternalFTPInfos) {
        this.m_oFTPServerSettingPanel = new ExternalFTPServerSettingPanel(oSystemSettingDlg, oExternalFTPInfos);
        this.m_oFTPSettingForUpgradeTaskPanel = new ExternalFTPSettingForUpgradeTaskPanel(oSystemSettingDlg, strSelectServerName);
        this.m_oFTPServerSettingPanel.addUpdateExternalFTPInfoListener(this.m_oFTPSettingForUpgradeTaskPanel);
        TaskSrcDstVersionCheck.getInstance().setThirdFTPServerName(strSelectServerName);
        this.jInit();
    }

    private void jInit() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.m_oFTPServerSettingPanel, "Center");
        this.add((Component)this.m_oFTPSettingForUpgradeTaskPanel, "South");
    }

    public boolean setExternalFTPInfo() {
        boolean bIsSuccess = true;
        try {
            ExternalFTPInfo[] oExternalFTPInfos = this.m_oFTPServerSettingPanel.getAllExternalFTPInfos();
            String strSelectServerName = this.m_oFTPSettingForUpgradeTaskPanel.getSelectedServerName();
            SystemManager oSysMgr = new SystemManager();
            int iErrorCode = oSysMgr.setExternalFTPConfiguration(strSelectServerName, oExternalFTPInfos);
            if (iErrorCode != 0) {
                DCOptionPane.showMessageDialog((Component)this, iErrorCode, DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            } else {
                TaskSrcDstVersionCheck.getInstance().setThirdFTPServerName(strSelectServerName);
            }
        }
        catch (DCException oDCException) {
            DCOptionPane.showMessageDialog((Component)this, oDCException.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            bIsSuccess = false;
        }
        return bIsSuccess;
    }

    public void disposePanel() {
        this.m_oFTPServerSettingPanel = null;
        this.m_oFTPSettingForUpgradeTaskPanel = null;
    }
}

