/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system.externalftp;

import com.huawei.dc.common.asndatacenter.AsnProtocolEnum;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.u2kcbb.U2kPasswordFiled;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.ValidationUtility;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.ProtocolConfigInfo;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPServerSettingPanel;
import com.swimap.imap12.util.InmLengthLimitTextField;
import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfigExternalFTPDlg
extends DCModalDialog {
    private static final long serialVersionUID = -3489904853774991912L;
    private static final int MAX_LENGTH = 40;
    private static final int DEFAULT_FTP_PORT = 21;
    private static final int DEFAULT_SFTP_PORT = 22;
    private InmLengthLimitTextField m_oServerNameText;
    private IPAddressTextField m_oServerIPText;
    private JComboBox m_oTypeComboBox;
    private InmLengthLimitTextField m_oUserNameText;
    private U2kPasswordFiled m_oPasswordText;
    private NumericSpinnerModel m_oPortNumberSpinnerModel;
    private Spinner m_oPortNumberSpinner = null;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private ExternalFTPServerSettingPanel m_oExternalFTPSettingPanel;
    private ExternalFTPInfo m_oExternalFTPInfo;
    private String m_strOldServerName = "";
    private boolean m_isModify = false;

    public ConfigExternalFTPDlg(ExternalFTPServerSettingPanel oExternalFTPSettingPanel) {
        this(oExternalFTPSettingPanel, false);
    }

    public ConfigExternalFTPDlg(ExternalFTPServerSettingPanel oExternalFTPSettingPanel, boolean isModify) {
        this.setSize(320, 260);
        this.m_isModify = isModify;
        this.m_oExternalFTPSettingPanel = oExternalFTPSettingPanel;
        this.jInit();
        this.initDefaultValue();
    }

    private void jInit() {
        Container oContainer = this.getContentPane();
        oContainer.setLayout(new GridBagLayout());
        GridBagConstraints oGridBag = new GridBagConstraints();
        oGridBag.insets = new Insets(10, 10, 10, 10);
        oGridBag.anchor = 21;
        oGridBag.weightx = 0.1;
        oGridBag.gridwidth = 1;
        int x = 0;
        int y = 0;
        JLabel oServerNameLbl = new JLabel(this.m_oResMgr.getResString("EXTERNAL_FTP_SERVER_NAME_LABEL_TEXT"));
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add(oServerNameLbl, oGridBag);
        oGridBag.insets = new Insets(0, 10, 10, 10);
        JLabel oServerIPLbl = new JLabel(this.m_oResMgr.getResString("EXTERNAL_FTP_SERVER_IP_LABEL_TEXT"));
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add(oServerIPLbl, oGridBag);
        JLabel oTypeLbl = new JLabel(this.m_oResMgr.getResString("EXTERNAL_FTP_TYPE_LABEL_TEXT"));
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add(oTypeLbl, oGridBag);
        JLabel oPortLbl = new JLabel(this.m_oResMgr.getResString("EXTERNAL_FTP_PORT_LABEL_TEXT"));
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add(oPortLbl, oGridBag);
        JLabel oUserNameLbl = new JLabel(this.m_oResMgr.getResString("EXTERNAL_FTP_USER_NAME_LABEL_TEXT"));
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add(oUserNameLbl, oGridBag);
        JLabel oPasswordLbl = new JLabel(this.m_oResMgr.getResString("EXTERNAL_FTP_PASSWORD_LABEL_TEXT"));
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add(oPasswordLbl, oGridBag);
        oGridBag.insets = new Insets(10, 10, 10, 10);
        oGridBag.fill = 2;
        oGridBag.weightx = 1.0;
        oGridBag.gridwidth = 3;
        x = 1;
        y = 0;
        this.m_oServerNameText = new InmLengthLimitTextField(40);
        this.m_oServerNameText.setToolTipText(this.m_oResMgr.getResString("EXTERNAL_FTP_SERVER_NAME_CANNOT_HAVE_SPECIAL_CHARACTERS"));
        this.m_oServerNameText.setName("com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg.m_oServerNameText");
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add((Component)this.m_oServerNameText, oGridBag);
        oGridBag.insets = new Insets(0, 10, 10, 10);
        this.m_oServerIPText = new IPAddressTextField();
        this.m_oServerIPText.setName("com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg.m_oServerIPText");
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add((Component)this.m_oServerIPText, oGridBag);
        this.m_oTypeComboBox = new JComboBox();
        this.m_oTypeComboBox.setName("com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg.m_oTypeComboBox");
        this.m_oTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if ("FTP".equals(e.getItem())) {
                    ConfigExternalFTPDlg.this.m_oPortNumberSpinnerModel.setValue((Object)21);
                } else {
                    ConfigExternalFTPDlg.this.m_oPortNumberSpinnerModel.setValue((Object)22);
                }
            }
        });
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add(this.m_oTypeComboBox, oGridBag);
        this.m_oPortNumberSpinnerModel = new NumericSpinnerModel(21, 1, 65535, 1);
        this.m_oPortNumberSpinner = new Spinner((SpinnerModel)this.m_oPortNumberSpinnerModel);
        this.m_oPortNumberSpinner.setName("com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg.oPortNumberSpinner");
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add((Component)this.m_oPortNumberSpinner, oGridBag);
        this.m_oUserNameText = new InmLengthLimitTextField(40);
        this.m_oUserNameText.setName("com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg.m_oUserNameText");
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add((Component)this.m_oUserNameText, oGridBag);
        this.m_oPasswordText = new U2kPasswordFiled(40);
        this.m_oPasswordText.setName("com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg.m_oPasswordText");
        oGridBag.gridx = x;
        oGridBag.gridy = y++;
        this.add(this.m_oPasswordText, oGridBag);
        oGridBag.gridwidth = 4;
        oGridBag.gridx = 0;
        oGridBag.gridy = y;
        this.add(this.getBtnPanel(), oGridBag);
    }

    private JPanel getBtnPanel() {
        JPanel oBtnPanel = new JPanel(new FlowLayout());
        Dimension oSize = new Dimension(80, 22);
        JButton oTestBtn = new JButton(this.m_oResMgr.getResString("SYS_SETTING_TEST_BTN"));
        oTestBtn.setName("com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg.oTestBtn");
        oTestBtn.setMnemonic('T');
        oTestBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigExternalFTPDlg.this.testXFTP();
            }
        });
        oTestBtn.setMinimumSize(oSize);
        oTestBtn.setPreferredSize(oSize);
        oTestBtn.setMaximumSize(oSize);
        this.m_oOKBtn.setText(this.m_oResMgr.getResString("OK_BTN"));
        this.m_oOKBtn.setName("com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg.m_oOKBtn");
        this.m_oOKBtn.setMinimumSize(oSize);
        this.m_oOKBtn.setPreferredSize(oSize);
        this.m_oOKBtn.setMaximumSize(oSize);
        this.m_oCancelBtn.setText(this.m_oResMgr.getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setName("com.huawei.dc.configuration.system.externalftp.ConfigExternalFTPDlg.m_oCancelBtn");
        this.m_oCancelBtn.setMinimumSize(oSize);
        this.m_oCancelBtn.setPreferredSize(oSize);
        this.m_oCancelBtn.setMaximumSize(oSize);
        oBtnPanel.add(oTestBtn);
        oBtnPanel.add(this.m_oOKBtn);
        oBtnPanel.add(this.m_oCancelBtn);
        return oBtnPanel;
    }

    private void initDefaultValue() {
        this.m_oTypeComboBox.addItem("FTP");
        this.m_oTypeComboBox.addItem("SFTP");
        if (this.m_isModify) {
            ExternalFTPInfo oExternalFTPInfo = this.m_oExternalFTPSettingPanel.getSelectedFTPInfos()[0];
            this.setTitle(this.m_oResMgr.getResString("MODIFY_EXTERNAL_FTP_DLG_TITLE"));
            this.m_strOldServerName = oExternalFTPInfo.getServerName();
            this.m_oServerNameText.setText(this.m_strOldServerName);
            this.m_oServerIPText.setText(oExternalFTPInfo.getServerIP());
            this.m_oTypeComboBox.setSelectedItem(oExternalFTPInfo.getType());
            this.m_oPortNumberSpinnerModel.setValue((Object)oExternalFTPInfo.getPort());
            this.m_oUserNameText.setText(oExternalFTPInfo.getUserName());
            this.m_oPasswordText.setPassword(oExternalFTPInfo.getPassword());
            this.m_oServerNameText.setEditable(false);
            this.m_oServerIPText.setEditable(false);
            this.m_oTypeComboBox.setEnabled(false);
            this.m_oPortNumberSpinner.setEnabled(false);
        } else {
            this.setTitle(this.m_oResMgr.getResString("ADD_EXTERNAL_FTP_DLG_TITLE"));
        }
    }

    private void testXFTP() {
        ExternalFTPInfo oTmpExternalFTPInfo = this.constructExternalFTPInfo();
        if (!this.validateField(oTmpExternalFTPInfo, false)) {
            return;
        }
        ProtocolConfigInfo oProtocolConfigInfo = new ProtocolConfigInfo();
        oProtocolConfigInfo.setServerIP(oTmpExternalFTPInfo.getServerIP());
        oProtocolConfigInfo.setUserName(oTmpExternalFTPInfo.getUserName());
        oProtocolConfigInfo.setPassword(oTmpExternalFTPInfo.getPassword());
        oProtocolConfigInfo.setPortNumber(oTmpExternalFTPInfo.getPort());
        oProtocolConfigInfo.setServerName(oTmpExternalFTPInfo.getServerName());
        String strType = oTmpExternalFTPInfo.getType();
        AsnProtocolEnum oAsnProtocolType = new AsnProtocolEnum();
        oAsnProtocolType.value = "SFTP".equals(strType) ? 2 : 1;
        oProtocolConfigInfo.setProtocolType(oAsnProtocolType);
        SystemManager oSysMgr = new SystemManager();
        int iErrorCode = oSysMgr.testProtocolSetting(oProtocolConfigInfo, "");
        if (iErrorCode == 0) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("OPERTION_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
        } else {
            DCOptionPane.showMessageDialog((Component)((Object)this), iErrorCode, ResourceManager.getInstance().getResString("MODIFY_FTP_USER_ERROR"), 0);
        }
    }

    @Override
    public void oKButton_ActionPerformed() {
        ExternalFTPInfo oTmpExternalFTPInfo = this.constructExternalFTPInfo();
        if (!this.validateField(oTmpExternalFTPInfo, true)) {
            return;
        }
        this.m_oExternalFTPInfo = oTmpExternalFTPInfo;
        super.closeDialog();
    }

    private ExternalFTPInfo constructExternalFTPInfo() {
        ExternalFTPInfo oTmpExternalFTPInfo = new ExternalFTPInfo();
        oTmpExternalFTPInfo.setServerName(this.m_oServerNameText.getText());
        try {
            oTmpExternalFTPInfo.setServerIP(this.m_oServerIPText.getTrimedAddress());
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        oTmpExternalFTPInfo.setType(this.m_oTypeComboBox.getSelectedItem().toString());
        oTmpExternalFTPInfo.setPort((Integer)this.m_oPortNumberSpinnerModel.getValue());
        oTmpExternalFTPInfo.setUserName(this.m_oUserNameText.getText());
        oTmpExternalFTPInfo.setPassword(this.m_oPasswordText.getPasswordInChar());
        return oTmpExternalFTPInfo;
    }

    @Override
    protected void closeDialog() {
        this.m_oExternalFTPInfo = null;
        super.closeDialog();
    }

    public ExternalFTPInfo getExternalFTPInfo() {
        return this.m_oExternalFTPInfo;
    }

    public String getOldServerName() {
        return this.m_strOldServerName;
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    private boolean validateField(ExternalFTPInfo oExternalFTPInfo, boolean isVerifyServerName) {
        boolean bValidate = true;
        String strServerName = this.m_oServerNameText.getText();
        String strUserName = this.m_oUserNameText.getText();
        if ("".equals(strServerName.trim())) {
            this.showMessageDialog(this.m_oResMgr.getResString("EXTERNAL_FTP_SERVER_NAME_INCORRECT"));
            bValidate = false;
        } else if ("".equals(strUserName.trim())) {
            this.showMessageDialog(this.m_oResMgr.getResString("USER_NAME_BLANK"));
            bValidate = false;
        } else if (!".   .   .".equals(this.m_oServerIPText.getText().trim())) {
            try {
                this.m_oServerIPText.getTrimedAddress();
            }
            catch (InValideIPAddressException e) {
                this.showMessageDialog(this.m_oResMgr.getResString("EXTERNAL_FTP_IP_INCORRECT"));
                this.m_oServerIPText.requestFocus();
                this.m_oServerIPText.setFocusable(true);
                bValidate = false;
            }
        } else if (".   .   .".equals(this.m_oServerIPText.getText().trim())) {
            this.showMessageDialog(this.m_oResMgr.getResString("EXTERNAL_FTP_SERVER_NAME_INCORRECT"));
            bValidate = false;
        } else {
            bValidate = true;
        }
        if (bValidate && isVerifyServerName) {
            if (!ValidationUtility.validateName(strServerName, true)) {
                this.showMessageDialog(this.m_oResMgr.getResString("EXTERNAL_FTP_SERVER_NAME_CANNOT_HAVE_SPECIAL_CHARACTERS"));
                bValidate = false;
            } else {
                boolean isCheckServerName = true;
                if (this.m_isModify && strServerName.equals(this.m_strOldServerName)) {
                    isCheckServerName = false;
                }
                if (isCheckServerName && this.m_oExternalFTPSettingPanel.isExistFTPServer(oExternalFTPInfo)) {
                    this.showMessageDialog(this.m_oResMgr.getResString("EXTERNAL_FTP_SERVER_REPEAT"));
                    bValidate = false;
                }
            }
        }
        return bValidate;
    }

    private void showMessageDialog(String strMessage) {
        DCOptionPane.showMessageDialog((Component)((Object)this), strMessage, this.m_oResMgr.getResString("INFO"), 1);
    }
}

