/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceProtocolInfo;
import com.huawei.dc.common.asndatacenter.AsnDCProtocolInfoList;
import com.huawei.dc.common.asndatacenter.AsnSystemSettingInfoRsp;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.system.SystemSettingUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.DevcieProtocolSettingInfo;
import com.huawei.dc.configuration.system.ProtocolFactory;
import com.huawei.dc.configuration.system.ProtocolInfo;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.framework.XFtpFileOperationFactory;
import com.huawei.u2000.framework.adaptive.AdaptiveUtil;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class TransferProtocolPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int PROTOCOL_INFO = 1;
    private static final int DEVICE_INFO_COL = 0;
    private static final int DEVICE_TYPE = 0;
    private boolean m_bShowConfirmation = true;
    private JPanel m_oDeviceProtocolConfPanel = null;
    private JScrollPane m_oDeviceTableScrollPane = null;
    private JTable m_oDeviceTable = null;
    private SystemSettingDlg m_oSystemSettingDlg = null;
    private HashMap<DeviceTypeInfo, ProtocolInfo> m_oProtocolConfigInfo;
    private static final int PROTOCOL_COLUMN_INDEX = 1;
    private ISystemManager m_oSystemMgr;
    private DevcieProtocolSettingInfo[] m_arrDeviceProtocolSettingInfo;
    private ProtocolFactory m_oProtocolFactory;
    private ComboBoxWithToolTip[] m_oProtocolCombox = null;
    private DefaultTableModel m_oTableModel = null;
    private SortButtonRenderer m_oSortButtonRenderer;
    private transient TableCellRenderer tableCellRenderer = new TableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
            JLabel oLabel = new JLabel();
            oLabel.setOpaque(true);
            if (isSelected) {
                oLabel.setBackground(table.getSelectionBackground());
                oLabel.setForeground(Color.white);
            } else {
                oLabel.setBackground(table.getBackground());
                oLabel.setForeground(table.getForeground());
            }
            if (null != value) {
                oLabel.setText(value.toString());
                oLabel.setToolTipText(value.toString());
            }
            return oLabel;
        }
    };

    public TransferProtocolPanel(SystemSettingDlg oSystemSettingDlg, AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp) {
        this.m_oProtocolFactory = ProtocolFactory.getInstance();
        this.m_oSystemSettingDlg = oSystemSettingDlg;
        this.m_oProtocolConfigInfo = new HashMap(0);
        this.jbinit(oAsnSystemSettingInfoRsp);
    }

    private void jbinit(AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp) {
        this.setLayout(null);
        this.m_oDeviceProtocolConfPanel = new JPanel(null);
        this.initializeSystemManager();
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            JPanel panel = new JPanel(null);
            JLabel oServerFileTranProLabel = new JLabel(this.getLocalisedString("SERVER_FILE_TRANSFER_PROTOCOL_LAB"));
            oServerFileTranProLabel.setBounds(7, 20, 200, 20);
            panel.add(oServerFileTranProLabel);
            this.add(panel);
        }
        if (!(DCFrameWorkUtil.getIsSingleClient() || AdaptiveUtil.isSubsystemDeployed((String)"access") && AdaptiveUtil.isSubsystemDeployed((String)"nemgr_router") && AdaptiveUtil.isSubsystemDeployed((String)"trans_common"))) {
            AsnDCProtocolInfoList oAsnDCProtocolInfoList = oAsnSystemSettingInfoRsp.oDeviceProtocolInfoList;
            AsnDCDeviceProtocolInfo oAsnDCDeviceProtocolInfo = new AsnDCDeviceProtocolInfo();
            AsnDCProtocolInfoList oAsnDCProtocolInfoListSel = new AsnDCProtocolInfoList();
            DeviceTypeInfo oDeviceTypeInfo = new DeviceTypeInfo();
            for (int i = 0; i < oAsnDCProtocolInfoList.size(); ++i) {
                oAsnDCDeviceProtocolInfo = (AsnDCDeviceProtocolInfo)oAsnDCProtocolInfoList.get(i);
                oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(oAsnDCDeviceProtocolInfo.iDeviceTypeId.intValue(), oAsnDCDeviceProtocolInfo.iDeviceVersionId.intValue());
                if (null == oDeviceTypeInfo) continue;
                if (AdaptiveUtil.isSubsystemDeployed((String)"access") && oDeviceTypeInfo.getDevDomain() == 1) {
                    oAsnDCProtocolInfoListSel.add((Object)oAsnDCDeviceProtocolInfo);
                    continue;
                }
                if (AdaptiveUtil.isSubsystemDeployed((String)"nemgr_router") && oDeviceTypeInfo.getDevDomain() == 2) {
                    oAsnDCProtocolInfoListSel.add((Object)oAsnDCDeviceProtocolInfo);
                    continue;
                }
                if (!AdaptiveUtil.isSubsystemDeployed((String)"trans_common") || oDeviceTypeInfo.getDevDomain() != 4) continue;
                oAsnDCProtocolInfoListSel.add((Object)oAsnDCDeviceProtocolInfo);
            }
            oAsnSystemSettingInfoRsp.oDeviceProtocolInfoList = oAsnDCProtocolInfoListSel;
        }
        this.createTable(oAsnSystemSettingInfoRsp);
        TitledBorder oTitledBorder = BorderFactory.createTitledBorder(this.getLocalisedString("DEV_PROTOCOL_CONFIG"));
        this.m_oDeviceProtocolConfPanel.setBorder(oTitledBorder);
        this.m_oDeviceProtocolConfPanel.setBounds(7, 10, 528, 348);
        this.m_oDeviceProtocolConfPanel.add(this.m_oDeviceTableScrollPane);
        JLabel oDevCOnfigNoteLabel = new JLabel(this.getLocalisedString("DEV_PROTOCOL_CONFIG_NOTE"));
        if (DCFrameWorkUtil.getIsSingleClient()) {
            oDevCOnfigNoteLabel.setBounds(10, 20, 480, 40);
        } else {
            oDevCOnfigNoteLabel.setBounds(20, 15, 480, 40);
        }
        this.m_oDeviceProtocolConfPanel.add(oDevCOnfigNoteLabel);
        if (this.getIsSupportFTPFileTranProtocal()) {
            this.add(this.m_oDeviceProtocolConfPanel);
        }
        this.m_oSystemSettingDlg.getApplyButton().setEnabled(false);
        this.setVisible(true);
    }

    private void initializeSystemManager() {
        this.m_oSystemMgr = new SystemManager();
    }

    private void createTable(AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp) {
        this.createTableModel();
        this.m_oDeviceTable = new JTable(this.m_oTableModel);
        this.initProtocolInfo(oAsnSystemSettingInfoRsp);
        this.m_oDeviceTable.getColumnModel().getColumn(1).setCellRenderer(new ProtocolColumnRenderer());
        if (this.m_oProtocolCombox.length > 0 && this.getIsSupportFTPFileTranProtocal()) {
            this.m_oDeviceTable.getColumnModel().getColumn(1).setCellEditor(new ProtocolColumnEditor(this.m_oProtocolCombox[0]));
        }
        this.m_oDeviceTable.setName("SystemSetting_TransferProtocolPanel_m_oDeviceTable");
        this.m_oDeviceTable.getColumnModel().getColumn(0).setCellRenderer(this.tableCellRenderer);
        this.m_oDeviceTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                char keyCode = e.getKeyChar();
                String keyStr = String.valueOf(keyCode).toLowerCase();
                for (int i = 0; i < TransferProtocolPanel.this.m_oDeviceTable.getRowCount(); ++i) {
                    if (TransferProtocolPanel.this.m_oDeviceTable.getModel().getValueAt(i, 0) == null) {
                        return;
                    }
                    String devTypeInfo = TransferProtocolPanel.this.m_oDeviceTable.getModel().getValueAt(i, 0).toString().toLowerCase();
                    if (!devTypeInfo.toLowerCase().startsWith(keyStr)) continue;
                    TransferProtocolPanel.this.m_oDeviceTable.setRowSelectionInterval(i, i);
                    Rectangle oRect = TransferProtocolPanel.this.m_oDeviceTable.getCellRect(i, 0, true);
                    TransferProtocolPanel.this.m_oDeviceTable.scrollRectToVisible(oRect);
                    return;
                }
            }
        });
        this.m_oDeviceTableScrollPane = new JScrollPane(this.m_oDeviceTable);
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.m_oDeviceTableScrollPane.setBounds(13, 75, 503, 259);
        } else {
            this.m_oDeviceTableScrollPane.setBounds(13, 65, 503, 253);
        }
        this.m_oDeviceTable.setRowHeight(21);
        this.m_oDeviceTable.getTableHeader().setPreferredSize(new Dimension(this.m_oDeviceTable.getSize().width, 21));
        this.m_oDeviceTable.getTableHeader().setReorderingAllowed(false);
        this.m_oSortButtonRenderer = new SortButtonRenderer();
        this.m_oSortButtonRenderer.setName("System_TransferProtocolPanel_m_oSortButtonRenderer");
        this.m_oDeviceTable.getTableHeader().addMouseListener(this.generateMouseAdapterForTableHeader());
        this.m_oDeviceTable.getColumnModel().getColumn(0).setHeaderRenderer((TableCellRenderer)this.m_oSortButtonRenderer);
    }

    private MouseAdapter generateMouseAdapterForTableHeader() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TransferProtocolPanel.this.fileInfoTableHeader_MousePressed(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TransferProtocolPanel.this.setCursorState();
            }
        };
    }

    protected void setCursorState() {
        DCFrameWorkUtil.setCursor(this, Cursor.getPredefinedCursor(0));
    }

    private void createTableModel() {
        Object[] oTableColumns = new String[]{ResourceManager.getInstance().getResString("DEVICE_TYPE"), ResourceManager.getInstance().getResString("PROTOCOL")};
        this.m_oTableModel = new DefaultTableModel(oTableColumns, 0){
            private static final long serialVersionUID = -7918896678332006306L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
    }

    private void fileInfoTableHeader_MousePressed(MouseEvent oMouseEvent) {
        if (0 == (0x10 & oMouseEvent.getModifiers())) {
            return;
        }
        if (this.m_oDeviceTable.getRowCount() <= 0) {
            return;
        }
        int iCurrentColumn = this.m_oDeviceTable.getTableHeader().columnAtPoint(oMouseEvent.getPoint());
        if (0 != iCurrentColumn) {
            return;
        }
        boolean bSortType = this.m_oSortButtonRenderer.getState(iCurrentColumn) == 1;
        this.sortAllRowsBy(this.m_oTableModel, iCurrentColumn, bSortType);
        this.m_oSortButtonRenderer.setSelectedColumn(iCurrentColumn);
        this.m_oDeviceTable.getColumnModel().getColumn(1).setCellRenderer(new ProtocolColumnRenderer());
        if (this.getIsSupportFTPFileTranProtocal()) {
            this.m_oDeviceTable.getColumnModel().getColumn(1).setCellEditor(new ProtocolColumnEditor(this.m_oProtocolCombox[0]));
        }
        this.m_oDeviceTable.getColumnModel().getColumn(0).setCellRenderer(this.tableCellRenderer);
        this.m_oDeviceTable.getColumnModel().getColumn(0).setHeaderRenderer((TableCellRenderer)this.m_oSortButtonRenderer);
        this.m_oDeviceTable.getTableHeader().repaint();
        this.m_oDeviceTable.updateUI();
        this.m_oDeviceTable.repaint();
    }

    public void sortAllRowsBy(DefaultTableModel model, int colIndex, boolean ascending) {
        Vector<Vector> dataVector = model.getDataVector();
        Collections.sort(dataVector, new ColumnSorter(colIndex, ascending));
        model.setDataVector(dataVector, this.getColumnVector());
        this.m_oProtocolCombox = new ComboBoxWithToolTip[dataVector.size()];
        for (int i = 0; i < dataVector.size(); ++i) {
            Object oTmpObj = dataVector.get(i).get(1);
            if (oTmpObj instanceof ComboBoxWithToolTip) {
                this.m_oProtocolCombox[i] = (ComboBoxWithToolTip)dataVector.get(i).get(1);
                continue;
            }
            if (oTmpObj instanceof ProtocolInfo) {
                DCDebugTracer.trace("ProtocolInfo");
                continue;
            }
            if (!(oTmpObj instanceof String)) continue;
            DeviceTypeInfo oDevTypeInfo = (DeviceTypeInfo)dataVector.get(i).get(0);
            ProtocolInfo oPro = this.m_oProtocolConfigInfo.get(oDevTypeInfo);
            this.m_oProtocolCombox[i] = this.constructCombox(oPro);
            this.m_oProtocolCombox[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int iRow = TransferProtocolPanel.this.m_oDeviceTable.getSelectedRow();
                    DeviceTypeInfo oDevType = (DeviceTypeInfo)TransferProtocolPanel.this.m_oTableModel.getValueAt(iRow, 0);
                    String ss = e.getItem().toString();
                    TransferProtocolPanel.this.m_oTableModel.getDataVector().get(iRow).setElementAt(ss, 1);
                    int iProId = ProtocolFactory.getInstance().getProtocolID(ss);
                    ((ProtocolInfo)TransferProtocolPanel.this.m_oProtocolConfigInfo.get(oDevType)).setProtoTypeId(iProId);
                    TransferProtocolPanel.this.m_oSystemSettingDlg.getApplyButton().setEnabled(true);
                }
            });
        }
        model.fireTableDataChanged();
    }

    private Vector<String> getColumnVector() {
        Vector<String> oColumnVct = new Vector<String>(2);
        oColumnVct.addElement(ResourceManager.getInstance().getResString("DEVICE_TYPE"));
        oColumnVct.addElement(ResourceManager.getInstance().getResString("PROTOCOL"));
        return oColumnVct;
    }

    private void initProtocolInfo(AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp) {
        try {
            if (null == oAsnSystemSettingInfoRsp) {
                oAsnSystemSettingInfoRsp = this.m_oSystemMgr.getDeviceProtocolInfo();
            }
            SystemSettingUtil oSysSettingUtil = new SystemSettingUtil();
            this.m_arrDeviceProtocolSettingInfo = oSysSettingUtil.getDeviceProtocolConfigInfo(oAsnSystemSettingInfoRsp);
            this.initPrococolCombox(this.m_arrDeviceProtocolSettingInfo);
        }
        catch (DCException ex) {
            DCDebugTracer.trace(ex);
            DCOptionPane.showMessageDialog((Component)this, ex.getErrorCode(), ResourceManager.getInstance().getResString("PROTOCOL_INFO_ERROR"), 0);
            this.m_oSystemSettingDlg.dispose();
        }
    }

    private void initPrococolCombox(DevcieProtocolSettingInfo[] arrDeviceProtocolSettingInfo) {
        if (null == arrDeviceProtocolSettingInfo) {
            return;
        }
        int iNoOfDevice = arrDeviceProtocolSettingInfo.length;
        for (int index = 0; index < iNoOfDevice; ++index) {
            DevcieProtocolSettingInfo oDeviceProtocolInfo = arrDeviceProtocolSettingInfo[index];
            DeviceTypeInfo oDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(oDeviceProtocolInfo.getDeviceTypeId(), oDeviceProtocolInfo.getDeviceVersionId());
            oDeviceProtocolInfo.setODevTypeInfo(oDevTypeInfo);
        }
        Arrays.sort(arrDeviceProtocolSettingInfo);
        ArrayList<ComboBoxWithToolTip> oProtocolComboxLst = new ArrayList<ComboBoxWithToolTip>();
        ArrayList<DeviceTypeInfo> oDevTypeLst = new ArrayList<DeviceTypeInfo>();
        int iSize = arrDeviceProtocolSettingInfo.length;
        Vector<Serializable> oRowVector = null;
        for (int index = 0; index < iSize; ++index) {
            DevcieProtocolSettingInfo oDeviceProtocolInfo = arrDeviceProtocolSettingInfo[index];
            DeviceTypeInfo oDevTypeInfo = oDeviceProtocolInfo.getODevTypeInfo();
            if (null == oDevTypeInfo) continue;
            oRowVector = new Vector<Serializable>(2);
            oRowVector.addElement(oDevTypeInfo);
            oDevTypeLst.add(oDevTypeInfo);
            List<Integer> oProIDLst = this.getProcotolIdLst(oDeviceProtocolInfo.getProtocolList().toArray());
            ProtocolInfo protocolInfo = this.m_oProtocolFactory.getProtocolInfo(oDeviceProtocolInfo.getProtocolType());
            protocolInfo.setProtocolTypeIdLst(oProIDLst);
            if (protocolInfo.getProtoTypeId() < 1) {
                DCDebugTracer.trace("DC:: protocol error get error oDevTypeInfo= " + oDevTypeInfo + " protocaltypeid=" + protocolInfo.getProtoTypeId());
            }
            ComboBoxWithToolTip oProtocolCombox = this.constructCombox(protocolInfo);
            oProtocolCombox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int iRow = TransferProtocolPanel.this.m_oDeviceTable.getSelectedRow();
                    DeviceTypeInfo oDevType = (DeviceTypeInfo)TransferProtocolPanel.this.m_oTableModel.getValueAt(iRow, 0);
                    String ss = e.getItem().toString();
                    TransferProtocolPanel.this.m_oTableModel.getDataVector().get(iRow).setElementAt(ss, 1);
                    int iProId = ProtocolFactory.getInstance().getProtocolID(ss);
                    ((ProtocolInfo)TransferProtocolPanel.this.m_oProtocolConfigInfo.get(oDevType)).setProtoTypeId(iProId);
                    TransferProtocolPanel.this.m_oSystemSettingDlg.getApplyButton().setEnabled(true);
                }
            });
            oRowVector.addElement(oProtocolCombox);
            this.m_oTableModel.addRow(oRowVector);
            oProtocolComboxLst.add(oProtocolCombox);
            this.m_oProtocolConfigInfo.put(oDevTypeInfo, protocolInfo);
        }
        this.m_oProtocolCombox = oProtocolComboxLst.toArray(new ComboBoxWithToolTip[0]);
    }

    private ComboBoxWithToolTip constructCombox(ProtocolInfo oProtocolInfo) {
        ComboBoxWithToolTip oComBox = new ComboBoxWithToolTip();
        List<Integer> oProIDLst = oProtocolInfo.getProtocolTypeIdLst();
        for (int i = 0; i < oProIDLst.size(); ++i) {
            String item = ProtocolFactory.getInstance().getProtocolInfo(oProIDLst.get(i)).toString();
            oComBox.addItem(item);
            if (oProIDLst.get(i).intValue() != oProtocolInfo.getProtoTypeId()) continue;
            oComBox.setSelectedIndex(i);
        }
        return oComBox;
    }

    private List<Integer> getProcotolIdLst(Object[] oArrProtcolType) {
        ArrayList<Integer> oProIdLst = new ArrayList<Integer>();
        for (int iProtocolListIndex = 0; iProtocolListIndex < oArrProtcolType.length; ++iProtocolListIndex) {
            Integer iProTyhpeID = Integer.valueOf(oArrProtcolType[iProtocolListIndex].toString());
            oProIdLst.add(iProTyhpeID);
        }
        return oProIdLst;
    }

    private String getLocalisedString(String strkey) {
        return ResourceManager.getInstance().getResString(strkey);
    }

    public void setShowConfirmation(boolean bval) {
        this.m_bShowConfirmation = bval;
    }

    public boolean setProtocolDeviceInfo() {
        try {
            int iRowCount = this.m_oTableModel.getRowCount();
            int iErrorCode = -1;
            this.m_arrDeviceProtocolSettingInfo = new DevcieProtocolSettingInfo[iRowCount];
            for (int iRowIndex = 0; iRowIndex < iRowCount; ++iRowIndex) {
                this.m_arrDeviceProtocolSettingInfo[iRowIndex] = new DevcieProtocolSettingInfo();
                DeviceTypeInfo oDevTypeInfo = (DeviceTypeInfo)this.m_oTableModel.getValueAt(iRowIndex, 0);
                if (null == oDevTypeInfo) {
                    DCDebugTracer.trace("DC:: protocol error set error device type is null");
                    continue;
                }
                this.m_arrDeviceProtocolSettingInfo[iRowIndex].setDeviceTypeId(oDevTypeInfo.getDevTypeID());
                this.m_arrDeviceProtocolSettingInfo[iRowIndex].setDeviceVersion(oDevTypeInfo.getDevTypeVersionId());
                Object oo = this.m_oTableModel.getValueAt(iRowIndex, 1);
                if (oo instanceof String) {
                    DCDebugTracer.trace("oDevTypeInfo : " + oDevTypeInfo + "oProtocolType : " + oo);
                    oo = this.m_oProtocolCombox[iRowIndex];
                }
                ProtocolInfo oProtocolType = null;
                if (oo instanceof ProtocolInfo) {
                    oProtocolType = (ProtocolInfo)this.m_oTableModel.getValueAt(iRowIndex, 1);
                } else if (oo instanceof ComboBoxWithToolTip) {
                    String sPro = (String)((ComboBoxWithToolTip)oo).getSelectedItem();
                    oProtocolType = this.m_oProtocolConfigInfo.get(oDevTypeInfo);
                    int iProID = ProtocolFactory.getInstance().getProtocolID(sPro);
                    oProtocolType.setProtoTypeId(iProID);
                }
                if (null == oProtocolType) {
                    DCDebugTracer.trace("DC:: protocol error set error protocol is null");
                    continue;
                }
                if (oProtocolType.getProtoTypeId() < 1) {
                    DCDebugTracer.trace("DC:: protocol error set error devType= " + oDevTypeInfo + " protocaltypeid=" + oProtocolType.getProtoTypeId());
                }
                this.m_arrDeviceProtocolSettingInfo[iRowIndex].setProtocolType(oProtocolType.getProtoTypeId());
            }
            if (!DCFrameWorkUtil.getIsSingleClient()) {
                int xFtpType = XFtpFileOperationFactory.getXFtpType();
                iErrorCode = this.m_oSystemMgr.setDeviceProtocolInfo(this.m_arrDeviceProtocolSettingInfo, xFtpType);
            } else {
                iErrorCode = this.m_oSystemMgr.setDeviceProtocolInfo(this.m_arrDeviceProtocolSettingInfo, 1);
            }
            this.displayMessageResult(iErrorCode);
        }
        catch (DCException oDCException) {
            DCOptionPane.showMessageDialog((Component)((Object)this.m_oSystemSettingDlg), oDCException.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DCDebugTracer.trace("DC::TransferProtocolPanel::setProtocolDeviceInfo()::throw exception::" + oDCException.getMessage());
            return false;
        }
        catch (Exception ignore) {
            return false;
        }
        return true;
    }

    private void displayMessageResult(int iErrorCode) {
        if (iErrorCode == 0) {
            if (this.m_bShowConfirmation) {
                DCOptionPane.showMessageDialog((Component)this, 0, ResourceManager.getInstance().getResString("INFO"), 1);
            }
        } else {
            this.showMessageDialog(iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    private void showMessageDialog(int iErrorCode, String strErrorType, int iOptionType) {
        DCOptionPane.showMessageDialog((Component)((Object)this.m_oSystemSettingDlg), iErrorCode, strErrorType, iOptionType);
    }

    public JTable getDeviceTable() {
        return this.m_oDeviceTable;
    }

    public void disposePanel() {
        this.m_oDeviceProtocolConfPanel = null;
        this.m_oDeviceTableScrollPane = null;
        this.m_oDeviceTable = null;
        this.m_oSystemSettingDlg = null;
        if (null != this.m_oProtocolConfigInfo) {
            this.m_oProtocolConfigInfo.clear();
        }
        this.m_oProtocolConfigInfo = null;
        this.m_oSystemMgr = null;
        if (null != this.m_arrDeviceProtocolSettingInfo && this.m_arrDeviceProtocolSettingInfo.length > 0) {
            for (int i = 0; i < this.m_arrDeviceProtocolSettingInfo.length; ++i) {
                if (null == this.m_arrDeviceProtocolSettingInfo[i].getProtocolList()) continue;
                this.m_arrDeviceProtocolSettingInfo[i].getProtocolList().clear();
            }
        }
        this.m_arrDeviceProtocolSettingInfo = null;
        if (null != this.m_oProtocolFactory) {
            ProtocolFactory.oProtocoltable.clear();
        }
        this.m_oProtocolFactory = null;
    }

    private boolean getIsSupportFTPFileTranProtocal() {
        return DCFrameWorkUtil.getIsSingleClient() || AdaptiveUtil.isSubsystemDeployed((String)"access") || AdaptiveUtil.isSubsystemDeployed((String)"nemgr_router") || AdaptiveUtil.isSubsystemDeployed((String)"trans_common");
    }

    private class ProtocolColumnEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 5908399744710383623L;

        public ProtocolColumnEditor(ComboBoxWithToolTip boardComBox) {
            super(boardComBox);
        }

        @Override
        public ComboBoxWithToolTip getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return TransferProtocolPanel.this.m_oProtocolCombox[row];
        }
    }

    private class ProtocolColumnRenderer
    extends ComboBoxWithToolTip
    implements TableCellRenderer {
        private static final long serialVersionUID = -9083442540821584512L;

        private ProtocolColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TransferProtocolPanel.this.m_oProtocolCombox[row].setBackground(table.getBackground());
            return TransferProtocolPanel.this.m_oProtocolCombox[row];
        }
    }

    private class ColumnSorter
    implements Comparator {
        private int colIndex;
        private boolean ascending;

        ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        public int compare(Object a, Object b) {
            Vector v1 = (Vector)a;
            Vector v2 = (Vector)b;
            Object o1 = v1.get(this.colIndex);
            Object o2 = v2.get(this.colIndex);
            if (null == o1 || null == o2) {
                return 0;
            }
            int resultManip = this.ascending ? 1 : -1;
            String strLhs = o1.toString();
            String strRhs = o2.toString();
            Collator oCompare = Collator.getInstance();
            oCompare.setStrength(0);
            int iVal = oCompare.compare(strLhs.trim(), strRhs.trim());
            return iVal * resultManip;
        }
    }
}

