/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.AbstractThirdPartyFTPSettingPanel;
import com.huawei.dc.configuration.system.IThirdPartyFTPSetting;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class ThirdPartyFTPSettingForSinglePanel
extends AbstractThirdPartyFTPSettingPanel
implements IThirdPartyFTPSetting {
    private static final long serialVersionUID = -8600322183977713540L;
    private JCheckBox m_oCheckBox;
    private ComboBoxWithToolTip m_oThirdFTPServerCombox;
    private SystemSettingDlg m_oSystemSettingDlg = null;
    private ResourceManager m_oResMgr = ResourceManager.getInstance();
    private String m_strSelectServerName = "";
    private ExternalFTPInfo[] m_oThirdPartyFTPInfos;
    private ISystemManager m_oSystemMgr = null;

    public ThirdPartyFTPSettingForSinglePanel(SystemSettingDlg oSystemSettingDlg, String strSelectedServerName, ExternalFTPInfo[] oThirdPartyFTPInfos) {
        this.m_oSystemSettingDlg = oSystemSettingDlg;
        this.m_strSelectServerName = strSelectedServerName;
        this.m_oThirdPartyFTPInfos = oThirdPartyFTPInfos;
        this.m_oSystemMgr = new SystemManager();
        this.jInit();
    }

    private void jInit() {
        this.setLayout(new BorderLayout(0, 10));
        Border oEmptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setBorder(oEmptyBorder);
        JPanel oTmpPanel = new JPanel();
        oTmpPanel.setLayout(new BorderLayout(0, 10));
        TitledBorder oTitleBorder = BorderFactory.createTitledBorder(this.m_oResMgr.getResString("EXTERNAL_FTP_SETTING_FOR_UPGRADE_TASK_TITLE"));
        CompoundBorder oBorder = BorderFactory.createCompoundBorder(oTitleBorder, oEmptyBorder);
        oTmpPanel.setBorder(oBorder);
        JLabel oInfoLabel = new JLabel(this.m_oResMgr.getResString("THIRD_PARTY_FTP_SETTING_INFO_NOTE"));
        oTmpPanel.add((Component)oInfoLabel, "North");
        this.m_oCheckBox = new JCheckBox(this.m_oResMgr.getResString("SELECT_EXTERNAL_FTP_SERVER"));
        this.m_oCheckBox.setName("com.huawei.dc.configuration.system.ExternalFTPSettingForUpgradeTaskPanel.m_oCheckBox");
        oTmpPanel.add((Component)this.m_oCheckBox, "West");
        this.m_oThirdFTPServerCombox = new ComboBoxWithToolTip();
        this.m_oThirdFTPServerCombox.setName("com.huawei.dc.configuration.system.ExternalFTPSettingForUpgradeTaskPanel.m_oThirdFTPServerCombox");
        int i = 0;
        int index = 0;
        DCDebugTracer.trace("m_strSelectServerName = " + this.m_strSelectServerName);
        for (ExternalFTPInfo oThirdPartyFTPInfo : this.m_oThirdPartyFTPInfos) {
            this.m_oThirdFTPServerCombox.addItem(oThirdPartyFTPInfo);
            if (oThirdPartyFTPInfo.getServerName().equals(this.m_strSelectServerName)) {
                index = i;
            }
            ++i;
        }
        if (this.m_oThirdFTPServerCombox.getItemCount() > 0) {
            this.m_oThirdFTPServerCombox.setSelectedIndex(index);
        }
        this.m_oThirdFTPServerCombox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ThirdPartyFTPSettingForSinglePanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }
        });
        oTmpPanel.add((Component)this.m_oThirdFTPServerCombox, "Center");
        if ("".equals(this.m_strSelectServerName)) {
            this.setSelectStatus(false);
        } else {
            this.setSelectStatus(true);
        }
        this.m_oCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    ThirdPartyFTPSettingForSinglePanel.this.setSelectStatus(true);
                    if (0 == ThirdPartyFTPSettingForSinglePanel.this.m_oThirdFTPServerCombox.getItemCount()) {
                        DCOptionPane.showMessageDialog((Component)ThirdPartyFTPSettingForSinglePanel.this, ThirdPartyFTPSettingForSinglePanel.this.m_oResMgr.getResString("NOT_CONFIG_EXTERNAL_FTP"), ThirdPartyFTPSettingForSinglePanel.this.m_oResMgr.getResString("INFO"), 1);
                        ThirdPartyFTPSettingForSinglePanel.this.m_oCheckBox.setSelected(false);
                    }
                } else {
                    ThirdPartyFTPSettingForSinglePanel.this.setSelectStatus(false);
                }
                ThirdPartyFTPSettingForSinglePanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }
        });
        this.add((Component)oTmpPanel, "North");
    }

    private void setSelectStatus(boolean isSelected) {
        this.m_oThirdFTPServerCombox.setEnabled(isSelected);
        this.m_oCheckBox.setSelected(isSelected);
        if (isSelected) {
            this.m_oCheckBox.setForeground(Color.BLACK);
        } else {
            this.m_oCheckBox.setForeground(Color.GRAY);
        }
    }

    @Override
    public void disposePanel() {
        this.m_oThirdFTPServerCombox = null;
    }

    @Override
    public boolean setThirdPartyFTPInfo() {
        boolean bIsSuccess = true;
        try {
            int iErrorCode;
            Object obj;
            String strSelectedServerName = "";
            ExternalFTPInfo oThirdPartyFTPInfo = new ExternalFTPInfo();
            if (this.m_oCheckBox.isSelected() && (obj = this.m_oThirdFTPServerCombox.getSelectedItem()) instanceof ExternalFTPInfo) {
                oThirdPartyFTPInfo = (ExternalFTPInfo)obj;
                strSelectedServerName = oThirdPartyFTPInfo.getServerName();
            }
            if ((iErrorCode = this.m_oSystemMgr.setThirdPartyFTPInfo(strSelectedServerName, oThirdPartyFTPInfo)) != 0) {
                this.displayMessageResult(iErrorCode);
            } else {
                TaskSrcDstVersionCheck.getInstance().setThirdFTPServerName(strSelectedServerName);
            }
        }
        catch (DCException oDCException) {
            this.showMessageDialog(oDCException.getMessage(), DCFrameWorkUtil.getLocalizedString("ERROR"), 0);
            bIsSuccess = false;
        }
        return bIsSuccess;
    }
}

