/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TerminalDialog
extends DCModalDialog {
    private static final long serialVersionUID = 4508874492928001372L;
    private JLabel m_oDeviceIPLabel;
    private JLabel oProtocolLabel;
    private ComboBoxWithToolTip oProtocolLabelComboBox = null;
    private JLabel m_oPortLabel;
    private TitledBorder oBorder;
    private JPanel cenPanel;
    private IPAddressTextField m_oDeviceIPTextField;
    private static final int DEFAULT_TELNET_PORT_VALUE = 23;
    private static final int DEFAULT_SSH_PORT_VALUE = 22;
    private Spinner m_oPortField;
    private NumericSpinnerModel m_oPortModel;
    private static final String DEVICE_IP_EMPTY = "DEVICE_IP_EMPTY";
    private static final String TITLE_DIALGOG = "TERMINAL_TOOL_TITLE";
    private static final String PROTOCOL_TYPE_LABEL = "PROTOCOL_TYPE_LABEL";
    private static final String TELNET_CONFIGURATION = "TELNET_CONFIGURATION";
    private static final String STELNET_CONFIGURATION = "STELNET_CONFIGURATION";
    private static final String[] INTERFACE_VALUES = new String[]{DCFrameWorkUtil.getLocalizedString("ADD_ROUTER_DEV_PROTOCOL_TELNET"), DCFrameWorkUtil.getLocalizedString("ADD_ROUTER_DEV_PROTOCOL_SSH")};

    public TerminalDialog() {
        this.jbinit();
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    private void jbinit() {
        this.setSize(new Dimension(400, 220));
        this.setLayout(new GridBagLayout());
        this.setTitle(DCFrameWorkUtil.getLocalizedString(TITLE_DIALGOG));
        this.createComponent();
        this.addComponent();
    }

    public void createComponent() {
        this.oProtocolLabel = new JLabel(DCFrameWorkUtil.getLocalizedString(PROTOCOL_TYPE_LABEL));
        this.oProtocolLabel.setPreferredSize(new Dimension(100, 23));
        this.oProtocolLabelComboBox = new ComboBoxWithToolTip(INTERFACE_VALUES);
        this.oProtocolLabelComboBox.setSize(new Dimension(50, 23));
        this.oProtocolLabelComboBox.addActionListener(new ActionListener(){
            private long selectWhen = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.selectWhen != e.getWhen()) {
                    TerminalDialog.this.updateCenterPanel();
                    this.selectWhen = e.getWhen();
                }
            }
        });
        this.m_oDeviceIPLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("STANDALONE_DEVICE_IP_LABEL"));
        this.m_oDeviceIPLabel.setPreferredSize(new Dimension(100, 23));
        this.m_oDeviceIPTextField = new IPAddressTextField();
        this.m_oDeviceIPTextField.setName("StandAlone_AddTelnetDevicePanel_m_oDeviceIPTextField");
        this.m_oDeviceIPTextField.setPreferredSize(new Dimension(90, 23));
        this.m_oPortLabel = new JLabel(DCFrameWorkUtil.getLocalizedString("PORT_LABEL"));
        this.m_oPortLabel.setPreferredSize(new Dimension(50, 23));
        this.m_oPortModel = new NumericSpinnerModel(23, 1, 65535, 1);
        this.m_oPortField = new Spinner((SpinnerModel)this.m_oPortModel);
        this.m_oPortField.setName("StandAlone_AddTelnetDevicePanel_m_oPortField");
        this.m_oPortField.setPreferredSize(new Dimension(120, 23));
        this.m_oOKBtn.setName("StandAlone_ModifyDeviceDialog_m_oOKBtn");
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString("OK_BTN"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 23));
        this.m_oCancelBtn.setName("StandAlone_ModifyDeviceDialog_m_oCancelBtn");
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CANCEL_BTN"));
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 23));
        this.cenPanel = new JPanel();
        this.oBorder = BorderFactory.createTitledBorder(DCFrameWorkUtil.getLocalizedString(TELNET_CONFIGURATION));
        this.cenPanel.setBorder(this.oBorder);
    }

    private void updateCenterPanel() {
        String item = (String)this.oProtocolLabelComboBox.getSelectedItem();
        if (DCFrameWorkUtil.getLocalizedString("ADD_ROUTER_DEV_PROTOCOL_TELNET").equals(item)) {
            this.m_oPortField.setValue((Object)23);
            this.oBorder.setTitle(DCFrameWorkUtil.getLocalizedString(TELNET_CONFIGURATION));
        } else {
            this.m_oPortField.setValue((Object)22);
            this.oBorder.setTitle(DCFrameWorkUtil.getLocalizedString(STELNET_CONFIGURATION));
        }
        this.cenPanel.repaint();
    }

    public void addComponent() {
        this.getContentPane().add((Component)this.createUpPanel(), new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 15, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.addComponentToCenterPanel();
        this.getContentPane().add((Component)this.cenPanel, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(12, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.createDownPanel(), new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 11, 2, new Insets(12, 12, 0, 0), 0, 0));
    }

    private void addComponentToCenterPanel() {
        this.cenPanel.setLayout(new GridBagLayout());
        this.cenPanel.add((Component)this.m_oDeviceIPLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(5, 0, 12, 0), 0, 0));
        this.cenPanel.add((Component)this.m_oDeviceIPTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 12, 0), 0, 0));
        this.cenPanel.add((Component)this.m_oPortLabel, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(0, 0, 12, 0), 0, 0));
        this.cenPanel.add((Component)this.m_oPortField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 12, 0), 0, 0));
    }

    private JPanel createDownPanel() {
        JPanel downPanel = new JPanel();
        downPanel.setLayout(new FlowLayout(2));
        downPanel.add(this.m_oOKBtn);
        downPanel.add(Box.createVerticalStrut(0));
        downPanel.add(this.m_oCancelBtn);
        return downPanel;
    }

    private JPanel createUpPanel() {
        JPanel upPanel = new JPanel();
        upPanel.setLayout(new FlowLayout(0));
        upPanel.add(this.oProtocolLabel);
        upPanel.add(this.oProtocolLabelComboBox);
        return upPanel;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_TERMINAL";
    }

    @Override
    protected void oKButton_ActionPerformed() {
        if (!this.validateIPAddressField()) {
            return;
        }
        String deviceIp = "";
        try {
            deviceIp = this.m_oDeviceIPTextField.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        String port = String.valueOf(this.m_oPortField.getValue());
        String puttyVersion = DCCommonUtil.getPuttyVer();
        StringBuffer telnetCommand = new StringBuffer();
        telnetCommand.append(puttyVersion).append(" -").append(((String)this.oProtocolLabelComboBox.getSelectedItem()).toLowerCase()).append(" -P ").append(port).append(' ').append(deviceIp);
        String telnetCmd = telnetCommand.toString();
        try {
            File file = new File(puttyVersion);
            if (!file.exists()) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_DO_NOT_EXIST", new String[]{puttyVersion}));
                DCDebugTracer.trace(telnetCmd);
                return;
            }
            Process oTelnetProcess = Runtime.getRuntime().exec(telnetCmd);
            DCFrameWorkUtil.setTelnetTerminalProcess(oTelnetProcess);
        }
        catch (IOException e) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), e.getMessage());
            DCDebugTracer.trace(e);
        }
    }

    private boolean validateIPAddressField() {
        boolean bValidate = true;
        String strIpAdrress = "";
        try {
            strIpAdrress = this.m_oDeviceIPTextField.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        if (strIpAdrress.length() == 0) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString(DCFrameWorkUtil.getLocalizedString(DEVICE_IP_EMPTY)), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            this.m_oDeviceIPTextField.requestFocus();
            this.m_oDeviceIPTextField.setFocusable(true);
            bValidate = false;
        }
        return bValidate;
    }
}

