/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnSystemSettingInfoRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.ProtocolStatus;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.system.SystemSettingUtil;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.configuration.system.FileTransferServicePanel;
import com.huawei.dc.configuration.system.IPConfigInfo;
import com.huawei.dc.configuration.system.MultipleNICSettingDlg;
import com.huawei.dc.configuration.system.OperationPanel;
import com.huawei.dc.configuration.system.ThirdPartyFTPSettingForSinglePanel;
import com.huawei.dc.configuration.system.TransferProtocolPanel;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPConfigPanel;
import com.huawei.dc.configuration.system.externalftp.ExternalFTPInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.view.ValidationResult;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.u2000.framework.help.HelpLabel;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

public class SystemSettingDlg
extends DCModalDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private int IPCONFIG_TAB_INDEX = 0;
    private int FTP_SERVICE_TAB_INDEX = -1;
    private int TRANSFER_PROTOCOL_TAB_INDEX = -1;
    private int PURGE_MODE_TAB_INDEX = -1;
    private int THIRD_PARTY_FTP_TAB_INDEX = -1;
    private int INTERCURRENT_CONF_TAB_INDEX = -1;
    private String[] ipTableColumnHeaderArray = null;
    private JTabbedPane sysConfigTabbedPane;
    private JButton addButton;
    private JButton m_oModifyButton;
    private JButton m_oDeleteButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton m_oApplyButton;
    private DefaultTableModel ipConfigTableModel;
    private JTable m_oAdressListTable;
    private ComboBoxWithToolTip m_oSingleMServerIPAddressCobox;
    private ComboBoxWithToolTip m_oSingleServerIPAddressCobox;
    private IPAddressTextField m_oSingleMNatIPAddressTxt = new IPAddressTextField();
    private IPAddressTextField m_oSingleNatIPAddressTxt = new IPAddressTextField();
    private IPAddressTextField m_oSingleSServerIPAddressTxt = new IPAddressTextField();
    private IPAddressTextField m_oSingleSNatIPAddressTxt = new IPAddressTextField();
    private JLabel oServerIPLabel = null;
    private JLabel oNatIPLabel = null;
    private JLabel mServerIPLabel = null;
    private JLabel mNatIPLabel = null;
    private JLabel sServerIPLabel = null;
    private JLabel sNatIPLabel = null;
    private JRadioButton singleNICRadioButton;
    private JRadioButton multipleNICRadioButton;
    private ArrayList ipConfigList = null;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private FileTransferServicePanel m_oFileTansferServicePanel = null;
    private TransferProtocolPanel m_oTransferProtocolPanel = null;
    private OperationPanel m_oOperationPanel;
    private ExternalFTPConfigPanel m_oExternalFTPConfigPanel = null;
    private ThirdPartyFTPSettingForSinglePanel m_oThirdPartyFTPConfigPanel = null;
    private ISystemManager m_oSystemMgr;
    private static final char ADD_BUTTON_MNEMONIC = 'a';
    private static final char MODIFY_BUTTON_MNEMONIC = 'm';
    private static final char DELETE_BUTTON_MNEMONIC = 'd';
    private static final char APPLY_BUTTON_MNEMONIC = 'p';
    private JScrollPane m_oTableScrollPane;
    boolean m_bValidIP = true;
    private ValidationResult m_oIPValidationResult;
    private JCheckBox isDoubleServer;
    private HelpLabel ohelpLable = null;
    AsnSystemSettingInfoRsp oAsnSystemSettingInfoRsp = null;
    SystemSettingUtil systemSettingUtil = null;
    private boolean isSetThirdFtpDuringCreateTask = false;

    public SystemSettingDlg() {
        this.setTitle(this.getLocalisedString("SYS_SETTINGS_DIALOG_TITLE"));
        this.initializeSystemMananger();
        this.getContentPane().setLayout(null);
        this.systemSettingUtil = new SystemSettingUtil();
        try {
            this.oAsnSystemSettingInfoRsp = this.m_oSystemMgr.getSystemSettingInfo();
            this.ipConfigList = this.systemSettingUtil.getIPConfigInfo(this.oAsnSystemSettingInfoRsp);
            TKCommonUtil.setRootPath(new String(this.oAsnSystemSettingInfoRsp.oFTSInfo.strServerRootDir));
        }
        catch (DCException e) {
            DCDebugTracer.trace("Get ip information failed!");
            DCDebugTracer.trace(e);
        }
        this.m_oSingleMServerIPAddressCobox = new ComboBoxWithToolTip((ComboBoxModel)new DefaultComboBoxModel());
        this.m_oSingleMServerIPAddressCobox.setEditable(true);
        this.sysConfigTabbedPane = new JTabbedPane();
        this.sysConfigTabbedPane.setBounds(12, 0, 547, 415);
        this.sysConfigTabbedPane.setFocusable(false);
        JPanel buttonPanel = new JPanel(null);
        buttonPanel.setBounds(10, 413, 550, 50);
        this.okButton = new JButton(this.getLocalisedString("SYS_SETTING_OK_BTN"));
        this.okButton.setName("SystemSetting_SystemSettingDlg_okButton");
        this.cancelButton = new JButton(this.getLocalisedString("SYS_SETTING_CANCEL_BTN"));
        this.cancelButton.setName("SystemSetting_SystemSettingDlg_cancelButton");
        this.m_oApplyButton = new JButton(this.getLocalisedString("SYS_SETTING_APPLY_BTN"));
        this.m_oApplyButton.setName("SystemSetting_SystemSettingDlg_m_oApplyButton");
        this.m_oApplyButton.setMnemonic('p');
        String sysTabTitle = this.getLocalisedString("SYS_SETTING_IPCONFIG_TAB_TITLE");
        this.sysConfigTabbedPane.addTab(sysTabTitle, this.getIPConfigurationPanel());
        int iTabIndex = this.IPCONFIG_TAB_INDEX;
        String strTransferProtocolTabTitle = this.m_oResourceManager.getResString("SYSTEM_SETTING_TRANSFER_PROTOCOL_TAB");
        this.sysConfigTabbedPane.addTab(strTransferProtocolTabTitle, this.getTransferProtocolPanel());
        this.TRANSFER_PROTOCOL_TAB_INDEX = this.IPCONFIG_TAB_INDEX + ++iTabIndex;
        this.sysConfigTabbedPane.setEnabledAt(this.TRANSFER_PROTOCOL_TAB_INDEX, true);
        if (DCFrameWorkUtil.getIsSingleClient()) {
            String ftpTabTitle = this.m_oResourceManager.getResString("SYSTEM_SETTING_FILE_TRANSFER_SETTING_TAB");
            this.sysConfigTabbedPane.addTab(ftpTabTitle, this.getFTPSettingPanel());
            this.FTP_SERVICE_TAB_INDEX = this.IPCONFIG_TAB_INDEX + ++iTabIndex;
            this.sysConfigTabbedPane.setEnabledAt(this.FTP_SERVICE_TAB_INDEX, true);
            String strThirdPartyFTPSettingTitle = this.m_oResourceManager.getResString("THIRD_PARTY_FTP_SETTING_TITLE");
            this.sysConfigTabbedPane.addTab(strThirdPartyFTPSettingTitle, this.getThirdPartyFTPPanel());
            this.THIRD_PARTY_FTP_TAB_INDEX = this.IPCONFIG_TAB_INDEX + ++iTabIndex;
            this.sysConfigTabbedPane.setEnabledAt(this.THIRD_PARTY_FTP_TAB_INDEX, true);
        }
        this.getContentPane().add(this.sysConfigTabbedPane);
        this.okButton.addActionListener(this);
        this.okButton.setBounds(new Rectangle(316, 13, 75, 22));
        buttonPanel.add(this.okButton);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setBounds(new Rectangle(395, 13, 75, 22));
        buttonPanel.add(this.cancelButton);
        this.m_oApplyButton.addActionListener(this);
        this.m_oApplyButton.setBounds(new Rectangle(474, 13, 75, 22));
        buttonPanel.add(this.m_oApplyButton);
        this.getContentPane().add(buttonPanel);
        this.handleEscButtonPressed();
        int width = 575;
        int height = 490;
        this.setSize(width, height);
        this.setApplyButtonEnable(false);
        this.enableHelpKeyValues(0);
        this.sysConfigTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SystemSettingDlg.this.enableHelpKeyValues(SystemSettingDlg.this.sysConfigTabbedPane.getSelectedIndex());
            }
        });
    }

    public SystemSettingDlg(boolean isSetThirdFTPDuringCreateTask) {
        this();
        this.isSetThirdFtpDuringCreateTask = isSetThirdFTPDuringCreateTask;
    }

    private void initializeSystemMananger() {
        this.m_oSystemMgr = new SystemManager();
        DeviceInfoManagerImpl.getInstance().getDeviceTypeFromDCServer();
    }

    private void handleEscButtonPressed() {
        ActionListener oEscKeyHandler = this.createActionListenerForEscape();
        KeyStroke oEscKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyBoardActionFor(oEscKeyStroke, oEscKeyHandler);
    }

    private String getLocalisedString(String key) {
        return this.m_oResourceManager.getResString(key);
    }

    public JPanel getIPConfigurationPanel() {
        JPanel sysInfoPanel = new JPanel(null);
        this.singleNICRadioButton = new JRadioButton(this.getLocalisedString("SYS_SETTING_SINGLE_NIC_RADIO_BTN"));
        this.singleNICRadioButton.setName("SystemSetting_SystemSettingDlg_singleNICRadioButton");
        this.singleNICRadioButton.setFocusable(false);
        this.singleNICRadioButton.setMnemonic('s');
        this.multipleNICRadioButton = new JRadioButton(this.getLocalisedString("SYS_SETTING_MULTIPLE_NIC_RADIO_BTN"));
        this.multipleNICRadioButton.setName("SystemSetting_SystemSettingDlg_multipleNICRadioButton");
        this.multipleNICRadioButton.setFocusable(false);
        this.multipleNICRadioButton.setMnemonic('m');
        ButtonGroup radioBtnGroup = new ButtonGroup();
        radioBtnGroup.add(this.singleNICRadioButton);
        radioBtnGroup.add(this.multipleNICRadioButton);
        this.singleNICRadioButton.addActionListener(this);
        this.multipleNICRadioButton.addActionListener(this);
        this.singleNICRadioButton.setBounds(10, 10, 400, 20);
        sysInfoPanel.add(this.singleNICRadioButton);
        this.multipleNICRadioButton.setBounds(10, 175, 400, 20);
        sysInfoPanel.add(this.multipleNICRadioButton);
        sysInfoPanel.add(this.getSingleNICPanel());
        sysInfoPanel.add(this.getMultipleNICPanel());
        boolean isMultipleNICOptionSelected = this.getInitialMultipleNICRadioOptionSelection();
        this.multipleNICRadioButton.setSelected(isMultipleNICOptionSelected);
        this.singleNICRadioButton.setSelected(!isMultipleNICOptionSelected);
        this.enableMultipleNICOptions(isMultipleNICOptionSelected);
        return sysInfoPanel;
    }

    private boolean getInitialMultipleNICRadioOptionSelection() {
        if (this.ipConfigList == null || 0 == this.ipConfigList.size()) {
            return false;
        }
        IPConfigInfo ipInfo = null;
        for (int i = 0; i < this.ipConfigList.size(); ++i) {
            ipInfo = (IPConfigInfo)this.ipConfigList.get(i);
            if (ipInfo.getStrNEIPAddress().equals("-1")) continue;
            return true;
        }
        return false;
    }

    private JPanel getSingleNICPanel() {
        String m_strLanguage = ConfigurationInfo.getInstance().getLocale().getLanguage();
        int iFirstColumnXnum = 0;
        int iSecondColumnXnum = 0;
        if (m_strLanguage.equals("zh")) {
            iFirstColumnXnum = 110;
            iSecondColumnXnum = 270;
        } else {
            iFirstColumnXnum = 180;
            iSecondColumnXnum = 320;
        }
        JPanel singleNICInfoPanel = new JPanel(null);
        Border titledBorder = BorderFactory.createEtchedBorder(1);
        singleNICInfoPanel.setBorder(titledBorder);
        singleNICInfoPanel.setBounds(10, 35, 525, 120);
        this.isDoubleServer = new JCheckBox();
        this.isDoubleServer.setText(this.getLocalisedString("SYS_SETTING_IS_DOUBLE_SERVER"));
        this.isDoubleServer.setSelected(false);
        this.isDoubleServer.setBounds(8, 10, 210, 20);
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.isDoubleServer.setVisible(false);
        }
        singleNICInfoPanel.add(this.isDoubleServer);
        this.oServerIPLabel = new JLabel(this.getLocalisedString("SYS_SETTING_SINGLE_NIC_IP_ADDRESS") + ":");
        this.oServerIPLabel.setBounds(10, 35, 150, 20);
        singleNICInfoPanel.add(this.oServerIPLabel);
        this.m_oSingleServerIPAddressCobox = new ComboBoxWithToolTip((ComboBoxModel)new DefaultComboBoxModel());
        this.m_oSingleServerIPAddressCobox.setEditable(true);
        this.m_oSingleServerIPAddressCobox.setName("SystemSetting_SystemSettingDlg_m_oSingleServerIPAddressCobox");
        this.m_oSingleServerIPAddressCobox.setBounds(iFirstColumnXnum, 35, 120, 20);
        singleNICInfoPanel.add(this.m_oSingleServerIPAddressCobox);
        this.oNatIPLabel = new JLabel(this.getLocalisedString("SYS_SETTING_SINGLE_NIC_NATIP_ADDRESS") + ":");
        this.oNatIPLabel.setBounds(iSecondColumnXnum, 35, 150, 20);
        singleNICInfoPanel.add(this.oNatIPLabel);
        this.m_oSingleNatIPAddressTxt.setName("SystemSetting_SystemSettingDlg_m_oSingleNatIPAddressTxt");
        this.m_oSingleNatIPAddressTxt.setText("");
        this.m_oSingleNatIPAddressTxt.setBounds(375, 35, 120, 20);
        singleNICInfoPanel.add((Component)this.m_oSingleNatIPAddressTxt);
        String ostrHelpID = ResourceManager.getInstance().getResString("HELP_TOPIC_SYS_SETTING_SINGLE_NIC_STANDBYNATIP_ADDRESS", "helpmapfile");
        this.ohelpLable = new HelpLabel("", ostrHelpID);
        this.ohelpLable.setBounds(496, 35, 20, 20);
        this.ohelpLable.setIcon((Icon)ResourceManager.getInstance().getImage("help1.png"));
        if (!DCFrameWorkUtil.isHelpIDFormSA()) {
            singleNICInfoPanel.add((Component)this.ohelpLable);
        }
        this.mServerIPLabel = new JLabel(this.getLocalisedString("SYS_SETTING_SINGLE_NIC_IP_MAINADDRESS") + ":");
        this.mServerIPLabel.setBounds(10, 65, 150, 20);
        singleNICInfoPanel.add(this.mServerIPLabel);
        this.m_oSingleMServerIPAddressCobox.setName("SystemSetting_SystemSettingDlg_m_oSingleMServerIPAddressCobox");
        this.m_oSingleMServerIPAddressCobox.setBounds(iFirstColumnXnum, 65, 120, 20);
        singleNICInfoPanel.add(this.m_oSingleMServerIPAddressCobox);
        this.mNatIPLabel = new JLabel(this.getLocalisedString("SYS_SETTING_SINGLE_NIC_NATIP_ADDRESS") + ":");
        this.mNatIPLabel.setBounds(iSecondColumnXnum, 65, 150, 20);
        singleNICInfoPanel.add(this.mNatIPLabel);
        this.m_oSingleMNatIPAddressTxt.setName("SystemSetting_SystemSettingDlg_m_oSingleServerIPAddressTxt");
        this.m_oSingleMNatIPAddressTxt.setBounds(375, 65, 120, 20);
        singleNICInfoPanel.add((Component)this.m_oSingleMNatIPAddressTxt);
        this.sServerIPLabel = new JLabel(this.getLocalisedString("SYS_SETTING_SINGLE_NIC_STANDBYIP_ADDRESS") + ":");
        this.sServerIPLabel.setBounds(10, 90, 200, 20);
        singleNICInfoPanel.add(this.sServerIPLabel);
        this.m_oSingleSServerIPAddressTxt.setName("SystemSetting_SystemSettingDlg_m_oSingleServerIPAddressTxt");
        this.m_oSingleSServerIPAddressTxt.setBounds(iFirstColumnXnum, 90, 120, 20);
        singleNICInfoPanel.add((Component)this.m_oSingleSServerIPAddressTxt);
        this.sNatIPLabel = new JLabel(this.getLocalisedString("SYS_SETTING_SINGLE_NIC_STANDBYNATIP_ADDRESS") + ":");
        this.sNatIPLabel.setBounds(iSecondColumnXnum, 90, 150, 20);
        singleNICInfoPanel.add(this.sNatIPLabel);
        this.m_oSingleSNatIPAddressTxt.setName("SystemSetting_SystemSettingDlg_m_oSingleServerIPAddressTxt");
        this.m_oSingleSNatIPAddressTxt.setBounds(375, 90, 120, 20);
        singleNICInfoPanel.add((Component)this.m_oSingleSNatIPAddressTxt);
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.oNatIPLabel.setVisible(false);
            this.mServerIPLabel.setVisible(false);
            this.ohelpLable.setVisible(false);
            this.mNatIPLabel.setVisible(false);
            this.sServerIPLabel.setVisible(false);
            this.sNatIPLabel.setVisible(false);
            this.m_oSingleNatIPAddressTxt.setVisible(false);
            this.m_oSingleMServerIPAddressCobox.setVisible(false);
            this.m_oSingleMNatIPAddressTxt.setVisible(false);
            this.m_oSingleSServerIPAddressTxt.setVisible(false);
            this.m_oSingleSNatIPAddressTxt.setVisible(false);
        }
        this.initComponentAction();
        return singleNICInfoPanel;
    }

    private void initComponentAction() {
        Component[] componentsM;
        Component[] components;
        for (Component oComponent : components = this.m_oSingleServerIPAddressCobox.getComponents()) {
            oComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SystemSettingDlg.this.setApplyButtonEnable(true);
                }
            });
        }
        this.m_oSingleServerIPAddressCobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SystemSettingDlg.this.setApplyButtonEnable(true);
            }
        });
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.m_oSingleNatIPAddressTxt.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent arg0) {
                    SystemSettingDlg.this.setApplyButtonEnable(true);
                }
            });
        }
        this.m_oSingleMServerIPAddressCobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SystemSettingDlg.this.setApplyButtonEnable(true);
            }
        });
        for (Component oComponent : componentsM = this.m_oSingleMServerIPAddressCobox.getComponents()) {
            oComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SystemSettingDlg.this.setApplyButtonEnable(true);
                }
            });
        }
        this.m_oSingleMNatIPAddressTxt.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                SystemSettingDlg.this.setApplyButtonEnable(true);
            }
        });
        this.m_oSingleSServerIPAddressTxt.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                SystemSettingDlg.this.setApplyButtonEnable(true);
            }
        });
        this.m_oSingleSNatIPAddressTxt.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                SystemSettingDlg.this.setApplyButtonEnable(true);
            }
        });
        this.isDoubleServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SystemSettingDlg.this.isDoubleServer.isSelected()) {
                    SystemSettingDlg.this.oNatIPLabel.setForeground(Color.GRAY);
                    SystemSettingDlg.this.oServerIPLabel.setForeground(Color.GRAY);
                    SystemSettingDlg.this.m_oSingleServerIPAddressCobox.setEditable(false);
                    SystemSettingDlg.this.m_oSingleServerIPAddressCobox.setEnabled(false);
                    SystemSettingDlg.this.m_oSingleNatIPAddressTxt.setEditable(false);
                    SystemSettingDlg.this.m_oSingleNatIPAddressTxt.setEnabled(false);
                    SystemSettingDlg.this.sServerIPLabel.setForeground(Color.BLACK);
                    SystemSettingDlg.this.mServerIPLabel.setForeground(Color.BLACK);
                    SystemSettingDlg.this.sNatIPLabel.setForeground(Color.BLACK);
                    SystemSettingDlg.this.mNatIPLabel.setForeground(Color.BLACK);
                    SystemSettingDlg.this.m_oSingleMNatIPAddressTxt.setEditable(true);
                    SystemSettingDlg.this.m_oSingleMNatIPAddressTxt.setEnabled(true);
                    SystemSettingDlg.this.m_oSingleMServerIPAddressCobox.setEditable(true);
                    SystemSettingDlg.this.m_oSingleMServerIPAddressCobox.setEnabled(true);
                    SystemSettingDlg.this.m_oSingleSServerIPAddressTxt.setEditable(true);
                    SystemSettingDlg.this.m_oSingleSServerIPAddressTxt.setEnabled(true);
                    SystemSettingDlg.this.m_oSingleSNatIPAddressTxt.setEditable(true);
                    SystemSettingDlg.this.m_oSingleSNatIPAddressTxt.setEnabled(true);
                    SystemSettingDlg.this.setIPTextFieldFocus(SystemSettingDlg.this.m_oSingleMServerIPAddressCobox);
                } else {
                    SystemSettingDlg.this.oNatIPLabel.setForeground(Color.BLACK);
                    SystemSettingDlg.this.oServerIPLabel.setForeground(Color.BLACK);
                    SystemSettingDlg.this.m_oSingleServerIPAddressCobox.setEditable(true);
                    SystemSettingDlg.this.m_oSingleServerIPAddressCobox.setEnabled(true);
                    SystemSettingDlg.this.m_oSingleNatIPAddressTxt.setEditable(true);
                    SystemSettingDlg.this.m_oSingleNatIPAddressTxt.setEnabled(true);
                    SystemSettingDlg.this.setIPTextFieldFocus(SystemSettingDlg.this.m_oSingleServerIPAddressCobox);
                    SystemSettingDlg.this.sServerIPLabel.setForeground(Color.GRAY);
                    SystemSettingDlg.this.mServerIPLabel.setForeground(Color.GRAY);
                    SystemSettingDlg.this.sNatIPLabel.setForeground(Color.GRAY);
                    SystemSettingDlg.this.mNatIPLabel.setForeground(Color.GRAY);
                    SystemSettingDlg.this.m_oSingleMNatIPAddressTxt.setEditable(false);
                    SystemSettingDlg.this.m_oSingleMNatIPAddressTxt.setEnabled(false);
                    SystemSettingDlg.this.m_oSingleMServerIPAddressCobox.setEditable(false);
                    SystemSettingDlg.this.m_oSingleMServerIPAddressCobox.setEnabled(false);
                    SystemSettingDlg.this.m_oSingleSServerIPAddressTxt.setEditable(false);
                    SystemSettingDlg.this.m_oSingleSServerIPAddressTxt.setEnabled(false);
                    SystemSettingDlg.this.m_oSingleSNatIPAddressTxt.setEditable(false);
                    SystemSettingDlg.this.m_oSingleSNatIPAddressTxt.setEnabled(false);
                }
                SystemSettingDlg.this.setApplyButtonEnable(true);
            }
        });
    }

    private void initializeIpConfigTab() {
        Object[][] dataVector = null;
        if (this.ipConfigList != null && this.ipConfigList.size() > 0) {
            boolean isSingleIP = false;
            IPConfigInfo oIPConfigInfo = (IPConfigInfo)this.ipConfigList.get(0);
            isSingleIP = oIPConfigInfo.getStrNEIPAddress().equals("-1");
            int size = this.ipConfigList.size();
            if (isSingleIP) {
                this.singleNICRadioButton.setSelected(true);
                this.multipleNICRadioButton.setSelected(false);
                boolean hasSetMasterIpCombox = false;
                for (int i = 0; i < this.ipConfigList.size(); ++i) {
                    oIPConfigInfo = (IPConfigInfo)this.ipConfigList.get(i);
                    if (oIPConfigInfo.getProperty() == 1) {
                        this.m_oSingleServerIPAddressCobox.addItem(oIPConfigInfo.getStrServerIPAddress());
                        this.m_oSingleServerIPAddressCobox.setSelectedItem(oIPConfigInfo.getStrServerIPAddress());
                        this.m_oSingleMServerIPAddressCobox.addItem(oIPConfigInfo.getStrServerIPAddress());
                        this.m_oSingleMServerIPAddressCobox.setSelectedItem(oIPConfigInfo.getStrServerIPAddress());
                        hasSetMasterIpCombox = true;
                        if (StringUtils.isNullOrEmptyStr(oIPConfigInfo.getStrNatIPAddress())) continue;
                        this.m_oSingleMNatIPAddressTxt.setText(oIPConfigInfo.getStrNatIPAddress());
                        this.m_oSingleNatIPAddressTxt.setText(oIPConfigInfo.getStrNatIPAddress());
                        continue;
                    }
                    if (oIPConfigInfo.getProperty() == 2) {
                        this.isDoubleServer.setSelected(true);
                        if (!StringUtils.isNullOrEmptyStr(oIPConfigInfo.getStrServerIPAddress())) {
                            this.m_oSingleSServerIPAddressTxt.setText(oIPConfigInfo.getStrServerIPAddress());
                        }
                        if (StringUtils.isNullOrEmptyStr(oIPConfigInfo.getStrNatIPAddress())) continue;
                        this.m_oSingleSNatIPAddressTxt.setText(oIPConfigInfo.getStrNatIPAddress());
                        continue;
                    }
                    if (oIPConfigInfo.getProperty() != 0) continue;
                    this.m_oSingleServerIPAddressCobox.addItem(oIPConfigInfo.getStrServerIPAddress());
                }
                if (size > 1 && !hasSetMasterIpCombox) {
                    this.m_oSingleServerIPAddressCobox.insertItemAt("", 0);
                    this.m_oSingleServerIPAddressCobox.setSelectedIndex(0);
                    this.m_oSingleMServerIPAddressCobox.insertItemAt("", 0);
                    this.m_oSingleMServerIPAddressCobox.setSelectedIndex(0);
                }
            } else {
                this.singleNICRadioButton.setSelected(false);
                this.multipleNICRadioButton.setSelected(true);
                dataVector = new String[size][2];
                ArrayList<String> ipArrayLst = new ArrayList<String>();
                String strServerIPAddress = null;
                for (int i = 0; i < size; ++i) {
                    oIPConfigInfo = (IPConfigInfo)this.ipConfigList.get(i);
                    dataVector[i][0] = oIPConfigInfo.getStrServerIPAddress();
                    dataVector[i][1] = oIPConfigInfo.getStrNEIPAddress();
                    strServerIPAddress = oIPConfigInfo.getStrServerIPAddress();
                    if (ipArrayLst.contains(strServerIPAddress)) continue;
                    ipArrayLst.add(strServerIPAddress);
                    this.m_oSingleServerIPAddressCobox.addItem(strServerIPAddress);
                    this.m_oSingleMServerIPAddressCobox.addItem(strServerIPAddress);
                }
                this.m_oSingleServerIPAddressCobox.setSelectedItem("");
                this.m_oSingleMServerIPAddressCobox.setSelectedItem("");
            }
            DefaultTableModel oDefaultTableModel = (DefaultTableModel)this.m_oAdressListTable.getModel();
            oDefaultTableModel.setDataVector(dataVector, this.ipTableColumnHeaderArray);
            if (0 < this.m_oAdressListTable.getRowCount()) {
                this.m_oAdressListTable.setRowSelectionInterval(0, 0);
            }
        } else {
            DefaultTableModel oDefaultTableModel = (DefaultTableModel)this.m_oAdressListTable.getModel();
            oDefaultTableModel.setDataVector(dataVector, this.ipTableColumnHeaderArray);
        }
    }

    private JPanel getMultipleNICPanel() {
        Border titledBorder = BorderFactory.createEtchedBorder(1);
        JPanel multipleNICInfoPanel = new JPanel(null);
        multipleNICInfoPanel.setBounds(10, 200, 525, 180);
        multipleNICInfoPanel.setBorder(titledBorder);
        JLabel multipleNICNoteLabel = new JLabel(this.getLocalisedString("SYS_SETTING_MULTIPLE_NIC_NOTE"));
        multipleNICNoteLabel.setBounds(10, 12, 515, 55);
        this.m_oTableScrollPane = this.getIPConfigTableScrollPane();
        this.m_oTableScrollPane.setBounds(10, 15, 373, 150);
        multipleNICInfoPanel.add(this.m_oTableScrollPane);
        JPanel multipleNICButtonPanel = this.getMultipleNICButtonPanel();
        multipleNICButtonPanel.setBounds(395, 10, 120, 84);
        multipleNICInfoPanel.add(multipleNICButtonPanel);
        return multipleNICInfoPanel;
    }

    private JPanel getMultipleNICButtonPanel() {
        JPanel multipleNICButtonPanel = new JPanel(null);
        this.addButton = new JButton(this.getLocalisedString("SYS_SETTING_MULTIPLE_NIC_ADD_BTN"));
        this.addButton.setName("SystemSetting_SystemSettingDlg_addButton");
        this.m_oModifyButton = new JButton(this.getLocalisedString("SYS_SETTING_MULTIPLE_NIC_MODIFY_BTN"));
        this.m_oModifyButton.setName("SystemSetting_SystemSettingDlg_m_oModifyButton");
        this.m_oDeleteButton = new JButton(this.getLocalisedString("SYS_SETTING_MULTIPLE_NIC_DELETE_BTN"));
        this.m_oDeleteButton.setName("SystemSetting_SystemSettingDlg_m_oDeleteButton");
        this.addButton.setMnemonic('a');
        this.m_oModifyButton.setMnemonic('m');
        this.m_oDeleteButton.setMnemonic('d');
        this.addButton.setBounds(0, 4, 100, 20);
        this.m_oModifyButton.setBounds(0, 34, 100, 20);
        this.m_oDeleteButton.setBounds(0, 64, 100, 20);
        this.addButton.addActionListener(this);
        this.m_oModifyButton.addActionListener(this);
        this.m_oDeleteButton.addActionListener(this);
        multipleNICButtonPanel.add(this.addButton);
        multipleNICButtonPanel.add(this.m_oModifyButton);
        multipleNICButtonPanel.add(this.m_oDeleteButton);
        return multipleNICButtonPanel;
    }

    private JPanel getFTPSettingPanel() {
        FTSInfo ftpInfo = null;
        if (null != this.oAsnSystemSettingInfoRsp) {
            ftpInfo = this.systemSettingUtil.getProtocolConfiguration(this.oAsnSystemSettingInfoRsp.oFTSInfo);
        }
        this.m_oFileTansferServicePanel = new FileTransferServicePanel(this, ftpInfo);
        return this.m_oFileTansferServicePanel;
    }

    private JPanel getThirdPartyFTPPanel() {
        String strSelectServerName = "";
        ExternalFTPInfo[] oExternalFTPInfos = new ExternalFTPInfo[]{};
        if (null != this.oAsnSystemSettingInfoRsp && null != this.oAsnSystemSettingInfoRsp.oThirdPartyFTPSetting) {
            oExternalFTPInfos = this.systemSettingUtil.getExternalFTPConfiguration(this.oAsnSystemSettingInfoRsp.oThirdPartyFTPSetting.oAsnThirdPartyFTPInfoLst);
            strSelectServerName = new String(this.oAsnSystemSettingInfoRsp.oThirdPartyFTPSetting.strSelectedServerName);
        }
        this.m_oExternalFTPConfigPanel = new ExternalFTPConfigPanel(this, strSelectServerName, oExternalFTPInfos);
        return this.m_oExternalFTPConfigPanel;
    }

    private JPanel getTransferProtocolPanel() {
        this.m_oTransferProtocolPanel = new TransferProtocolPanel(this, this.oAsnSystemSettingInfoRsp);
        return this.m_oTransferProtocolPanel;
    }

    private JScrollPane getIPConfigTableScrollPane() {
        this.ipTableColumnHeaderArray = new String[2];
        this.ipTableColumnHeaderArray[0] = this.getLocalisedString("SYS_SETTING_MULTIPLE_NIC_IP_ADDRESS");
        this.ipTableColumnHeaderArray[1] = this.getLocalisedString("SYS_SETTING_MULTIPLE_NIC_NE_IP_ADDRESS");
        this.ipConfigTableModel = new NonEditableTableModel();
        this.m_oAdressListTable = new JTable(this.ipConfigTableModel);
        this.m_oAdressListTable.setName("SystemSetting_SystemSettingDlg_m_oAdressListTable");
        this.m_oAdressListTable.setSelectionMode(0);
        this.m_oAdressListTable.setFocusable(true);
        this.initializeIpConfigTab();
        JScrollPane scrollPane = new JScrollPane(this.m_oAdressListTable);
        this.m_oAdressListTable.setRowSelectionAllowed(true);
        return scrollPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.performRowInsertion();
        } else if (e.getSource() == this.m_oDeleteButton) {
            this.performRowDeletion();
        } else if (e.getSource() == this.m_oModifyButton) {
            this.performRowModification();
        } else if (e.getSource() == this.multipleNICRadioButton || e.getSource() == this.singleNICRadioButton) {
            boolean isMultipleNICSelected = this.multipleNICRadioButton.isSelected();
            this.enableMultipleNICOptions(isMultipleNICSelected);
        } else if (e.getSource() == this.okButton) {
            this.performOKAction();
        } else if (e.getSource() == this.cancelButton) {
            this.performCancelAction();
        } else if (e.getSource() == this.m_oApplyButton) {
            try {
                if (this.performApplyAction()) {
                    ProtocolStatus.getInstance().checkFileTransferStatus(this.isSetThirdFtpDuringCreateTask);
                    this.setApplyButtonEnable(false);
                    if (this.m_oIPValidationResult.getErrorCode() != 0) {
                        if (this.m_oIPValidationResult.isWarningMessage()) {
                            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oIPValidationResult.getErrorMessage(), ResourceManager.getInstance().getResString("WARNING"), 2);
                        } else {
                            this.showErrorMessage();
                        }
                    }
                }
            }
            catch (DCException e1) {
                DCDebugTracer.trace(e1);
            }
        }
    }

    private void performOKAction() {
        try {
            if (!this.m_oApplyButton.isEnabled()) {
                this.closeDialog();
                return;
            }
            if (this.performApplyAction()) {
                ProtocolStatus.getInstance().checkFileTransferStatus(this.isSetThirdFtpDuringCreateTask);
                if (null == this.m_oIPValidationResult || this.m_oIPValidationResult.getErrorCode() == 0) {
                    this.closeDialog();
                } else if (this.m_oIPValidationResult.isWarningMessage()) {
                    int iConfirm = this.showWarningMessage();
                    if (iConfirm == 0) {
                        this.setApplyButtonEnable(false);
                    } else {
                        this.closeDialog();
                    }
                } else {
                    this.setApplyButtonEnable(false);
                    this.showErrorMessage();
                }
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
    }

    private int showWarningMessage() {
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oIPValidationResult.getErrorMessage(), ResourceManager.getInstance().getResString("OPERATE_RESULT"), 2);
        return iConfirm;
    }

    private void showErrorMessage() {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oIPValidationResult.getErrorMessage(), ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
    }

    private void performCancelAction() {
        this.closeDialog();
    }

    private boolean performApplyAction() throws DCException {
        boolean bIsSuccess = true;
        bIsSuccess = this.setIpConfigInfo();
        if (!bIsSuccess) {
            this.sysConfigTabbedPane.setSelectedIndex(this.IPCONFIG_TAB_INDEX);
            this.refresh();
            return false;
        }
        bIsSuccess = this.setFtpServiceInfo();
        if (!bIsSuccess) {
            this.sysConfigTabbedPane.setSelectedIndex(this.FTP_SERVICE_TAB_INDEX);
            this.refresh();
            return false;
        }
        bIsSuccess = this.setTransferProtocolInfo();
        if (!bIsSuccess) {
            this.sysConfigTabbedPane.setSelectedIndex(this.TRANSFER_PROTOCOL_TAB_INDEX);
            this.refresh();
            return false;
        }
        bIsSuccess = this.setPurgeInfo();
        if (!bIsSuccess) {
            this.sysConfigTabbedPane.setSelectedIndex(this.PURGE_MODE_TAB_INDEX);
            this.refresh();
            return false;
        }
        bIsSuccess = this.setThirdPartyFTPInfo();
        if (!bIsSuccess) {
            this.sysConfigTabbedPane.setSelectedIndex(this.THIRD_PARTY_FTP_TAB_INDEX);
            this.refresh();
            return false;
        }
        if (bIsSuccess && this.m_bValidIP) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("OPERTION_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
            this.refresh();
        }
        return bIsSuccess;
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SystemSettingDlg.this.validate();
            }
        });
    }

    private boolean setFtpServiceInfo() {
        if (null != this.m_oFileTansferServicePanel) {
            this.m_oFileTansferServicePanel.setShowConfirmation(false);
            return this.m_oFileTansferServicePanel.setFTSInfo();
        }
        return true;
    }

    private boolean setTransferProtocolInfo() {
        if (null != this.m_oTransferProtocolPanel) {
            this.m_oTransferProtocolPanel.setShowConfirmation(false);
            return this.m_oTransferProtocolPanel.setProtocolDeviceInfo();
        }
        return true;
    }

    private boolean setPurgeInfo() {
        if (null != this.m_oOperationPanel) {
            this.m_oOperationPanel.setShowConfirmation(false);
            return this.m_oOperationPanel.setPurgeInfo();
        }
        return true;
    }

    private boolean setThirdPartyFTPInfo() {
        if (null != this.m_oExternalFTPConfigPanel) {
            return this.m_oExternalFTPConfigPanel.setExternalFTPInfo();
        }
        return true;
    }

    private boolean setIpConfigInfo() {
        ArrayList<IPConfigInfo> ipConfigList = new ArrayList<IPConfigInfo>();
        boolean bIsSuccess = false;
        this.m_bValidIP = true;
        IPConfigInfo oIPConfigInfo = null;
        if (this.singleNICRadioButton.isSelected()) {
            if (!this.setIpConfigInfoForSingleNIC(ipConfigList)) {
                return false;
            }
        } else {
            DefaultTableModel oNonEditableTableModel = (DefaultTableModel)this.m_oAdressListTable.getModel();
            Vector<Vector> dataVector = oNonEditableTableModel.getDataVector();
            int rowCount = dataVector.size();
            if (0 == rowCount) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("INVALID_IP_SEGMENT"), ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
                return bIsSuccess;
            }
            ipConfigList = new ArrayList(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                Vector row = dataVector.elementAt(i);
                oIPConfigInfo = new IPConfigInfo((String)row.elementAt(0), (String)row.elementAt(1), "", 0);
                ipConfigList.add(oIPConfigInfo);
            }
        }
        try {
            this.m_oSystemMgr.setIPConfigInfo(ipConfigList);
            bIsSuccess = true;
        }
        catch (DCException oDCException) {
            DCOptionPane.showMessageDialog((Component)((Object)this), oDCException.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DCDebugTracer.trace("DC::SystemSettingDlg::setIpConfigInfo()::throw exception::" + oDCException.getMessage());
            bIsSuccess = false;
        }
        return bIsSuccess;
    }

    private boolean setIpConfigInfoForSingleNIC(ArrayList<IPConfigInfo> ipConfigList) {
        int iIndex = -1;
        String strLastSegment = "";
        String strMServerIP = "";
        String strSServerIP = "";
        String strMNATIP = "";
        String strSNATIP = "";
        String strSystemIP = "";
        try {
            strSystemIP = this.m_oSingleServerIPAddressCobox.getSelectedItem().toString();
            if (this.isDoubleServer.isSelected() && null != this.m_oSingleMServerIPAddressCobox.getSelectedItem()) {
                strMServerIP = this.m_oSingleMServerIPAddressCobox.getSelectedItem().toString();
            } else if (null != this.m_oSingleServerIPAddressCobox.getSelectedItem()) {
                strMServerIP = this.m_oSingleServerIPAddressCobox.getSelectedItem().toString();
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        try {
            strSServerIP = this.m_oSingleSServerIPAddressTxt.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        try {
            strMNATIP = this.isDoubleServer.isSelected() ? this.m_oSingleMNatIPAddressTxt.getTrimedAddress() : this.m_oSingleNatIPAddressTxt.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        try {
            strSNATIP = this.m_oSingleSNatIPAddressTxt.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        if (!this.isDoubleServer.isSelected() && strSystemIP.length() == 0) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("SYSTEM_INFO_IP_ADDRESS_EMPTY"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
            this.setIPTextFieldFocus(this.m_oSingleServerIPAddressCobox);
            return false;
        }
        if (strMServerIP.length() == 0) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("SYSTEM_INFO_HOST_IP_EMPTY"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
            if (this.isDoubleServer.isSelected()) {
                this.setIPTextFieldFocus(this.m_oSingleMServerIPAddressCobox);
            } else {
                this.setIPTextFieldFocus(this.m_oSingleServerIPAddressCobox);
            }
            return false;
        }
        iIndex = strMServerIP.lastIndexOf(46);
        strLastSegment = strMServerIP.substring(iIndex + 1);
        if (strLastSegment.equals("255") || strLastSegment.equals("0") || iIndex == -1) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("INVALID_NMS_SERVER_IP_ADDRESS"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
            if (this.isDoubleServer.isSelected()) {
                this.setIPTextFieldFocus(this.m_oSingleMServerIPAddressCobox);
            } else {
                this.setIPTextFieldFocus(this.m_oSingleServerIPAddressCobox);
            }
            return false;
        }
        if (strMNATIP.length() > 0 && ((strLastSegment = strMNATIP.substring((iIndex = strMNATIP.lastIndexOf(46)) + 1)).equals("255") || strLastSegment.equals("0"))) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("INVALID_NMS_SERVER_IP_ADDRESS"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
            if (this.isDoubleServer.isSelected()) {
                this.setIPTextFieldFocus((Component)this.m_oSingleMNatIPAddressTxt);
            } else {
                this.setIPTextFieldFocus((Component)this.m_oSingleNatIPAddressTxt);
            }
            return false;
        }
        IPConfigInfo oHostIPConfigInfo = new IPConfigInfo(strMServerIP, "", strMNATIP, 1);
        ipConfigList.add(oHostIPConfigInfo);
        if (!this.doubleServerCheck(strSServerIP, strLastSegment, strMServerIP, strSNATIP, ipConfigList)) {
            return false;
        }
        this.m_bValidIP = this.validateIPAddress(strMServerIP);
        return true;
    }

    private boolean doubleServerCheck(String strSServerIP, String strLastSegment, String strMServerIP, String strSNATIP, ArrayList<IPConfigInfo> ipConfigList) {
        if (this.isDoubleServer.isSelected()) {
            if (strSServerIP.length() == 0) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("SYSTEM_INFO_STANDBY_IP_EMPTY"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
                this.setIPTextFieldFocus((Component)this.m_oSingleSServerIPAddressTxt);
                return false;
            }
            int iIndex = strSServerIP.lastIndexOf(46);
            strLastSegment = strSServerIP.substring(iIndex + 1);
            if (strLastSegment.equals("255") || strLastSegment.equals("0")) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("INVALID_NMS_SERVER_IP_ADDRESS"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
                this.setIPTextFieldFocus((Component)this.m_oSingleSServerIPAddressTxt);
                return false;
            }
            if (strMServerIP.equals(strSServerIP)) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("INVALID_NMS_STANDBY_SERVER_IP_ADDRESS"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
                this.setIPTextFieldFocus((Component)this.m_oSingleSServerIPAddressTxt);
                return false;
            }
            if (strSNATIP.length() > 0 && ((strLastSegment = strSServerIP.substring((iIndex = strSServerIP.lastIndexOf(46)) + 1)).equals("255") || strLastSegment.equals("0"))) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("INVALID_NMS_SERVER_IP_ADDRESS"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
                this.setIPTextFieldFocus((Component)this.m_oSingleSNatIPAddressTxt);
                return false;
            }
            IPConfigInfo oStandbyIPConfigInfo = new IPConfigInfo(strSServerIP, "", strSNATIP, 0);
            ipConfigList.add(oStandbyIPConfigInfo);
            return true;
        }
        return true;
    }

    private void enableMultipleNICOptions(boolean isSelected) {
        this.addButton.setEnabled(isSelected);
        this.m_oModifyButton.setEnabled(isSelected);
        this.m_oDeleteButton.setEnabled(isSelected);
        this.m_oSingleServerIPAddressCobox.setEditable(!this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleServerIPAddressCobox.setEnabled(!this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleNatIPAddressTxt.setEditable(!this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleNatIPAddressTxt.setEnabled(!this.isDoubleServer.isSelected() && !isSelected);
        this.ohelpLable.setEnabled(!isSelected);
        this.oServerIPLabel.setForeground(!this.isDoubleServer.isSelected() && !isSelected ? Color.BLACK : Color.GRAY);
        this.oNatIPLabel.setForeground(!this.isDoubleServer.isSelected() && !isSelected ? Color.BLACK : Color.GRAY);
        this.m_oSingleMServerIPAddressCobox.setEditable(this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleMServerIPAddressCobox.setEnabled(this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleMNatIPAddressTxt.setEditable(this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleMNatIPAddressTxt.setEnabled(this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleSServerIPAddressTxt.setEditable(this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleSServerIPAddressTxt.setEnabled(this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleSNatIPAddressTxt.setEditable(this.isDoubleServer.isSelected() && !isSelected);
        this.m_oSingleSNatIPAddressTxt.setEnabled(this.isDoubleServer.isSelected() && !isSelected);
        this.mServerIPLabel.setForeground(this.isDoubleServer.isSelected() && !isSelected ? Color.BLACK : Color.GRAY);
        this.mNatIPLabel.setForeground(this.isDoubleServer.isSelected() && !isSelected ? Color.BLACK : Color.GRAY);
        this.sServerIPLabel.setForeground(this.isDoubleServer.isSelected() && !isSelected ? Color.BLACK : Color.GRAY);
        this.sNatIPLabel.setForeground(this.isDoubleServer.isSelected() && !isSelected ? Color.BLACK : Color.GRAY);
        this.isDoubleServer.setEnabled(!isSelected);
        this.m_oAdressListTable.setEnabled(isSelected);
        this.m_oAdressListTable.setFocusable(isSelected);
        this.m_oTableScrollPane.setEnabled(isSelected);
        this.setApplyButtonEnable(true);
        if (isSelected) {
            this.m_oTableScrollPane.setEnabled(isSelected);
            boolean bIsEmptyTable = this.m_oAdressListTable.getRowCount() != 0;
            this.m_oDeleteButton.setEnabled(bIsEmptyTable);
            this.m_oModifyButton.setEnabled(bIsEmptyTable);
        } else if (this.isDoubleServer.isSelected()) {
            this.setIPTextFieldFocus(this.m_oSingleMServerIPAddressCobox);
        } else {
            this.setIPTextFieldFocus(this.m_oSingleServerIPAddressCobox);
        }
    }

    private void setIPTextFieldFocus(Component oServerIPAddressTxt) {
        oServerIPAddressTxt.setFocusable(true);
        oServerIPAddressTxt.requestFocus();
    }

    private void performRowInsertion() {
        this.setApplyButtonEnable(true);
        MultipleNICSettingDlg oDlg = new MultipleNICSettingDlg(0, this.m_oAdressListTable);
        oDlg.setVisible(true);
        this.refreshButtonStates();
    }

    private boolean validateIPAddress(String ipAddress) {
        boolean bValidIP = false;
        this.m_oIPValidationResult = new ValidationResult();
        int iErrCode = this.m_oSystemMgr.validateServerIP(ipAddress);
        if (iErrCode == 989855845) {
            this.sysConfigTabbedPane.setSelectedIndex(this.IPCONFIG_TAB_INDEX);
            this.m_oIPValidationResult.setErrorCode(iErrCode);
            this.m_oIPValidationResult.setErrorMessage(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrCode)));
            this.m_oIPValidationResult.setWarningMessage(true);
        } else if (iErrCode == 0) {
            bValidIP = true;
        } else {
            this.sysConfigTabbedPane.setSelectedIndex(this.IPCONFIG_TAB_INDEX);
            this.m_oIPValidationResult.setErrorCode(iErrCode);
            this.m_oIPValidationResult.setErrorMessage(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrCode)));
            this.m_oIPValidationResult.setWarningMessage(false);
        }
        return bValidIP;
    }

    private void performRowModification() {
        this.setApplyButtonEnable(true);
        MultipleNICSettingDlg oDlg = new MultipleNICSettingDlg(1, this.m_oAdressListTable);
        oDlg.setVisible(true);
        this.refreshButtonStates();
    }

    private void performRowDeletion() {
        this.setApplyButtonEnable(true);
        int selectedRowIndex = this.m_oAdressListTable.getSelectedRow();
        if (selectedRowIndex >= 0) {
            this.ipConfigTableModel.removeRow(selectedRowIndex);
            int count = this.m_oAdressListTable.getRowCount();
            if (count > 0) {
                this.m_oAdressListTable.setRowSelectionInterval(0, 0);
            } else {
                this.m_oDeleteButton.setEnabled(false);
                this.m_oModifyButton.setEnabled(false);
            }
        }
    }

    @Override
    protected ActionListener createActionListenerForEscape() {
        ActionListener oEscKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemSettingDlg.this.closeDialog();
            }
        };
        return oEscKeyHandler;
    }

    public JButton getApplyButton() {
        return this.m_oApplyButton;
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        if (null != this.m_oTransferProtocolPanel) {
            this.m_oAdressListTable.registerKeyboardAction(oKeyHandler, oKeyStroke, 0);
            this.m_oTransferProtocolPanel.getDeviceTable().registerKeyboardAction(oKeyHandler, oKeyStroke, 0);
        }
    }

    @Override
    protected void closeDialog() {
        DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.setVisible(false);
        this.m_oSingleMServerIPAddressCobox = null;
        this.dispose();
    }

    @Override
    protected String getCurrentContext() {
        String strHelpFileName = null;
        int iSelectedIndex = this.sysConfigTabbedPane.getSelectedIndex();
        if (this.IPCONFIG_TAB_INDEX == iSelectedIndex) {
            strHelpFileName = "HELP_TOPIC_SYSTEM_SETTING_INFORMATION";
        } else if (this.TRANSFER_PROTOCOL_TAB_INDEX == iSelectedIndex) {
            strHelpFileName = "HELP_TOPIC_SYSTEM_SETTING_TRANSFER_PROTOCOL";
        } else if (this.PURGE_MODE_TAB_INDEX == iSelectedIndex) {
            strHelpFileName = "HELP_TOPIC_SYSTEM_SETTING_PURGE_MODE";
        }
        return strHelpFileName;
    }

    private void enableHelpKeyValues(int iSelectedIndex) {
        DCHelpManager oHelpManager = DCHelpManager.getInstance();
        int index = this.sysConfigTabbedPane.getSelectedIndex();
        if (this.IPCONFIG_TAB_INDEX == index) {
            oHelpManager.enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SYSTEM_SETTING_INFORMATION");
        } else if (this.TRANSFER_PROTOCOL_TAB_INDEX == index) {
            oHelpManager.enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SYSTEM_SETTING_TRANSFER_PROTOCOL");
        } else if (this.PURGE_MODE_TAB_INDEX == index) {
            oHelpManager.enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SYSTEM_SETTING_PURGE_MODE");
        } else if (this.THIRD_PARTY_FTP_TAB_INDEX == index) {
            oHelpManager.enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_PARTY_FTP");
        } else if (this.INTERCURRENT_CONF_TAB_INDEX == index) {
            oHelpManager.enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SYSTEM_SETTING_CONCURRENT");
        } else {
            oHelpManager.enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_SYSTEM_SETTING_INFORMATION");
        }
    }

    public String getFTSRootPath() {
        if (null == this.m_oFileTansferServicePanel) {
            return "";
        }
        return this.m_oFileTansferServicePanel.getFTSRootPath();
    }

    public void setApplyButtonEnable(boolean bFlag) {
        this.m_oApplyButton.setEnabled(bFlag);
    }

    @Override
    public void doCleanUp() {
        if (null != this.m_oOperationPanel) {
            this.m_oOperationPanel.disposePanel();
        }
        if (null != this.m_oTransferProtocolPanel) {
            this.m_oTransferProtocolPanel.disposePanel();
        }
        if (null != this.m_oExternalFTPConfigPanel) {
            this.m_oExternalFTPConfigPanel.disposePanel();
        }
        this.ipTableColumnHeaderArray = null;
        this.sysConfigTabbedPane = null;
        this.addButton = null;
        this.m_oModifyButton = null;
        this.m_oDeleteButton = null;
        this.okButton = null;
        this.cancelButton = null;
        this.m_oApplyButton = null;
        this.ipConfigTableModel = null;
        this.m_oAdressListTable = null;
        this.m_oSingleMServerIPAddressCobox = null;
        this.m_oSingleMNatIPAddressTxt = null;
        this.m_oSingleSServerIPAddressTxt = null;
        this.m_oSingleSNatIPAddressTxt = null;
        this.singleNICRadioButton = null;
        this.multipleNICRadioButton = null;
        this.ipConfigList = null;
        this.m_oResourceManager = null;
        this.m_oTransferProtocolPanel = null;
        this.m_oOperationPanel = null;
        this.m_oExternalFTPConfigPanel = null;
        this.m_oSystemMgr = null;
        this.m_oTableScrollPane = null;
        this.m_oIPValidationResult = null;
        this.isDoubleServer = null;
        super.doCleanUp();
    }

    public void setTabSelectedIndex(int iTabIndex) {
        this.sysConfigTabbedPane.setSelectedIndex(iTabIndex);
    }

    public int getBoardTabIndex() {
        return this.THIRD_PARTY_FTP_TAB_INDEX;
    }

    private void refreshButtonStates() {
        if (this.m_oAdressListTable.getSelectedRows().length > 0) {
            this.addButton.setEnabled(true);
            this.m_oModifyButton.setEnabled(true);
            this.m_oDeleteButton.setEnabled(true);
        } else {
            this.m_oModifyButton.setEnabled(false);
            this.m_oDeleteButton.setEnabled(false);
        }
    }

    private class NonEditableTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 3204437868708532261L;

        private NonEditableTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

