/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.configuration.system.PurgeMode;
import java.util.ArrayList;

public class PurgeInfo {
    private static final int MINIMUM_BACK_UP_TIMES = 1;
    private static final int MAXIMUM_BACK_UP_TIMES = 200;
    private ArrayList purgeModeList;
    private int m_iNumOfBackupCopies;
    private int m_iMaximumNoOfBackupCopies;
    private PurgeMode selectedPurgeMode;
    public final PurgeMode AUTOMATICMODE = new PurgeMode();
    public static final PurgeMode MANUALMODE = new PurgeMode();
    private static final PurgeInfo PURGE_INFO = new PurgeInfo();
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private int m_iMinimumNoOfBackupCopies;

    public PurgeMode getSelectedPurgeMode() {
        return this.selectedPurgeMode;
    }

    public static synchronized PurgeInfo getInstance() {
        return PURGE_INFO;
    }

    public void setSelectedPurgeMode(PurgeMode selectedPurgeMode) {
        this.selectedPurgeMode = selectedPurgeMode;
    }

    private PurgeInfo() {
        this.initBackupTimes();
        this.m_iNumOfBackupCopies = this.m_iMinimumNoOfBackupCopies;
        this.AUTOMATICMODE.setName(this.m_oRes.getResString("PURGE_MODE_AUTOMATIC"));
        this.AUTOMATICMODE.setAutomaticMode(true);
        MANUALMODE.setName(this.m_oRes.getResString("PURGE_MODE_MANUAL"));
        MANUALMODE.setAutomaticMode(false);
        this.purgeModeList = new ArrayList(2);
        this.purgeModeList.add(this.AUTOMATICMODE);
        this.purgeModeList.add(MANUALMODE);
        this.selectedPurgeMode = this.AUTOMATICMODE;
    }

    private void initBackupTimes() {
        this.m_iMaximumNoOfBackupCopies = 200;
        this.m_iNumOfBackupCopies = this.m_iMinimumNoOfBackupCopies = 1;
    }

    public PurgeMode getPurgeMode(boolean bIsPurgeModeAutomatic) {
        return bIsPurgeModeAutomatic ? this.AUTOMATICMODE : MANUALMODE;
    }

    public ArrayList getPurgeModeList() {
        return this.purgeModeList;
    }

    public int getNumOfBackupCopies() {
        return this.m_iNumOfBackupCopies;
    }

    public void setNumOfBackupCopies(int numOfBackupCopies) {
        this.m_iNumOfBackupCopies = numOfBackupCopies;
    }

    public int getMaximumBackupTimes() {
        return this.m_iMaximumNoOfBackupCopies;
    }

    public void setMaximumBackupTimes(int iMaxBackupTimes) {
        this.m_iMaximumNoOfBackupCopies = iMaxBackupTimes;
    }

    public int getMinimumBackupTimes() {
        return this.m_iMinimumNoOfBackupCopies;
    }
}

