/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.configuration.system.ProtocolInfo;
import java.text.Collator;
import java.util.Hashtable;

public class ProtocolFactory {
    private static ResourceManager m_oRes = ResourceManager.getInstance();
    private static final String FTP = m_oRes.getResString("FTP");
    private static final String HFCP = m_oRes.getResString("HFCP");
    private static final String SFTP = m_oRes.getResString("SFTP");
    private static final String TFTP = m_oRes.getResString("TFTP");
    private static final String UNKNOWN = m_oRes.getResString("UNKNOWN_PROTOCOL");
    static Hashtable<Integer, ProtocolInfo> oProtocoltable = new Hashtable();
    private static ProtocolFactory m_oProtocolFactory;

    public static ProtocolFactory getInstance() {
        return m_oProtocolFactory;
    }

    private ProtocolFactory() {
    }

    public int getProtocolID(String sProtocolName) {
        Collator ins = Collator.getInstance();
        if (ins.equals(sProtocolName, FTP)) {
            return 1;
        }
        if (ins.equals(sProtocolName, SFTP)) {
            return 2;
        }
        if (ins.equals(sProtocolName, TFTP)) {
            return 4;
        }
        if (ins.equals(sProtocolName, HFCP)) {
            return 8;
        }
        return -1;
    }

    public ProtocolInfo getProtocolInfo(int iProtocolType) {
        switch (iProtocolType) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return (ProtocolInfo)CloneUtil.getClone(oProtocoltable.get(iProtocolType));
            }
        }
        return (ProtocolInfo)CloneUtil.getClone(oProtocoltable.get(-1));
    }

    static {
        ProtocolInfo ftpPro = new ProtocolInfo();
        ftpPro.setProtocolName(FTP);
        ftpPro.setProtoTypeId(1);
        oProtocoltable.put(1, ftpPro);
        ProtocolInfo sftpPro = new ProtocolInfo();
        sftpPro.setProtocolName(SFTP);
        sftpPro.setProtoTypeId(2);
        oProtocoltable.put(2, sftpPro);
        ProtocolInfo tftpPro = new ProtocolInfo();
        tftpPro.setProtocolName(TFTP);
        tftpPro.setProtoTypeId(4);
        oProtocoltable.put(4, tftpPro);
        ProtocolInfo hfcpPro = new ProtocolInfo();
        hfcpPro.setProtocolName(HFCP);
        hfcpPro.setProtoTypeId(8);
        oProtocoltable.put(8, hfcpPro);
        ProtocolInfo unknownPro = new ProtocolInfo();
        unknownPro.setProtocolName(UNKNOWN);
        unknownPro.setProtoTypeId(-1);
        oProtocoltable.put(-1, unknownPro);
        m_oProtocolFactory = new ProtocolFactory();
    }
}

