/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.PurgeInfo;
import com.huawei.dc.configuration.system.PurgeMode;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

public class OperationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean m_bShowConfirmation = true;
    private JPanel m_oPurgePanel;
    private ComboBoxWithToolTip m_oPurgeModeComboBox;
    private SystemSettingDlg m_oSystemSettingDlg;
    private PurgeInfo m_oPurgeModeInfo;
    private Spinner m_oSaveTimes = null;
    private NumericSpinnerModel m_oSpinmodel = null;
    private ISystemManager m_oSystemMgr;
    private ResourceManager m_oRes = ResourceManager.getInstance();
    private JLabel m_oNoOfBackupFilesLabel;

    public OperationPanel(SystemSettingDlg oSystemSettingDlg, PurgeInfo purgeInfo) {
        this.m_oSystemSettingDlg = oSystemSettingDlg;
        this.initializeSystemManager();
        this.m_oPurgeModeInfo = null == purgeInfo ? this.m_oSystemMgr.getPurgeInfo() : purgeInfo;
        this.jbinit();
    }

    private void initializeSystemManager() {
        this.m_oSystemMgr = new SystemManager();
    }

    private void jbinit() {
        this.setLayout(null);
        this.m_oPurgePanel = new JPanel(null);
        TitledBorder ConfigureProtocolBorder = BorderFactory.createTitledBorder(this.m_oRes.getResString("CONFIGURE_PURGE_MODE"));
        this.m_oPurgePanel.setBorder(ConfigureProtocolBorder);
        this.m_oPurgePanel.setBounds(10, 10, 525, 160);
        this.initBackupJSpinner();
        this.m_oSaveTimes.setBounds(220, 120, 120, 20);
        this.m_oPurgeModeComboBox = new ComboBoxWithToolTip(this.m_oPurgeModeInfo.getPurgeModeList().toArray());
        this.m_oPurgeModeComboBox.setName("SystemSetting_OperationPanel_m_oPurgeModeComboBox");
        this.m_oPurgeModeComboBox.setSelectedItem(this.m_oPurgeModeInfo.getSelectedPurgeMode());
        this.m_oPurgeModeComboBox.setBounds(220, 90, 120, 20);
        JLabel oNoteLabel = new JLabel();
        oNoteLabel.setText(this.m_oRes.getResString("PURGE_MODE_NOTE_LABEL"));
        oNoteLabel.setBounds(10, 10, 500, 80);
        JLabel oPurgeModeLabel = new JLabel();
        oPurgeModeLabel.setText(this.m_oRes.getResString("PURGE_MODE"));
        oPurgeModeLabel.setBounds(20, 90, 180, 20);
        this.m_oNoOfBackupFilesLabel = new JLabel();
        this.m_oNoOfBackupFilesLabel.setText(this.m_oRes.getResString("NO_OF_BACKUPS"));
        this.m_oNoOfBackupFilesLabel.setBounds(20, 120, 180, 20);
        this.m_oPurgePanel.add((Component)this.m_oSaveTimes);
        this.m_oPurgePanel.add(this.m_oPurgeModeComboBox);
        this.m_oPurgePanel.add(oPurgeModeLabel);
        this.m_oPurgePanel.add(this.m_oNoOfBackupFilesLabel);
        this.m_oPurgePanel.add(oNoteLabel);
        this.add(this.m_oPurgePanel);
        this.m_oPurgeModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                OperationPanel.this.purgeModeComboBoxChanged();
                OperationPanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }
        });
        this.purgeModeComboBoxChanged();
    }

    private void purgeModeComboBoxChanged() {
        PurgeMode oPurgeMode = (PurgeMode)this.m_oPurgeModeComboBox.getSelectedItem();
        if (!oPurgeMode.isAutomaticMode()) {
            this.m_oNoOfBackupFilesLabel.setVisible(false);
            this.m_oSaveTimes.setVisible(false);
        } else {
            this.m_oNoOfBackupFilesLabel.setVisible(true);
            this.m_oSaveTimes.setVisible(true);
        }
    }

    public void setShowConfirmation(boolean bval) {
        this.m_bShowConfirmation = bval;
    }

    public boolean setPurgeInfo() {
        boolean bIsSuccess = this.validatePurgeInfo();
        if (!bIsSuccess) {
            return false;
        }
        try {
            PurgeMode oPurgeMode = (PurgeMode)this.m_oPurgeModeComboBox.getSelectedItem();
            this.m_oPurgeModeInfo.setSelectedPurgeMode(oPurgeMode);
            if (oPurgeMode.isAutomaticMode()) {
                this.m_oPurgeModeInfo.setNumOfBackupCopies((Integer)this.m_oSpinmodel.getValue());
            }
            int iErrorCode = this.m_oSystemMgr.setPurgeInfo(this.m_oPurgeModeInfo);
            this.displayMessageResult(iErrorCode);
        }
        catch (DCException oDCException) {
            this.showMessageDialog(oDCException.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            DCDebugTracer.trace("DC::OperationPanel::setPurgeInfo()::throw exception::" + oDCException.getMessage());
            bIsSuccess = false;
        }
        return bIsSuccess;
    }

    private boolean validatePurgeInfo() {
        PurgeMode oPurgeMode = (PurgeMode)this.m_oPurgeModeComboBox.getSelectedItem();
        if (!oPurgeMode.isAutomaticMode()) {
            return true;
        }
        boolean bIsValid = false;
        Object oSelectedValue = this.m_oSpinmodel.getValue();
        if (oSelectedValue instanceof Integer) {
            int iCurrValue = (Integer)oSelectedValue;
            int iMaxCount = this.m_oPurgeModeInfo.getMaximumBackupTimes();
            int iMinCount = this.m_oPurgeModeInfo.getMinimumBackupTimes();
            if (iCurrValue >= iMinCount && iCurrValue <= iMaxCount) {
                bIsValid = true;
            }
        }
        if (!bIsValid) {
            this.showMessageDialog(ResourceManager.getInstance().getResString("INVALID_PURGE_VALUE_ERROR"), ResourceManager.getInstance().getResString("ERROR"), 0);
            this.m_oSaveTimes.requestFocus();
            this.m_oSaveTimes.setFocusable(true);
        }
        return bIsValid;
    }

    private void displayMessageResult(int iErrorCode) {
        if (iErrorCode == 0) {
            if (this.m_bShowConfirmation) {
                this.showMessageDialog(0, ResourceManager.getInstance().getResString("INFO"), 1);
            }
        } else {
            this.showMessageDialog(iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
        }
    }

    protected void showMessageDialog(int iErrorCode, String strErrorType, int iOptionType) {
        DCOptionPane.showMessageDialog((Component)((Object)this.m_oSystemSettingDlg), iErrorCode, strErrorType, iOptionType);
    }

    protected void showMessageDialog(String strMsg, String strErrorType, int iOptionType) {
        DCOptionPane.showMessageDialog((Component)((Object)this.m_oSystemSettingDlg), strMsg, strErrorType, iOptionType);
    }

    private void initBackupJSpinner() {
        int iMaxCount = this.m_oPurgeModeInfo.getMaximumBackupTimes();
        int iMinCount = this.m_oPurgeModeInfo.getMinimumBackupTimes();
        int iCurValue = this.m_oPurgeModeInfo.getNumOfBackupCopies();
        if (iMaxCount < iMinCount) {
            iMaxCount = iMinCount;
        }
        if (iCurValue < iMinCount) {
            iCurValue = iMinCount;
        }
        if (iCurValue > iMaxCount) {
            iCurValue = iMaxCount;
        }
        this.m_oSpinmodel = new NumericSpinnerModel(iCurValue, iMinCount, iMaxCount, 1);
        this.m_oSaveTimes = new Spinner((SpinnerModel)this.m_oSpinmodel){
            private static final long serialVersionUID = 4978931810820716272L;

            public void stateChanged(ChangeEvent oEvent) {
                OperationPanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
                super.stateChanged(oEvent);
            }
        };
        this.m_oSaveTimes.setName("SystemSetting_OperationPanel_m_oSaveTimes");
        StringBuffer strToolTipText = new StringBuffer(5);
        strToolTipText.append(iMinCount);
        strToolTipText.append('-');
        strToolTipText.append(iMaxCount);
        this.m_oSaveTimes.setToolTipText(strToolTipText.toString());
    }

    public void disposePanel() {
        this.m_oPurgeModeInfo = null;
        this.m_oPurgePanel = null;
        this.m_oPurgeModeComboBox = null;
        this.m_oSystemSettingDlg = null;
        this.m_oSaveTimes = null;
        this.m_oSpinmodel = null;
        this.m_oSystemMgr = null;
        this.m_oRes = null;
        this.m_oNoOfBackupFilesLabel = null;
    }
}

