/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.NumberTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NetworkSegmentField
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected NumberTextField ipFieldA = new NumberTextField(0, 999, 3);
    protected NumberTextField ipFieldB = new NumberTextField(0, 999, 3);
    protected NumberTextField ipFieldC = new NumberTextField(0, 999, 3);
    protected NumberTextField ipFieldD = new NumberTextField(0, 999, 3);
    protected NumberTextField ipFieldE = new NumberTextField(0, 99, 2);
    protected JLabel dotLabel1 = new JLabel(".", 0);
    protected JLabel dotLabel2 = new JLabel(".", 0);
    protected JLabel dotLabel3 = new JLabel(".", 0);
    protected JLabel dotLabel4 = new JLabel("/", 0);
    public static final Color DEFAULT_BACKGROUND_COLOR = SystemColor.activeCaptionText;
    public static final Color DEFAULT_FOREGROUND_COLOR = SystemColor.textText;
    private String sValue = "";
    private int iColumns = 3;
    private boolean isInternetIP = false;

    public NetworkSegmentField(boolean isInternetIPTextField) {
        this.isInternetIP = isInternetIPTextField;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    private void jbInit() throws Exception {
        this.ipFieldA.setColumns(this.iColumns);
        this.ipFieldA.setName("SystemSetting_NetworkSegmentField_ipFieldA");
        this.ipFieldB.setColumns(this.iColumns);
        this.ipFieldB.setName("SystemSetting_NetworkSegmentField_ipFieldB");
        this.ipFieldC.setColumns(this.iColumns);
        this.ipFieldC.setName("SystemSetting_NetworkSegmentField_ipFieldC");
        this.ipFieldD.setColumns(this.iColumns);
        this.ipFieldD.setName("SystemSetting_NetworkSegmentField_ipFieldD");
        this.ipFieldE.setColumns(2);
        this.ipFieldE.setName("SystemSetting_NetworkSegmentField_ipFieldE");
        this.dotLabel1.setBackground(UIManager.getColor("TextField.background"));
        this.dotLabel1.setFont(new Font("Dialog", 1, 8));
        this.dotLabel1.setBorder(null);
        this.dotLabel1.setRequestFocusEnabled(false);
        this.dotLabel1.setFocusable(false);
        this.dotLabel2.setBackground(UIManager.getColor("TextField.background"));
        this.dotLabel2.setFont(new Font("Dialog", 1, 8));
        this.dotLabel2.setBorder(null);
        this.dotLabel2.setRequestFocusEnabled(false);
        this.dotLabel2.setFocusable(false);
        this.dotLabel3.setBackground(UIManager.getColor("TextField.background"));
        this.dotLabel3.setFont(new Font("Dialog", 1, 8));
        this.dotLabel3.setBorder(null);
        this.dotLabel3.setRequestFocusEnabled(false);
        this.dotLabel3.setFocusable(false);
        this.dotLabel4.setBackground(UIManager.getColor("TextField.background"));
        this.dotLabel4.setFont(new Font("Dialog", 1, 12));
        this.dotLabel4.setBorder(null);
        this.dotLabel4.setRequestFocusEnabled(false);
        this.dotLabel4.setFocusable(false);
        this.setForeground(UIManager.getColor("TextField.foreground"));
        this.setBackground(new Color(227, 232, 233));
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.ipFieldA.setBackground(new Color(227, 232, 233));
        this.ipFieldA.setBorder(null);
        this.ipFieldA.setHorizontalAlignment(0);
        this.ipFieldB.setBorder(null);
        this.ipFieldB.setHorizontalAlignment(0);
        this.ipFieldC.setBorder(null);
        this.ipFieldC.setHorizontalAlignment(0);
        this.ipFieldD.setBorder(null);
        this.ipFieldD.setHorizontalAlignment(0);
        this.ipFieldE.setBorder(null);
        this.ipFieldE.setHorizontalAlignment(0);
        KeyListener keyListener = new KeyListener();
        this.ipFieldA.addKeyListener(keyListener);
        this.ipFieldB.addKeyListener(keyListener);
        this.ipFieldC.addKeyListener(keyListener);
        this.ipFieldD.addKeyListener(keyListener);
        this.ipFieldE.addKeyListener(keyListener);
        FocusHandle focusHandle = new FocusHandle();
        this.ipFieldA.addFocusListener(focusHandle);
        this.ipFieldB.addFocusListener(focusHandle);
        this.ipFieldC.addFocusListener(focusHandle);
        this.ipFieldD.addFocusListener(focusHandle);
        this.ipFieldE.addFocusListener(focusHandle);
        IPTextActionListener actionListener = new IPTextActionListener();
        this.ipFieldA.addActionListener(actionListener);
        this.ipFieldB.addActionListener(actionListener);
        this.ipFieldC.addActionListener(actionListener);
        this.ipFieldD.addActionListener(actionListener);
        this.ipFieldE.addActionListener(actionListener);
        DocListener docListener = new DocListener();
        this.ipFieldA.getDocument().addDocumentListener(docListener);
        this.ipFieldB.getDocument().addDocumentListener(docListener);
        this.ipFieldC.getDocument().addDocumentListener(docListener);
        this.ipFieldD.getDocument().addDocumentListener(docListener);
        this.ipFieldE.getDocument().addDocumentListener(docListener);
        this.setBackground(SystemColor.text);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1), BorderFactory.createLineBorder(new Color(120, 120, 120))));
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.ipFieldA, 0);
        this.add((Component)this.dotLabel1, 1);
        this.add((Component)this.ipFieldB, 2);
        this.add((Component)this.dotLabel2, 3);
        this.add((Component)this.ipFieldC, 4);
        this.add((Component)this.dotLabel3, 5);
        this.add((Component)this.ipFieldD, 6);
        this.add((Component)this.dotLabel4, 7);
        this.add((Component)this.ipFieldE, 8);
    }

    public boolean isEditable() {
        return this.ipFieldA.isEditable();
    }

    public String getIPAddress() {
        return this.sValue;
    }

    @Override
    public void setEnabled(boolean b) {
        this.ipFieldA.setEnabled(b);
        this.dotLabel1.setEnabled(b);
        this.ipFieldB.setEnabled(b);
        this.dotLabel2.setEnabled(b);
        this.ipFieldC.setEnabled(b);
        this.dotLabel3.setEnabled(b);
        this.ipFieldD.setEnabled(b);
        this.dotLabel4.setEnabled(b);
        this.ipFieldE.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this.ipFieldA.isEnabled();
    }

    @Override
    public void setBackground(Color bg) {
        if (this.ipFieldA != null) {
            this.ipFieldA.setBackground(bg);
            this.dotLabel1.setBackground(bg);
            this.ipFieldB.setBackground(bg);
            this.dotLabel2.setBackground(bg);
            this.ipFieldC.setBackground(bg);
            this.dotLabel3.setBackground(bg);
            this.ipFieldD.setBackground(bg);
            this.dotLabel4.setBackground(bg);
            this.ipFieldE.setBackground(bg);
            this.repaint();
        } else {
            super.setBackground(bg);
        }
    }

    @Override
    public Color getBackground() {
        return this.ipFieldA != null ? this.ipFieldA.getBackground() : super.getBackground();
    }

    @Override
    public void setForeground(Color fc) {
        if (this.ipFieldA != null) {
            this.ipFieldA.setForeground(fc);
            this.dotLabel1.setForeground(fc);
            this.ipFieldB.setForeground(fc);
            this.dotLabel2.setForeground(fc);
            this.ipFieldC.setForeground(fc);
            this.dotLabel3.setForeground(fc);
            this.ipFieldD.setForeground(fc);
            this.dotLabel4.setForeground(fc);
            this.ipFieldE.setForeground(fc);
            this.repaint();
        } else {
            super.setForeground(fc);
        }
    }

    @Override
    public Color getForeground() {
        return this.ipFieldA != null ? this.ipFieldA.getForeground() : super.getForeground();
    }

    public void setIPAddress(String strIPAddress) {
        int iIndex = strIPAddress.indexOf(".");
        String strSubString = strIPAddress.substring(0, iIndex);
        this.ipFieldA.setText(strSubString);
        strIPAddress = strIPAddress.substring(iIndex + 1);
        iIndex = strIPAddress.indexOf(".");
        strSubString = strIPAddress.substring(0, iIndex);
        this.ipFieldB.setText(strSubString);
        strIPAddress = strIPAddress.substring(iIndex + 1);
        iIndex = strIPAddress.indexOf(".");
        strSubString = strIPAddress.substring(0, iIndex);
        this.ipFieldC.setText(strSubString);
        strIPAddress = strIPAddress.substring(iIndex + 1);
        iIndex = strIPAddress.indexOf("/");
        strSubString = strIPAddress.substring(0, iIndex);
        this.ipFieldD.setText(strSubString);
        strIPAddress = strIPAddress.substring(iIndex + 1);
        this.ipFieldE.setText(strIPAddress);
    }

    private String buildUPIpAddress() {
        StringBuffer sb = new StringBuffer(0);
        if (this.ipFieldA.getText().length() == 0) {
            return "";
        }
        sb.append(this.ipFieldA.getValueText());
        if (this.ipFieldB.getText().length() == 0) {
            return "";
        }
        sb.append(".").append(this.ipFieldB.getValueText());
        if (this.ipFieldC.getText().length() == 0) {
            return "";
        }
        sb.append(".").append(this.ipFieldC.getValueText());
        if (this.ipFieldD.getText().length() == 0) {
            return "";
        }
        sb.append(".").append(this.ipFieldD.getValueText());
        if (this.ipFieldE.getText().length() == 0) {
            return "";
        }
        sb.append("/").append(this.ipFieldE.getValueText());
        return sb.toString();
    }

    protected void ipFieldA_Action(KeyEvent e) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        int iPosA = this.ipFieldA.getCaretPosition();
        int iLengthA = this.ipFieldA.getText().length();
        String selectedTextA = this.ipFieldA.getSelectedText();
        if (this.specialHomeAndEndKeyAction(keyCode)) {
            return;
        }
        if (keyCode == 39 && iPosA == iLengthA) {
            this.ipFieldB.requestFocus();
            this.ipFieldB.setCaretPosition(0);
            return;
        }
        if (this.automaticJumpCondition(iPosA, keyCode, keyChar, iLengthA, false) || this.dotActionCondition(iPosA, keyCode, keyChar)) {
            if (selectedTextA == null) {
                this.ipFieldB.selectAll();
                this.ipFieldB.requestFocus();
                return;
            }
            return;
        }
        if ((keyCode == 37 || keyCode == 8) && iPosA == 0) {
            int leftLength = this.ipFieldD.getText().length();
            this.ipFieldD.requestFocus();
            this.ipFieldD.setCaretPosition(leftLength);
            return;
        }
    }

    protected void ipFieldB_Action(KeyEvent e) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        int iPosB = this.ipFieldB.getCaretPosition();
        int iLengthB = this.ipFieldB.getText().length();
        String selectedTextB = this.ipFieldB.getSelectedText();
        if (this.specialHomeAndEndKeyAction(keyCode)) {
            return;
        }
        if (keyCode == 39 && iLengthB == iPosB) {
            this.ipFieldC.requestFocus();
            this.ipFieldC.setCaretPosition(0);
            return;
        }
        if (this.automaticJumpCondition(iPosB, keyCode, keyChar, iLengthB, false) || this.dotActionCondition(iPosB, keyCode, keyChar)) {
            if (selectedTextB == null) {
                this.ipFieldC.selectAll();
                this.ipFieldC.requestFocus();
                return;
            }
            return;
        }
        if ((keyCode == 37 || keyCode == 8) && iPosB == 0) {
            int leftLength = this.ipFieldA.getText().length();
            this.ipFieldA.requestFocus();
            this.ipFieldA.setCaretPosition(leftLength);
            return;
        }
    }

    protected void ipFieldC_Action(KeyEvent e) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        int iPosC = this.ipFieldC.getCaretPosition();
        int iLengthC = this.ipFieldC.getText().length();
        String selectedTextC = this.ipFieldC.getSelectedText();
        if (this.specialHomeAndEndKeyAction(keyCode)) {
            return;
        }
        if (e.getKeyCode() == 39 && iLengthC == iPosC) {
            this.ipFieldD.requestFocus();
            this.ipFieldD.setCaretPosition(0);
            return;
        }
        if (this.automaticJumpCondition(iPosC, keyCode, keyChar, iLengthC, false) || this.dotActionCondition(iPosC, keyCode, keyChar)) {
            if (selectedTextC == null) {
                this.ipFieldD.selectAll();
                this.ipFieldD.requestFocus();
                return;
            }
            return;
        }
        if ((keyCode == 37 || keyCode == 8) && iPosC == 0) {
            int leftLength = this.ipFieldB.getText().length();
            this.ipFieldB.requestFocus();
            this.ipFieldB.setCaretPosition(leftLength);
            return;
        }
    }

    protected void ipFieldD_Action(KeyEvent e) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        int iPosD = this.ipFieldD.getCaretPosition();
        int iLengthD = this.ipFieldD.getText().length();
        String selectedTextD = this.ipFieldD.getSelectedText();
        if (this.specialHomeAndEndKeyAction(keyCode)) {
            return;
        }
        if (keyCode == 39 && iLengthD == iPosD) {
            this.ipFieldE.requestFocus();
            this.ipFieldE.setCaretPosition(0);
            return;
        }
        if (this.automaticJumpCondition(iPosD, keyCode, keyChar, iLengthD, false) || this.dotActionCondition(iPosD, keyCode, keyChar)) {
            if (selectedTextD == null) {
                this.ipFieldE.selectAll();
                this.ipFieldE.requestFocus();
                return;
            }
            return;
        }
        if ((keyCode == 37 || keyCode == 8) && iPosD == 0) {
            int leftLength = this.ipFieldC.getText().length();
            this.ipFieldC.requestFocus();
            this.ipFieldC.setCaretPosition(leftLength);
            return;
        }
    }

    protected void ipFieldE_Action(KeyEvent e) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        int iPosD = this.ipFieldE.getCaretPosition();
        int iLengthD = this.ipFieldE.getText().length();
        String selectedTextE = this.ipFieldE.getSelectedText();
        if (this.specialHomeAndEndKeyAction(keyCode)) {
            return;
        }
        if (keyCode == 39 && iLengthD == iPosD) {
            this.ipFieldA.requestFocus();
            this.ipFieldA.setCaretPosition(0);
            return;
        }
        if (this.automaticJumpCondition(iPosD, keyCode, keyChar, iLengthD, true) || this.dotActionCondition(iPosD, keyCode, keyChar)) {
            if (selectedTextE == null) {
                this.ipFieldA.selectAll();
                this.ipFieldA.requestFocus();
                return;
            }
            return;
        }
        if ((keyCode == 37 || keyCode == 8) && iPosD == 0) {
            int leftLength = this.ipFieldD.getText().length();
            this.ipFieldD.requestFocus();
            this.ipFieldD.setCaretPosition(leftLength);
            return;
        }
    }

    private boolean specialHomeAndEndKeyAction(int keyCode) {
        int iLength = this.ipFieldE.getText().length();
        if (keyCode == 36) {
            this.ipFieldA.requestFocus();
            this.ipFieldA.setCaretPosition(0);
            return true;
        }
        if (keyCode == 35) {
            this.ipFieldE.requestFocus();
            this.ipFieldE.setCaretPosition(iLength);
            return true;
        }
        return false;
    }

    private boolean automaticJumpCondition(int caretPosition, int keyCode, int keyChar, int curLength, boolean isFieldE) {
        if (isFieldE) {
            return (caretPosition == 1 && curLength == 1 || caretPosition == 2) && (keyChar == 47 || keyCode == 46 || keyCode == 96 || keyCode == 97 || keyCode == 98 || keyCode == 99 || keyCode == 100 || keyCode == 101 || keyCode == 102 || keyCode == 103 || keyCode == 104 || keyCode == 105 || keyCode == 48 || keyCode == 49 || keyCode == 50 || keyCode == 51 || keyCode == 52 || keyCode == 53 || keyCode == 54 || keyCode == 55 || keyCode == 56 || keyCode == 57);
        }
        return (caretPosition == 2 && curLength == 2 || caretPosition == 3) && (keyChar == 46 || keyCode == 46 || keyCode == 96 || keyCode == 97 || keyCode == 98 || keyCode == 99 || keyCode == 100 || keyCode == 101 || keyCode == 102 || keyCode == 103 || keyCode == 104 || keyCode == 105 || keyCode == 48 || keyCode == 49 || keyCode == 50 || keyCode == 51 || keyCode == 52 || keyCode == 53 || keyCode == 54 || keyCode == 55 || keyCode == 56 || keyCode == 57);
    }

    private boolean dotActionCondition(int caretPosition, int keyCode, int keyChar) {
        return (keyChar == 46 || keyChar == 47) && keyCode != 0 && caretPosition != 0;
    }

    public NumberTextField getTextFieldA() {
        return this.ipFieldA;
    }

    public NumberTextField getTextFieldB() {
        return this.ipFieldB;
    }

    public NumberTextField getTextFieldC() {
        return this.ipFieldC;
    }

    public NumberTextField getTextFieldD() {
        return this.ipFieldD;
    }

    public NumberTextField getTextFieldE() {
        return this.ipFieldE;
    }

    private class IPTextActionListener
    implements ActionListener {
        private IPTextActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == NetworkSegmentField.this.ipFieldA) {
                NetworkSegmentField.this.ipFieldA.setFocusable(false);
                NetworkSegmentField.this.ipFieldA.setFocusable(true);
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldB) {
                NetworkSegmentField.this.ipFieldB.setFocusable(false);
                NetworkSegmentField.this.ipFieldB.setFocusable(true);
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldC) {
                NetworkSegmentField.this.ipFieldC.setFocusable(false);
                NetworkSegmentField.this.ipFieldC.setFocusable(true);
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldD) {
                NetworkSegmentField.this.ipFieldD.setFocusable(false);
                NetworkSegmentField.this.ipFieldD.setFocusable(true);
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldE) {
                NetworkSegmentField.this.ipFieldE.setFocusable(false);
                NetworkSegmentField.this.ipFieldE.setFocusable(true);
                return;
            }
        }
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String strNewVal = NetworkSegmentField.this.buildUPIpAddress();
            if (!strNewVal.equals(NetworkSegmentField.this.sValue)) {
                NetworkSegmentField.this.sValue = strNewVal;
            }
        }

        @Override
        public synchronized void insertUpdate(DocumentEvent e) {
            String strNewVal = NetworkSegmentField.this.buildUPIpAddress();
            if (!strNewVal.equals(NetworkSegmentField.this.sValue)) {
                NetworkSegmentField.this.sValue = strNewVal;
            }
        }

        @Override
        public synchronized void removeUpdate(DocumentEvent e) {
            String strNewVal = NetworkSegmentField.this.buildUPIpAddress();
            if (!strNewVal.equals(NetworkSegmentField.this.sValue)) {
                NetworkSegmentField.this.sValue = strNewVal;
            }
        }
    }

    private class FocusHandle
    implements FocusListener {
        private FocusHandle() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object obj = e.getSource();
            if (obj == NetworkSegmentField.this.ipFieldA) {
                NetworkSegmentField.this.ipFieldB.setFocusable(true);
                NetworkSegmentField.this.ipFieldC.setFocusable(true);
                NetworkSegmentField.this.ipFieldD.setFocusable(true);
                NetworkSegmentField.this.ipFieldE.setFocusable(true);
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldB) {
                NetworkSegmentField.this.ipFieldA.setFocusable(true);
                NetworkSegmentField.this.ipFieldC.setFocusable(true);
                NetworkSegmentField.this.ipFieldD.setFocusable(true);
                NetworkSegmentField.this.ipFieldE.setFocusable(true);
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldC) {
                NetworkSegmentField.this.ipFieldA.setFocusable(true);
                NetworkSegmentField.this.ipFieldB.setFocusable(true);
                NetworkSegmentField.this.ipFieldD.setFocusable(true);
                NetworkSegmentField.this.ipFieldE.setFocusable(true);
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldD) {
                NetworkSegmentField.this.ipFieldA.setFocusable(true);
                NetworkSegmentField.this.ipFieldB.setFocusable(true);
                NetworkSegmentField.this.ipFieldC.setFocusable(true);
                NetworkSegmentField.this.ipFieldE.setFocusable(true);
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldE) {
                NetworkSegmentField.this.ipFieldA.setFocusable(true);
                NetworkSegmentField.this.ipFieldB.setFocusable(true);
                NetworkSegmentField.this.ipFieldC.setFocusable(true);
                NetworkSegmentField.this.ipFieldD.setFocusable(true);
                return;
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object obj = e.getSource();
            if (obj == NetworkSegmentField.this.ipFieldA) {
                int iLengthA = NetworkSegmentField.this.ipFieldA.getText().length();
                String valueTxtA = NetworkSegmentField.this.ipFieldA.getValueText();
                if (iLengthA != 0) {
                    int value = Integer.parseInt(valueTxtA);
                    if (NetworkSegmentField.this.isInternetIP) {
                        if (value == 0 || value > 223) {
                            NetworkSegmentField.this.ipFieldB.setCaretPosition(0);
                            NetworkSegmentField.this.ipFieldB.setFocusable(false);
                            NetworkSegmentField.this.ipFieldA.requestFocus();
                            if (value == 0) {
                                NetworkSegmentField.this.ipFieldA.setText("1");
                            }
                            if (value > 223) {
                                NetworkSegmentField.this.ipFieldA.setText("223");
                            }
                            NetworkSegmentField.this.ipFieldA.setCaretPosition(0);
                            return;
                        }
                    } else {
                        if (value > 255) {
                            NetworkSegmentField.this.ipFieldB.setCaretPosition(0);
                            NetworkSegmentField.this.ipFieldB.setFocusable(false);
                            NetworkSegmentField.this.ipFieldA.requestFocus();
                            NetworkSegmentField.this.ipFieldA.setText("255");
                            NetworkSegmentField.this.ipFieldA.setCaretPosition(0);
                            return;
                        }
                        return;
                    }
                }
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldB) {
                int value;
                int iLengthB = NetworkSegmentField.this.ipFieldB.getText().length();
                String valueTxtB = NetworkSegmentField.this.ipFieldB.getValueText();
                if (iLengthB != 0 && (value = Integer.parseInt(valueTxtB)) > 255) {
                    NetworkSegmentField.this.ipFieldC.setCaretPosition(0);
                    NetworkSegmentField.this.ipFieldC.setFocusable(false);
                    NetworkSegmentField.this.ipFieldB.requestFocus();
                    NetworkSegmentField.this.ipFieldB.setText("255");
                    NetworkSegmentField.this.ipFieldB.setCaretPosition(0);
                    return;
                }
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldC) {
                int value;
                int iLengthC = NetworkSegmentField.this.ipFieldC.getText().length();
                String valueTxtC = NetworkSegmentField.this.ipFieldC.getValueText();
                if (iLengthC != 0 && (value = Integer.parseInt(valueTxtC)) > 255) {
                    NetworkSegmentField.this.ipFieldA.setCaretPosition(0);
                    NetworkSegmentField.this.ipFieldA.setFocusable(false);
                    NetworkSegmentField.this.ipFieldC.requestFocus();
                    NetworkSegmentField.this.ipFieldC.setText("255");
                    NetworkSegmentField.this.ipFieldC.setCaretPosition(0);
                    return;
                }
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldD) {
                int value;
                int iLengthD = NetworkSegmentField.this.ipFieldD.getText().length();
                String valueTxtD = NetworkSegmentField.this.ipFieldD.getValueText();
                if (iLengthD != 0 && (value = Integer.parseInt(valueTxtD)) > 255) {
                    NetworkSegmentField.this.ipFieldA.setCaretPosition(0);
                    NetworkSegmentField.this.ipFieldA.setFocusable(false);
                    NetworkSegmentField.this.ipFieldD.requestFocus();
                    NetworkSegmentField.this.ipFieldD.setText("255");
                    NetworkSegmentField.this.ipFieldD.setCaretPosition(0);
                    return;
                }
                return;
            }
            if (obj == NetworkSegmentField.this.ipFieldE) {
                int value;
                int iLengthD = NetworkSegmentField.this.ipFieldE.getText().length();
                String valueTxtD = NetworkSegmentField.this.ipFieldE.getValueText();
                if (iLengthD != 0 && (value = Integer.parseInt(valueTxtD)) > 31) {
                    NetworkSegmentField.this.ipFieldA.setCaretPosition(0);
                    NetworkSegmentField.this.ipFieldA.setFocusable(false);
                    NetworkSegmentField.this.ipFieldE.requestFocus();
                    NetworkSegmentField.this.ipFieldE.setText("31");
                    NetworkSegmentField.this.ipFieldE.setCaretPosition(0);
                    return;
                }
                return;
            }
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Object obj = e.getSource();
            if (obj == NetworkSegmentField.this.ipFieldA) {
                NetworkSegmentField.this.ipFieldA_Action(e);
            }
            if (obj == NetworkSegmentField.this.ipFieldB) {
                NetworkSegmentField.this.ipFieldB_Action(e);
            }
            if (obj == NetworkSegmentField.this.ipFieldC) {
                NetworkSegmentField.this.ipFieldC_Action(e);
            }
            if (obj == NetworkSegmentField.this.ipFieldD) {
                NetworkSegmentField.this.ipFieldD_Action(e);
            }
            if (obj == NetworkSegmentField.this.ipFieldE) {
                NetworkSegmentField.this.ipFieldE_Action(e);
            }
        }
    }
}

