/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.NetworkSegmentField;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class MultipleNICSettingDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private JPanel m_oMultipleNICInfoPanel;
    private JLabel m_oIPAddressLabel;
    private JLabel m_oIPAddressNELabel;
    private IPAddressTextField m_oServerIPAddressTxt;
    private NetworkSegmentField m_oNeIPAddressTxt;
    private String m_strIPAddress = "";
    private String m_strNeIPAddress = "";
    private JTable m_oAdressListTable;
    private int m_iType = 0;
    static final int ADD_TYPE = 0;
    static final int MODIFY_TYPE = 1;

    public MultipleNICSettingDlg(int iType, JTable m_oAdressListTable) {
        this.m_iType = iType;
        this.m_oAdressListTable = m_oAdressListTable;
        this.jbInit();
    }

    private void jbInit() {
        if (0 == this.m_iType) {
            this.setTitle(ResourceManager.getInstance().getResString("SYS_SETTING_MULTIPLE_NIC_ADD_TITLE"));
        } else {
            this.setTitle(ResourceManager.getInstance().getResString("SYS_SETTING_MULTIPLE_NIC_MODIFY_TITLE"));
        }
        int iSelRow = this.m_oAdressListTable.getSelectedRow();
        if (iSelRow >= 0) {
            this.m_strIPAddress = this.m_oAdressListTable.getValueAt(iSelRow, 0).toString();
            this.m_strNeIPAddress = this.m_oAdressListTable.getValueAt(iSelRow, 1).toString();
        }
        this.setSize(290, 180);
        this.setResizable(false);
        this.setLayout(null);
        this.initPanel();
        this.initIPAddressTxtField();
        this.initNEIPAddressTxtField();
        this.addButtons();
    }

    private void initPanel() {
        this.m_oMultipleNICInfoPanel = new JPanel();
        this.m_oMultipleNICInfoPanel.setName("Configuration_System_MultipleNICSettingDlg_m_oMultipleNICInfoPanel");
        this.m_oMultipleNICInfoPanel.setLayout(null);
        this.m_oMultipleNICInfoPanel.setBounds(10, 10, 262, 100);
        this.getContentPane().add(this.m_oMultipleNICInfoPanel);
        this.m_oMultipleNICInfoPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
    }

    private void initIPAddressTxtField() {
        this.m_oIPAddressLabel = new JLabel(ResourceManager.getInstance().getResString("SYS_SETTING_MULTIPLE_NIC_IP_ADDRESS") + ":");
        this.m_oIPAddressLabel.setName("Configuration_System_MultipleNICSettingDlg_m_oIPAddressLabel");
        this.m_oIPAddressLabel.setBounds(12, 22, 150, 20);
        this.m_oServerIPAddressTxt = new IPAddressTextField();
        this.m_oServerIPAddressTxt.setName("Configuration_System_MultipleNICSettingDlg_m_oServerIPAddressTxt");
        this.m_oServerIPAddressTxt.setBounds(130, 22, 120, 20);
        if (!this.m_strIPAddress.equals("")) {
            this.m_oServerIPAddressTxt.setText(this.m_strIPAddress);
        }
        this.m_oMultipleNICInfoPanel.add(this.m_oIPAddressLabel);
        this.m_oMultipleNICInfoPanel.add((Component)this.m_oServerIPAddressTxt);
    }

    private void initNEIPAddressTxtField() {
        this.m_oIPAddressNELabel = new JLabel(ResourceManager.getInstance().getResString("SYS_SETTING_MULTIPLE_NIC_NE_IP_ADDRESS") + ":");
        this.m_oIPAddressNELabel.setName("Configuration_System_MultipleNICSettingDlg_m_oIPAddressNELabel");
        this.m_oIPAddressNELabel.setBounds(12, 55, 150, 20);
        this.m_oNeIPAddressTxt = new NetworkSegmentField(false);
        this.m_oNeIPAddressTxt.setName("Configuration_System_MultipleNICSettingDlg_m_oNeIPAddressTxt");
        this.m_oNeIPAddressTxt.setBackground(this.m_oServerIPAddressTxt.getBackground());
        this.m_oNeIPAddressTxt.setBounds(130, 55, 120, 20);
        if (!this.m_strNeIPAddress.equals("")) {
            this.m_oNeIPAddressTxt.setIPAddress(this.m_strNeIPAddress);
        }
        this.m_oMultipleNICInfoPanel.add(this.m_oIPAddressNELabel);
        this.m_oMultipleNICInfoPanel.add(this.m_oNeIPAddressTxt);
    }

    private void addButtons() {
        this.m_oOKBtn.setName("Configuration_System_MultipleNICSettingDlg_m_oOKBtn");
        this.m_oOKBtn.setBounds(100, 120, 80, 20);
        this.m_oOKBtn.setFocusable(true);
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("OK_BTN"));
        this.getContentPane().add(this.m_oOKBtn);
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MultipleNICSettingDlg.this.okBtnActionPerformed();
            }
        });
        this.m_oCancelBtn.setName("Configuration_System_MultipleNICSettingDlg_m_oCancelBtn");
        this.m_oCancelBtn.setBounds(192, 120, 80, 20);
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("CANCEL_BTN"));
        this.getContentPane().add(this.m_oCancelBtn);
    }

    private boolean checkInputData() {
        String strIpAdrress = "";
        try {
            strIpAdrress = this.m_oServerIPAddressTxt.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        if (strIpAdrress.length() == 0) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("SYSTEM_INFO_IP_ADDRESS_EMPTY"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
            this.setIPTextFieldFocus((Component)this.m_oServerIPAddressTxt);
            return false;
        }
        int iIndex = strIpAdrress.lastIndexOf(46);
        String strLastSegment = strIpAdrress.substring(iIndex + 1);
        if (strLastSegment.equals("255") || strLastSegment.equals("0")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("INVALID_NMS_SERVER_IP_ADDRESS"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
            this.setIPTextFieldFocus((Component)this.m_oServerIPAddressTxt);
            return false;
        }
        if (this.m_oNeIPAddressTxt.getIPAddress().length() == 0) {
            this.handleIfNEIPaddressInvalid();
            return false;
        }
        if (this.m_oNeIPAddressTxt.getIPAddress().startsWith("0") || Integer.parseInt(this.m_oNeIPAddressTxt.getTextFieldA().getText()) >= 224) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NETWORK_IP_ADDRESS_INVALID"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
            this.m_oNeIPAddressTxt.grabFocus();
            return false;
        }
        return true;
    }

    private void okBtnActionPerformed() {
        if (this.checkInputData()) {
            if (0 == this.m_iType) {
                this.handleRowInsertion();
            } else {
                this.handleRowModify();
            }
        }
    }

    private void setIPTextFieldFocus(Component oServerIPAddressTxt) {
        oServerIPAddressTxt.setFocusable(true);
        oServerIPAddressTxt.requestFocus();
    }

    private void handleIfNEIPaddressInvalid() {
        DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NETWORK_IP_ADDRESS_EMPTY"), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
        if (0 == this.m_oNeIPAddressTxt.getTextFieldA().getText().length()) {
            this.m_oNeIPAddressTxt.getTextFieldA().requestFocus();
            this.m_oNeIPAddressTxt.getTextFieldA().setFocusable(true);
        } else if (0 == this.m_oNeIPAddressTxt.getTextFieldB().getText().length()) {
            this.m_oNeIPAddressTxt.getTextFieldB().requestFocus();
            this.m_oNeIPAddressTxt.getTextFieldB().setFocusable(true);
        } else if (0 == this.m_oNeIPAddressTxt.getTextFieldC().getText().length()) {
            this.m_oNeIPAddressTxt.getTextFieldC().requestFocus();
            this.m_oNeIPAddressTxt.getTextFieldC().setFocusable(true);
        } else if (0 == this.m_oNeIPAddressTxt.getTextFieldD().getText().length()) {
            this.m_oNeIPAddressTxt.getTextFieldD().requestFocus();
            this.m_oNeIPAddressTxt.getTextFieldD().setFocusable(true);
        } else {
            this.m_oNeIPAddressTxt.getTextFieldE().requestFocus();
            this.m_oNeIPAddressTxt.getTextFieldE().setFocusable(true);
        }
    }

    private void handleRowInsertion() {
        int rowCount = this.m_oAdressListTable.getRowCount();
        String strIPAddress = "";
        try {
            strIPAddress = this.m_oServerIPAddressTxt.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        String strNEIPAddress = this.m_oNeIPAddressTxt.getIPAddress();
        boolean bIsAdd = this.checkTable(this.m_oNeIPAddressTxt.getIPAddress(), strIPAddress, -1);
        SystemManager m_oSystemMgr = new SystemManager();
        int errorCode = m_oSystemMgr.validateServerIP(strIPAddress);
        if (errorCode == 989855843) {
            DCOptionPane.showMessageDialog((Component)((Object)this), errorCode, ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
            this.m_oServerIPAddressTxt.grabFocus();
            return;
        }
        if (errorCode == 989855845 && bIsAdd) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorCode, ResourceManager.getInstance().getResString("WARNING"), 2);
        }
        if (!bIsAdd) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NETWORK_IP_ADDRESS_ALREADY_CONFIGURED"), ResourceManager.getInstance().getResString("INFO"), 1);
            return;
        }
        ((DefaultTableModel)this.m_oAdressListTable.getModel()).insertRow(rowCount, new String[]{strIPAddress, strNEIPAddress});
        int iNewRowCount = this.m_oAdressListTable.getRowCount();
        this.m_oAdressListTable.setRowSelectionInterval(iNewRowCount - 1, iNewRowCount - 1);
        super.closeDialog();
    }

    private void handleRowModify() {
        int iRowCount = this.m_oAdressListTable.getSelectedRow();
        String serverIPAddres = "";
        try {
            serverIPAddres = this.m_oServerIPAddressTxt.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        boolean bIsAdd = this.checkTable(this.m_oNeIPAddressTxt.getIPAddress(), serverIPAddres, iRowCount);
        SystemManager m_oSystemMgr = new SystemManager();
        int errorCode = m_oSystemMgr.validateServerIP(serverIPAddres);
        if (errorCode == 989855843) {
            DCOptionPane.showMessageDialog((Component)((Object)this), errorCode, ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
            return;
        }
        if (errorCode == 989855845 && bIsAdd) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorCode, ResourceManager.getInstance().getResString("WARNING"), 2);
        }
        if (!bIsAdd) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NETWORK_IP_ADDRESS_ALREADY_CONFIGURED"), ResourceManager.getInstance().getResString("INFO"), 1);
            return;
        }
        this.m_oAdressListTable.setValueAt(serverIPAddres, iRowCount, 0);
        this.m_oAdressListTable.setValueAt(this.m_oNeIPAddressTxt.getIPAddress(), iRowCount, 1);
        super.closeDialog();
    }

    private boolean checkTable(String neSegementIP, String serverIP, int iSelectedRow) {
        boolean bIsAdd = true;
        for (int count = 0; count < this.m_oAdressListTable.getRowCount(); ++count) {
            String neIP;
            if (count == iSelectedRow || !(neIP = (String)this.m_oAdressListTable.getModel().getValueAt(count, 1)).equals(neSegementIP)) continue;
            bIsAdd = false;
            break;
        }
        return bIsAdd;
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }
}

