/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import com.huawei.dc.common.asndatacenter.AsnProtocolEnum;
import com.huawei.dc.common.components.u2kcbb.U2kPasswordFiled;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.system.DirTextField;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.configuration.system.ProtocolConfigInfo;
import com.huawei.dc.configuration.system.SystemSettingDlg;
import com.huawei.dc.toolkit.client.base.util.TKCommonUtil;
import com.huawei.u2000.framework.help.HelpLabel;
import com.swimap.imap12.util.InmLengthLimitTextField;
import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileTransferServicePanel
extends JPanel {
    private static final long serialVersionUID = 2014960019916621390L;
    private static final int MAXIMUM_DIR_LENGTH = 101;
    private boolean m_bShowConfirmation = true;
    private InmLengthLimitTextField m_oFTPUserNameTextField = null;
    private U2kPasswordFiled m_oFTPPasswordField = null;
    private InmLengthLimitTextField m_oSFTPUserNameTextField = null;
    private U2kPasswordFiled m_oSFTPPasswordField = null;
    private SystemSettingDlg m_oSystemSettingDlg;
    private DirTextField m_oRootPath = null;
    private JButton m_oTestFTPBtn = null;
    private HelpLabel pathhelpLable = null;
    private JButton m_oTestSFTPButton = null;
    private ISystemManager m_oSystemManager = new SystemManager();
    private JButton m_oTestTFTPButton = null;
    private Spinner m_oPortNoSpin = null;
    private NumericSpinnerModel m_oSpinmodel = null;
    private Spinner m_oPortNoSpinForFTP = null;
    private NumericSpinnerModel m_oSpinmodelForFTP = null;
    public static final char FTP_BUTTON_MNEMONIC = 'F';
    public static final char SFTP_BUTTON_MNEMONIC = 'S';
    public static final char TFTP_BUTTON_MNEMONIC = 'T';
    public static final int USER_NAME_LENGTH = 20;
    private FTSInfo m_oFTSInfo = null;

    public FileTransferServicePanel(SystemSettingDlg oSystemSettingDlg, FTSInfo ftpInfo) {
        super(null);
        this.m_oFTSInfo = null == ftpInfo ? this.m_oSystemManager.getFTSInfo() : ftpInfo;
        this.m_oSystemSettingDlg = oSystemSettingDlg;
        this.jbinit();
    }

    private void jbinit() {
        JPanel oDirSettingInfoPanel = this.createDirSettingInfoPanel();
        JPanel oConfigureProtocol = this.createConfigureFTPProtocolPanel();
        this.setDefaultUserNamePassword();
        this.add(oDirSettingInfoPanel);
        this.add(oConfigureProtocol);
    }

    private JPanel createDirSettingInfoPanel() {
        JPanel oDirSettingInfoPanel = new JPanel(null);
        JLabel oDirectortyInServer = new JLabel();
        this.m_oRootPath = new DirTextField();
        this.m_oRootPath.setRootDir(true);
        this.m_oRootPath.setTextValue(this.m_oFTSInfo.getRootDirectory());
        this.m_oRootPath.setText(this.m_oFTSInfo.getRootDirectory());
        this.m_oRootPath.setToolTipText(ResourceManager.getInstance().getResString("ROOT_CANNOT_HAVE_SPECIAL_CHARACTERS"));
        oDirectortyInServer.setText(this.getLocalisedString("DIRECTORY_IN_SERVER"));
        oDirectortyInServer.setBounds(10, 24, 200, 22);
        this.m_oRootPath.setBounds(230, 27, 120, 22);
        String strpathHelpID = ResourceManager.getInstance().getResString("HELP_TOPIC_DIRECTORY_SETTING", "helpmapfile");
        this.pathhelpLable = new HelpLabel("", strpathHelpID);
        this.pathhelpLable.setBounds(356, 27, 20, 21);
        this.pathhelpLable.setIcon((Icon)ResourceManager.getInstance().getImage("help1.png"));
        if (!DCFrameWorkUtil.isHelpIDFormSA()) {
            oDirSettingInfoPanel.add((Component)this.pathhelpLable);
        }
        TitledBorder oTitledBorder = BorderFactory.createTitledBorder(this.getLocalisedString("DIRECTORY_SETTING"));
        this.registerRootPathActionLister();
        oDirSettingInfoPanel.setBorder(oTitledBorder);
        oDirSettingInfoPanel.setBounds(10, 6, 525, 63);
        oDirSettingInfoPanel.add(oDirectortyInServer);
        oDirSettingInfoPanel.add(this.m_oRootPath);
        return oDirSettingInfoPanel;
    }

    private JPanel createConfigureFTPProtocolPanel() {
        JPanel oConfigureFTSPanel = new JPanel(null);
        TitledBorder oConfigureFTSPanelBorder = BorderFactory.createTitledBorder(this.getLocalisedString("FILE_TRANSFER_SERVICE_CONFIGURATION"));
        oConfigureFTSPanel.setBorder(oConfigureFTSPanelBorder);
        oConfigureFTSPanel.setBounds(10, 73, 525, 285);
        JPanel oConfigureFTPPanel = this.createConfigureFTPPanel();
        JPanel oConfigureSFTPPanel = this.createConfigureSFTPPanel();
        JPanel oConfigureTFTPPanel = this.createConfigureTFTPPanel();
        oConfigureFTSPanel.add(oConfigureFTPPanel);
        oConfigureFTSPanel.add(oConfigureSFTPPanel);
        oConfigureFTSPanel.add(oConfigureTFTPPanel);
        JPanel oConfigureProtcolPanel = new JPanel(null);
        TitledBorder ConfigureProtocolBorder = BorderFactory.createTitledBorder(this.getLocalisedString("CONFIGURE_FTP"));
        oConfigureProtcolPanel.setBorder(ConfigureProtocolBorder);
        oConfigureProtcolPanel.setBounds(10, 120, 500, 120);
        oConfigureProtcolPanel.add(oConfigureFTSPanel);
        return oConfigureFTSPanel;
    }

    private JPanel createConfigureTFTPPanel() {
        JPanel oConfigureTFTPPanel = new JPanel(null);
        TitledBorder oConfigureTFTPPanelBorder = BorderFactory.createTitledBorder(this.getLocalisedString("CONFIGURE_TFTP"));
        oConfigureTFTPPanel.setBorder(oConfigureTFTPPanelBorder);
        oConfigureTFTPPanel.setBounds(15, 218, 492, 55);
        JLabel oNoConfForTFTP = new JLabel(this.getLocalisedString("NO_CONF_FOR_TFTP"));
        oNoConfForTFTP.setBounds(10, 20, 250, 20);
        this.m_oTestTFTPButton = new JButton(this.getLocalisedString("TEST_TFTP"));
        this.m_oTestTFTPButton.setName("SystemSetting_FileTransferServicePanel_m_oTestTFTPButton");
        this.m_oTestTFTPButton.setMnemonic('T');
        this.m_oTestTFTPButton.setBounds(370, 20, 100, 20);
        this.registerTFTPButtonActionListener();
        oConfigureTFTPPanel.add(this.m_oTestTFTPButton);
        oConfigureTFTPPanel.add(oNoConfForTFTP);
        return oConfigureTFTPPanel;
    }

    private JPanel createConfigureSFTPPanel() {
        JPanel oConfigureSFTPPanel = new JPanel(null);
        TitledBorder oConfigureSFTPPanelBorder = BorderFactory.createTitledBorder(this.getLocalisedString("CONFIGURE_SFTP"));
        oConfigureSFTPPanel.setBorder(oConfigureSFTPPanelBorder);
        oConfigureSFTPPanel.setBounds(15, 117, 492, 93);
        JLabel oSFTPUserNameLabel = new JLabel(this.getLocalisedString("FTP_USER_NAME"));
        oSFTPUserNameLabel.setBounds(10, 25, 100, 20);
        JLabel oSFTPPortNumberLabel = new JLabel(this.getLocalisedString("SFTP_PORT_NUMBER"));
        oSFTPPortNumberLabel.setBounds(280, 25, 100, 20);
        this.m_oSFTPUserNameTextField = new InmLengthLimitTextField(20);
        this.m_oSFTPUserNameTextField.setName("SystemSetting_FileTransferServicePanel_m_oSFTPUserNameTextField");
        this.m_oSFTPUserNameTextField.setBounds(115, 25, 130, 20);
        JLabel oSFTPpasswordLabel = new JLabel(this.getLocalisedString("PASSWORD"));
        oSFTPpasswordLabel.setBounds(10, 55, 100, 20);
        this.m_oSFTPPasswordField = new U2kPasswordFiled(40);
        this.m_oSFTPPasswordField.setName("SystemSetting_FileTransferServicePanel_m_oSFTPPasswordField");
        this.m_oSFTPPasswordField.setBounds(115, 55, 130, 20);
        this.registerSftpUserNameActionListener();
        this.registerSftpPasswordActionListener();
        this.m_oTestSFTPButton = new JButton(this.getLocalisedString("TEST_SFTP"));
        this.m_oTestSFTPButton.setName("SystemSetting_FileTransferServicePanel_m_oTestSFTPButton");
        this.m_oTestSFTPButton.setBounds(370, 55, 100, 20);
        this.m_oTestSFTPButton.setMnemonic('S');
        this.registerSFTPButtonActionListener();
        oConfigureSFTPPanel.add(oSFTPUserNameLabel);
        oConfigureSFTPPanel.add(oSFTPPortNumberLabel);
        oConfigureSFTPPanel.add((Component)this.m_oSFTPUserNameTextField);
        oConfigureSFTPPanel.add(oSFTPpasswordLabel);
        oConfigureSFTPPanel.add(this.m_oSFTPPasswordField);
        oConfigureSFTPPanel.add(this.m_oTestSFTPButton);
        this.m_oSpinmodel = new NumericSpinnerModel(22, 0, 65535, 1);
        this.m_oPortNoSpin = new Spinner((SpinnerModel)this.m_oSpinmodel){
            private static final long serialVersionUID = -5385634374042992762L;

            public void stateChanged(ChangeEvent oEvent) {
                FileTransferServicePanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
                super.stateChanged(oEvent);
            }
        };
        this.m_oPortNoSpin.setName("SystemSetting_FileTransferServicePanel_m_oPortNoSpin");
        this.m_oPortNoSpin.setBounds(370, 25, 100, 20);
        this.m_oPortNoSpin.setToolTipText("0-65535");
        oConfigureSFTPPanel.add((Component)this.m_oPortNoSpin);
        return oConfigureSFTPPanel;
    }

    private JPanel createConfigureFTPPanel() {
        JPanel oConfigureFTPPanel = new JPanel(null);
        TitledBorder oConfigureFTPPanelBorder = BorderFactory.createTitledBorder(this.getLocalisedString("CONFIGURE_FTP"));
        oConfigureFTPPanel.setBorder(oConfigureFTPPanelBorder);
        oConfigureFTPPanel.setBounds(15, 20, 492, 93);
        JLabel oFTPUserNameLabel = new JLabel(this.getLocalisedString("FTP_USER_NAME"));
        oFTPUserNameLabel.setBounds(10, 25, 100, 20);
        JLabel oFTPPortNumberLabel = new JLabel(this.getLocalisedString("SFTP_PORT_NUMBER"));
        oFTPPortNumberLabel.setBounds(280, 25, 100, 20);
        this.m_oFTPUserNameTextField = new InmLengthLimitTextField(20);
        this.m_oFTPUserNameTextField.setName("SystemSetting_FileTransferServicePanel_m_oFTPUserNameTextField");
        this.m_oFTPUserNameTextField.setBounds(115, 25, 130, 20);
        JLabel oFTPpasswordLabel = new JLabel(this.getLocalisedString("PASSWORD"));
        oFTPpasswordLabel.setBounds(10, 55, 100, 20);
        this.m_oFTPPasswordField = new U2kPasswordFiled(40);
        this.m_oFTPPasswordField.setName("SystemSetting_FileTransferServicePanel_m_oFTPPasswordField");
        this.m_oFTPPasswordField.setBounds(115, 55, 130, 20);
        this.m_oTestFTPBtn = new JButton();
        this.m_oTestFTPBtn.setName("SystemSetting_FileTransferServicePanel_m_oTestFTPBtn");
        this.m_oTestFTPBtn.setText(this.getLocalisedString("TEST_FTP"));
        this.m_oTestFTPBtn.setMnemonic('F');
        this.m_oTestFTPBtn.setBounds(370, 55, 100, 20);
        this.registerFTPButtonActionListener();
        this.registerFtpUserNameActionListener();
        this.registerFtpPasswordActionListener();
        oConfigureFTPPanel.add(oFTPUserNameLabel);
        oConfigureFTPPanel.add(oFTPPortNumberLabel);
        oConfigureFTPPanel.add((Component)this.m_oFTPUserNameTextField);
        oConfigureFTPPanel.add(oFTPpasswordLabel);
        oConfigureFTPPanel.add(this.m_oFTPPasswordField);
        oConfigureFTPPanel.add(this.m_oTestFTPBtn);
        this.m_oSpinmodelForFTP = new NumericSpinnerModel(22, 0, 65535, 1);
        this.m_oPortNoSpinForFTP = new Spinner((SpinnerModel)this.m_oSpinmodelForFTP){
            private static final long serialVersionUID = -7189968229203239337L;

            public void stateChanged(ChangeEvent oEvent) {
                FileTransferServicePanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
                super.stateChanged(oEvent);
            }
        };
        this.m_oPortNoSpinForFTP.setName("SystemSetting_FileTransferServicePanel_m_oPortNoSpinForFTP");
        this.m_oPortNoSpinForFTP.setBounds(370, 25, 100, 20);
        this.m_oPortNoSpinForFTP.setToolTipText("0-65535");
        oConfigureFTPPanel.add((Component)this.m_oPortNoSpinForFTP);
        return oConfigureFTPPanel;
    }

    private void registerRootPathActionLister() {
        this.m_oRootPath.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                FileTransferServicePanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }
        });
    }

    private void registerFtpUserNameActionListener() {
        this.m_oFTPUserNameTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                FileTransferServicePanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }
        });
    }

    private void registerFtpPasswordActionListener() {
        this.m_oFTPPasswordField.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileTransferServicePanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void registerSftpUserNameActionListener() {
        this.m_oSFTPUserNameTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                FileTransferServicePanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }
        });
    }

    private void registerSftpPasswordActionListener() {
        this.m_oSFTPPasswordField.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileTransferServicePanel.this.m_oSystemSettingDlg.setApplyButtonEnable(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void registerTFTPButtonActionListener() {
        this.m_oTestTFTPButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransferServicePanel.this.tftpButtonActionPerformed();
            }
        });
    }

    private void registerFTPButtonActionListener() {
        this.m_oTestFTPBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransferServicePanel.this.testFTPButtonActionPerformed();
            }
        });
    }

    private void registerSFTPButtonActionListener() {
        this.m_oTestSFTPButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTransferServicePanel.this.testSFTPButtonActionPerformed();
            }
        });
    }

    private void setDefaultUserNamePassword() {
        this.m_oFTPUserNameTextField.setText(this.m_oFTSInfo.getFTPUserName());
        this.m_oFTPPasswordField.setPassword(this.m_oFTSInfo.getFTPPassword());
        this.m_oPortNoSpinForFTP.setValue((Object)this.m_oFTSInfo.getFTPPortNumber());
        this.m_oSFTPUserNameTextField.setText(this.m_oFTSInfo.getSFTPUserName());
        this.m_oSFTPPasswordField.setPassword(this.m_oFTSInfo.getSFTPPassword());
        this.m_oPortNoSpin.setValue((Object)this.m_oFTSInfo.getSFTPPortNumber());
    }

    private void tftpButtonActionPerformed() {
        int iErrorCode = -1;
        ProtocolConfigInfo oProtocolConfigInfo = new ProtocolConfigInfo();
        oProtocolConfigInfo.setProtocolType(new AsnProtocolEnum(4));
        iErrorCode = this.m_oSystemManager.testProtocolSetting(oProtocolConfigInfo, this.m_oRootPath.getText());
        if (iErrorCode == 0) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("OPERTION_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
        } else {
            this.showMessageDialog(iErrorCode, ResourceManager.getInstance().getResString("MODIFY_FTP_USER_ERROR"), 0);
        }
    }

    private void testFTPButtonActionPerformed() {
        int iErrorCode = -1;
        ProtocolConfigInfo oProtocolConfigInfo = new ProtocolConfigInfo();
        oProtocolConfigInfo.setProtocolType(new AsnProtocolEnum(1));
        if (!this.validateUserNameField((JTextField)this.m_oFTPUserNameTextField, ResourceManager.getInstance().getResString("MODIFY_FTP_USER_NAME_EMPTY"))) {
            return;
        }
        if (null != this.m_oFTPUserNameTextField.getText() && null != this.m_oFTPPasswordField.getPasswordInChar()) {
            oProtocolConfigInfo.setUserName(this.m_oFTPUserNameTextField.getText());
            oProtocolConfigInfo.setPassword(this.m_oFTPPasswordField.getPasswordInChar());
            oProtocolConfigInfo.setPortNumber((Integer)this.m_oPortNoSpinForFTP.getValue());
            iErrorCode = this.m_oSystemManager.testProtocolSetting(oProtocolConfigInfo, this.m_oRootPath.getText());
        }
        if (iErrorCode == 0) {
            this.showMessageDialog(0, ResourceManager.getInstance().getResString("INFO"), 1);
        } else {
            this.showMessageDialog(iErrorCode, ResourceManager.getInstance().getResString("MODIFY_FTP_USER_ERROR"), 0);
        }
    }

    private void testSFTPButtonActionPerformed() {
        int iErrorCode = -1;
        ProtocolConfigInfo oProtocolConfigInfo = new ProtocolConfigInfo();
        oProtocolConfigInfo.setProtocolType(new AsnProtocolEnum(2));
        if (!this.validateUserNameField((JTextField)this.m_oSFTPUserNameTextField, ResourceManager.getInstance().getResString("MODIFY_SFTP_USER_NAME_EMPTY"))) {
            return;
        }
        if (null != this.m_oSFTPUserNameTextField.getText() && null != this.m_oSFTPPasswordField.getPasswordInChar()) {
            oProtocolConfigInfo.setUserName(this.m_oSFTPUserNameTextField.getText());
            oProtocolConfigInfo.setPassword(this.m_oSFTPPasswordField.getPasswordInChar());
            oProtocolConfigInfo.setPortNumber((Integer)this.m_oPortNoSpin.getValue());
            iErrorCode = this.m_oSystemManager.testProtocolSetting(oProtocolConfigInfo, this.m_oRootPath.getText());
        }
        if (iErrorCode == 0) {
            this.showMessageDialog(0, ResourceManager.getInstance().getResString("INFO"), 1);
        } else {
            this.showMessageDialog(iErrorCode, ResourceManager.getInstance().getResString("MODIFY_FTP_USER_ERROR"), 0);
        }
    }

    private boolean validateUserNameField(JTextField oUserNameTextField, String strMsg) {
        return true;
    }

    public void showMessageDialog(int iErrorCode, String strErrorType, int iOptionType) {
        DCOptionPane.showMessageDialog((Component)((Object)this.m_oSystemSettingDlg), iErrorCode, strErrorType, iOptionType);
    }

    public void showMessageDialog(String strMsg, String strErrorType, int iOptionType) {
        DCOptionPane.showMessageDialog((Component)((Object)this.m_oSystemSettingDlg), strMsg, strErrorType, iOptionType);
    }

    private String getLocalisedString(String strkey) {
        return ResourceManager.getInstance().getResString(strkey);
    }

    private String checkLastChar(String strDirectory) {
        if (strDirectory.length() > 1 && (strDirectory.endsWith("/") || strDirectory.endsWith("\\"))) {
            strDirectory = strDirectory.substring(0, strDirectory.length() - 1);
        }
        return strDirectory;
    }

    public void setShowConfirmation(boolean bval) {
        this.m_bShowConfirmation = bval;
    }

    public boolean setFTSInfo() {
        boolean bIsSuccess = true;
        String strFTSRootDir = this.checkLastChar(this.m_oRootPath.getText().trim());
        if (strFTSRootDir.contains(" ")) {
            this.showMessageDialog(ResourceManager.getInstance().getResString("SYSTEM_INFO_TFTP_ROOT_DIRECTORY_BLANK_SPACE"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            this.m_oRootPath.grabFocus();
            return false;
        }
        if (0 == strFTSRootDir.trim().length()) {
            this.showMessageDialog(ResourceManager.getInstance().getResString("SYSTEM_INFO_TFTP_ROOT_DIRECTORY_EMPTY"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            this.m_oRootPath.grabFocus();
            return false;
        }
        if (strFTSRootDir.length() >= 101) {
            this.showMessageDialog(ResourceManager.getInstance().getResString("INCORRECT_FILE_NAME_LENGTH"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            return false;
        }
        this.m_oFTSInfo.setRootDirectory(strFTSRootDir);
        boolean bFlag = this.validateUserNameField((JTextField)this.m_oFTPUserNameTextField, ResourceManager.getInstance().getResString("MODIFY_FTP_USER_NAME_EMPTY"));
        if (!bFlag) {
            return false;
        }
        this.m_oFTSInfo.setFTPUserName(this.m_oFTPUserNameTextField.getText().trim());
        this.m_oFTSInfo.setFTPPassword(this.m_oFTPPasswordField.getPasswordInChar());
        this.m_oFTSInfo.setFTPPortNumber((Integer)this.m_oPortNoSpinForFTP.getValue());
        bFlag = this.validateUserNameField((JTextField)this.m_oSFTPUserNameTextField, ResourceManager.getInstance().getResString("MODIFY_SFTP_USER_NAME_EMPTY"));
        if (!bFlag) {
            return false;
        }
        this.m_oFTSInfo.setSFTPUserName(this.m_oSFTPUserNameTextField.getText());
        this.m_oFTSInfo.setSFTPPassword(this.m_oSFTPPasswordField.getPasswordInChar());
        this.m_oFTSInfo.setSFTPPortNumber((Integer)this.m_oPortNoSpin.getValue());
        int iErrorCode = this.m_oSystemManager.setFTSInfo(this.m_oFTSInfo);
        if (iErrorCode == 0) {
            TKCommonUtil.setRootPath(strFTSRootDir);
            if (this.m_bShowConfirmation) {
                this.showMessageDialog(0, ResourceManager.getInstance().getResString("INFO"), 1);
            }
            bIsSuccess = true;
        } else {
            this.showMessageDialog(iErrorCode, ResourceManager.getInstance().getResString("MODIFY_FTP_USER_ERROR"), 0);
            bIsSuccess = false;
        }
        return bIsSuccess;
    }

    public String getFTSRootPath() {
        if (null == this.m_oRootPath) {
            return "";
        }
        return this.m_oRootPath.getText();
    }

    public void disposePanel() {
        this.m_oFTPUserNameTextField = null;
        this.m_oFTPPasswordField = null;
        this.m_oSFTPUserNameTextField = null;
        this.m_oSFTPPasswordField = null;
        this.m_oSystemSettingDlg = null;
        this.m_oRootPath = null;
        this.m_oTestFTPBtn = null;
        this.m_oTestTFTPButton = null;
        this.m_oTestSFTPButton = null;
        this.m_oSystemManager = null;
        this.m_oPortNoSpin = null;
        this.m_oPortNoSpinForFTP = null;
        this.m_oSpinmodel = null;
        this.m_oSpinmodelForFTP = null;
        this.m_oFTSInfo = null;
    }
}

