/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.system;

import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class DirTextField
extends JTextField {
    private static final long serialVersionUID = -6430885396759514784L;
    private String m_strSplChars = "`~!@#$%^&*()+=|\"';?>.<,";
    private boolean m_bIsRootDir = false;
    private StringBuffer m_strValue;
    public int m_iCurposition = 0;
    public String m_strDirCurval = null;

    public void setDirCurval(String mStrDirCurval) {
        this.m_strDirCurval = mStrDirCurval;
    }

    public DirTextField() {
        InputDocument input = new InputDocument(this);
        this.setDocument(input);
    }

    @Override
    public void processKeyEvent(KeyEvent ev) {
        char c = ev.getKeyChar();
        this.m_iCurposition = this.getCaretPosition();
        char keyCode = '\uffff';
        this.m_strDirCurval = this.getText();
        boolean bflag = true;
        this.m_strSplChars = !this.m_bIsRootDir ? "`~!@#$%^&*()+=|\"';?>.<,:" : "`~!@#$%^&*()+=|\"';?>.<,";
        if (c != keyCode && (this.m_strSplChars.indexOf(c) >= 0 || c >= '\u0080')) {
            ev.consume();
            return;
        }
        if ('/' == c) {
            bflag = this.putForwardSlash(this.m_iCurposition, this.m_strDirCurval);
        }
        if (bflag) {
            if (this.m_strValue.length() > 0 && ev.getKeyCode() != 18) {
                this.m_strValue.append(c);
            }
            if (!ev.isConsumed()) {
                super.processKeyEvent(ev);
            }
        } else {
            ev.consume();
            return;
        }
    }

    public void setRootDir(boolean isRootDir) {
        this.m_bIsRootDir = isRootDir;
    }

    public void setTextValue(String strValue) {
        this.m_strValue = new StringBuffer(strValue);
    }

    public boolean putForwardSlash(int iCurposition, String strDirCurval) {
        boolean bflag;
        if (0 == iCurposition && 0 == strDirCurval.length()) {
            bflag = true;
        } else if (strDirCurval.length() == iCurposition) {
            char chPre = strDirCurval.charAt(iCurposition - 1);
            bflag = '/' != chPre && '\\' != chPre;
        } else if (0 == iCurposition && 0 != strDirCurval.length()) {
            char chNext = strDirCurval.charAt(iCurposition);
            bflag = '/' != chNext && '\\' != chNext;
        } else {
            char chNext = strDirCurval.charAt(iCurposition);
            char chPre = strDirCurval.charAt(iCurposition - 1);
            bflag = '/' != chNext && '/' != chPre && '\\' != chNext && '\\' != chPre;
        }
        return bflag;
    }

    class InputDocument
    extends PlainDocument {
        private static final long serialVersionUID = 513895972022154112L;
        public JTextComponent textComponent;

        public InputDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String strInput, AttributeSet attributeSet) throws BadLocationException {
            char[] charArray = strInput.toCharArray();
            boolean isRight = true;
            if (strInput.indexOf(47) >= 0 && null != DirTextField.this.m_strDirCurval) {
                isRight = strInput.indexOf("//") >= 0 ? false : DirTextField.this.putForwardSlash(DirTextField.this.m_iCurposition, DirTextField.this.m_strDirCurval);
            }
            if (strInput.indexOf(92) >= 0 && null != DirTextField.this.m_strDirCurval) {
                isRight = strInput.indexOf("\\\\") >= 0 ? false : DirTextField.this.putForwardSlash(DirTextField.this.m_iCurposition, DirTextField.this.m_strDirCurval);
            }
            if (isRight) {
                for (int i = 0; i < charArray.length; ++i) {
                    char inputChar = charArray[i];
                    if (!DirTextField.this.m_bIsRootDir) {
                        DirTextField.this.m_strSplChars = "`~!@#$%^&*()+=|\"';?>.<,:";
                    } else {
                        DirTextField.this.m_strSplChars = "`~!@#$%^&*()+=|\"';?>.<,";
                    }
                    if (DirTextField.this.m_strSplChars.indexOf(inputChar) < 0) continue;
                    isRight = false;
                    break;
                }
            }
            if (isRight) {
                super.insertString(offset, strInput, attributeSet);
            }
        }
    }
}

