/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.servicemanagement;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnNMSServiceOperation;
import com.huawei.dc.common.asndatacenter.AsnNMSServiceOperationReq;
import com.huawei.dc.common.asndatacenter.AsnNMSServiceOperationRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.table.renderer.SimpleTableCellRenderer;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.servicemanagement.ServiceInfo;
import com.huawei.dc.configuration.servicemanagement.ServiceUtil;
import com.huawei.dc.framework.ErrorCodeReader;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import net.commustru.fstru.FStruct;

public class ServiceInfoDialog
extends DCModalDialog {
    private static final long serialVersionUID = 6839845867951548416L;
    private JLabel m_olabel;
    private JPanel m_oServiceTablePanel;
    private JTable m_oServiceTable;
    private JScrollPane m_oScrollPane;
    private DefaultTableModel m_oServiceTableModel;
    private List<ServiceInfo> m_oServiceInfoList;
    private JRadioButton m_oServiceStopButton;
    private JRadioButton m_oServiceStartButton;
    private ButtonGroup m_oButtonGroup;
    public static final String TitleJLabel = "JTITLE_SERVICE_OPERATION_SELECT";
    public static final String SERVICE_TABLE_HEADER_ID = "SERVICE_TABLE_HEADER_ID";
    public static final String SERVICE_TABLE_HEADER_NAME = "SERVICE_TABLE_HEADER_NAME";
    public static final String SERVICE_TABLE_HEADER_STATUS = "SERVICE_TABLE_HEADER_STATUS";
    public static final String SERVICE_TABLE_HEADER_ERROR_REASON = "SERVICE_TABLE_HEADER_ERROR_REASON";
    public static final String TITLE_SERVICE_STOP_BUTTON = "BUTTON_SERVICE_STOP";
    public static final String TITLE_SERVICE_START_BUTTON = "BUTTON_SERVICE_START";
    public static final String SERVICE_STATUS_FAILURE = "SERVICE_STATUS_FAILURE";
    public static final String SERVICESTATUS_START = "SERVICE_STATUS_START";
    public static final String SERVICESTATUS_STOP = "SERVICE_STATUS_STOP";
    public static final String WARNING_SERVICE_MANANGEMENT = "WARNINGS_SERVICE_MANAGEMENT";
    public static final String WARNING_STOP_SERVICE_MANAGEMENT = "WARNINGS_STOP_SERVICE_MANAGEMENT";
    public static final String OK_BUTTON_NAME = "OK_BUTTON";
    public static final String APPLY_BUTTON_NAME = "SERVICE_MGR_APPLY_BTN";
    public static final String TITLE_DIALOG = "SERVICE_MANAGEMENT_DIALOG_TITLE";
    public static final int ERRCODE_UPGRADE_RUNNING = 989859177;
    public static final int ERRCODE_BACKUP_TASK_NOT_EXIST = 989859176;
    public static final int UPGRADE_TASK_RUNING = 989855805;
    public static final int BMS_POLL_SERVICE_ID = 1;
    public static final int DC_SAVE_BACKUP_SERVICE_ID = 0;
    public int operation;
    private JPanel m_oBntPanl = null;
    private JButton m_oApplyBtn = null;
    private JProgressBar m_oProgressBar = null;

    public ServiceInfoDialog(List<ServiceInfo> list) {
        this.m_oServiceInfoList = list;
        this.jbInit();
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    public void jbInit() {
        this.initPanel();
        this.populateTableData(this.m_oServiceInfoList);
        this.refreshTable();
    }

    public void initPanel() {
        this.setSize(new Dimension(400, 300));
        this.setTitle(DCFrameWorkUtil.getLocalizedString(TITLE_DIALOG));
        this.createComponent();
        this.addComponent();
        this.addKeyListener();
    }

    public void createComponent() {
        this.m_oServiceTablePanel = new JPanel();
        this.m_oServiceTablePanel.setLayout(new GridBagLayout());
        this.m_olabel = new JLabel(DCFrameWorkUtil.getLocalizedString(TitleJLabel));
        this.m_oScrollPane = new JScrollPane();
        this.m_oScrollPane.setViewportView(this.getServiceTable());
        this.m_oProgressBar = new JProgressBar();
        this.m_oProgressBar.setMinimumSize(new Dimension(370, 19));
        this.m_oProgressBar.setPreferredSize(new Dimension(370, 19));
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString(OK_BUTTON_NAME));
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CANCEL_BUTTON"));
        this.m_oApplyBtn = new JButton(DCFrameWorkUtil.getLocalizedString(APPLY_BUTTON_NAME));
        this.m_oApplyBtn.setMnemonic('A');
        this.m_oBntPanl = new JPanel();
        this.m_oBntPanl.setName("ServiceInfoDialog_m_oBntPanl");
        this.m_oBntPanl.setLayout(new FlowLayout(2));
        this.m_oBntPanl.setMinimumSize(new Dimension(300, 30));
        this.m_oBntPanl.setPreferredSize(new Dimension(300, 30));
        this.m_oBntPanl.add(this.m_oOKBtn);
        this.m_oBntPanl.add(this.m_oCancelBtn);
        this.m_oBntPanl.add(this.m_oApplyBtn);
        this.m_oButtonGroup = new ButtonGroup();
        this.m_oServiceStartButton = new JRadioButton(DCFrameWorkUtil.getLocalizedString(TITLE_SERVICE_START_BUTTON));
        this.m_oServiceStartButton.setSelected(true);
        this.m_oServiceStartButton.setFocusable(false);
        this.m_oServiceStopButton = new JRadioButton(DCFrameWorkUtil.getLocalizedString(TITLE_SERVICE_STOP_BUTTON));
        this.m_oServiceStopButton.setFocusable(false);
        this.m_oButtonGroup.add(this.m_oServiceStartButton);
        this.m_oButtonGroup.add(this.m_oServiceStopButton);
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oApplyBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oServiceTablePanel.setPreferredSize(new Dimension(370, 220));
    }

    private void visibleProgress(final boolean bVisible, final String sPrompt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (bVisible) {
                    ServiceInfoDialog.this.m_oProgressBar.setVisible(true);
                    ServiceInfoDialog.this.m_oProgressBar.setString(sPrompt);
                    ServiceInfoDialog.this.m_oProgressBar.setStringPainted(true);
                    ServiceInfoDialog.this.m_oProgressBar.setIndeterminate(true);
                } else {
                    ServiceInfoDialog.this.m_oProgressBar.setVisible(bVisible);
                }
            }
        });
    }

    private void addKeyListener() {
        this.addKeyListenerToComponent(this.m_oServiceTable);
        this.m_oServiceStartButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ServiceInfoDialog.this.m_oApplyBtn.setEnabled(true);
            }
        });
        this.m_oApplyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ServiceInfoDialog.this.doServiceChange();
            }
        });
    }

    public void addComponent() {
        this.m_oServiceTablePanel.add((Component)this.m_olabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.m_oServiceTablePanel.add((Component)this.m_oServiceStartButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 30, 0, 10), 0, 0));
        this.m_oServiceTablePanel.add((Component)this.m_oServiceStopButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 40, 0, 10), 0, 0));
        this.m_oServiceTablePanel.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.m_oServiceTablePanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.m_oProgressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oBntPanl, new GridBagConstraints(0, 2, 2, 1, 2.0, 0.0, 13, 0, new Insets(10, 0, 10, 10), 0, 0));
        this.visibleProgress(false, "");
    }

    public Component getServiceTable() {
        Object[] servieTableHeader = new String[]{DCFrameWorkUtil.getLocalizedString(SERVICE_TABLE_HEADER_ID), DCFrameWorkUtil.getLocalizedString(SERVICE_TABLE_HEADER_NAME), DCFrameWorkUtil.getLocalizedString(SERVICE_TABLE_HEADER_STATUS), DCFrameWorkUtil.getLocalizedString(SERVICE_TABLE_HEADER_ERROR_REASON)};
        this.m_oServiceTableModel = new DefaultTableModel(servieTableHeader, 0){
            private static final long serialVersionUID = -6984343840134109879L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_oServiceTable = new JTable(this.m_oServiceTableModel);
        this.m_oServiceTable.setRowSelectionAllowed(false);
        this.m_oServiceTable.removeColumn(this.m_oServiceTable.getColumnModel().getColumn(0));
        SimpleTableCellRenderer tableCellRenderer = new SimpleTableCellRenderer();
        this.m_oServiceTable.setDefaultRenderer(Object.class, tableCellRenderer);
        return this.m_oServiceTable;
    }

    private void populateTableData(List<ServiceInfo> list) {
        this.m_oServiceTable.removeAll();
        Vector<Object> oRowDataVector = null;
        Iterator<ServiceInfo> it = list.iterator();
        while (it.hasNext()) {
            oRowDataVector = new Vector<Object>(10);
            ServiceInfo info = it.next();
            oRowDataVector.add(info.getServiceId());
            oRowDataVector.add(info.getServiceName());
            oRowDataVector.add(this.getStatusString(info.getStatus()));
            oRowDataVector.add("");
            this.m_oServiceTableModel.addRow(oRowDataVector);
        }
    }

    public String getStatusString(int status) {
        switch (status) {
            case 1: {
                return DCFrameWorkUtil.getLocalizedString(SERVICE_STATUS_FAILURE);
            }
            case 2: {
                return DCFrameWorkUtil.getLocalizedString(SERVICESTATUS_START);
            }
            case 3: {
                return DCFrameWorkUtil.getLocalizedString(SERVICESTATUS_STOP);
            }
        }
        return "";
    }

    public String getFailureReason(int errcode) {
        return ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errcode));
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != ServiceInfoDialog.this.m_oServiceTable) {
                    ServiceInfoDialog.this.m_oServiceTable.updateUI();
                }
            }
        });
    }

    @Override
    protected void oKButton_ActionPerformed() {
        if (!this.m_oApplyBtn.isEnabled()) {
            this.closeDialog();
            return;
        }
        boolean bSuc = this.doServiceChange();
        if (bSuc) {
            this.closeDialog();
        }
    }

    @Override
    protected void cancelButton_ActionPerformed() {
        this.closeDialog();
    }

    private boolean doServiceChange() {
        this.m_oApplyBtn.setEnabled(false);
        this.m_oOKBtn.setEnabled(false);
        String sPrompt = "";
        if (this.m_oServiceStartButton.isSelected()) {
            this.operation = 2;
            sPrompt = DCFrameWorkUtil.getLocalizedString("START_SERVIER_PROMPT");
        } else {
            this.operation = 1;
            sPrompt = DCFrameWorkUtil.getLocalizedString("STOP_SERVIER_PROMPT");
        }
        try {
            int confirm;
            boolean bOperation = true;
            if (1 == this.operation) {
                int confirm2 = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString(WARNING_STOP_SERVICE_MANAGEMENT), ResourceManager.getInstance().getResString("CONFIRM"), 0);
                if (confirm2 != 0) {
                    bOperation = false;
                }
            } else if (this.checkUpgradeRunning(this.operation) && (confirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString(WARNING_SERVICE_MANANGEMENT), ResourceManager.getInstance().getResString("CONFIRM"), 0)) != 0) {
                bOperation = false;
            }
            if (bOperation) {
                this.visibleProgress(true, sPrompt);
                this.operateService();
            } else {
                this.m_oOKBtn.setEnabled(true);
                this.m_oApplyBtn.setEnabled(true);
            }
        }
        catch (DCException ex) {
            this.m_oOKBtn.setEnabled(true);
            this.m_oApplyBtn.setEnabled(true);
            if (989855805 != ex.getErrorCode()) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getErrorCode(), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
            return false;
        }
        return true;
    }

    public void operateService() throws DCException {
        final AsnNMSServiceOperationReq asnNMSOperationRea = new AsnNMSServiceOperationReq();
        final AsnNMSServiceOperationRsp asnNMSServiceOperationRsp = new AsnNMSServiceOperationRsp();
        asnNMSOperationRea.enNMSServiceoOperation = new AsnNMSServiceOperation(this.operation);
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44037), (FStruct)asnNMSOperationRea, (FStruct)asnNMSServiceOperationRsp);
                return iErrorCode;
            }
        };
        int iErrorCode = 0;
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = asnNMSServiceOperationRsp.iErrCode.intValue();
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        List<ServiceInfo> oserviceInfoList = ServiceUtil.getServiceListFromAsn(asnNMSServiceOperationRsp.oAsnNMSServiceList);
        this.updateTableForResponse(oserviceInfoList);
        this.visibleProgress(false, "");
        this.m_oOKBtn.setEnabled(true);
        this.refreshTable();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != DCFrameWorkUtil.getDeviceTreePanel()) {
                    DCFrameWorkUtil.getDeviceTreePanel().refreshDeviceTree();
                }
                if (null != DCFrameWorkUtil.getDeviceTablePanel()) {
                    DCFrameWorkUtil.getDeviceTablePanel().refreshSelectedDevCountLabel();
                }
            }
        });
    }

    private void updateTableForResponse(List<ServiceInfo> oServiceInfoList) {
        int iRowCount = this.m_oServiceTableModel.getRowCount();
        int iSize = oServiceInfoList.size();
        ServiceInfo oServiceInfo = null;
        String strMessage = null;
        String strStatus = null;
        for (int i = 0; i < iRowCount; ++i) {
            strMessage = null;
            int iServiceID = (Integer)this.m_oServiceTableModel.getValueAt(i, 0);
            for (int j = 0; j < iSize; ++j) {
                oServiceInfo = oServiceInfoList.get(j);
                if (oServiceInfo.getServiceId() != iServiceID) continue;
                strMessage = this.getFailureReason(oServiceInfo.getErrcode());
                strStatus = this.getStatusString(oServiceInfo.getStatus());
                break;
            }
            if (null == strMessage) {
                this.m_oServiceTableModel.setValueAt(DCFrameWorkUtil.getLocalizedString("OPERATIONFAILED"), i, 3);
                continue;
            }
            this.m_oServiceTableModel.setValueAt(strStatus, i, 2);
            this.m_oServiceTableModel.setValueAt(strMessage, i, 3);
        }
    }

    public boolean checkUpgradeRunning(int operation) throws DCException {
        if (1 == operation) {
            return false;
        }
        final AsnNMSServiceOperationRsp asnNMSServiceOperationRsp = new AsnNMSServiceOperationRsp();
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DCFrameWorkUtil.getCommManager();
                DCFrameWorkUtil.getCommManager();
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(44035), null, (FStruct)asnNMSServiceOperationRsp);
                return iErrorCode;
            }
        };
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int iErrorCode = 0;
        iErrorCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (iErrorCode != 0) {
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        iErrorCode = asnNMSServiceOperationRsp.iErrCode.intValue();
        if (iErrorCode != 0 && 989859177 != iErrorCode) {
            int confirm;
            if (iErrorCode == 989855805 && (confirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("WARNINGS_START_SERVICE_MANAGEMENT"), ResourceManager.getInstance().getResString("CONFIRM"), 0)) == 0) {
                return false;
            }
            throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
        return 989859177 == iErrorCode || 989859176 == iErrorCode;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_SERVICE_INFO";
    }
}

