/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.policy.mxupolicy;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.policy.mxupolicy.MXUUpgradeDataModel;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.policy.mxupolicy.FileInfo;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.event.ISAMEventListener;
import com.huawei.dc.sam.event.SAMEvent;
import com.huawei.dc.sam.model.SAMFileInfo;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ShowDeletedSoftwareLstDlg
extends DCModalDialog
implements ISAMEventListener {
    private static final long serialVersionUID = -6655789102584533610L;
    private MXUUpgradeDataModel m_oDataModel;
    private Vector m_oFileInfo;
    private DefaultTableModel m_oTableModel;
    private JTable m_oTable;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private JScrollPane m_oTableScrollPane = new JScrollPane();
    private FileInfo[] m_oCurrentFileInfo;

    public ShowDeletedSoftwareLstDlg(MXUUpgradeDataModel updateDataModel, Vector filesDeleted, FileInfo[] oFileLst) {
        this.m_oDataModel = updateDataModel;
        this.m_oFileInfo = filesDeleted;
        SAMManager.getInstance().addSAMEventListener(this);
        SAMManager.getInstance().registerForFileDeleteNtfn();
        this.createCurrentFileList(oFileLst);
        this.setSize(500, 300);
        this.getContentPane().setLayout(null);
        this.setModal(true);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(this.getLocalisedString("DELETED_SOFTWARE_LIST"));
        this.jInit();
    }

    private void createCurrentFileList(FileInfo[] fileLst) {
        this.m_oCurrentFileInfo = new FileInfo[fileLst.length];
        System.arraycopy(fileLst, 0, this.m_oCurrentFileInfo, 0, fileLst.length);
    }

    private void jInit() {
        JLabel oInfoLabel = new JLabel();
        String strText = StringUtils.getHtmlString(this.getLocalisedString("DELETED_SOFTWARE_INFO"));
        oInfoLabel.setText(strText);
        oInfoLabel.setBounds(10, 10, 480, 40);
        this.showDeletedFileInfo();
        this.m_oTableScrollPane.setBounds(0, 60, 495, 165);
        this.m_oTableScrollPane.setBorder(BorderFactory.createEtchedBorder());
        JButton oCloseBtn = new JButton(this.getLocalisedString("CLOSE"));
        oCloseBtn.setName("Policy_ShowDeletedSoftwareLstDlg_oCloseBtn");
        oCloseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                ShowDeletedSoftwareLstDlg.this.closeDialog();
            }
        });
        oCloseBtn.setBounds(380, 235, 80, 21);
        this.getContentPane().add(oCloseBtn);
        this.getContentPane().add(oInfoLabel);
        this.getContentPane().add(this.m_oTableScrollPane);
    }

    @Override
    public void closeDialog() {
        this.m_oDataModel = null;
        this.m_oFileInfo = null;
        this.m_oTableModel = null;
        this.m_oTable = null;
        this.m_oResourceManager = null;
        this.m_oTableScrollPane = null;
        SAMManager.getInstance().removeSAMEventListener(this);
        super.closeDialog();
    }

    private void showDeletedFileInfo() {
        this.createTableModel();
        this.createTable();
        this.addDataToTable();
    }

    private void addDataToTable() {
        int iNoOfDeletedFiles = this.m_oFileInfo.size();
        IDeviceInfoManager oDevInfoMgr = DeviceInfoManagerImpl.getInstance();
        for (int i = 0; i < iNoOfDeletedFiles; ++i) {
            Vector<String> v = new Vector<String>(5);
            if (this.m_oDataModel.getSubMapID().equals("HWMAP_PHY_SUBMAP")) {
                v.add("HWMAP_PHY_SUBMAP");
            } else {
                SubMapInfo oSubMapInfo = oDevInfoMgr.getSubmapForID(this.m_oDataModel.getSubMapID());
                v.add(oSubMapInfo.m_strSubMapName);
            }
            v.add(this.m_oDataModel.getDevTypeInfo().getDevTypeName() + '(' + this.m_oDataModel.getDevTypeInfo().getDevTypeVersionName() + ')');
            v.add(this.m_oDataModel.getTargetVersion());
            FileInfo oFileInfo = (FileInfo)this.m_oFileInfo.get(i);
            v.add(oFileInfo.getFileName());
            v.add(oFileInfo.getContentType());
            this.m_oTableModel.addRow(v);
        }
    }

    private void createTable() {
        this.m_oTable = new JTable(this.m_oTableModel){
            private static final long serialVersionUID = 6054101796415470198L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_oTable.setName("Policy_ShowDeletedSoftwareLstDlg_m_oTable");
        this.m_oTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTableScrollPane.getViewport().add(this.m_oTable);
        this.m_oTableScrollPane.setVerticalScrollBarPolicy(22);
        this.m_oTableScrollPane.setHorizontalScrollBarPolicy(32);
        this.m_oTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oTable.setRowHeight(21);
        this.m_oTable.getTableHeader().setPreferredSize(new Dimension(this.m_oTable.getSize().width, 21));
    }

    private void createTableModel() {
        Object[] arrColHeaders = new String[]{this.getLocalisedString("SEARCH_TABLE_SUBMAP"), this.getLocalisedString("TASK_TABLE_COLUMN_DEVICE_TYPE"), this.getLocalisedString("UPGRADE_VERSION"), this.getLocalisedString("TASK_TABLE_COLUMN_SOFTWARE_NAME"), this.getLocalisedString("CONTENT_TYPE")};
        this.m_oTableModel = new DefaultTableModel(arrColHeaders, 0);
    }

    @Override
    protected String getCurrentContext() {
        return ResourceManager.getInstance().getResString("HELP_TOPIC_DELETE_FILE_LIST", "helpmapfile");
    }

    private String getLocalisedString(String key) {
        return this.m_oResourceManager.getResString(key);
    }

    @Override
    public void onSAMEvent(SAMEvent oEvent) {
        if (1 != oEvent.getEventType() || 0 != oEvent.getErrorCode()) {
            return;
        }
        if (oEvent.getSource() instanceof SAMFileInfo) {
            SAMFileInfo oFileInfo = (SAMFileInfo)oEvent.getSource();
            for (int i = 0; i < this.m_oCurrentFileInfo.length; ++i) {
                if (!this.m_oDataModel.getTargetVersion().equals(oFileInfo.getVersion()) || !this.m_oCurrentFileInfo[i].getFileName().equals(oFileInfo.getFileName())) continue;
                Vector<String> v = new Vector<String>(5);
                v.add(this.m_oDataModel.getSubMapID());
                v.add(this.m_oDataModel.getDevTypeInfo().getDevTypeName() + '(' + this.m_oDataModel.getDevTypeInfo().getDevTypeVersionName() + ')');
                v.add(this.m_oDataModel.getTargetVersion());
                v.add(oFileInfo.getFileName());
                v.add(oFileInfo.getFileType().getStrContentType());
                this.m_oTableModel.addRow(v);
            }
        }
    }
}

