/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.policy.mxupolicy;

import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMFileInfo;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionFileLstRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMGetVersionRsp;
import com.huawei.dc.common.asndatacenter.AsnSAMVersion;
import com.huawei.dc.common.asndatacenter.AsnSAMVersionLst;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CheckBoxHeader;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.policy.mxupolicy.MXUDeviceTablePanel;
import com.huawei.dc.configuration.policy.mxupolicy.MXUUpgradeDataModel;
import com.huawei.dc.configuration.policy.mxupolicy.ShowDeletedSoftwareLstDlg;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.policy.mxupolicy.FileInfo;
import com.huawei.dc.policy.mxupolicy.FileInfoForMxuUpgrade;
import com.huawei.dc.sam.SAMUtil;
import com.huawei.dc.sam.controller.ISAMManager;
import com.huawei.dc.sam.controller.SAMManager;
import com.huawei.dc.sam.model.SAMFileInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class MxuTargetVersionAndFileSelectionDlg
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private ComboBoxWithToolTip m_oVersionComboBox;
    private MXUUpgradeDataModel m_oUpdateDataModel;
    private MXUUpgradeDataModel m_oFileSelectionData;
    private DefaultTableModel m_oFileSelectionTableModel;
    private JTable m_oFileSelectionTable;
    private final JScrollPane m_oTableScrollPane = new JScrollPane();
    private static final int TABLE_MODEL_OPERATION_ID = 0;
    private static final int SERIAL_NO = 0;
    private static final int FILE_NAME = 2;
    private static final int CONTENT_TYPE = 3;
    private int m_iNoOfFilesSelected = 0;
    private CheckBoxHeader m_oCheckBoxHeader = null;
    private int m_iSelectionType = 2;
    private boolean m_bFileSelOption = false;
    private static final int ALL_SELECTED = 0;
    private static final int PART_SELECTED = 1;
    private static final int NONE_SELECTED = 2;
    private JButton m_oMoveUpButton = null;
    private JButton m_oMoveDownButton = null;
    private JButton m_oMoveToBottomButton = null;
    private JButton m_oMoveToTopButton = null;
    private MXUDeviceTablePanel m_oPanelData;
    ItemListener oItemListener = null;

    public MxuTargetVersionAndFileSelectionDlg(MXUUpgradeDataModel oData, MXUDeviceTablePanel oPanel, int m_iDevDomain) {
        this.m_oUpdateDataModel = oData;
        this.m_oPanelData = oPanel;
        this.setSize(825, 450);
        this.getContentPane().setLayout(null);
        this.setModal(true);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(this.getLocalisedString("SELECT_FILES_PANEL"));
        this.enableHelpKeyValues(m_iDevDomain);
        this.jInit();
    }

    private void enableHelpKeyValues(int i) {
        DCHelpManager oHelpManager = DCHelpManager.getInstance();
        switch (i) {
            case 2: {
                oHelpManager.enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
                break;
            }
            case 1: {
                oHelpManager.enableHelpKey(this.getContentPane(), ResourceManager.getInstance().getResString("HELP_TOPIC_MXU_AUTO_UPGRADE", "helpmapfile"));
                break;
            }
        }
    }

    private void jInit() {
        this.createButtons();
        Border oBorder = BorderFactory.createEtchedBorder();
        JPanel oInnerPanel = new JPanel();
        oInnerPanel.setLayout(null);
        oInnerPanel.setBorder(oBorder);
        oInnerPanel.setBounds(10, 10, 795, 370);
        JLabel oUgradeVersionLabel = new JLabel();
        oUgradeVersionLabel.setText(this.getLocalisedString("UPGRADE_VERSION_LABEL"));
        oUgradeVersionLabel.setBounds(10, 10, 110, 21);
        oInnerPanel.add(oUgradeVersionLabel);
        this.createFileSelectionTableModel();
        this.createFileSelectionTable();
        this.m_oVersionComboBox = this.getVersionComboBox();
        this.m_oVersionComboBox.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oVersionComboBox");
        this.m_oVersionComboBox.setBounds(120, 10, 200, 21);
        oInnerPanel.add(this.m_oVersionComboBox);
        if (0 == this.m_oVersionComboBox.getItemCount()) {
            this.setVisible(false);
            return;
        }
        this.createButtonsInPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBounds(760, 40, 30, 180);
        buttonPanel.setLayout(null);
        buttonPanel.add((Component)this.m_oMoveToTopButton, null);
        buttonPanel.add((Component)this.m_oMoveUpButton, null);
        buttonPanel.add((Component)this.m_oMoveDownButton, null);
        buttonPanel.add((Component)this.m_oMoveToBottomButton, null);
        oInnerPanel.add((Component)buttonPanel, "East");
        this.m_oTableScrollPane.setBounds(10, 40, 745, 320);
        oInnerPanel.add(this.m_oTableScrollPane);
        this.getContentPane().add(oInnerPanel);
        this.setVisible(true);
    }

    private void createButtonsInPanel() {
        this.createMoveUpButton();
        this.createMoveDownButton();
        this.createMoveToTopButton();
        this.createMoveToBottomButton();
    }

    private void createMoveUpButton() {
        this.m_oMoveUpButton = new JButton();
        this.m_oMoveUpButton.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oMoveUpButton");
        ImageIcon moveUpIcon = ResourceManager.getInstance().getImage("autoupgrade_moveup.gif");
        this.m_oMoveUpButton.setIcon(moveUpIcon);
        this.m_oMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MxuTargetVersionAndFileSelectionDlg.this.moveUpButton_ActionPerformed();
            }
        });
        this.m_oMoveUpButton.setBounds(new Rectangle(3, 27, 23, 23));
        this.m_oMoveUpButton.setToolTipText(this.getLocalisedString("PROGRAM_SELECTION_MOVE_UP_BTN_TOOL_TIP"));
        this.m_oMoveUpButton.setEnabled(false);
    }

    private void createMoveDownButton() {
        this.m_oMoveDownButton = new JButton();
        this.m_oMoveDownButton.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oMoveDownButton");
        ImageIcon moveDownIcon = ResourceManager.getInstance().getImage("autoupgrade_movedown.gif");
        this.m_oMoveDownButton.setIcon(moveDownIcon);
        this.m_oMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MxuTargetVersionAndFileSelectionDlg.this.moveDownButton_ActionPerformed();
            }
        });
        this.m_oMoveDownButton.setBounds(new Rectangle(3, 54, 23, 23));
        this.m_oMoveDownButton.setToolTipText(this.getLocalisedString("PROGRAM_SELECTION_MOVE_DOWN_BTN_TOOL_TIP"));
        this.m_oMoveDownButton.setEnabled(false);
    }

    private void createMoveToTopButton() {
        this.m_oMoveToTopButton = new JButton();
        this.m_oMoveToTopButton.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oMoveToTopButton");
        this.m_oMoveToTopButton.setBounds(new Rectangle(3, 0, 23, 23));
        this.m_oMoveToTopButton.setToolTipText(this.getLocalisedString("AUTO_UPGRADE_MOVE_UPMOST_BUTTON"));
        this.m_oMoveToTopButton.setVerifyInputWhenFocusTarget(true);
        this.m_oMoveToTopButton.setMnemonic('F');
        this.m_oMoveToTopButton.setEnabled(false);
        ImageIcon upMostIcon = ResourceManager.getInstance().getImage("movetofirst.gif");
        this.m_oMoveToTopButton.setIcon(upMostIcon);
        this.m_oMoveToTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MxuTargetVersionAndFileSelectionDlg.this.moveToTopButton_ActionPerformed();
            }
        });
    }

    private void createMoveToBottomButton() {
        this.m_oMoveToBottomButton = new JButton();
        this.m_oMoveToBottomButton.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oMoveToBottomButton");
        this.m_oMoveToBottomButton.setBounds(new Rectangle(3, 81, 23, 23));
        this.m_oMoveToBottomButton.setToolTipText(this.getLocalisedString("AUTO_UPGRADE_MOVE_DOWNMOST_BUTTON"));
        this.m_oMoveToBottomButton.setMnemonic('L');
        this.m_oMoveToBottomButton.setEnabled(false);
        ImageIcon downMostIcon = ResourceManager.getInstance().getImage("movetolast.gif");
        this.m_oMoveToBottomButton.setIcon(downMostIcon);
        this.m_oMoveToBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MxuTargetVersionAndFileSelectionDlg.this.moveToBottomButton_ActionPerformed();
            }
        });
    }

    private void moveUpButton_ActionPerformed() {
        int[] arrRows = this.m_oFileSelectionTable.getSelectedRows();
        if (0 == arrRows.length) {
            return;
        }
        int iCount = arrRows[0];
        if (0 == iCount) {
            return;
        }
        int iLastCount = arrRows[arrRows.length - 1];
        this.m_oFileSelectionTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], iCount - 1);
        this.m_oFileSelectionTable.setColumnSelectionAllowed(false);
        this.m_oFileSelectionTable.setRowSelectionAllowed(true);
        this.m_oFileSelectionTable.setRowSelectionInterval(iCount - 1, iLastCount - 1);
        Rectangle oRect = this.m_oFileSelectionTable.getCellRect(iCount - 1, 0, true);
        this.m_oFileSelectionTable.scrollRectToVisible(oRect);
        this.updateRowSequence();
        this.m_oFileSelectionTable.repaint();
        this.updateStatusOfButtons();
    }

    private void moveDownButton_ActionPerformed() {
        int[] arrRows = this.m_oFileSelectionTable.getSelectedRows();
        int iCount = arrRows.length;
        if (0 == iCount) {
            return;
        }
        int iFirstRow = arrRows[0];
        if (arrRows[arrRows.length - 1] == this.m_oFileSelectionTable.getRowCount() - 1) {
            return;
        }
        this.m_oFileSelectionTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], iFirstRow + 1);
        this.m_oFileSelectionTable.setColumnSelectionAllowed(false);
        this.m_oFileSelectionTable.setRowSelectionAllowed(true);
        this.m_oFileSelectionTable.setRowSelectionInterval(iFirstRow + 1, iCount + iFirstRow);
        Rectangle oRect = this.m_oFileSelectionTable.getCellRect(iCount + iFirstRow, 0, true);
        this.m_oFileSelectionTable.scrollRectToVisible(oRect);
        this.updateRowSequence();
        this.m_oFileSelectionTable.repaint();
        this.updateStatusOfButtons();
    }

    protected void moveToBottomButton_ActionPerformed() {
        int[] arrRows = this.m_oFileSelectionTable.getSelectedRows();
        if (0 == arrRows.length) {
            return;
        }
        int iLastRow = arrRows[arrRows.length - 1];
        int iFirstRow = arrRows[0];
        if (this.m_oFileSelectionTable.getRowCount() - 1 != arrRows[arrRows.length - 1]) {
            if (arrRows[0] == arrRows[arrRows.length - 1]) {
                this.m_oFileSelectionTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], this.m_oFileSelectionTable.getRowCount() - 1);
            } else {
                this.m_oFileSelectionTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], this.m_oFileSelectionTable.getRowCount() - arrRows.length);
            }
            this.m_oFileSelectionTable.setColumnSelectionAllowed(false);
            this.m_oFileSelectionTable.setRowSelectionAllowed(true);
            this.m_oFileSelectionTable.setRowSelectionInterval(this.m_oFileSelectionTable.getRowCount() - 1, iFirstRow + (this.m_oFileSelectionTable.getRowCount() - 1 - iLastRow));
            JScrollBar oVertScrollBar = this.m_oTableScrollPane.getVerticalScrollBar();
            oVertScrollBar.setValue(oVertScrollBar.getMaximum());
            this.updateRowSequence();
            this.m_oFileSelectionTable.repaint();
            this.updateStatusOfButtons();
        }
    }

    protected void moveToTopButton_ActionPerformed() {
        int[] arrRows = this.m_oFileSelectionTable.getSelectedRows();
        if (0 == arrRows.length) {
            return;
        }
        int iLastRow = arrRows[arrRows.length - 1];
        int iFirstRow = arrRows[0];
        if (0 != arrRows[0]) {
            this.m_oFileSelectionTableModel.moveRow(arrRows[0], arrRows[arrRows.length - 1], 0);
            this.m_oFileSelectionTable.setColumnSelectionAllowed(false);
            this.m_oFileSelectionTable.setRowSelectionAllowed(true);
            this.m_oFileSelectionTable.setRowSelectionInterval(0, iLastRow - iFirstRow);
            JScrollBar oVertScrollBar = this.m_oTableScrollPane.getVerticalScrollBar();
            oVertScrollBar.setValue(oVertScrollBar.getMinimum());
            this.updateRowSequence();
            this.m_oFileSelectionTable.repaint();
            this.updateStatusOfButtons();
        }
    }

    private void updateRowSequence() {
        int rowCount = this.m_oFileSelectionTable.getRowCount();
        if (rowCount > 0) {
            for (int rowId = 0; rowId < rowCount; ++rowId) {
                Integer oRowId = rowId + 1;
                this.m_oFileSelectionTable.setValueAt(oRowId, rowId, 0);
            }
        }
    }

    private void updateStatusOfButtons() {
        int[] updatedrows = this.m_oFileSelectionTable.getSelectedRows();
        int iRowCount = this.m_oFileSelectionTable.getRowCount();
        if (updatedrows.length >= 1) {
            this.m_oMoveDownButton.setEnabled(true);
            this.m_oMoveToBottomButton.setEnabled(true);
            this.m_oMoveUpButton.setEnabled(true);
            this.m_oMoveToTopButton.setEnabled(true);
            if (iRowCount >= 1) {
                int iLastSelectedRowIndex = updatedrows[updatedrows.length - 1];
                if (iRowCount - 1 == iLastSelectedRowIndex) {
                    this.m_oMoveDownButton.setEnabled(false);
                    this.m_oMoveToBottomButton.setEnabled(false);
                }
                if (0 == updatedrows[0]) {
                    this.m_oMoveUpButton.setEnabled(false);
                    this.m_oMoveToTopButton.setEnabled(false);
                }
            }
        } else {
            this.m_oMoveUpButton.setEnabled(false);
            this.m_oMoveToTopButton.setEnabled(false);
            this.m_oMoveDownButton.setEnabled(false);
            this.m_oMoveToBottomButton.setEnabled(false);
        }
        this.m_oFileSelectionTable.repaint();
    }

    private void createFileSelectionTable() {
        this.m_oFileSelectionTable = new JTable(this.m_oFileSelectionTableModel);
        this.m_oFileSelectionTable.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oFileSelectionTable");
        this.m_oFileSelectionTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTableScrollPane.getViewport().add(this.m_oFileSelectionTable);
        this.m_oTableScrollPane.setVerticalScrollBarPolicy(20);
        this.m_oTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_oTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oFileSelectionTable.setRowHeight(21);
        this.m_oFileSelectionTable.getTableHeader().setPreferredSize(new Dimension(this.m_oFileSelectionTable.getSize().width, 28));
        this.addListenersToTable();
        this.customizeTable();
    }

    private void addListenersToTable() {
        this.m_oFileSelectionTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.hasFocus()) {
                    MxuTargetVersionAndFileSelectionDlg.this.updateStatusOfButtons();
                }
            }
        });
        this.m_oFileSelectionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MxuTargetVersionAndFileSelectionDlg.this.updateStatusOfButtons();
            }
        });
        this.m_oFileSelectionTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent event) {
                MxuTargetVersionAndFileSelectionDlg.this.updateStatusOfButtons();
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                Point p = event.getPoint();
                int hitColumnIndex = MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.columnAtPoint(p);
                int hitRowIndex = MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.rowAtPoint(p);
                Object str = MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.getValueAt(hitRowIndex, hitColumnIndex);
                MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.setToolTipText(str.toString());
            }
        });
    }

    private void customizeTable() {
        this.m_oFileSelectionTable.removeColumn(this.m_oFileSelectionTable.getColumnModel().getColumn(0));
        TableColumn oSaveCoulmn = this.addCheckBoxHeader(true);
        oSaveCoulmn.setHeaderRenderer(this.m_oCheckBoxHeader);
        this.m_oFileSelectionTable.getColumnModel().getColumn(0).setCellRenderer(new FileSeclectionCheckBoxRenderer());
        this.m_oFileSelectionTable.getColumnModel().getColumn(0).setCellEditor(new FileSeclectionCheckBoxEditor());
        this.m_oFileSelectionTable.getColumnModel().getColumn(0).setMaxWidth(70);
        this.m_oFileSelectionTable.getColumnModel().getColumn(0).setPreferredWidth(60);
    }

    private TableColumn addCheckBoxHeader(boolean bSetHeaderSave) {
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oSaveCoulmn = this.m_oFileSelectionTable.getColumnModel().getColumn(0);
        this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, bSetHeaderSave, this, this.m_oFileSelectionTable.getTableHeader().getBackground());
        return oSaveCoulmn;
    }

    private void createFileSelectionTableModel() {
        Object[] arrcolHeader = new String[]{"OPERATION_OBJ", this.getLocalisedString("SERIAL_NO"), this.getLocalisedString("LOAD_FILE"), this.getLocalisedString("CONTENT_TYPE"), this.getLocalisedString("SAM_TABLE_COLUMN_VERSION"), this.getLocalisedString("SAM_TABLE_COLUMN_PATCH_VERSION")};
        this.m_oFileSelectionTableModel = new DefaultTableModel(arrcolHeader, 0);
    }

    private void createButtons() {
        this.m_oOKBtn = new JButton(this.getLocalisedString("SYS_SETTING_OK_BTN"));
        this.m_oOKBtn.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oOKBtn");
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                MxuTargetVersionAndFileSelectionDlg.this.performOkAction();
            }
        });
        this.m_oCancelBtn = new JButton(this.getLocalisedString("SYS_SETTING_CANCEL_BTN"));
        this.m_oCancelBtn.setName("Policy_MxuTargetVersionAndFileSelectionDlg_m_oCancelBtn");
        this.m_oCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent oEvent) {
                MxuTargetVersionAndFileSelectionDlg.this.dispose();
            }
        });
        this.m_oOKBtn.setBounds(635, 385, 80, 20);
        this.m_oCancelBtn.setBounds(725, 385, 80, 20);
        this.add(this.m_oOKBtn);
        this.add(this.m_oCancelBtn);
    }

    private void performOkAction() {
        String oTargetVersion = (String)this.m_oVersionComboBox.getSelectedItem();
        this.m_oUpdateDataModel.setTargetVersion(oTargetVersion);
        int iNoOfRows = this.m_oFileSelectionTableModel.getRowCount();
        ArrayList<FileInfo> oFileList = new ArrayList<FileInfo>(this.m_iNoOfFilesSelected);
        int iFileListIndx = 0;
        for (int iRow = 0; iRow < iNoOfRows; ++iRow) {
            MXUUpgradeDataModel oData = (MXUUpgradeDataModel)this.m_oFileSelectionTableModel.getValueAt(iRow, 0);
            if (!oData.getIsFileSelected()) continue;
            FileInfo oFileInfo = new FileInfo();
            oFileInfo.setFileName((String)this.m_oFileSelectionTableModel.getValueAt(iRow, 2));
            oFileInfo.setContentType((String)this.m_oFileSelectionTableModel.getValueAt(iRow, 3));
            oFileInfo.setIContentType(oData.getContentType());
            oFileInfo.setSeqNumber(iFileListIndx + 1);
            oFileList.add(oFileInfo);
            ++iFileListIndx;
        }
        if (0 == oFileList.size()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), this.getLocalisedString("SELECT_ALTEAST_ONE_FILE"), this.getLocalisedString("INFO"), 1);
            return;
        }
        boolean isValidFiles = PolicyUtil.validateFileList(oFileList);
        if (!isValidFiles) {
            DCOptionPane.showMessageDialog((Component)((Object)this), this.getLocalisedString("FILE_SELECTION_NOT_CORRECT"), this.getLocalisedString("INFO"), 1);
            return;
        }
        boolean isValidFileTypes = PolicyUtil.validateFileTypes(this.m_oUpdateDataModel.getDevTypeInfo(), oFileList);
        if (!isValidFileTypes) {
            return;
        }
        this.m_oUpdateDataModel.setFileList(oFileList);
        this.dispose();
    }

    private ComboBoxWithToolTip getVersionComboBox() {
        this.m_oVersionComboBox = new ComboBoxWithToolTip();
        this.oItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MxuTargetVersionAndFileSelectionDlg.this.m_iNoOfFilesSelected = 0;
                    MxuTargetVersionAndFileSelectionDlg.this.handleActions();
                }
            }
        };
        this.m_oVersionComboBox.addItemListener(this.oItemListener);
        this.addComboBoxItems();
        return this.m_oVersionComboBox;
    }

    private void handleActions() {
        String oTargetVersion = (String)this.m_oVersionComboBox.getSelectedItem();
        if (null != oTargetVersion) {
            ISAMManager oManager = SAMManager.getInstance();
            SAMFileInfo oFileInfo = new SAMFileInfo();
            oFileInfo.setDeviceTypeInfo(this.m_oUpdateDataModel.getDevTypeInfo());
            oFileInfo.setVersion(oTargetVersion);
            AsnSAMGetVersionFileLstRsp oFileListRsp = oManager.getAsnSAMDeviceVersionFileReq(oFileInfo);
            AsnDCErrorCodeInfo oAsnDCErrorCodeInfo = oFileListRsp.oErrorInfo;
            int iErrCode = oAsnDCErrorCodeInfo.iErrorNo.intValue();
            if (iErrCode != 0) {
                DCDebugTracer.trace("handleActions#ErrorCode:" + iErrCode);
                DCOptionPane.showMessageDialog((Component)((Object)this), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrCode)), ResourceManager.getInstance().getResString("ERROR"), 0);
                FileInfoForMxuUpgrade[] oFileInfoForMxuUpgradeList = new FileInfoForMxuUpgrade[]{};
                this.addToTable(oFileInfoForMxuUpgradeList);
                return;
            }
            int iNoOfFile = oFileListRsp.oAsnSAMFileInfoLst.size();
            int iNoOfFilesTobeConsidered = 0;
            for (int i = 0; i < iNoOfFile; ++i) {
                int iContentType = ((AsnSAMFileInfo)oFileListRsp.oAsnSAMFileInfoLst.get((int)i)).iFileType.intValue();
                SAMUtil.getInstance();
                ContentType oContentType = SAMUtil.getFileTypeObj(oFileInfo.getDeviceTypeInfo(), iContentType);
                if (oContentType.getId().equals("DBUPDATE") || oContentType.getId().equals("PACKETTOOL")) continue;
                ++iNoOfFilesTobeConsidered;
            }
            FileInfo[] oFileInfoForMxuUpgradeList = new FileInfoForMxuUpgrade[iNoOfFilesTobeConsidered];
            if (0 == oFileInfoForMxuUpgradeList.length) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("IMPORT_FILES_TO_SAM"), ResourceManager.getInstance().getResString("WARNING"), 2);
            }
            int iIndex = 0;
            for (int i = 0; i < iNoOfFile; ++i) {
                AsnSAMFileInfo oAsnSAMFileInfo = (AsnSAMFileInfo)oFileListRsp.oAsnSAMFileInfoLst.get(i);
                String strFilename = new String(oAsnSAMFileInfo.strFileName);
                strFilename = strFilename.replace('\\', '/');
                strFilename = strFilename.substring(strFilename.lastIndexOf(47) + 1);
                int iContentType = ((AsnSAMFileInfo)oFileListRsp.oAsnSAMFileInfoLst.get((int)i)).iFileType.intValue();
                SAMUtil.getInstance();
                ContentType oContentType = SAMUtil.getFileTypeObj(oFileInfo.getDeviceTypeInfo(), iContentType);
                if (oContentType != null && (oContentType.getId().equals("DBUPDATE") || oContentType.getId().equals("PACKETTOOL")) || null == strFilename || strFilename.equals("")) continue;
                oFileInfoForMxuUpgradeList[iIndex] = new FileInfoForMxuUpgrade();
                oFileInfoForMxuUpgradeList[iIndex].setFileName(strFilename);
                oFileInfoForMxuUpgradeList[iIndex].setIContentType(iContentType);
                if (null != oContentType) {
                    oFileInfoForMxuUpgradeList[iIndex].setContentType(oContentType.getStrContentType());
                } else {
                    oFileInfoForMxuUpgradeList[iIndex].setContentType("" + iContentType + "");
                }
                if (oAsnSAMFileInfo.strPatchVersion != null) {
                    ((FileInfoForMxuUpgrade)oFileInfoForMxuUpgradeList[iIndex]).setPatchVer(new String(oAsnSAMFileInfo.strPatchVersion));
                }
                if (oAsnSAMFileInfo.strVersion != null) {
                    ((FileInfoForMxuUpgrade)oFileInfoForMxuUpgradeList[iIndex]).setVersion(new String(oAsnSAMFileInfo.strVersion));
                }
                ++iIndex;
            }
            this.addToTable((FileInfoForMxuUpgrade[])oFileInfoForMxuUpgradeList);
            this.validateIfSomeFilesAreDeleted(oFileInfoForMxuUpgradeList);
        }
    }

    private void validateIfSomeFilesAreDeleted(FileInfo[] oFileLst) {
        List oAlreadySelectedFileInfo = (List)this.getAlreadySelectedData(false);
        Vector oFilesDeleted = new Vector(5);
        int iNoAlreadySelFile = 0;
        if (null != oAlreadySelectedFileInfo) {
            iNoAlreadySelFile = oAlreadySelectedFileInfo.size();
        }
        int iCurrentFilesFromSAM = oFileLst.length;
        boolean bIsAllFilesPresent = false;
        for (int i = iNoAlreadySelFile - 1; i >= 0; --i) {
            bIsAllFilesPresent = false;
            if (null == oAlreadySelectedFileInfo) continue;
            String strFileName = ((FileInfo)oAlreadySelectedFileInfo.get(i)).getFileName();
            for (int j = 0; j < iCurrentFilesFromSAM; ++j) {
                String strCurrentFile = oFileLst[j].getFileName();
                if (!strFileName.equals(strCurrentFile)) continue;
                bIsAllFilesPresent = true;
                break;
            }
            if (bIsAllFilesPresent) continue;
            oFilesDeleted.add(oAlreadySelectedFileInfo.get(i));
            oAlreadySelectedFileInfo.remove(i);
        }
        if (oFilesDeleted.size() > 0) {
            this.m_oUpdateDataModel.setTargetVersion((String)this.m_oVersionComboBox.getSelectedItem());
            ShowDeletedSoftwareLstDlg oDelSwDlg = new ShowDeletedSoftwareLstDlg(this.m_oUpdateDataModel, oFilesDeleted, oFileLst);
            oDelSwDlg.setVisible(true);
        }
    }

    private void addToTable(FileInfoForMxuUpgrade[] oFileInfoForMxuUpgradeList) {
        this.m_oFileSelectionTableModel.getDataVector().removeAllElements();
        this.m_oFileSelectionTableModel.fireTableDataChanged();
        List oAlreadySelectedFileInfo = (List)this.getAlreadySelectedData(false);
        for (int i = 0; i < oFileInfoForMxuUpgradeList.length; ++i) {
            Vector<Object> v = new Vector<Object>(5);
            this.m_oFileSelectionData = new MXUUpgradeDataModel();
            boolean bIsFileSelectedAlready = false;
            if (null != oAlreadySelectedFileInfo) {
                for (int j = 0; j < oAlreadySelectedFileInfo.size(); ++j) {
                    if (!oFileInfoForMxuUpgradeList[i].getFileName().equals(((FileInfo)oAlreadySelectedFileInfo.get(j)).getFileName()) || !oFileInfoForMxuUpgradeList[i].getContentType().equals(((FileInfo)oAlreadySelectedFileInfo.get(j)).getContentType())) continue;
                    bIsFileSelectedAlready = true;
                    this.m_bFileSelOption = true;
                    this.m_iNoOfFilesSelected = 0;
                    break;
                }
            }
            this.m_oFileSelectionData.setFileSelected(bIsFileSelectedAlready);
            this.m_oFileSelectionData.setContentType(oFileInfoForMxuUpgradeList[i].getIContentType());
            v.add(this.m_oFileSelectionData);
            v.add(i + 1);
            v.add(oFileInfoForMxuUpgradeList[i].getFileName());
            v.add(oFileInfoForMxuUpgradeList[i].getContentType());
            v.add(oFileInfoForMxuUpgradeList[i].getVersion());
            v.add(oFileInfoForMxuUpgradeList[i].getPatchVer());
            this.m_oFileSelectionTableModel.addRow(v);
        }
        this.setCheckBox();
        this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
        this.m_oFileSelectionTableModel.fireTableDataChanged();
        this.m_oFileSelectionTable.getTableHeader().repaint();
    }

    private void addComboBoxItems() {
        String strAlreadySelectedTargetVersion = (String)this.getAlreadySelectedData(true);
        DeviceTypeInfo oDevTypeInfo = this.m_oUpdateDataModel.getDevTypeInfo();
        ISAMManager oManager = SAMManager.getInstance();
        SAMFileInfo oFileInfo = new SAMFileInfo();
        oFileInfo.setDeviceTypeInfo(oDevTypeInfo);
        AsnSAMGetVersionRsp oRsp = oManager.getAsnSAMGetVersionReq(oFileInfo, 6);
        oRsp = this.validateTargetVersions(oRsp);
        int iNoOfTargetVersions = oRsp.oAsnSAMVersionLst.size();
        if (0 == iNoOfTargetVersions) {
            List<FileInfo> oFileLst = this.getDataModel();
            if (null == oFileLst || 0 == oFileLst.size()) {
                DCOptionPane.showMessageDialog((Component)((Object)this), this.getLocalisedString("IMPORT_FILES_TO_SAM"), this.getLocalisedString("INFO"), 1);
            } else {
                this.showDeletedFileInfo(oFileLst);
            }
        } else {
            this.checkifTargetVersionExists(oRsp.oAsnSAMVersionLst);
            String strItem = "";
            AsnSAMVersion oAsnSAMVersion = null;
            ArrayList<String> oVersionLst = new ArrayList<String>();
            this.m_oVersionComboBox.removeItemListener(this.oItemListener);
            for (int i = 0; i < iNoOfTargetVersions; ++i) {
                oAsnSAMVersion = (AsnSAMVersion)oRsp.oAsnSAMVersionLst.get(i);
                strItem = new String(oAsnSAMVersion.stringSWVersion);
                if (oVersionLst.contains(strItem)) continue;
                oVersionLst.add(strItem);
                this.m_oVersionComboBox.addItem(strItem);
            }
            this.m_oVersionComboBox.addItemListener(this.oItemListener);
            this.m_oVersionComboBox.setSelectedIndex(-1);
            if (strAlreadySelectedTargetVersion.length() > 0) {
                this.m_oVersionComboBox.setSelectedItem(strAlreadySelectedTargetVersion);
            } else {
                this.m_oVersionComboBox.setSelectedIndex(0);
            }
        }
    }

    private AsnSAMGetVersionRsp validateTargetVersions(AsnSAMGetVersionRsp oasnSAMGetVersionRsp) {
        AsnSAMGetVersionRsp oFilterRsp = oasnSAMGetVersionRsp;
        int iNoOfTargetVersions = oFilterRsp.oAsnSAMVersionLst.size();
        String oPatchVersion = "";
        AsnSAMVersion oAsnSAMVersion = null;
        int i = 0;
        int j = 0;
        while (j < iNoOfTargetVersions) {
            oAsnSAMVersion = (AsnSAMVersion)oFilterRsp.oAsnSAMVersionLst.get(i);
            String oTargetVersion = new String(oAsnSAMVersion.stringSWVersion);
            if (null != oAsnSAMVersion.stringPatchVersion) {
                oPatchVersion = new String(oAsnSAMVersion.stringPatchVersion);
            }
            ISAMManager oManager = SAMManager.getInstance();
            SAMFileInfo oFileInfo = new SAMFileInfo();
            oFileInfo.setDeviceTypeInfo(this.m_oUpdateDataModel.getDevTypeInfo());
            oFileInfo.setVersion(oTargetVersion);
            oFileInfo.setPatchVer(oPatchVersion);
            AsnSAMGetVersionFileLstRsp oFileListRsp = oManager.getAsnSAMDeviceVersionFileReq(oFileInfo);
            if (0 == oFileListRsp.oAsnSAMFileInfoLst.size()) {
                oFilterRsp.oAsnSAMVersionLst.remove(i);
                --i;
            }
            ++j;
            ++i;
        }
        return oFilterRsp;
    }

    private void showDeletedFileInfo(List<FileInfo> oFileLst) {
        Vector<FileInfo> oDelteFiles = new Vector<FileInfo>(2);
        for (int i = 0; i < oFileLst.size(); ++i) {
            oDelteFiles.add(oFileLst.get(i));
        }
        oFileLst.clear();
        FileInfo[] arrFileInfo = new FileInfo[]{};
        ShowDeletedSoftwareLstDlg oDelSwDlg = new ShowDeletedSoftwareLstDlg(this.m_oUpdateDataModel, oDelteFiles, arrFileInfo);
        oDelSwDlg.setVisible(true);
    }

    private void checkifTargetVersionExists(AsnSAMVersionLst oAsnSAMVersionLst) {
        List<FileInfo> oFileLst;
        String strSelectedTargetVersion = (String)this.getAlreadySelectedData(true);
        boolean isPresent = false;
        if (0 == strSelectedTargetVersion.length()) {
            return;
        }
        int oSizeTargetVersion = oAsnSAMVersionLst.size();
        String strTargetVersion = null;
        for (int i = 0; i < oSizeTargetVersion; ++i) {
            AsnSAMVersion oVersion = (AsnSAMVersion)oAsnSAMVersionLst.get(i);
            strTargetVersion = new String(oVersion.stringSWVersion);
            if (!strSelectedTargetVersion.equals(strTargetVersion.trim())) continue;
            isPresent = true;
            break;
        }
        if (!isPresent && null != (oFileLst = this.getDataModel()) && 0 != oFileLst.size()) {
            this.showDeletedFileInfo(oFileLst);
        }
    }

    private List<FileInfo> getDataModel() {
        String strKey;
        HashMap<String, MXUUpgradeDataModel> oDataAlreadySelected = this.m_oPanelData.getData();
        List<FileInfo> oFileInfoLst = null;
        if (oDataAlreadySelected.size() > 0 && oDataAlreadySelected.containsKey(strKey = this.m_oUpdateDataModel.getSubMapID() + this.m_oUpdateDataModel.getDevTypeInfo().getDevTypeName() + '(' + this.m_oUpdateDataModel.getDevTypeInfo().getDevTypeVersionName() + ')')) {
            MXUUpgradeDataModel oData = oDataAlreadySelected.get(strKey);
            oFileInfoLst = oData.getFileList();
        }
        return oFileInfoLst;
    }

    private Object getAlreadySelectedData(boolean isTargetVersion) {
        String strKey;
        String strAlreadySelectedTargetVersion = "";
        List<FileInfo> oFileInfoLst = null;
        HashMap<String, MXUUpgradeDataModel> oDataAlreadySelected = this.m_oPanelData.getData();
        if (oDataAlreadySelected.size() > 0 && oDataAlreadySelected.containsKey(strKey = this.m_oUpdateDataModel.getSubMapID() + this.m_oUpdateDataModel.getDevTypeInfo().getDevTypeName() + '(' + this.m_oUpdateDataModel.getDevTypeInfo().getDevTypeVersionName() + ')')) {
            MXUUpgradeDataModel oData = oDataAlreadySelected.get(strKey);
            strAlreadySelectedTargetVersion = oData.getTargetVersion();
            if (null != this.m_oVersionComboBox.getSelectedItem() && this.m_oVersionComboBox.getSelectedItem().equals(strAlreadySelectedTargetVersion)) {
                oFileInfoLst = oData.getFileList();
            }
        }
        if (null == strAlreadySelectedTargetVersion) {
            strAlreadySelectedTargetVersion = "";
        }
        if (isTargetVersion) {
            return strAlreadySelectedTargetVersion;
        }
        return oFileInfoLst;
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_TARGETVERSION_FILE_SELECTION";
    }

    private String getLocalisedString(String key) {
        return ResourceManager.getInstance().getResString(key);
    }

    public int countNumberOfFileSelected() {
        int iRowCount = this.m_oFileSelectionTableModel.getRowCount();
        this.m_iSelectionType = 0 == iRowCount ? 2 : (this.m_iNoOfFilesSelected == iRowCount ? 0 : (this.m_iNoOfFilesSelected < iRowCount && this.m_iNoOfFilesSelected != 0 ? 1 : 2));
        return this.m_iSelectionType;
    }

    private void setCheckBox() {
        int iRowCount = this.m_oFileSelectionTableModel.getRowCount();
        if (!this.m_bFileSelOption) {
            this.m_iNoOfFilesSelected = 0;
        } else {
            for (int i = 0; i < iRowCount; ++i) {
                MXUUpgradeDataModel oDataModel = (MXUUpgradeDataModel)this.m_oFileSelectionTableModel.getValueAt(i, 0);
                if (!oDataModel.getIsFileSelected()) continue;
                ++this.m_iNoOfFilesSelected;
            }
        }
    }

    private void setCheckBoxonClick() {
        int iRowCount = this.m_oFileSelectionTableModel.getRowCount();
        this.m_iNoOfFilesSelected = !this.m_bFileSelOption ? 0 : iRowCount;
        for (int i = 0; i < iRowCount; ++i) {
            MXUUpgradeDataModel oDataModel = (MXUUpgradeDataModel)this.m_oFileSelectionTableModel.getValueAt(i, 0);
            oDataModel.setFileSelected(this.m_bFileSelOption);
        }
    }

    @Override
    public void doCleanUp() {
        super.doCleanUp();
        this.m_oVersionComboBox = null;
        this.m_oUpdateDataModel = null;
        this.m_oFileSelectionData = null;
        this.m_oFileSelectionTableModel = null;
        this.m_oFileSelectionTable = null;
        this.m_oPanelData = null;
    }

    private class FileSeclectionCheckBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private JCheckBox m_oSelectionCheckBox = new JCheckBox();
        private boolean m_bIsSelected = false;
        private MXUUpgradeDataModel m_oDataModel;
        private int iSerialNo = -1;

        FileSeclectionCheckBoxEditor() {
            this.m_oSelectionCheckBox.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable oTable, Object oValue, boolean bSelected, int iRowNo, int iCcolNo) {
            this.m_oDataModel = (MXUUpgradeDataModel)MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTableModel.getValueAt(iRowNo, 0);
            this.m_bIsSelected = this.m_oDataModel.getIsFileSelected();
            this.iSerialNo = iRowNo;
            this.m_oSelectionCheckBox.setBackground(MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.getBackground());
            this.m_oSelectionCheckBox.setText("" + (iRowNo + 1));
            this.m_oSelectionCheckBox.setSelected(this.m_bIsSelected);
            return this.m_oSelectionCheckBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_oSelectionCheckBox;
        }

        @Override
        public void actionPerformed(ActionEvent oActionEvent) {
            boolean bl = this.m_bIsSelected = !this.m_bIsSelected;
            if (this.m_bIsSelected) {
                MxuTargetVersionAndFileSelectionDlg.this.m_iNoOfFilesSelected++;
            }
            if (MxuTargetVersionAndFileSelectionDlg.this.m_iNoOfFilesSelected > 0 && !this.m_bIsSelected) {
                MxuTargetVersionAndFileSelectionDlg.this.m_iNoOfFilesSelected--;
            }
            MxuTargetVersionAndFileSelectionDlg.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            this.m_oDataModel.setFileSelected(this.m_bIsSelected);
            this.m_oSelectionCheckBox.setBackground(MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.getBackground());
            this.m_oSelectionCheckBox.setText("" + (this.iSerialNo + 1));
            this.m_oSelectionCheckBox.setSelected(this.m_bIsSelected);
            this.fireEditingStopped();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.repaint();
                    MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.getTableHeader().repaint();
                }
            });
        }
    }

    private class FileSeclectionCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private FileSeclectionCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable oOpTable, Object value, boolean bIsSelected, boolean bhasFocus, int iRow, int iColumn) {
            MXUUpgradeDataModel oDataModel = (MXUUpgradeDataModel)MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTableModel.getValueAt(iRow, 0);
            this.setBackground(oOpTable.getBackground());
            this.setSelected(oDataModel.getIsFileSelected());
            this.setText("" + (iRow + 1));
            this.setToolTipText(this.getText());
            return this;
        }
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source instanceof AbstractButton) {
                if (0 == MxuTargetVersionAndFileSelectionDlg.this.m_iSelectionType) {
                    MxuTargetVersionAndFileSelectionDlg.this.m_bFileSelOption = false;
                } else if (2 == MxuTargetVersionAndFileSelectionDlg.this.m_iSelectionType || 1 == MxuTargetVersionAndFileSelectionDlg.this.m_iSelectionType) {
                    MxuTargetVersionAndFileSelectionDlg.this.m_bFileSelOption = true;
                }
            } else {
                return;
            }
            MxuTargetVersionAndFileSelectionDlg.this.setCheckBoxonClick();
            MxuTargetVersionAndFileSelectionDlg.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.repaint();
                    MxuTargetVersionAndFileSelectionDlg.this.m_oFileSelectionTable.getTableHeader().repaint();
                }
            });
        }
    }
}

