/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.policy.mxupolicy;

import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.CheckBoxHeader;
import com.huawei.dc.configuration.policy.mxupolicy.MXUUpgradeDataModel;
import com.huawei.dc.configuration.policy.mxupolicy.MxuTargetVersionAndFileSelectionDlg;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class MXUDeviceTablePanel
extends JPanel
implements DCTreeEventListener {
    private static final long serialVersionUID = 1L;
    private DeviceTree m_TreePanel;
    private ResourceManager m_oResourceMgr = ResourceManager.getInstance();
    private DefaultTableModel m_oDeviceTableModel;
    private JTable m_oDeviceTable;
    private final JScrollPane m_oTableScrollPane = new JScrollPane();
    private IDeviceInfoManager m_oDeviceInfoMgr;
    private static final int TABLE_DEVICETYPE_NAME = 0;
    private static final int CONFIGURE_UPGRADE_VERSION = 1;
    private int m_iNoSaveSelectedRows = 0;
    private CheckBoxHeader m_oCheckBoxHeader = null;
    private int m_iSelectionType = 2;
    private boolean m_bDevTypeSelOption = false;
    private static final int ALL_SELECTED = 0;
    private static final int PART_SELECTED = 1;
    private static final int NONE_SELECTED = 2;
    private static final int TABLE_MODEL_OPERATION_ID = 0;
    private HashMap<String, MXUUpgradeDataModel> m_oSubMapDevTypeSoftwareMap = new HashMap(5);
    private SubMapNodeInfo m_oSubMapNodeInfo = null;
    private int m_iDevDomain = 2;
    private ActionListener selectAllHandler;

    public MXUDeviceTablePanel() {
        if (this.m_oSubMapDevTypeSoftwareMap.size() > 0) {
            this.m_oSubMapDevTypeSoftwareMap.clear();
        }
    }

    public void initPanel(DeviceTree oTreepanel, IDeviceInfoManager oDeviceInfoMgr, int iDevDomain) {
        this.m_TreePanel = oTreepanel;
        this.m_oDeviceInfoMgr = oDeviceInfoMgr;
        this.m_iDevDomain = iDevDomain;
        this.registerForListners();
        this.createTreeTableModel();
        this.createTreeTable();
        this.fillInitialDataforTable();
        Border oBorder = BorderFactory.createEtchedBorder(1);
        this.setBorder(oBorder);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_oTableScrollPane, "Center");
        if (this.m_TreePanel.getRoot().getChildCount() > 0) {
            this.m_TreePanel.setSelectionPath(new TreePath(this.m_TreePanel.getRoot().getChildAt(0)));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MXUDeviceTablePanel.this.m_TreePanel.updateUI();
            }
        });
        this.selectAllHandler = this.createSelectAllListener();
        this.registerKeyBoardAction();
    }

    private ActionListener createSelectAllListener() {
        ActionListener selectAllKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MXUDeviceTablePanel.this.handleAllSelect();
            }
        };
        return selectAllKeyHandler;
    }

    private void handleAllSelect() {
        if (0 == this.m_iSelectionType) {
            this.m_bDevTypeSelOption = false;
        } else if (2 == this.m_iSelectionType || 1 == this.m_iSelectionType) {
            this.m_bDevTypeSelOption = true;
        }
        this.setCheckBoxonClick();
        this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MXUDeviceTablePanel.this.m_oDeviceTable.repaint();
                MXUDeviceTablePanel.this.m_oDeviceTable.getTableHeader().repaint();
            }
        });
    }

    private void registerKeyBoardAction() {
        KeyStroke ostroke = KeyStroke.getKeyStroke(65, 2);
        this.registerKeyboardAction(this.selectAllHandler, ostroke, 2);
    }

    private void fillInitialDataforTable() {
        this.m_oSubMapNodeInfo = new SubMapNodeInfo();
        this.m_oSubMapNodeInfo.m_submapId = "HWMAP_PHY_SUBMAP";
        this.fillDataToTable(this.m_oDeviceInfoMgr.getDeviceTypes());
    }

    private void createTreeTable() {
        this.m_oDeviceTable = new JTable(this.m_oDeviceTableModel);
        this.m_oDeviceTable.setName("Policy_MXUDeviceTablePanel_m_oDeviceTable");
        this.m_oDeviceTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTableScrollPane.getViewport().add(this.m_oDeviceTable);
        this.m_oTableScrollPane.setVerticalScrollBarPolicy(20);
        this.m_oTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_oTableScrollPane.getVerticalScrollBar().setAutoscrolls(true);
        this.m_oDeviceTable.setRowHeight(21);
        this.m_oDeviceTable.getTableHeader().setPreferredSize(new Dimension(this.m_oDeviceTable.getSize().width, 28));
        this.customizeTable();
    }

    private void customizeTable() {
        this.m_oDeviceTable.removeColumn(this.m_oDeviceTable.getColumnModel().getColumn(0));
        TableColumn oSaveCoulmn = this.addCheckBoxDevTypeHeader(true);
        oSaveCoulmn.setHeaderRenderer(this.m_oCheckBoxHeader);
        this.m_oDeviceTable.getColumnModel().getColumn(0).setCellRenderer(new DevTypeCheckBoxRenderer());
        this.m_oDeviceTable.getColumnModel().getColumn(1).setCellRenderer(new ConfigUpgradeVersionLinkRenderer());
        this.m_oDeviceTable.getColumnModel().getColumn(0).setCellEditor(new DevTypeCheckBoxEditor());
        this.m_oDeviceTable.getColumnModel().getColumn(1).setCellEditor(new ConfigUpgradeVersionLinkEditor());
        this.m_oDeviceTable.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.m_oDeviceTable.getColumnModel().getColumn(0).setMaxWidth(250);
        this.m_oDeviceTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.m_oDeviceTable.addMouseMotionListener(new OperationTableMouseMotionListener());
        this.m_oDeviceTable.addMouseListener(new OperationTableMouseListener());
    }

    private TableColumn addCheckBoxDevTypeHeader(boolean bSetHeaderSave) {
        ChckBoxHeaderItemLstner oChckItemListener = new ChckBoxHeaderItemLstner();
        TableColumn oSaveCoulmn = this.m_oDeviceTable.getColumnModel().getColumn(0);
        this.m_oCheckBoxHeader = new CheckBoxHeader((ItemListener)oChckItemListener, bSetHeaderSave, this, this.m_oDeviceTable.getTableHeader().getBackground());
        this.m_oDeviceTable.getTableHeader().setPreferredSize(new Dimension(this.m_oDeviceTable.getSize().width, 28));
        this.m_oDeviceTable.setName("Policy_MXUDeviceTablePanel_m_oCheckBoxHeader");
        return oSaveCoulmn;
    }

    private void createTreeTableModel() {
        Object[] arrcolHeader = new String[]{"OPERATION_OBJ", this.getLocalisedString("TASK_TABLE_COLUMN_DEVICE_TYPE"), this.getLocalisedString("CONFIGURE_UPGRADE_VERSION")};
        this.m_oDeviceTableModel = new DefaultTableModel(arrcolHeader, 0);
    }

    private void registerForListners() {
        this.m_TreePanel.registerForTreeSelectionEvent(this);
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        this.m_oDeviceTable.getModel();
        this.m_oDeviceTableModel.getDataVector().removeAllElements();
        this.m_oDeviceTableModel.getDataVector().setSize(0);
        this.m_oDeviceTableModel.getDataVector().clear();
        this.m_oDeviceTableModel.fireTableDataChanged();
        this.m_oDeviceTableModel.setRowCount(0);
        this.m_iNoSaveSelectedRows = 0;
        this.m_bDevTypeSelOption = false;
        this.setCheckBox();
        this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
        TreeNodeInfo oNode = (TreeNodeInfo)oEventObject.getSource();
        this.m_oSubMapNodeInfo = oNode.m_oSubMapNodeInfo;
        if (this.m_oSubMapNodeInfo.m_submapId.equals("S102")) {
            this.m_oSubMapNodeInfo = new SubMapNodeInfo();
            this.m_oSubMapNodeInfo.m_submapId = "HWMAP_PHY_SUBMAP";
        }
        final DeviceTypeInfo[] oDeviceTypeList = this.m_oDeviceInfoMgr.getDeviceTypes();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MXUDeviceTablePanel.this.fillDataToTable(oDeviceTypeList);
            }
        });
    }

    private void fillDataToTable(DeviceTypeInfo[] oDeviceTypeList) {
        int i;
        int iNoOfDevices = oDeviceTypeList.length;
        for (i = 0; i < iNoOfDevices; ++i) {
            if (!oDeviceTypeList[i].getIsMXUDevice() || oDeviceTypeList[i].getDevDomain() != this.m_iDevDomain) continue;
            MXUUpgradeDataModel oDataModel = this.getMxuModelData(oDeviceTypeList[i], this.m_oSubMapNodeInfo.m_submapId);
            Vector<Object> v = new Vector<Object>(5);
            v.add(oDataModel);
            v.add(oDeviceTypeList[i].getDevTypeName() + '(' + oDeviceTypeList[i].getDevTypeVersionName() + ')');
            v.add(this.getLocalisedString("CONFIGURE_UPGRADE_VERSION"));
            this.m_oDeviceTableModel.addRow(v);
        }
        if (this.m_oSubMapDevTypeSoftwareMap.size() > 0) {
            for (i = 0; i < this.m_oDeviceTableModel.getRowCount(); ++i) {
                MXUUpgradeDataModel oData = (MXUUpgradeDataModel)this.m_oDeviceTableModel.getValueAt(i, 0);
                String strKey = oData.getSubMapID() + oData.getDevTypeInfo().getDevTypeName() + '(' + oData.getDevTypeInfo().getDevTypeVersionName() + ')';
                if (!this.m_oSubMapDevTypeSoftwareMap.containsKey(strKey)) continue;
                MXUUpgradeDataModel oExistingData = this.m_oSubMapDevTypeSoftwareMap.get(strKey);
                oData.setIsSelected(oExistingData.getIsSelected());
                this.m_bDevTypeSelOption = true;
            }
            this.setCheckBox();
            this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MXUDeviceTablePanel.this.m_oDeviceTable.repaint();
                    MXUDeviceTablePanel.this.m_oDeviceTable.getTableHeader().updateUI();
                }
            });
        }
        this.m_oDeviceTableModel.fireTableRowsUpdated(0, this.m_oDeviceTableModel.getRowCount());
    }

    private MXUUpgradeDataModel getMxuModelData(DeviceTypeInfo oDevTypeInfo, String strSubMapid) {
        MXUUpgradeDataModel oMxuDatModel;
        String strKey = strSubMapid + oDevTypeInfo.getDevTypeName() + '(' + oDevTypeInfo.getDevTypeVersionName() + ')';
        if (this.m_oSubMapDevTypeSoftwareMap.containsKey(strKey)) {
            oMxuDatModel = this.m_oSubMapDevTypeSoftwareMap.get(strKey);
        } else {
            oMxuDatModel = new MXUUpgradeDataModel();
            oMxuDatModel.setDevType(oDevTypeInfo.getDevTypeName());
            oMxuDatModel.setIsSelected(false);
            oMxuDatModel.setDevTypeInfo(oDevTypeInfo);
            oMxuDatModel.setSubMapID(this.m_oSubMapNodeInfo.m_submapId);
        }
        return oMxuDatModel;
    }

    @Override
    public void onTreeInit(DCEventObject oEventObject) {
    }

    private void setCheckBoxonClick() {
        int iRowCount = this.m_oDeviceTableModel.getRowCount();
        this.m_iNoSaveSelectedRows = !this.m_bDevTypeSelOption ? 0 : iRowCount;
        for (int i = 0; i < iRowCount; ++i) {
            MXUUpgradeDataModel oDataModel = (MXUUpgradeDataModel)this.m_oDeviceTableModel.getValueAt(i, 0);
            oDataModel.setIsSelected(this.m_bDevTypeSelOption);
            this.m_oSubMapDevTypeSoftwareMap.put(oDataModel.getSubMapID() + oDataModel.getDevTypeInfo().getDevTypeName() + '(' + oDataModel.getDevTypeInfo().getDevTypeVersionName() + ')', oDataModel);
        }
    }

    private void setCheckBox() {
        int iRowCount = this.m_oDeviceTableModel.getRowCount();
        if (!this.m_bDevTypeSelOption) {
            this.m_iNoSaveSelectedRows = 0;
        } else {
            for (int i = 0; i < iRowCount; ++i) {
                MXUUpgradeDataModel oDataModel = (MXUUpgradeDataModel)this.m_oDeviceTableModel.getValueAt(i, 0);
                if (!oDataModel.getIsSelected()) continue;
                ++this.m_iNoSaveSelectedRows;
            }
        }
    }

    public int rowsSelectedForDevType() {
        int iRowCount = this.m_oDeviceTableModel.getRowCount();
        this.m_iSelectionType = 0 == iRowCount ? 2 : (this.m_iNoSaveSelectedRows == iRowCount ? 0 : (this.m_iNoSaveSelectedRows < iRowCount && this.m_iNoSaveSelectedRows != 0 ? 1 : 2));
        return this.m_iSelectionType;
    }

    private void addDataToSelectionList(MXUUpgradeDataModel oData) {
        if (this.m_oSubMapDevTypeSoftwareMap.containsKey(oData.getSubMapID() + oData.getDevTypeInfo().getDevTypeName() + '(' + oData.getDevTypeInfo().getDevTypeVersionName() + ')')) {
            this.m_oSubMapDevTypeSoftwareMap.remove(oData.getSubMapID() + oData.getDevTypeInfo().getDevTypeName() + '(' + oData.getDevTypeInfo().getDevTypeVersionName() + ')');
        }
        this.m_oSubMapDevTypeSoftwareMap.put(oData.getSubMapID() + oData.getDevTypeInfo().getDevTypeName() + '(' + oData.getDevTypeInfo().getDevTypeVersionName() + ')', oData);
    }

    public HashMap<String, MXUUpgradeDataModel> getData() {
        return this.m_oSubMapDevTypeSoftwareMap;
    }

    public void setData(HashMap<String, MXUUpgradeDataModel> oDataAlreadyConfigured) {
        this.m_oSubMapDevTypeSoftwareMap = oDataAlreadyConfigured;
    }

    private String getLocalisedString(String key) {
        return this.m_oResourceMgr.getResString(key);
    }

    private class OperationTableMouseListener
    extends MouseAdapter {
        private OperationTableMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Cursor cur = new Cursor(0);
            DCFrameWorkUtil.setCursor(MXUDeviceTablePanel.this.getParent(), cur);
        }
    }

    private class OperationTableMouseMotionListener
    extends MouseMotionAdapter {
        private OperationTableMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent oMouseEvent) {
            Point oPoint = oMouseEvent.getPoint();
            if (MXUDeviceTablePanel.this.m_oDeviceTable.columnAtPoint(oPoint) == 1) {
                TableCellRenderer oRenderer = MXUDeviceTablePanel.this.m_oDeviceTable.getCellRenderer(MXUDeviceTablePanel.this.m_oDeviceTable.rowAtPoint(oPoint), 1);
                if (oRenderer instanceof ConfigUpgradeVersionLinkRenderer) {
                    MXUUpgradeDataModel oData = (MXUUpgradeDataModel)MXUDeviceTablePanel.this.m_oDeviceTableModel.getValueAt(MXUDeviceTablePanel.this.m_oDeviceTable.rowAtPoint(oPoint), 0);
                    if (oData.getIsSelected()) {
                        Cursor cur = new Cursor(12);
                        DCFrameWorkUtil.setCursor(MXUDeviceTablePanel.this.getParent(), cur);
                    }
                } else {
                    Cursor cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(MXUDeviceTablePanel.this.getParent(), cur);
                }
            } else {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(MXUDeviceTablePanel.this.getParent(), cur);
            }
        }
    }

    private class ConfigUpgradeVersionLinkEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private JButton m_oLinkButton = new JButton();
        private MXUUpgradeDataModel oData;

        public ConfigUpgradeVersionLinkEditor() {
            this.m_oLinkButton.setBackground(MXUDeviceTablePanel.this.m_oDeviceTable.getBackground());
            this.m_oLinkButton.setRolloverEnabled(true);
            this.m_oLinkButton.addActionListener(this);
        }

        private void updateButtonView() {
            MatteBorder oMatteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, MXUDeviceTablePanel.this.m_oDeviceTable.getBackground());
            this.m_oLinkButton.setBorder(oMatteBorder);
            this.m_oLinkButton.setBackground(MXUDeviceTablePanel.this.m_oDeviceTable.getBackground());
            String strOplink = "<html><a href=\"x\">" + MXUDeviceTablePanel.this.getLocalisedString("CONFIGURE_UPGRADE_VERSION") + "</a>" + "</html>";
            this.m_oLinkButton.setText(strOplink);
            this.m_oLinkButton.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.oData = (MXUUpgradeDataModel)MXUDeviceTablePanel.this.m_oDeviceTableModel.getValueAt(row, 0);
            if (!this.oData.getIsSelected()) {
                return null;
            }
            String strOplink = MXUDeviceTablePanel.this.getLocalisedString("CONFIGURE_UPGRADE_VERSION");
            if (this.oData.getIsSelected()) {
                strOplink = "<html><a href=\"x\">" + MXUDeviceTablePanel.this.getLocalisedString("CONFIGURE_UPGRADE_VERSION") + "</a>" + "</html>";
            }
            this.m_oLinkButton.setText(strOplink);
            this.m_oLinkButton.setHorizontalAlignment(2);
            this.m_oLinkButton.setEnabled(this.oData.getIsSelected());
            return this.m_oLinkButton;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_oLinkButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.oData.getIsSelected()) {
                return;
            }
            if (MXUDeviceTablePanel.this.m_oSubMapDevTypeSoftwareMap.containsKey(this.oData.getSubMapID() + this.oData.getDevTypeInfo().getDevTypeName() + '(' + this.oData.getDevTypeInfo().getDevTypeVersionName() + ')')) {
                this.oData = (MXUUpgradeDataModel)MXUDeviceTablePanel.this.m_oSubMapDevTypeSoftwareMap.get(this.oData.getSubMapID() + this.oData.getDevTypeInfo().getDevTypeName() + '(' + this.oData.getDevTypeInfo().getDevTypeVersionName() + ')');
            }
            new MxuTargetVersionAndFileSelectionDlg(this.oData, MXUDeviceTablePanel.this, MXUDeviceTablePanel.this.m_iDevDomain);
            if (null == this.oData.getFileList() || 0 == this.oData.getFileList().size()) {
                this.oData.setIsSelected(false);
                MXUDeviceTablePanel.this.m_iNoSaveSelectedRows--;
                MXUDeviceTablePanel.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MXUDeviceTablePanel.this.m_oDeviceTable.repaint();
                        MXUDeviceTablePanel.this.m_oDeviceTable.getTableHeader().repaint();
                    }
                });
            }
            MXUDeviceTablePanel.this.addDataToSelectionList(this.oData);
            this.updateButtonView();
            this.fireEditingStopped();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MXUDeviceTablePanel.this.m_oDeviceTable.updateUI();
                }
            });
        }
    }

    private class DevTypeCheckBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1L;
        private JCheckBox m_oDevTypeCheckBox = new JCheckBox();
        private boolean m_bIsSelected = false;
        private MXUUpgradeDataModel m_oDataModel;

        DevTypeCheckBoxEditor() {
            this.m_oDevTypeCheckBox.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable oTable, Object oValue, boolean bSelected, int iRowNo, int iCcolNo) {
            this.m_oDataModel = (MXUUpgradeDataModel)MXUDeviceTablePanel.this.m_oDeviceTableModel.getValueAt(iRowNo, 0);
            this.m_bIsSelected = this.m_oDataModel.getIsSelected();
            this.m_oDevTypeCheckBox.setBackground(MXUDeviceTablePanel.this.m_oDeviceTable.getBackground());
            this.m_oDevTypeCheckBox.setText(this.m_oDataModel.getDevTypeInfo().getDevTypeName() + '(' + this.m_oDataModel.getDevTypeInfo().getDevTypeVersionName() + ')');
            this.m_oDevTypeCheckBox.setSelected(this.m_bIsSelected);
            return this.m_oDevTypeCheckBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_oDevTypeCheckBox;
        }

        @Override
        public void actionPerformed(ActionEvent oActionEvent) {
            boolean bl = this.m_bIsSelected = !this.m_bIsSelected;
            if (this.m_bIsSelected) {
                MXUDeviceTablePanel.this.m_iNoSaveSelectedRows++;
            }
            if (MXUDeviceTablePanel.this.m_iNoSaveSelectedRows > 0 && !this.m_bIsSelected) {
                MXUDeviceTablePanel.this.m_iNoSaveSelectedRows--;
            }
            MXUDeviceTablePanel.this.m_oCheckBoxHeader.handleHeaderChckBxChanges();
            this.m_oDataModel.setIsSelected(this.m_bIsSelected);
            String strKey = this.m_oDataModel.getSubMapID() + this.m_oDataModel.getDevTypeInfo().getDevTypeName() + '(' + this.m_oDataModel.getDevTypeInfo().getDevTypeVersionName() + ')';
            MXUDeviceTablePanel.this.m_oSubMapDevTypeSoftwareMap.put(strKey, this.m_oDataModel);
            this.m_oDevTypeCheckBox.setBackground(MXUDeviceTablePanel.this.m_oDeviceTable.getBackground());
            this.m_oDevTypeCheckBox.setText(this.m_oDataModel.getDevTypeInfo().getDevTypeName() + '(' + this.m_oDataModel.getDevTypeInfo().getDevTypeVersionName() + ')');
            this.m_oDevTypeCheckBox.setSelected(this.m_bIsSelected);
            this.fireEditingStopped();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MXUDeviceTablePanel.this.m_oDeviceTable.repaint();
                    MXUDeviceTablePanel.this.m_oDeviceTable.getTableHeader().repaint();
                }
            });
        }
    }

    private class ConfigUpgradeVersionLinkRenderer
    extends JButton
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ConfigUpgradeVersionLinkRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MXUUpgradeDataModel oDataModel = (MXUUpgradeDataModel)MXUDeviceTablePanel.this.m_oDeviceTableModel.getValueAt(row, 0);
            this.setBackground(MXUDeviceTablePanel.this.m_oDeviceTable.getBackground());
            String strOpDesc = MXUDeviceTablePanel.this.getLocalisedString("CONFIGURE_UPGRADE_VERSION");
            String strOplink = "";
            strOplink = oDataModel.getIsSelected() ? "<html><a href=\"x\">" + strOpDesc + "</a>" + "</html>" : strOpDesc;
            this.setText(strOplink);
            MatteBorder oMatteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
            this.setBorder(oMatteBorder);
            this.setHorizontalAlignment(2);
            this.setEnabled(oDataModel.getIsSelected());
            return this;
        }
    }

    private class DevTypeCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        private DevTypeCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable oOpTable, Object value, boolean bIsSelected, boolean bhasFocus, int iRow, int iColumn) {
            MXUUpgradeDataModel oDataModel = (MXUUpgradeDataModel)MXUDeviceTablePanel.this.m_oDeviceTableModel.getValueAt(iRow, 0);
            this.setBackground(oOpTable.getBackground());
            this.setSelected(oDataModel.getIsSelected());
            this.setText(oDataModel.getDevTypeInfo().getDevTypeName() + '(' + oDataModel.getDevTypeInfo().getDevTypeVersionName() + ')');
            return this;
        }
    }

    class ChckBoxHeaderItemLstner
    implements ItemListener {
        ChckBoxHeaderItemLstner() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (!(source instanceof AbstractButton)) {
                return;
            }
            MXUDeviceTablePanel.this.handleAllSelect();
        }
    }
}

