/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.policy.mxupolicy;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfo;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfoResp;
import com.huawei.dc.common.asndatacenter.AsnLoadFileInfo;
import com.huawei.dc.common.asndatacenter.AsnLoadFileLst;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.tree.devicetree.DeviceTree;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeFactory;
import com.huawei.dc.common.components.tree.devicetree.DeviceTreeUtil;
import com.huawei.dc.common.components.tree.devicetree.descriptor.DeviceTreeBaseDescriptor;
import com.huawei.dc.common.components.tree.devicetree.descriptor.MainDeviceTreeDescriptor;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.configuration.policy.common.PolicyConfigurationAdapter;
import com.huawei.dc.configuration.policy.mxupolicy.MXUDeviceTablePanel;
import com.huawei.dc.configuration.policy.mxupolicy.MXUUpgradeDataModel;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.policy.mxupolicy.FileInfo;
import com.huawei.dc.sam.SAMUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ConfigureMXUPolicyDlg
extends DCModalDialog
implements IDeviceConfigChangeListener {
    private static final long serialVersionUID = 1L;
    private IDeviceInfoManager m_oDeviceInfoMgr;
    private PolicyConfigurationAdapter m_oPolicyConfAdapter;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private DeviceTree m_oSubMapTree;
    private transient DeviceTreeBaseDescriptor m_oCurrentTreeDescriptor;
    private MXUDeviceTablePanel m_DevTypeSeclectionPanel;
    private JSplitPane m_oHorizontalSplitPane;
    private JPanel m_oDeviceTreePanel;
    private int m_iDevDomain = 2;
    public static final int HELP_TOPIC_MXU_UPGRADE_DEVICE = 2;
    public static final int HELP_TOPIC_MXU_AUTO_UPGRADE = 1;

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_MXU_UPGRADE_DEVICE";
    }

    public ConfigureMXUPolicyDlg(IDeviceInfoManager oDeviceInfoMgr, PolicyConfigurationAdapter oPolicyConfAdapter, int iDevDomain) throws DCException {
        this.m_oDeviceInfoMgr = oDeviceInfoMgr;
        this.m_oPolicyConfAdapter = oPolicyConfAdapter;
        this.m_iDevDomain = iDevDomain;
        this.m_DevTypeSeclectionPanel = new MXUDeviceTablePanel();
        this.getContentPane().setLayout(null);
        this.setModal(true);
        this.setSize(650, 430);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.setTitle(this.getLocalisedString("CONFIGURE_MXU_POLICY"));
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
        this.getAlreadyConfiguredData();
        this.createSubMapTree();
        this.initializeDeviceTypeSelectionPanel();
        this.addHorizontalSplitPane();
        this.addPanelsToSplitPanes();
        this.createButtons();
        this.enableHelpKeyValues(iDevDomain);
    }

    private void initializeDeviceTypeSelectionPanel() {
        this.m_DevTypeSeclectionPanel.initPanel(this.m_oSubMapTree, this.m_oDeviceInfoMgr, this.m_iDevDomain);
        this.m_DevTypeSeclectionPanel.setMinimumSize(new Dimension(450, 300));
    }

    private void createButtons() {
        this.m_oOKBtn = new JButton(this.getLocalisedString("SYS_SETTING_OK_BTN"));
        this.m_oOKBtn.setName("Policy_ConfigureMXUPolicyDlg_m_oOKBtn");
        this.m_oCancelBtn = new JButton(this.getLocalisedString("SYS_SETTING_CANCEL_BTN"));
        this.m_oCancelBtn.setName("Policy_ConfigureMXUPolicyDlg_m_oCancelBtn");
        this.m_oOKBtn.setBounds(470, 370, 80, 20);
        this.m_oCancelBtn.setBounds(555, 370, 80, 20);
        this.addListenersToBtns();
        this.add(this.m_oOKBtn);
        this.add(this.m_oCancelBtn);
    }

    private void addListenersToBtns() {
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConfigureMXUPolicyDlg.this.handleOkBtnActionPerformed();
            }
        });
        this.m_oCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConfigureMXUPolicyDlg.this.handleCancelBtnActionPerformed();
            }
        });
    }

    private void addPanelsToSplitPanes() {
        this.m_oHorizontalSplitPane.add((Component)this.m_oDeviceTreePanel, "left");
        this.m_oHorizontalSplitPane.add((Component)this.m_DevTypeSeclectionPanel, "right");
        this.getContentPane().add((Component)this.m_oHorizontalSplitPane, null);
    }

    private void addHorizontalSplitPane() {
        this.m_oHorizontalSplitPane = new JSplitPane(1);
        this.m_oHorizontalSplitPane.setBounds(10, 10, 625, 350);
        this.m_oHorizontalSplitPane.setMinimumSize(new Dimension(385, 177));
        this.m_oHorizontalSplitPane.setPreferredSize(new Dimension(385, 634));
        this.m_oHorizontalSplitPane.setAutoscrolls(false);
        this.m_oHorizontalSplitPane.setContinuousLayout(true);
        this.m_oHorizontalSplitPane.setOneTouchExpandable(false);
        this.m_oHorizontalSplitPane.setDividerLocation(200);
        this.m_oHorizontalSplitPane.setDividerSize(6);
    }

    private void handleCancelBtnActionPerformed() {
        this.closeDialog();
    }

    @Override
    public void doCleanUp() {
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        this.m_oDeviceInfoMgr = null;
        this.m_oPolicyConfAdapter = null;
        this.m_oResourceManager = null;
        this.m_oSubMapTree = null;
        this.m_oCurrentTreeDescriptor = null;
        this.m_DevTypeSeclectionPanel = null;
        super.doCleanUp();
    }

    private void handleOkBtnActionPerformed() {
        boolean isDataSent = this.sendDataToServer();
        if (isDataSent) {
            DCFrameWorkUtil.setCursor((Component)((Object)this), Cursor.getDefaultCursor());
            this.setVisible(false);
        }
    }

    private boolean sendDataToServer() {
        boolean bIsDataSent = false;
        HashMap<String, MXUUpgradeDataModel> oData = this.m_DevTypeSeclectionPanel.getData();
        Iterator<Map.Entry<String, MXUUpgradeDataModel>> oDataItr = oData.entrySet().iterator();
        AsnDCMxuUpgradePolicyInfoLst oAsnDCMxuUpgradePolicyInfoLst = new AsnDCMxuUpgradePolicyInfoLst();
        Map.Entry<String, MXUUpgradeDataModel> oDataEntry = null;
        while (oDataItr.hasNext()) {
            AsnDCMxuUpgradePolicyInfo oPolicyReq;
            oDataEntry = oDataItr.next();
            MXUUpgradeDataModel oConfigInfo = oDataEntry.getValue();
            if (!oConfigInfo.getIsSelected()) {
                oPolicyReq = new AsnDCMxuUpgradePolicyInfo();
                oPolicyReq.strSubMapId = oConfigInfo.getSubMapID().getBytes();
                oPolicyReq.iDevicetypeId = BigInteger.valueOf(oConfigInfo.getDevTypeInfo().getDevTypeID());
                oPolicyReq.iDeviceTypeVerId = BigInteger.valueOf(oConfigInfo.getDevTypeInfo().getDevTypeVersionId());
                oPolicyReq.strUpgradeDevVersion = new byte[0];
                oPolicyReq.strUpgradeFileList = new AsnLoadFileLst();
                oPolicyReq.iPolicyState = BigInteger.valueOf(1L);
                oAsnDCMxuUpgradePolicyInfoLst.add((Object)oPolicyReq);
                continue;
            }
            oPolicyReq = new AsnDCMxuUpgradePolicyInfo();
            oPolicyReq.strSubMapId = oConfigInfo.getSubMapID().getBytes();
            oPolicyReq.iDevicetypeId = BigInteger.valueOf(oConfigInfo.getDevTypeInfo().getDevTypeID());
            oPolicyReq.iDeviceTypeVerId = BigInteger.valueOf(oConfigInfo.getDevTypeInfo().getDevTypeVersionId());
            if (null == oConfigInfo.getTargetVersion() || null == oConfigInfo.getFileList()) {
                DefaultMutableTreeNode subMapNode = DeviceTreeUtil.findNodeForSubmap(this.m_oSubMapTree, oConfigInfo.getSubMapID());
                this.m_oSubMapTree.setSelectionPath(new TreePath(subMapNode.getPath()));
                DCOptionPane.showMessageDialog((Component)((Object)this), MessageFormat.format(this.getLocalisedString("TARGET_VERSION_NOT_SELECTED"), subMapNode.getUserObject()), this.getLocalisedString("ERROR_MESSAGE_TITLE"), 2);
                return bIsDataSent;
            }
            oPolicyReq.strUpgradeDevVersion = oConfigInfo.getTargetVersion().getBytes();
            List<FileInfo> strFilelst = oConfigInfo.getFileList();
            oPolicyReq.strUpgradeFileList = new AsnLoadFileLst();
            for (int j = 0; j < strFilelst.size(); ++j) {
                AsnLoadFileInfo oFileInfo = new AsnLoadFileInfo();
                oFileInfo.iDevId = BigInteger.valueOf(0L);
                oFileInfo.iContentType = BigInteger.valueOf(strFilelst.get(j).getIContentType());
                oFileInfo.strFileName = strFilelst.get(j).getFileName().getBytes();
                oFileInfo.iSequence = BigInteger.valueOf(strFilelst.get(j).getSeqNumber());
                oPolicyReq.strUpgradeFileList.add((Object)oFileInfo);
            }
            oPolicyReq.iPolicyState = BigInteger.valueOf(0L);
            oAsnDCMxuUpgradePolicyInfoLst.add((Object)oPolicyReq);
        }
        int iErrorNo = this.m_oPolicyConfAdapter.setMxuPolicy(oAsnDCMxuUpgradePolicyInfoLst);
        bIsDataSent = true;
        if (iErrorNo != 0) {
            DCOptionPane.showMessageDialog((Component)((Object)this), iErrorNo, this.getLocalisedString("OPERATE_RESULT"), 0);
        } else {
            DCOptionPane.showMessageDialog((Component)((Object)this), this.getLocalisedString("OPERTION_SUCCESS"), this.getLocalisedString("INFO"), 1);
        }
        return bIsDataSent;
    }

    private void getAlreadyConfiguredData() throws DCException {
        HashMap<String, MXUUpgradeDataModel> oAlreadyConfiguredData = new HashMap<String, MXUUpgradeDataModel>(5);
        AsnDCMxuUpgradePolicyInfoResp oResp = this.m_oPolicyConfAdapter.getMxuPolicy();
        AsnDCMxuUpgradePolicyInfoLst oRespLst = oResp.oUpgradeInfoLst;
        int iSize = oRespLst.size();
        String strSubMapId = "";
        String strUpgradeVersion = "";
        for (int i = 0; i < iSize; ++i) {
            DeviceTypeInfo oDevInfo;
            AsnDCMxuUpgradePolicyInfo oInfo = (AsnDCMxuUpgradePolicyInfo)oRespLst.get(i);
            strSubMapId = new String(oInfo.strSubMapId);
            if ("S102".equals(strSubMapId)) {
                strSubMapId = "HWMAP_PHY_SUBMAP";
            }
            if (null == (oDevInfo = this.m_oDeviceInfoMgr.getDeviceTypeInfo(oInfo.iDevicetypeId.intValue(), oInfo.iDeviceTypeVerId.intValue()))) {
                DCDebugTracer.trace("DC::no device type found for mxu policy ");
                continue;
            }
            if (oDevInfo.getDevDomain() != this.m_iDevDomain) continue;
            String strDevType = oDevInfo.getDevTypeName();
            String strDevTypeVersion = oDevInfo.getDevTypeVersionName();
            String strKey = strSubMapId + strDevType + '(' + strDevTypeVersion + ')';
            MXUUpgradeDataModel oData = new MXUUpgradeDataModel();
            AsnLoadFileLst oFileLst = oInfo.strUpgradeFileList;
            ArrayList<FileInfo> oFileInfoLst = new ArrayList<FileInfo>(oFileLst.size());
            String strFileName = "";
            for (int j = 0; j < oFileLst.size(); ++j) {
                AsnLoadFileInfo oAsnFileInfo = (AsnLoadFileInfo)oFileLst.get(j);
                strFileName = new String(oAsnFileInfo.strFileName);
                FileInfo oFileInfo = new FileInfo();
                oFileInfo.setFileName(strFileName);
                oFileInfo.setIContentType(oAsnFileInfo.iContentType.intValue());
                ContentType oContentType = SAMUtil.getFileTypeObj(oDevInfo, oAsnFileInfo.iContentType.intValue());
                oFileInfo.setContentType(oContentType.getStrContentType());
                oFileInfoLst.add(oFileInfo);
            }
            oData.setFileList(oFileInfoLst);
            strUpgradeVersion = new String(oInfo.strUpgradeDevVersion);
            oData.setTargetVersion(strUpgradeVersion);
            oData.setIsSelected(true);
            oData.setFileSelected(true);
            oData.setDevType(oDevInfo.getDevTypeName());
            oData.setSubMapID(strSubMapId);
            oData.setDevTypeInfo(oDevInfo);
            oAlreadyConfiguredData.put(strKey, oData);
        }
        this.m_DevTypeSeclectionPanel.setData(oAlreadyConfiguredData);
    }

    private String getLocalisedString(String key) {
        return this.m_oResourceManager.getResString(key);
    }

    private void enableHelpKeyValues(int i) {
        DCHelpManager oHelpManager = DCHelpManager.getInstance();
        switch (i) {
            case 2: {
                oHelpManager.enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
                break;
            }
            case 1: {
                oHelpManager.enableHelpKey(this.getContentPane(), ResourceManager.getInstance().getResString("HELP_TOPIC_MXU_AUTO_UPGRADE", "helpmapfile"));
                break;
            }
        }
    }

    private void createSubMapTree() {
        this.m_oCurrentTreeDescriptor = this.generateTreeDescriptor(3);
        this.m_oCurrentTreeDescriptor.setTreeSelectable(false);
        this.m_oSubMapTree = DeviceTreeFactory.createDeviceTree(this.m_oCurrentTreeDescriptor, this.m_oDeviceInfoMgr, ResourceManager.getInstance().getResString("DEVICE_TREE_PAN_ROOT_NODE"));
        this.m_oSubMapTree.setName("Policy_ConfigureMXUPolicyDlg_m_oSubMapTree");
        this.m_oSubMapTree.setModel(this.m_oSubMapTree.getModel());
        this.expandTreeAtRoot();
        this.m_oDeviceTreePanel = new JPanel();
        this.m_oDeviceTreePanel.setLayout(new BorderLayout());
        JScrollPane oScrollPane = new JScrollPane(this.m_oSubMapTree);
        Border oBorder = BorderFactory.createEtchedBorder(1);
        this.m_oDeviceTreePanel.setMinimumSize(new Dimension(150, 300));
        this.m_oDeviceTreePanel.setBorder(oBorder);
        this.m_oDeviceTreePanel.add(oScrollPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != ConfigureMXUPolicyDlg.this.m_oSubMapTree) {
                    ConfigureMXUPolicyDlg.this.m_oSubMapTree.updateUI();
                }
            }
        });
    }

    private void expandTreeAtRoot() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null == ConfigureMXUPolicyDlg.this.m_oSubMapTree) {
                    return;
                }
                TreePath rowTreePath = ConfigureMXUPolicyDlg.this.m_oSubMapTree.getPathForRow(0);
                if (ConfigureMXUPolicyDlg.this.m_oSubMapTree.isCollapsed(rowTreePath)) {
                    ConfigureMXUPolicyDlg.this.m_oSubMapTree.expandPath(rowTreePath);
                }
            }
        });
    }

    private MainDeviceTreeDescriptor generateTreeDescriptor(int iTreeViewType) {
        MainDeviceTreeDescriptor oTreeDescriptor = new MainDeviceTreeDescriptor(iTreeViewType);
        oTreeDescriptor.setTreeSelectable(true);
        return oTreeDescriptor;
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        for (int i = 0; i < oDeviceInfoList.size(); ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            this.m_oSubMapTree.processEvent(iEventType, oAsnDeviceInfo);
        }
        this.m_oSubMapTree.treeDidChange();
    }

    @Override
    protected void closeDialog() {
        this.doCleanUp();
        super.closeDialog();
    }
}

