/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.policy.common;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfoLstReq;
import com.huawei.dc.common.asndatacenter.AsnDCMxuUpgradePolicyInfoResp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import java.math.BigInteger;
import java.util.Collection;
import net.commustru.fstru.FStruct;

public class PolicyManager
implements IDCObjectDeallocator {
    private BaseCommManager m_oCommManager = DCFrameWorkUtil.getCommManager();
    private static PolicyManager m_oInstance = null;

    private PolicyManager() {
    }

    @Override
    public void setToNULL() {
        this.m_oCommManager = null;
        m_oInstance = null;
    }

    public static synchronized PolicyManager getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new PolicyManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    public int setMxuPolicy(AsnDCMxuUpgradePolicyInfoLst oAsnMxuUpgradePolicyInfoLst) {
        AsnDCMxuUpgradePolicyInfoLstReq oAsnReq = new AsnDCMxuUpgradePolicyInfoLstReq();
        int iReqId = DCFrameWorkUtil.generateRequestId();
        oAsnReq.oReqID = BigInteger.valueOf(iReqId);
        oAsnReq.oAsnMxuPolicyLst.addAll((Collection)oAsnMxuUpgradePolicyInfoLst);
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        int errorcode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43971), (FStruct)oAsnReq, (FStruct)oAsnRsp);
        if (errorcode != 0) {
            return errorcode;
        }
        errorcode = oAsnRsp.oErrorInfo.iErrorNo.intValue();
        return errorcode;
    }

    public AsnDCMxuUpgradePolicyInfoResp getMxuPolicy() throws DCException {
        AsnDCMxuUpgradePolicyInfoResp oAsnDCMxuPolicyInfoResp = new AsnDCMxuUpgradePolicyInfoResp();
        int errorcode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43972), null, (FStruct)oAsnDCMxuPolicyInfoResp);
        if (0 != errorcode) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        errorcode = oAsnDCMxuPolicyInfoResp.oErrorInfo.iErrorNo.intValue();
        if (0 != errorcode) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
        return oAsnDCMxuPolicyInfoResp;
    }
}

