/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.licence.authorization.net;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.security.DCEncryptServiceUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.licence.LicenseInfo;
import com.huawei.dc.configuration.licence.authorization.AbstractAuthorization;
import com.huawei.dc.configuration.licence.authorization.net.DownloadFileListReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.misc.BASE64Encoder;

public class NetAuthorization
extends AbstractAuthorization {
    private static final String ERROR_KEY = "download_error";
    private static final long TIME_OVER = 1000L;
    private static final int TWO = 2;
    private URLConnection connection;
    private String errorMsg;
    private boolean ifOverNotify;
    private int isSuccess = -1;
    private char[] password;
    private String userName;

    public NetAuthorization(String userName, char[] password) {
        this.userName = userName;
        this.password = password;
    }

    @Override
    public int authorization() {
        Map<String, String> fileMap = this.getDownloadFiles();
        if (null == fileMap) {
            this.errorMsg = DCFrameWorkUtil.getLocalizedString("LICENSE_AUTH_NET_DOWNLOAD_FILE_EMPTY");
            return -1;
        }
        int iRet = -1;
        for (int i = 2; i > 0; --i) {
            String url = fileMap.get(String.valueOf(i));
            iRet = this.downLoadFile(this.userName, DCEncryptServiceUtil.decrypt(this.password), url);
            if (iRet >= 0) {
                DCDebugTracer.traceError("License load successful !" + iRet);
                break;
            }
            DCDebugTracer.traceError("License load failed !" + iRet);
        }
        if (iRet < 0) {
            this.errorMsg = DCFrameWorkUtil.getLocalizedString("LICENSE_AUTH_NET_DOWNLOAD_FILE_FAILED");
            DCDebugTracer.traceError("License checked failed !" + iRet);
            return iRet;
        }
        return iRet;
    }

    @Override
    public LicenseInfo createLicense() {
        LicenseInfo license = new LicenseInfo();
        license.setiLicenseModeType(1);
        license.setStrLicenseInfo(null);
        return license;
    }

    private int downLoadFile(String name, char[] secret, String url) {
        try {
            URL downUrl = new URL(url);
            String strSecret = String.valueOf(secret);
            char[] credit = (name + ":" + strSecret).toCharArray();
            String encoding = new BASE64Encoder().encode(String.valueOf(credit).getBytes());
            this.connection = downUrl.openConnection();
            this.connection.setRequestProperty("Authorization", "Basic " + encoding);
            this.ifOverNotify = true;
            OverTime overTimeThread = new OverTime();
            overTimeThread.setName(this.getClass().getName());
            overTimeThread.start();
            while (this.ifOverNotify) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
            }
            DCDebugTracer.traceError("License: " + this.isSuccess);
            StringUtils.clearCharCipher(credit);
            StringUtils.clearCharCipher(secret);
            return this.isSuccess;
        }
        catch (UnknownHostException e) {
            DCDebugTracer.trace(e);
            return -1;
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return -1;
        }
    }

    private Map<String, String> getDownloadFiles() {
        DownloadFileListReader reader = new DownloadFileListReader();
        Set<Object> keySet = reader.getSet();
        if (null == keySet || 0 == keySet.size()) {
            return null;
        }
        HashMap<String, String> fileMap = new HashMap<String, String>();
        Iterator<Object> iter = keySet.iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            String value = reader.getProperty(key);
            fileMap.put(key, value);
        }
        return fileMap;
    }

    @Override
    public String getLastError() {
        return this.errorMsg;
    }

    private class OverTime
    extends Thread {
        private OverTime() {
        }

        @Override
        public void run() {
            int contentLength;
            Map<String, List<String>> headers = NetAuthorization.this.connection.getHeaderFields();
            Set<String> set = headers.keySet();
            boolean errNameorPsw = set.contains(NetAuthorization.ERROR_KEY);
            if (errNameorPsw) {
                DCDebugTracer.traceError("License: The Name or password wrong!");
            }
            if ((contentLength = NetAuthorization.this.connection.getContentLength()) <= 0) {
                DCDebugTracer.traceError("License: The connection.getContentLength() <= 0!");
            }
            if (!errNameorPsw && contentLength > 0) {
                NetAuthorization.this.isSuccess = 0;
                DCDebugTracer.traceError("License: isSuccess !");
            }
            NetAuthorization.this.ifOverNotify = false;
        }
    }
}

