/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.licence.authorization.file;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.IOStreamClose;
import com.huawei.dc.configuration.licence.LicenseInfo;
import com.huawei.dc.configuration.licence.authorization.AbstractAuthorization;
import com.huawei.dc.configuration.licence.util.FileOperation;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class FileAuthorization
extends AbstractAuthorization {
    private String licenseFilePath;
    private String errorMsg = "";

    public FileAuthorization(String filePath) {
        this.licenseFilePath = filePath;
    }

    @Override
    public int authorization() {
        if (FileOperation.isFileExist(this.licenseFilePath)) {
            return 0;
        }
        this.errorMsg = ResourceManager.getInstance().getResString("LICENSE_AUTH_FILE_FILE_NOT_EXIST_MSG");
        return -1;
    }

    @Override
    public String getLastError() {
        return this.errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LicenseInfo createLicense() throws IOException {
        LicenseInfo license = new LicenseInfo();
        license.setiLicenseModeType(0);
        FileInputStream oFileInputStream = new FileInputStream(this.licenseFilePath);
        BufferedReader oBufferedReader = null;
        String oByteStr = null;
        try {
            oBufferedReader = new BufferedReader(new InputStreamReader(oFileInputStream));
            oByteStr = oBufferedReader.readLine();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        finally {
            IOStreamClose.closeInputStream(oFileInputStream);
            oBufferedReader.close();
        }
        DCDebugTracer.trace("createLicense length:" + oByteStr.length());
        license.setStrLicenseInfo(oByteStr.getBytes());
        return license;
    }
}

