/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.licence.authorization;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.configuration.licence.authorization.AbstractAuthorization;
import com.huawei.dc.configuration.licence.authorization.file.FileAuthorization;
import com.huawei.dc.configuration.licence.authorization.net.NetAuthorization;
import com.huawei.dc.configuration.licence.authorization.temp.TempAuthorization;

public class AuthorizationFactory {
    private String username;
    private char[] password;
    private String path;

    public AuthorizationFactory(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    public AuthorizationFactory(String path) {
        this.path = path;
    }

    public AuthorizationFactory() {
    }

    public AbstractAuthorization creatAuthorization(int mode) {
        AbstractAuthorization authorization = null;
        switch (mode) {
            case 0: {
                authorization = new FileAuthorization(this.path);
                break;
            }
            case 1: {
                authorization = new NetAuthorization(this.username, this.password);
                break;
            }
            case 2: {
                authorization = new TempAuthorization();
                break;
            }
            default: {
                DCDebugTracer.trace("error mode information : " + mode);
            }
        }
        return authorization;
    }
}

