/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.licence;

import com.huawei.dc.common.DCConfigFileParser;
import com.huawei.dc.common.asndatacenter.AsnDCLicenseInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCLicenseStatusRsp;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.swimap.iview.communicate.MSGPacketExt;
import net.commustru.fstru.FStruct;

public class LicenseMonitor
extends AbstractDCMSGReceiver
implements IDCObjectDeallocator {
    private boolean isControlTranLicesne = false;
    private int iLastStatus = 0;
    private int iCurrStatus = -1;
    private Object synObj = new Object();
    private static final int WAIT_TIME = 100;
    private static LicenseMonitor oLicenseMonitor;

    private LicenseMonitor() {
        super(44080);
        this.isControlTranLicesne = DCConfigFileParser.isTranNeedLicense();
    }

    public boolean isControlTran() {
        return this.isControlTranLicesne;
    }

    public static synchronized LicenseMonitor getInstance() {
        if (null == oLicenseMonitor) {
            oLicenseMonitor = new LicenseMonitor();
            DCObjectDestructor.getInstance().addObjectForDestructor(oLicenseMonitor);
        }
        return oLicenseMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessage(MSGPacketExt packetExt) {
        DCDebugTracer.trace("DC::LicenseMonitor-processMessage|CMDCODE=" + packetExt.mheader.cmdCode);
        if (packetExt.mheader.cmdCode == 44080) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                DCDebugTracer.trace(ex);
            }
            AsnDCLicenseStatusRsp oLicenseInfoRsp = new AsnDCLicenseStatusRsp();
            int errorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oLicenseInfoRsp, packetExt.getData());
            if (errorcode == 0) {
                Object object = this.synObj;
                synchronized (object) {
                    this.iLastStatus = oLicenseInfoRsp.enLastStatus.value;
                    this.iCurrStatus = oLicenseInfoRsp.enCurrentStatus.value;
                    if (this.iLastStatus != this.iCurrStatus && null != DCFrameWorkUtil.getTaskTableButtonPanel()) {
                        DCFrameWorkUtil.getTaskTableButtonPanel().checkButtonsStatus();
                    }
                }
            } else {
                DCDebugTracer.trace("DC::LicenseMonitor-processMessage AsnDCLicenseInfoRsp decode failed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getiLastStatus() {
        Object object = this.synObj;
        synchronized (object) {
            return this.iLastStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrStatusValid() {
        Object object = this.synObj;
        synchronized (object) {
            if (-1 == this.iCurrStatus) {
                SystemManager sysMgr = new SystemManager();
                AsnDCLicenseInfoRsp oAsnDCLIcense = sysMgr.getLicenseInformation();
                int iErrorCode = oAsnDCLIcense.oErrorNo.iErrorNo.intValue();
                this.iCurrStatus = 0 == iErrorCode ? 1 : 0;
            }
            return this.iCurrStatus == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setiCurrStatus(int iCurrStatus) {
        Object object = this.synObj;
        synchronized (object) {
            this.iCurrStatus = iCurrStatus;
        }
    }

    @Override
    public void timeout(int cCmdCode, Character character) {
        StringBuffer szBuf = new StringBuffer(5);
        szBuf.append(ResourceManager.getInstance().getResString("TIMEOUT"));
        szBuf.append(": ");
        szBuf.append(ResourceManager.getInstance().getResString("CMD_CODE_" + cCmdCode));
        szBuf.append("/n");
    }

    @Override
    public void setToNULL() {
        this.closeReceiver();
    }
}

