/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.licence;

import com.huawei.dc.common.asndatacenter.AsnDCLicenseInfoRsp;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCParsePackageXmlUtil;
import com.huawei.dc.configuration.licence.LicenseApplyDlg;
import com.huawei.dc.configuration.licence.LicenseMonitor;
import com.huawei.dc.framework.ErrorCodeReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class LicenseInfoDlg
extends DCModalDialog {
    private static final long serialVersionUID = -5798556783504370532L;
    private JLabel oDCLicense = null;
    private JPanel oAboutPanel = null;
    private KeyStroke keyStroke = null;
    private JLabel overdueLbl = null;

    public LicenseInfoDlg(JFrame parentFrame) {
        super(parentFrame, true);
        try {
            this.setSize(400, 350);
            this.setTitle(ResourceManager.getInstance().getResString("DATACENTER_LICENSE_INFO"));
            this.setDefaultCloseOperation(2);
            this.setResizable(false);
            this.setLocationRelativeTo(parentFrame);
            this.jbInit();
        }
        catch (Exception oException) {
            DCDebugTracer.trace("DC::LicenseInfoDlg::LicenseInfoDlg()::throw exception::" + oException.getMessage());
        }
    }

    private void jbInit() throws Exception {
        Border oBorder = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(103, 101, 98), new Color(148, 145, 140));
        this.oAboutPanel = new JPanel();
        this.oAboutPanel.setName("License_LicenseInfoDlg_oAboutPanel");
        this.oAboutPanel.setLayout(null);
        this.oDCLicense = new JLabel();
        this.oDCLicense.setName("License_LicenseInfoDlg_oDCLicense");
        int iNewBounds = 0;
        this.updateLicenseInfo();
        if (null != DCFrameWorkUtil.getTaskTableButtonPanel()) {
            DCFrameWorkUtil.getTaskTableButtonPanel().checkButtonsStatus();
        }
        iNewBounds = 20;
        this.oDCLicense.setBounds(new Rectangle(75, 10, 294, 30));
        JLabel oImageLbl = new JLabel();
        oImageLbl.setIcon(ResourceManager.getInstance().getImage("about.jpg"));
        oImageLbl.setBounds(0, 0, 400, 150);
        JLabel oImageLogoLbl = new JLabel();
        oImageLogoLbl.setIcon(ResourceManager.getInstance().getImage("logo.png"));
        oImageLogoLbl.setBounds(new Rectangle(0, 0, 80, 74));
        JButton m_olicenseButton = new JButton();
        m_olicenseButton.setText(ResourceManager.getInstance().getResString("UPDATE_LICENSE_BTN"));
        m_olicenseButton.setMnemonic('A');
        m_olicenseButton.setBounds(new Rectangle(164, 271, 100, 21));
        m_olicenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LicenseInfoDlg.this.appalyLicenseBtnActionPerformed();
            }
        });
        JButton oCloseButton = new JButton();
        oCloseButton.setText(ResourceManager.getInstance().getResString("CLOSE"));
        oCloseButton.setMnemonic('C');
        oCloseButton.setBounds(new Rectangle(285, 271, 100, 21));
        oCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LicenseInfoDlg.this.oCloseButtonAction();
            }
        });
        JPanel oPanel = new JPanel();
        oPanel.setName("License_LicenseInfoDlg_oPanel");
        oPanel.setBorder(oBorder);
        oPanel.setBounds(new Rectangle(10, 170, 375, 66 + iNewBounds));
        oPanel.setLayout(null);
        oPanel.add((Component)oImageLogoLbl, null);
        oPanel.add((Component)this.oDCLicense, null);
        if (null != this.overdueLbl) {
            oPanel.add((Component)this.overdueLbl, null);
        }
        this.oAboutPanel.add((Component)oImageLbl, null);
        this.oAboutPanel.add((Component)oPanel, null);
        this.oAboutPanel.add((Component)m_olicenseButton, null);
        this.oAboutPanel.add((Component)oCloseButton, null);
        this.getContentPane().add((Component)this.oAboutPanel, "Center");
        ActionListener escKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LicenseInfoDlg.this.dispose();
            }
        };
        this.keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.rootPane.registerKeyboardAction(escKeyHandler, this.keyStroke, 0);
        this.setSize(400, 320 + iNewBounds);
    }

    protected void oCloseButtonAction() {
        if (null != this.keyStroke) {
            this.rootPane.unregisterKeyboardAction(this.keyStroke);
            this.keyStroke = null;
        }
        this.dispose();
    }

    public void updateLicenseInfo() {
        SystemManager sysMgr = new SystemManager();
        AsnDCLicenseInfoRsp oAsnDCLIcense = sysMgr.getLicenseInformation();
        int iErrorCode = oAsnDCLIcense.oErrorNo.iErrorNo.intValue();
        String strMessage = null;
        ResourceManager oResMgr = ResourceManager.getInstance();
        int OVER_TIME_DATE = 3;
        if (0 == iErrorCode) {
            if (null != oAsnDCLIcense.iValidPeriod && oAsnDCLIcense.iValidPeriod.intValue() <= 3) {
                strMessage = "<html>" + oResMgr.getResString("DC_LICENCE") + " : " + "<b><Font color = #0000ff>" + this.getFormattedTime(oAsnDCLIcense.strStartTime) + " " + oResMgr.getResString("TO") + " " + this.getFormattedTime(oAsnDCLIcense.strEndTime) + "</Font></b></html>";
                String overdue = "<html><b><Font color = #0000ff>" + MessageFormat.format(oResMgr.getResString("LICENSE_OVERDUE"), "" + oAsnDCLIcense.iValidPeriod.intValue()) + "</Font></b></html>";
                this.overdueLbl = new JLabel();
                this.overdueLbl.setHorizontalAlignment(2);
                this.overdueLbl.setText(overdue);
                this.overdueLbl.setBounds(new Rectangle(75, 40, 294, 30));
                this.overdueLbl.setToolTipText(overdue);
            } else {
                if (null != this.overdueLbl) {
                    this.overdueLbl.setText("");
                }
                strMessage = "<html>" + oResMgr.getResString("DC_LICENCE") + " : " + "<b><Font color = #0000ff>" + this.getFormattedTime(oAsnDCLIcense.strStartTime) + " " + oResMgr.getResString("TO") + " " + this.getFormattedTime(oAsnDCLIcense.strEndTime) + "</Font></b></html>";
            }
            LicenseMonitor.getInstance().setiCurrStatus(1);
        } else {
            LicenseMonitor.getInstance().setiCurrStatus(0);
            strMessage = "<html>" + oResMgr.getResString("DC_LICENCE") + " : " + "<b><Font color = #ff0000>" + ErrorCodeReader.getInstance().getErrorDesc(oAsnDCLIcense.oErrorNo.iErrorNo) + "</Font></b></html>";
        }
        if (null != this.oDCLicense) {
            this.oDCLicense.setText(strMessage);
            this.oDCLicense.setToolTipText(strMessage);
        }
        if (null != this.oAboutPanel) {
            DCFrameWorkUtil.updateUI(this.oAboutPanel);
        }
    }

    private String getVersion() {
        try {
            String strVersion = "";
            String strPckName = DCParsePackageXmlUtil.getInstance().getPackageName();
            strVersion = strPckName + " : " + DCParsePackageXmlUtil.getInstance().getPackageVersion();
            return strVersion;
        }
        catch (Exception oException) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), oException.getMessage(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return " ";
        }
    }

    private String getFormattedTime(byte[] bStrFormat) {
        String strFormat = new String(bStrFormat);
        int iLen = strFormat.length();
        int i = 0;
        StringBuffer strFormatted = new StringBuffer();
        int iVarLen = 4;
        while (i < iLen) {
            strFormatted.append(strFormat.substring(i, i + iVarLen));
            strFormatted.append("-");
            if (2 == iVarLen) {
                strFormatted.append(strFormat.substring(i + iVarLen, iLen));
                break;
            }
            i = iVarLen;
            iVarLen = 2;
        }
        return strFormatted.toString();
    }

    private void appalyLicenseBtnActionPerformed() {
        LicenseApplyDlg oDlg = new LicenseApplyDlg(this);
        oDlg.setVisible(true);
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }
}

